/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.DriverConstants;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.ParseException;
import com.tmax.tibero.jdbc.util.TbUrlParser;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class TbDriver
implements Driver {
    protected static Connection defaultConn = null;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        Debug.logMethod("TbDriver.acceptsURL", new String[]{"url"}, new Object[]{url});
        try {
            if (TbUrlParser.parseUrl(url, null) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Connection connect(ConnectionInfo info) throws SQLException {
        Debug.logMethod("TbDriver.connect", new String[]{"Info"}, new Object[]{info});
        return this.connectInternal(info);
    }

    @Override
    public Connection connect(String url, Properties infos) throws SQLException {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)infos);
        prop.remove("password");
        Debug.logMethod("TbDriver.connect", new String[]{"URL", "Info"}, new Object[]{url, prop});
        ConnectionInfo info = null;
        if (TbUrlParser.isInternalUrl(url)) {
            info = new ConnectionInfo();
            info.setInternal(true);
        } else {
            if (!TbUrlParser.isTiberoUrl(url)) {
                return null;
            }
            try {
                info = TbUrlParser.parseUrl(url, infos);
            }
            catch (ParseException e) {
                throw TbError.newSQLException(-90605, e);
            }
        }
        return this.connectInternal(info);
    }

    private Connection connectInternal(ConnectionInfo info) throws SQLException {
        if (info == null) {
            return null;
        }
        try {
            TbConnection connection = new TbConnection();
            String newPassword = info.getNewPassword();
            if (newPassword != null && newPassword.length() != 0) {
                try {
                    connection.openConnection(info, false);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 17002) {
                        // empty if block
                    }
                    connection.openConnection(info, true);
                }
            } else {
                connection.openConnection(info, false);
            }
            return connection;
        }
        catch (SQLException sqe) {
            throw sqe;
        }
        catch (Exception ex) {
            Debug.log("Failed to connect: " + ex.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection defaultConnection() throws SQLException {
        Debug.logMethod("TbDriver.defaultConnection", null, null);
        Class<TbDriver> clazz = TbDriver.class;
        synchronized (TbDriver.class) {
            if (defaultConn == null || defaultConn.isClosed()) {
                defaultConn = DriverManager.getConnection("jdbc:default:connection");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultConn;
        }
    }

    @Override
    public int getMajorVersion() {
        return Integer.parseInt(DriverConstants.JDBC_MAJOR);
    }

    @Override
    public int getMinorVersion() {
        return Integer.parseInt(DriverConstants.JDBC_MINOR);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Debug.logMethod("TbDriver.getPropertyInfo", new String[]{"URL", "Info"}, new Object[]{url, info});
        return new DriverPropertyInfo[0];
    }

    public int getRevision() {
        return Integer.parseInt(DriverConstants.JDBC_REVISION);
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new TbDriver());
        }
        catch (SQLException sqe) {
            throw new RuntimeException("Failed to register TiberoDriver:" + sqe.getMessage());
        }
    }
}

