/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.DriverConstants;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.charset.Charset;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbResultSetFactory;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbDatabaseMetaQuery;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;

public class TbDatabaseMetaData
implements DatabaseMetaData {
    protected TbConnection conn;

    public TbDatabaseMetaData(TbConnection conn1) {
        this.conn = conn1;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        if (!this.conn.getExtFeatureInfo().supports(1)) {
            return this.getAttributesEmpty();
        }
        PreparedStatement pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.getAttributesQuery(false, false));
        pstmt.setInt(1, this.conn.getMapDateToTimestamp() ? 93 : 91);
        pstmt.setString(2, schemaPattern == null ? "%" : schemaPattern);
        pstmt.setString(3, typeNamePattern == null ? "%" : typeNamePattern);
        pstmt.setString(4, attributeNamePattern == null ? "%" : attributeNamePattern);
        TbResultSetBase rs = (TbResultSetBase)pstmt.executeQuery();
        rs.closeStatementOnClose();
        return rs;
    }

    public ResultSet getAttributes(String hexEncodedOID) throws SQLException {
        Debug.logMethod("TbDatabaseMetaData.getAttributes", new Object[]{hexEncodedOID});
        PreparedStatement pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.getAttributesQuery(true, false));
        pstmt.setInt(1, this.conn.getMapDateToTimestamp() ? 93 : 91);
        pstmt.setString(2, hexEncodedOID);
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    private ResultSet getAttributesEmpty() throws SQLException {
        int columnSize = 21;
        int defaultPrecision = 0;
        int defaultScale = 0;
        int defaultEtcMeta = 0;
        int defaultMaxSize = 0;
        TbStatement stmt = new TbStatement(this.conn);
        TbResultSet emptyResultSet = TbResultSetFactory.buildEmptyResultSet(stmt, -2, columnSize, 0);
        DataTypeConverter typeConverter = this.conn.getTypeConverter();
        TbColumnDesc[] columnMeta = new TbColumnDesc[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            columnMeta[i] = new TbColumnDesc();
        }
        columnMeta[0].set("TYPE_CAT", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[1].set("TYPE_SCHEM", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[2].set("TYPE_NAME", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[3].set("ATTR_NAME", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[4].set("DATA_TYPE", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[5].set("ATTR_TYPE_NAME", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[6].set("ATTR_SIZE", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[7].set("DECIMAL_DIGITS", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[8].set("NUM_PREC_RADIX", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[9].set("NULLABLE", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[10].set("REMARKS", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[11].set("ATTR_DEF", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[12].set("SQL_DATA_TYPE", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[13].set("SQL_DATETIME_SUB", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[14].set("CHAR_OCTET_LENGTH", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[15].set("ORDINAL_POSITION", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[16].set("IS_NULLABLE", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[17].set("SCOPE_CATALOG", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[18].set("SCOPE_SCHEMA", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[19].set("SCOPE_TABLE", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[20].set("SOURCE_DATA_TYPE", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        typeConverter.buildColumnMetadata(columnMeta, emptyResultSet, columnMeta.length);
        ((TbResultSetBase)emptyResultSet).closeStatementOnClose();
        return emptyResultSet;
    }

    @Override
    public synchronized ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        PreparedStatement pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.getBestRowIdentifierQuery(this.conn.getExtFeatureInfo().supports(2)));
        pstmt.setInt(1, this.conn.getMapDateToTimestamp() ? 93 : 91);
        switch (scope) {
            case 0: {
                pstmt.setInt(2, 0);
                pstmt.setInt(3, 0);
                break;
            }
            case 1: {
                pstmt.setInt(2, 1);
                pstmt.setInt(3, 1);
                break;
            }
            case 2: {
                pstmt.setInt(2, 0);
                pstmt.setInt(3, 1);
            }
        }
        pstmt.setString(4, table);
        pstmt.setString(5, schema != null ? schema : "%");
        pstmt.setString(6, nullable ? "X" : "Y");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public synchronized ResultSet getCatalogs() throws SQLException {
        Statement stmt = this.conn.createStatement();
        TbResultSetBase rsb = (TbResultSetBase)stmt.executeQuery(TbDatabaseMetaQuery.QUERY_CATALOGS);
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        Statement statement = this.conn.createStatement();
        return statement.executeQuery("SELECT      NULL NAME,     -1 MAX_LEN,     NULL DEFAULT_VALUE,     NULL DESCRIPTION FROM DUAL WHERE 0 = 1");
    }

    @Override
    public synchronized ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        PreparedStatement pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_COLUMNPRIVILEGES);
        pstmt.setString(1, schema != null ? schema : "%");
        pstmt.setString(2, table);
        pstmt.setString(3, columnNamePattern != null ? columnNamePattern : "%");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public synchronized ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        boolean includeSynonyms = this.conn.getIncludeSynonyms();
        boolean mapDateToTimestamp = this.conn.getMapDateToTimestamp();
        PreparedStatement pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.getTableColumnsQuery(includeSynonyms, this.conn.getExtFeatureInfo().supports(2)));
        pstmt.setInt(1, mapDateToTimestamp ? 93 : 91);
        pstmt.setString(2, schemaPattern != null ? schemaPattern : "%");
        if (includeSynonyms) {
            pstmt.setString(3, schemaPattern != null ? schemaPattern : "%");
            pstmt.setString(4, tableNamePattern != null ? tableNamePattern : "%");
            pstmt.setString(5, tableNamePattern != null ? tableNamePattern : "%");
            pstmt.setString(6, columnNamePattern != null ? columnNamePattern : "%");
            pstmt.setString(7, schemaPattern != null ? schemaPattern : "%");
            pstmt.setString(8, schemaPattern != null ? schemaPattern : "%");
        } else {
            pstmt.setString(3, tableNamePattern != null ? tableNamePattern : "%");
            pstmt.setString(4, columnNamePattern != null ? columnNamePattern : "%");
        }
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getRelatedKeys(primarySchema, primaryTable, foreignSchema, foreignTable, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.conn.serverInfo.getTbMajor();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.conn.serverInfo.getTbMinor();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        String databaseProductName = this.conn.info.getDatabaseProductName();
        if (databaseProductName == null || databaseProductName.equals("")) {
            return this.conn.serverInfo.getTbProductName();
        }
        return databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        String databaseProductVersion = this.conn.info.getDatabaseProductVersion();
        if (databaseProductVersion == null || databaseProductVersion.equals("")) {
            return this.conn.serverInfo.getTbProductVersion();
        }
        return databaseProductVersion;
    }

    public synchronized ResultSet getDBParam(String paramName) throws SQLException {
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.QUERY_IPARAM);
        if (paramName != null) {
            sql.append(" name like '%").append(paramName.toUpperCase()).append("%' and");
        }
        sql.append(" name not like '").append(this.getSearchStringEscape()).append("_%' escape '").append(this.getSearchStringEscape()).append("'");
        PreparedStatement pstmt = this.conn.prepareStatement(sql.toString());
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public int getDriverMajorVersion() {
        return Integer.parseInt(DriverConstants.JDBC_MAJOR);
    }

    @Override
    public int getDriverMinorVersion() {
        return Integer.parseInt(DriverConstants.JDBC_MINOR);
    }

    @Override
    public String getDriverName() throws SQLException {
        String driverName = this.conn.info.getDriverName();
        if (driverName == null || driverName.equals("")) {
            return DriverConstants.BRAND_NAME + " " + DriverConstants.JDBC_PRODUCT_NAME;
        }
        return driverName;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        String driverVersion = this.conn.info.getDriverVersion();
        if (driverVersion == null || driverVersion.equals("")) {
            return DriverConstants.JDBC_MAJOR + "." + DriverConstants.JDBC_MINOR + "." + " ";
        }
        return driverVersion;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getRelatedKeys(schema, table, null, null, "ORDER BY fktable_schem, fktable_name, key_seq");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "$#";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        String orderByClause = "ORDER BY FUNCTION_SCHEM, FUNCTION_NAME\n";
        PreparedStatement pstmt = null;
        StringBuilder whereClause = new StringBuilder();
        String schemaName = schemaPattern;
        if (schemaPattern == null) {
            schemaName = "%";
        } else if (schemaPattern.equals("")) {
            schemaName = this.getUserName().toUpperCase();
        }
        String functionName = functionNamePattern;
        if (functionNamePattern == null) {
            functionName = "%";
        } else if (functionNamePattern.equals("")) {
            TbError.newSQLException(-90649);
        }
        String columnName = columnNamePattern;
        if (columnNamePattern == null || columnNamePattern.equals("%")) {
            columnName = "%";
            whereClause.append("  AND (ARG.ARGUMENT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'\n").append("       OR (ARG.ARGUMENT_NAME IS NULL\n").append("           AND ARG.DATA_TYPE IS NOT NULL))\n");
        } else if (columnNamePattern.equals("")) {
            TbError.newSQLException(-90649);
        } else {
            whereClause.append("  AND ARG.ARGUMENT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'\n");
        }
        boolean mapDateToTimestamp = this.conn.getMapDateToTimestamp();
        if (catalog == null) {
            String fullFunctionColumnsQuery = TbDatabaseMetaQuery.getFunctionColumnsQuery(mapDateToTimestamp) + whereClause + orderByClause;
            pstmt = this.conn.prepareStatement(fullFunctionColumnsQuery);
            pstmt.setString(1, schemaName);
            pstmt.setString(2, functionName);
            pstmt.setString(3, columnName);
        } else if (catalog.equals("")) {
            String standaloneFunctionColumnsQuery = TbDatabaseMetaQuery.getFunctionColumnsQuery(mapDateToTimestamp) + "  AND ARG.PACKAGE_NAME IS NULL\n" + whereClause + orderByClause;
            pstmt = this.conn.prepareStatement(standaloneFunctionColumnsQuery);
            pstmt.setString(1, schemaName);
            pstmt.setString(2, functionName);
            pstmt.setString(3, columnName);
        } else {
            String pkgFunctionColumnsQuery = TbDatabaseMetaQuery.getFunctionColumnsQuery(mapDateToTimestamp) + "  AND ARG.PACKAGE_NAME LIKE ? ESCAPE '" + this.getSearchStringEscape() + "'\n" + whereClause + orderByClause;
            pstmt = this.conn.prepareStatement(pkgFunctionColumnsQuery);
            pstmt.setString(1, schemaName);
            pstmt.setString(2, functionName);
            pstmt.setString(3, catalog);
            pstmt.setString(4, columnName);
        }
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String orderByClause = "ORDER BY FUNCTION_SCHEM, FUNCTION_NAME\n";
        PreparedStatement pstmt = null;
        String schemaName = schemaPattern;
        if (schemaPattern == null) {
            schemaName = "%";
        } else if (schemaPattern.equals("")) {
            schemaName = this.getUserName().toUpperCase();
        }
        String functionName = functionNamePattern;
        if (functionNamePattern == null) {
            functionName = "%";
        } else if (functionNamePattern.equals("")) {
            TbError.newSQLException(-90649);
        }
        if (catalog == null) {
            String fullFunctionsQuery = TbDatabaseMetaQuery.QUERY_FUNCTIONS_STANDALONE + "UNION ALL " + TbDatabaseMetaQuery.QUERY_FUNCTIONS_PKG + "  AND PACKAGE_NAME IS NOT NULL\n" + "  AND OWNER LIKE ? ESCAPE '" + this.getSearchStringEscape() + "'\n" + "  AND OBJECT_NAME LIKE ? ESCAPE '" + this.getSearchStringEscape() + "'\n" + orderByClause;
            pstmt = this.conn.prepareStatement(fullFunctionsQuery);
            pstmt.setString(1, schemaName);
            pstmt.setString(2, functionName);
            pstmt.setString(3, schemaName);
            pstmt.setString(4, functionName);
        } else if (catalog.equals("")) {
            pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_FUNCTIONS_STANDALONE);
            pstmt.setString(1, schemaName);
            pstmt.setString(2, functionName);
        } else {
            String pkgFunctionsQuery = TbDatabaseMetaQuery.QUERY_FUNCTIONS_PKG + "  AND PACKAGE_NAME LIKE ? ESCAPE '" + this.getSearchStringEscape() + "'\n" + "  AND OWNER LIKE ? ESCAPE '" + this.getSearchStringEscape() + "'\n" + "  AND OBJECT_NAME LIKE ? ESCAPE '" + this.getSearchStringEscape() + "'\n" + orderByClause;
            pstmt = this.conn.prepareStatement(pkgFunctionsQuery);
            pstmt.setString(1, schemaName);
            pstmt.setString(2, schemaName);
            pstmt.setString(3, functionName);
        }
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getRelatedKeys(null, null, schema, table, "ORDER BY pktable_schem, pktable_name, key_seq");
    }

    @Override
    public synchronized ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        block8: {
            if (!approximate) {
                try {
                    this.gatherTableStats(schema, table);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == -20003) break block8;
                    throw e;
                }
            }
        }
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.QUERY_INDEXINFO01);
        if (schema != null && schema.length() > 0) {
            sql.append(" and owner = ? ");
        }
        sql.append(" union ");
        sql.append(TbDatabaseMetaQuery.QUERY_INDEXINFO02);
        if (schema != null && schema.length() > 0) {
            sql.append(" and i.owner = ? ");
        }
        if (unique) {
            sql.append(" and i.uniqueness = 'UNIQUE' ");
        }
        sql.append(TbDatabaseMetaQuery.QUERY_INDEXINFO03);
        PreparedStatement pstmt = this.conn.prepareStatement(sql.substring(0, sql.length()));
        int i = 1;
        pstmt.setString(i++, table);
        if (schema != null && schema.length() > 0) {
            pstmt.setString(i++, schema);
        }
        pstmt.setString(i++, table);
        if (schema != null && schema.length() > 0) {
            pstmt.setString(i++, schema);
        }
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherTableStats(String schema, String table) throws SQLException {
        CallableStatement cstmt = null;
        try {
            cstmt = this.conn.prepareCall(TbDatabaseMetaQuery.QUERY_GATHER_TABLE_STATS);
            cstmt.setString(1, schema != null && schema.length() > 0 ? schema : this.conn.info.getUser());
            cstmt.setString(2, table);
            cstmt.execute();
        }
        finally {
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        int major = 3;
        major = 4;
        return major;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        int minor = 0;
        return minor;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 65535;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 65535;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 30;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 32;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 1000;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 30;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 30;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 30;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 30;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE";
    }

    @Override
    public synchronized ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        PreparedStatement pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_PRIMARYKEY);
        pstmt.setString(1, table);
        pstmt.setString(2, schema != null ? schema : "%");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public synchronized ResultSet getProcedureColumns(String catalog, String schemaPattern, String procNamePattern, String colNamePattern) throws SQLException {
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.getProcedureColumnsQuery(this.conn.getMapDateToTimestamp()));
        String schema = this.getQualifiedSchemaName(schemaPattern);
        String procName = this.getQualifiedObjName(procNamePattern);
        String argName = this.getQualifiedObjName(colNamePattern);
        if (catalog != null && catalog.length() == 0) {
            sql.append("   AND PACKAGE_NAME IS NULL");
        } else if (catalog != null) {
            sql.append("   AND PACKAGE_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'");
        }
        sql.append("   AND OBJECT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'");
        if (argName.equals("%")) {
            sql.append("   AND (ARGUMENT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("' ");
            sql.append("        OR (ARGUMENT_NAME IS NULL AND DATA_TYPE IS NOT NULL))");
        } else {
            sql.append("   AND ARGUMENT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("' ");
        }
        sql.append("   ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME");
        PreparedStatement pstmt = this.conn.prepareStatement(sql.toString());
        int index = 1;
        pstmt.setString(index++, schema);
        if (catalog != null && catalog.length() > 0) {
            pstmt.setString(index++, catalog);
        }
        pstmt.setString(index++, procName);
        pstmt.setString(index++, argName);
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public synchronized ResultSet getProcedures(String catalog, String schemaPattern, String objNamePattern) throws SQLException {
        String schema = this.getQualifiedSchemaName(schemaPattern);
        String objName = this.getQualifiedObjName(objNamePattern);
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.QUERY_PROCEDURES);
        if (catalog == null) {
            sql.append("   AND (OBJECT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("' OR");
            sql.append("        PROCEDURE_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("')");
            sql.append(" ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME");
        } else if (catalog.length() == 0) {
            sql.append("   AND OBJECT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'");
            sql.append("   AND PROCEDURE_NAME IS NULL");
        } else {
            sql.append("   AND OBJECT_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'");
            sql.append("   AND PROCEDURE_NAME LIKE ? ESCAPE '").append(this.getSearchStringEscape()).append("'");
            sql.append(" ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME");
        }
        PreparedStatement pstmt = this.conn.prepareStatement(sql.toString());
        pstmt.setString(1, schema);
        if (catalog == null) {
            pstmt.setString(2, objName);
            pstmt.setString(3, objName);
        } else if (catalog.equals("")) {
            pstmt.setString(2, objName);
        } else {
            pstmt.setString(2, catalog);
            pstmt.setString(3, objName);
        }
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    private String getQualifiedObjName(String objNamePtn) throws SQLException {
        if (objNamePtn == null) {
            return "%";
        }
        if (objNamePtn.length() == 0) {
            throw TbError.newSQLException(-90649);
        }
        return objNamePtn;
    }

    private String getQualifiedSchemaName(String schemaPtn) {
        if (schemaPtn == null) {
            return "%";
        }
        if (schemaPtn.equals("")) {
            return this.conn.info.getUser();
        }
        return schemaPtn;
    }

    private synchronized ResultSet getRelatedKeys(String primarySchema, String primaryTable, String foreignSchema, String foreignTable, String orderByClause) throws SQLException {
        int i = 1;
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.QUERY_RELATEDKEYS);
        if (primaryTable != null) {
            sql.append(" AND p.table_name \t= ? ");
        }
        if (foreignTable != null) {
            sql.append(" AND f.table_name \t= ? ");
        }
        if (primarySchema != null && primarySchema.length() > 0) {
            sql.append(" AND p.owner \t= ? ");
        }
        if (foreignSchema != null && foreignSchema.length() > 0) {
            sql.append(" AND f.owner \t= ? ");
        }
        sql.append(orderByClause);
        PreparedStatement pstmt = this.conn.prepareStatement(sql.substring(0, sql.length()));
        if (primaryTable != null) {
            pstmt.setString(i++, primaryTable);
        }
        if (foreignTable != null) {
            pstmt.setString(i++, foreignTable);
        }
        if (primarySchema != null && primarySchema.length() > 0) {
            pstmt.setString(i++, primarySchema);
        }
        if (foreignSchema != null && foreignSchema.length() > 0) {
            pstmt.setString(i++, foreignSchema);
        }
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        Statement stmt = this.conn.createStatement();
        TbResultSetBase rsb = (TbResultSetBase)stmt.executeQuery(TbDatabaseMetaQuery.QUERY_SCHEMAS_01 + TbDatabaseMetaQuery.QUERY_SCHEMAS_02);
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String schemaName = schemaPattern;
        if (schemaPattern == null) {
            schemaName = "%";
        } else if (schemaPattern.equals("")) {
            schemaName = this.getUserName().toUpperCase();
        }
        String schemaQuery = TbDatabaseMetaQuery.QUERY_SCHEMAS_01 + " WHERE USERNAME LIKE ? ESCAPE '" + this.getSearchStringEscape() + "' " + TbDatabaseMetaQuery.QUERY_SCHEMAS_02;
        PreparedStatement pstmt = this.conn.prepareStatement(schemaQuery);
        pstmt.setString(1, schemaName);
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return TbDatabaseMetaQuery.escapeChar;
    }

    public String getServerCharSet() throws SQLException {
        return Charset.getName(this.conn.getServerCharSet());
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "ACCESS, ADD, ALTER, AUDIT, CLUSTER, COLUMN, COMMENT, COMPRESS, CONNECT, DATE, DROP, EXCLUSIVE, FILE, IDENTIFIED, IMMEDIATE, INCREMENT, INDEX, INITIAL, INTERSECT, LEVEL, LOCK, LONG, MAXEXTENTS, MINUS, MODE, NOAUDIT, NOCOMPRESS, NOWAIT, NUMBER, OFFLINE, ONLINE, PCTFREE, PRIOR, all_PL_SQL_reserved_words";
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "ASCII,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SPACE,SUBSTRING,UCASE";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        int columnSize = 4;
        int defaultPrecision = 0;
        int defaultScale = 0;
        int defaultEtcMeta = 0;
        int defaultMaxSize = 0;
        TbStatement stmt = new TbStatement(this.conn);
        TbResultSet emptyResultSet = TbResultSetFactory.buildEmptyResultSet(stmt, -2, columnSize, 0);
        DataTypeConverter typeConverter = this.conn.getTypeConverter();
        TbColumnDesc[] columnMeta = new TbColumnDesc[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            columnMeta[i] = new TbColumnDesc();
        }
        columnMeta[0].set("TABLE_CAT", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[1].set("TABLE_SCHEM", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[2].set("TABLE_NAME", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[3].set("SUPERTABLE_NAME", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        typeConverter.buildColumnMetadata(columnMeta, emptyResultSet, columnMeta.length);
        ((TbResultSetBase)emptyResultSet).closeStatementOnClose();
        return emptyResultSet;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        int columnSize = 6;
        int defaultPrecision = 0;
        int defaultScale = 0;
        int defaultEtcMeta = 0;
        int defaultMaxSize = 0;
        TbStatement stmt = new TbStatement(this.conn);
        TbResultSet emptyResultSet = TbResultSetFactory.buildEmptyResultSet(stmt, -2, columnSize, 0);
        DataTypeConverter typeConverter = this.conn.getTypeConverter();
        TbColumnDesc[] columnMeta = new TbColumnDesc[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            columnMeta[i] = new TbColumnDesc();
        }
        columnMeta[0].set("TYPE_CAT", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[1].set("TYPE_SCHEM", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[2].set("TYPE_NAME", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[3].set("SUPERTYPE_CAT", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[4].set("SUPERTYPE_SCHEM", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[5].set("SUPERTYPE_NAME", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        typeConverter.buildColumnMetadata(columnMeta, emptyResultSet, columnMeta.length);
        ((TbResultSetBase)emptyResultSet).closeStatementOnClose();
        return emptyResultSet;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "DATABASE,IFNULL,USER";
    }

    @Override
    public synchronized ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        PreparedStatement pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_TABLEPRIVILEGES);
        pstmt.setString(1, schemaPattern != null ? schemaPattern : "%");
        pstmt.setString(2, tableNamePattern != null ? tableNamePattern : "%");
        pstmt.setString(3, schemaPattern != null ? schemaPattern : "%");
        pstmt.setString(4, tableNamePattern != null ? tableNamePattern : "%");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public synchronized ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        StringBuffer sql = new StringBuffer(TbDatabaseMetaQuery.QUERY_TABLES);
        if (types != null) {
            sql.append(" AND o.object_type IN ( ");
            for (int i = 0; i < types.length; ++i) {
                if (i == 0) {
                    sql.append("'").append(types[i]).append("'");
                    continue;
                }
                sql.append(", '").append(types[i]).append("'");
            }
            sql.append(") ");
        } else {
            sql.append(" AND o.object_type IN ('TABLE', 'SYNONYM', 'VIEW') ");
        }
        sql.append(" ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME");
        PreparedStatement pstmt = this.conn.prepareStatement(sql.substring(0, sql.length()));
        pstmt.setString(1, schemaPattern != null ? schemaPattern : "%");
        pstmt.setString(2, tableNamePattern != null ? tableNamePattern : "%");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public synchronized ResultSet getTableTypes() throws SQLException {
        Statement stmt = this.conn.createStatement();
        TbResultSetBase rsb = (TbResultSetBase)stmt.executeQuery(TbDatabaseMetaQuery.QUERY_TABLETYPES);
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURTIME,DAYOFMONTH,EXTRACT,HOUR,MINUTE,MONTH,NOW,SECOND,YEAR";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        PreparedStatement pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_TYPEINFO);
        boolean supportsUDT = this.conn.getExtFeatureInfo().supports(2);
        pstmt.setInt(1, supportsUDT ? 1 : 0);
        pstmt.setInt(2, supportsUDT ? 1 : 0);
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        if (this.conn.getExtFeatureInfo().supports(1) && (types == null || Arrays.binarySearch(types, 2002) > -1)) {
            PreparedStatement pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_UDTS);
            pstmt.setString(1, schemaPattern != null ? schemaPattern : "%");
            pstmt.setString(2, typeNamePattern != null ? typeNamePattern : "%");
            TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
            rsb.closeStatementOnClose();
            return rsb;
        }
        int columnSize = 7;
        int defaultPrecision = 0;
        int defaultScale = 0;
        int defaultEtcMeta = 0;
        int defaultMaxSize = 0;
        TbStatement stmt = new TbStatement(this.conn);
        TbResultSet emptyResultSet = TbResultSetFactory.buildEmptyResultSet(stmt, -2, columnSize, 0);
        DataTypeConverter typeConverter = this.conn.getTypeConverter();
        TbColumnDesc[] columnMeta = new TbColumnDesc[columnSize];
        for (int i = 0; i < columnSize; ++i) {
            columnMeta[i] = new TbColumnDesc();
        }
        columnMeta[0].set("TYPE_CAT", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[1].set("TYPE_SCHEM", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[2].set("TYPE_NAME", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[3].set("CLASS_NAME", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[4].set("DATA_TYPE", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[5].set("REMARKS", 3, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        columnMeta[6].set("BASE_TYPE", 1, defaultPrecision, defaultScale, defaultEtcMeta, defaultMaxSize);
        typeConverter.buildColumnMetadata(columnMeta, emptyResultSet, columnMeta.length);
        ((TbResultSetBase)emptyResultSet).closeStatementOnClose();
        return emptyResultSet;
    }

    public ResultSet getUDTs(String hexEncodedOID, boolean withSubTypes) throws SQLException {
        Debug.logMethod("TbDatabaseMetaData.getTypeByOID", new Object[]{hexEncodedOID, String.valueOf(withSubTypes)});
        String sql = withSubTypes ? "" : "";
        PreparedStatement pstmt = this.conn.prepareStatement(sql);
        pstmt.setString(1, hexEncodedOID);
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public String getURL() throws SQLException {
        return this.conn.info.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.conn.info.getUser();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        PreparedStatement pstmt = this.conn.prepareStatement(TbDatabaseMetaQuery.getVersionColumnsQuery(this.conn.getMapDateToTimestamp(), this.conn.getExtFeatureInfo().supports(2)));
        pstmt.setString(1, table);
        pstmt.setString(2, schema != null ? schema : "%");
        TbResultSetBase rsb = (TbResultSetBase)pstmt.executeQuery();
        rsb.closeStatementOnClose();
        return rsb;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbDatabaseMetaData.isWrapperFor", new Object[]{iface});
        return iface.isInstance(this);
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return type == 1005;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return type != 1007;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return type != 1007;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        switch (fromType) {
            case 1: 
            case 12: {
                switch (toType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                switch (toType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 12: {
                        return true;
                    }
                }
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                switch (toType) {
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        switch (concurrency) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                return false;
            }
        }
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: {
                return true;
            }
            case 1005: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 2: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbDatabaseMetaData.unwrap", new Object[]{iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }

    @Override
    public boolean updatesAreDetected(int i) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }
}

