/*
 * Decompiled with CFR 0.152.
 */
package core.log.conf.reloadable;

import core.log.exception.InternalException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;

public class ReloadableConfiguration
extends HashMap {
    private static ReloadableConfiguration reloadableConfiguration;
    private static Set fielteredMap;
    private static final String PROPERTY_POSITION = "core/log/log4sql_configuration";
    static String logLevel;
    static String fixedSelectPosition;
    static String fixedNoneSelectPosition;
    static String selectPosition;
    static String noneSelectPosition;
    static String viewPosition;
    static String viewInternalException;
    static String viewAppoint;
    static String asynchronous;

    private ReloadableConfiguration() {
        try {
            super.put("log.level", new Integer(logLevel));
        }
        catch (Throwable t) {
            new InternalException("log.level value must be Integer");
        }
        try {
            super.put("fixed.select", new Boolean(fixedSelectPosition));
        }
        catch (Throwable t) {
            new InternalException("fixed.select value must be Boolean [true or false]");
        }
        try {
            super.put("fixed.none_select", new Boolean(fixedNoneSelectPosition));
        }
        catch (Throwable t) {
            new InternalException("fixed.none_select value must be Boolean [true or false]");
        }
        try {
            super.put("select", new Integer(selectPosition));
        }
        catch (Throwable t) {
            new InternalException("select value must be Integer");
        }
        try {
            super.put("none_select", new Integer(noneSelectPosition));
        }
        catch (Throwable t) {
            new InternalException("none_select value must be Integer");
        }
        try {
            super.put("view.position", new Boolean(viewPosition));
        }
        catch (Throwable t) {
            new InternalException("view.position value must be Boolean [true or false]");
        }
        try {
            super.put("view.internal.exception", new Boolean(viewInternalException));
        }
        catch (Throwable t) {
            new InternalException("view.internal.exception value must be Boolean [true or false]");
        }
        try {
            super.put("view.appoint", viewAppoint);
        }
        catch (Throwable t) {
            new InternalException(t);
        }
        try {
            super.put("log.asynchronous", new Boolean(asynchronous));
        }
        catch (Throwable t) {
            new InternalException("query.logging.asynchronous value must be Boolean [true or false]");
        }
        fielteredMap.add("hashCode");
        fielteredMap.add("getMaxRows");
        fielteredMap.add("getQueryTimeout");
        fielteredMap.add("getFetchSize");
        fielteredMap.add("getMaxFieldSize");
        fielteredMap.add("getFetchDirection");
        fielteredMap.add("closePreparedStatements");
        fielteredMap.add("closeConnection");
    }

    public static ReloadableConfiguration getInstance() {
        if (reloadableConfiguration == null) {
            reloadableConfiguration = new ReloadableConfiguration();
            return reloadableConfiguration;
        }
        return reloadableConfiguration;
    }

    public int getLogLevel() {
        return (Integer)super.get("log.level");
    }

    public boolean getFixedSelectPosition() {
        return (Boolean)super.get("fixed.select");
    }

    public boolean getFixedNoneSelectPosition() {
        return (Boolean)super.get("fixed.none_select");
    }

    public int getSelectPosition() {
        return (Integer)super.get("select");
    }

    public int getNoneSelectPosition() {
        return (Integer)super.get("none_select");
    }

    public boolean getViewPosition() {
        return (Boolean)super.get("view.position");
    }

    public boolean getViewInternalException() {
        return (Boolean)super.get("view.internal.exception");
    }

    public String getViewAppoint() {
        return (String)super.get("view.appoint");
    }

    public boolean getAsynchronous() {
        return (Boolean)super.get("log.asynchronous");
    }

    public void setLogLevel(int val) {
        super.put("log.level", new Integer(val));
    }

    public void setFixedSelectPosition(boolean bool) {
        super.put("fixed.select", new Boolean(bool));
    }

    public void setFixedNoneSelectPosition(boolean bool) {
        super.put("fixed.none_select", new Boolean(bool));
    }

    public void setSelectPosition(int val) {
        super.put("select", new Integer(val));
    }

    public void setNoneSelectPosition(int val) {
        super.put("none_select", new Integer(val));
    }

    public void setViewPosition(boolean bool) {
        super.put("view.position", new Boolean(bool));
    }

    public void setViewInternalException(boolean bool) {
        super.put("view.internal.exception", new Boolean(bool));
    }

    public void setViewAppoint(String earMark) {
        super.put("view.appoint", earMark);
    }

    public void setAsynchronous(boolean asynchronous) {
        super.put("log.asynchronous", new Boolean(asynchronous));
    }

    public boolean isFieltered(String fielterdMethodName) {
        return !fielteredMap.contains(fielterdMethodName);
    }

    static {
        fielteredMap = new HashSet();
        try {
            logLevel = ResourceBundle.getBundle(PROPERTY_POSITION).getString("log.level");
            fixedSelectPosition = ResourceBundle.getBundle(PROPERTY_POSITION).getString("query.logging.position.fixed.select");
            fixedNoneSelectPosition = ResourceBundle.getBundle(PROPERTY_POSITION).getString("query.logging.position.fixed.none_select");
            selectPosition = ResourceBundle.getBundle(PROPERTY_POSITION).getString("query.logging.position.select");
            noneSelectPosition = ResourceBundle.getBundle(PROPERTY_POSITION).getString("query.logging.position.none_select");
            viewPosition = ResourceBundle.getBundle(PROPERTY_POSITION).getString("query.logging.view.position");
            viewInternalException = ResourceBundle.getBundle(PROPERTY_POSITION).getString("query.logging.view.internal.exception");
            viewAppoint = ResourceBundle.getBundle(PROPERTY_POSITION).getString("query.logging.view.appoint");
            asynchronous = ResourceBundle.getBundle(PROPERTY_POSITION).getString("query.logging.asynchronous");
        }
        catch (Throwable t) {
            new InternalException(t);
        }
    }
}

