/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ko;

import junit.framework.TestCase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ko.KoreanAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.junit.Test;

public class WordSegmentFilterTest
extends TestCase {
    @Test
    public void testAnalyze() throws Exception {
        String input = "\uae34\ud558\ub8e8";
        input = "\ubb34\uc8c4\ub2e4\ub77c\uace0 \ub9d0\ud560\uc218";
        input = "\uae40\ub2e4\uc740";
        input = "\uc608\uc218\ub780 \ud560\ub810\ub8e8\uc57c";
        KoreanAnalyzer a = new KoreanAnalyzer();
        a.setHasOrigin(true);
        a.setOriginCNoun(true);
        a.setBigrammable(false);
        a.setQueryMode(true);
        a.setWordSegment(true);
        StringBuilder actual = new StringBuilder();
        TokenStream ts = a.tokenStream("bogus", input);
        CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)ts.addAttribute(PositionIncrementAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
        ts.reset();
        while (ts.incrementToken()) {
            System.out.println(termAtt.toString() + ":" + posIncrAtt.getPositionIncrement() + "(" + offsetAtt.startOffset() + "," + offsetAtt.endOffset() + ")");
        }
        System.out.println(actual);
        ts.end();
        ts.close();
    }
}

