/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ko;

import java.util.List;
import junit.framework.TestCase;
import org.apache.lucene.analysis.ko.morph.AnalysisOutput;
import org.apache.lucene.analysis.ko.morph.CompoundEntry;
import org.apache.lucene.analysis.ko.morph.MorphAnalyzer;

public class TestMorphologicalAnalyzer
extends TestCase {
    public void testAnalyze() throws Exception {
        String[] terms = new String[]{"\ub9cc\ub4e4\uace0", "\uacf5\uc7a5\uc744", "\uac00\ub3d9\ud558\ub294", "\uc9c4\uc0b0\uc138\uace0", "\uae40\uacbd\uc740"};
        long start = System.currentTimeMillis();
        MorphAnalyzer morphAnalyzer = new MorphAnalyzer();
        for (String term : terms) {
            List results = morphAnalyzer.analyze(term);
            for (AnalysisOutput o : results) {
                List entries = o.getCNounList();
                for (CompoundEntry entry : entries) {
                    System.out.print(entry.getWord() + "/");
                }
                if (entries.size() == 0) {
                    System.out.print(o.getStem());
                }
                System.out.print("<" + o.getPatn() + ">->" + o.getScore());
                System.out.println();
            }
        }
        System.out.println(System.currentTimeMillis() - start + "ms");
    }
}

