/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ko.KoreanToken;
import org.apache.lucene.analysis.ko.MorphemeAttribute;
import org.apache.lucene.analysis.ko.morph.AnalysisOutput;
import org.apache.lucene.analysis.ko.morph.CompoundEntry;
import org.apache.lucene.analysis.ko.morph.MorphException;
import org.apache.lucene.analysis.ko.morph.WordSegmentAnalyzer;
import org.apache.lucene.analysis.ko.utils.DictionaryUtil;
import org.apache.lucene.analysis.ko.utils.MorphUtil;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public final class WordSegmentFilter
extends TokenFilter {
    private final LinkedList<KoreanToken> outQueue = new LinkedList();
    private boolean modeQueue = false;
    private WordSegmentAnalyzer segmentAnalyzer;
    private boolean hasOrigin = true;
    private List<AnalysisOutput> morphOutputs;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final MorphemeAttribute morphAtt = (MorphemeAttribute)this.addAttribute(MorphemeAttribute.class);

    protected WordSegmentFilter(TokenStream input) {
        super(input);
        this.segmentAnalyzer = new WordSegmentAnalyzer();
    }

    protected WordSegmentFilter(TokenStream input, boolean hasOrigin) {
        this(input);
        this.hasOrigin = hasOrigin;
    }

    public boolean incrementToken() throws IOException {
        if (this.modeQueue && this.outQueue.size() > 0) {
            this.setAttributesFromQueue();
            return true;
        }
        this.modeQueue = false;
        while (this.input.incrementToken()) {
            KoreanToken kToken = this.morphAtt.getToken();
            if (kToken == null) {
                return true;
            }
            if (this.morphOutputs != null) {
                if (this.morphOutputs == kToken.getOutputs()) continue;
                this.morphOutputs = null;
            }
            assert (kToken.getOutputs().size() > 0);
            if (this.posIncrAtt.getPositionIncrement() == 0 || kToken == null || kToken.getOutputs().size() == 0 || kToken.getOutputs().get(0).getScore() > 70 || kToken.getOutputs().get(0).getScore() == 70 && !this.containJosa(kToken) && !MorphUtil.hasVerbOnly((String)kToken.getOutputs().get(0).getStem())) {
                return true;
            }
            String term = this.termAtt.toString();
            try {
                List segments;
                if (this.hasOrigin) {
                    this.outQueue.add(new KoreanToken(this.termAtt.toString(), this.offsetAtt.startOffset(), this.posIncrAtt.getPositionIncrement()));
                }
                if ((segments = this.segmentAnalyzer.analyze(term)).size() < 2) {
                    if (this.hasOrigin) {
                        this.outQueue.removeFirst();
                    }
                    return true;
                }
                int offset = 0;
                for (int i = 0; i < segments.size(); ++i) {
                    int posInc;
                    assert (((List)segments.get(i)).size() > 0);
                    String word = ((AnalysisOutput)((List)segments.get(i)).get(0)).getSource();
                    List entries = ((AnalysisOutput)((List)segments.get(i)).get(0)).getCNounList();
                    int n = posInc = i == 0 ? 0 : 1;
                    if (this.hasOrigin) {
                        this.outQueue.add(new KoreanToken(word, this.offsetAtt.startOffset() + offset, posInc));
                    }
                    if (entries.size() > 1) {
                        if (!this.hasOrigin || !word.equals(((AnalysisOutput)((List)segments.get(i)).get(0)).getStem())) {
                            this.outQueue.add(new KoreanToken(((AnalysisOutput)((List)segments.get(i)).get(0)).getStem(), this.offsetAtt.startOffset() + offset, this.hasOrigin ? 0 : posInc));
                        }
                        int innerOffset = offset;
                        for (int k = 0; k < entries.size(); ++k) {
                            CompoundEntry ce = (CompoundEntry)entries.get(k);
                            int innerPosInc = k == 0 ? 0 : 1;
                            this.outQueue.add(new KoreanToken(ce.getWord(), this.offsetAtt.startOffset() + innerOffset, innerPosInc));
                            innerOffset += ce.getWord().length();
                        }
                    } else if (((AnalysisOutput)((List)segments.get(i)).get(0)).getPatn() >= 11 && ((AnalysisOutput)((List)segments.get(i)).get(0)).getPatn() < 35) {
                        if (!this.hasOrigin) {
                            this.outQueue.add(new KoreanToken(word, this.offsetAtt.startOffset() + offset, posInc));
                        }
                    } else if (!this.hasOrigin || !word.equals(((AnalysisOutput)((List)segments.get(i)).get(0)).getStem())) {
                        this.outQueue.add(new KoreanToken(((AnalysisOutput)((List)segments.get(i)).get(0)).getStem(), this.offsetAtt.startOffset() + offset, this.hasOrigin ? 0 : posInc));
                    }
                    offset += word.length();
                }
                this.captureState();
                this.modeQueue = true;
                this.morphOutputs = kToken.getOutputs();
                if (this.outQueue.isEmpty()) continue;
                this.setAttributesFromQueue();
                return true;
            }
            catch (MorphException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.outQueue.size() > 0) {
            this.setAttributesFromQueue();
            return true;
        }
        return false;
    }

    private boolean containJosa(KoreanToken kToken) {
        List<AnalysisOutput> outputs = kToken.getOutputs();
        if (outputs.size() == 0 || outputs.get(0).getCNounList().size() == 0) {
            return false;
        }
        try {
            List entries = outputs.get(0).getCNounList();
            for (int i = 0; i < entries.size(); ++i) {
                if (!DictionaryUtil.existJosa((String)((CompoundEntry)entries.get(i)).getWord())) continue;
                return true;
            }
        }
        catch (MorphException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private void setAttributesFromQueue() {
        KoreanToken iw = this.outQueue.removeFirst();
        this.termAtt.setEmpty().append(iw.getTerm());
        this.offsetAtt.setOffset(iw.getOffset(), iw.getOffset() + iw.getLength());
        this.posIncrAtt.setPositionIncrement(iw.getPosInc());
    }

    public void reset() throws IOException {
        super.reset();
        this.outQueue.clear();
    }
}

