/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

public final class PunctuationDelimitFilter
extends TokenFilter {
    private final LinkedList<Token> outQueue = new LinkedList();
    private AttributeSource.State currentState = null;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);

    protected PunctuationDelimitFilter(TokenStream input) {
        super(input);
    }

    public boolean incrementToken() throws IOException {
        if (!this.outQueue.isEmpty()) {
            this.restoreState(this.currentState);
            this.setAttributesFromQueue(false);
            return true;
        }
        while (this.input.incrementToken()) {
            if (this.keywordAtt.isKeyword()) {
                return true;
            }
            if (!this.containPunctuation(this.termAtt.toString())) {
                return true;
            }
            this.splitByPunctuation(this.termAtt.toString());
            if (this.outQueue.isEmpty()) continue;
            this.setAttributesFromQueue(true);
            return true;
        }
        return false;
    }

    private void setAttributesFromQueue(boolean isFirst) {
        Token iw = this.outQueue.removeFirst();
        if (isFirst && !this.outQueue.isEmpty()) {
            this.termAtt.setEmpty();
            this.currentState = this.captureState();
        }
        this.termAtt.setEmpty().append(iw.getTerm());
        this.offsetAtt.setOffset(iw.getOffset(), iw.getOffset() + iw.term.length());
        this.posIncrAtt.setPositionIncrement(iw.getIncrement());
    }

    private void splitByPunctuation(String term) {
        if (term.length() < 2) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int startOffset = this.offsetAtt.startOffset();
        ArrayList<String> array = new ArrayList<String>();
        for (int i = 0; i < term.length(); ++i) {
            if (PunctuationDelimitFilter.isPunctuation(term.charAt(i))) {
                if (sb.length() <= 0) continue;
                array.add(sb.toString());
                sb = new StringBuffer();
                continue;
            }
            sb.append(term.charAt(i));
        }
        if (sb.length() > 0) {
            array.add(sb.toString());
        }
        if (array.size() == 0) {
            return;
        }
        this.outQueue.add(new Token(this.termAtt.toString(), startOffset, this.posIncrAtt.getPositionIncrement()));
        sb = new StringBuffer();
        for (String str : array) {
            sb.append(str);
        }
        this.outQueue.add(new Token(sb.toString(), startOffset, 0));
        if (sb.length() == 1) {
            return;
        }
        int offset = 0;
        for (int i = 0; i < array.size(); ++i) {
            int inc = i == 0 ? 0 : 1;
            this.outQueue.add(new Token((String)array.get(i), startOffset + offset, inc));
            offset += ((String)array.get(i)).length();
        }
    }

    private boolean containPunctuation(String term) {
        for (int i = 0; i < term.length() - 1; ++i) {
            if (!PunctuationDelimitFilter.isPunctuation(term.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isPunctuation(char ch) {
        switch (Character.getType(ch)) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.outQueue.clear();
        this.currentState = null;
    }

    private class Token {
        int offset;
        int increment = 1;
        String term;

        public Token(String term, int offset) {
            this.term = term;
            this.offset = offset;
        }

        public Token(String term, int offset, int inc) {
            this(term, offset);
            this.increment = inc;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getIncrement() {
            return this.increment;
        }

        public void setIncrement(int increment) {
            this.increment = increment;
        }

        public String getTerm() {
            return this.term;
        }

        public void setTerm(String term) {
            this.term = term;
        }
    }
}

