/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.util.CharacterUtils;
import org.apache.lucene.util.AttributeFactory;

public final class KoreanTokenizer
extends Tokenizer {
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private int finalOffset = 0;
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 4096;
    private final CharacterUtils charUtils;
    private final CharacterUtils.CharacterBuffer ioBuffer = CharacterUtils.newCharacterBuffer((int)4096);
    private static Map<Integer, Integer> pairmap = new HashMap<Integer, Integer>();
    private List<Integer> pairstack = new ArrayList<Integer>();
    public static final String TYPE_KOREAN = "korean";
    public static final String TYPE_WORD = "word";
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

    public KoreanTokenizer() {
        this.charUtils = CharacterUtils.getInstance();
    }

    public KoreanTokenizer(AttributeFactory factory) {
        super(factory);
        this.charUtils = CharacterUtils.getInstance();
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        char[] buffer = this.termAtt.buffer();
        int length = 0;
        int start = -1;
        int end = -1;
        while (true) {
            if (this.bufferIndex >= this.dataLen) {
                this.offset += this.dataLen;
                this.charUtils.fill(this.ioBuffer, this.input);
                if (this.ioBuffer.getLength() == 0) {
                    this.dataLen = 0;
                    if (length <= 0) {
                        this.finalOffset = this.correctOffset(this.offset);
                        return false;
                    }
                    break;
                }
                this.dataLen = this.ioBuffer.getLength();
                this.bufferIndex = 0;
            }
            int c = this.charUtils.codePointAt(this.ioBuffer.getBuffer(), this.bufferIndex, this.ioBuffer.getLength());
            int charCount = Character.charCount(c);
            this.bufferIndex += charCount;
            if (this.pairstack.size() > 0 && this.pairstack.get(0) == c) {
                this.pairstack.remove(0);
                continue;
            }
            int closechar = this.getPairChar(c);
            if (closechar != 0) {
                if ((this.pairstack.size() == 0 || this.pairstack.get(0) != closechar) && length > 0) {
                    this.pairstack.add(0, closechar);
                    break;
                }
                this.pairstack.add(0, closechar);
                continue;
            }
            if (this.isTokenChar(c)) {
                if (length == 0) {
                    assert (start == -1);
                    end = start = this.offset + this.bufferIndex - charCount;
                } else if (length >= buffer.length - 1) {
                    buffer = this.termAtt.resizeBuffer(2 + length);
                }
                end += charCount;
                if ((length += Character.toChars(c, buffer, length)) < 255) continue;
                break;
            }
            if (length > 0) break;
        }
        this.termAtt.setLength(length);
        assert (start != -1);
        this.finalOffset = this.correctOffset(end);
        this.offsetAtt.setOffset(this.correctOffset(start), this.finalOffset);
        this.typeAtt.setType(this.getType());
        return true;
    }

    private boolean isTokenChar(int c) {
        return Character.isLetter(c) || Character.isDigit(c) || this.isPreserveSymbol((char)c);
    }

    private int getPairChar(int c) {
        Integer p = pairmap.get(c);
        return p == null ? 0 : p;
    }

    private String getType() {
        char[] buffer = this.termAtt.buffer();
        int leng = this.termAtt.length();
        for (int i = 0; i < leng && buffer[i] != '\u0000'; ++i) {
            if (buffer[i] < '\uac00' || buffer[i] > '\ud7a3') continue;
            return TYPE_KOREAN;
        }
        return TYPE_WORD;
    }

    private boolean isPreserveSymbol(char c) {
        return c == '#' || c == '+' || c == '-' || c == '\u00b7' || c == '&';
    }

    public final void end() throws IOException {
        super.end();
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    public void reset() throws IOException {
        super.reset();
        this.bufferIndex = 0;
        this.offset = 0;
        this.dataLen = 0;
        this.finalOffset = 0;
        this.ioBuffer.reset();
    }

    static {
        pairmap.put(34, 34);
        pairmap.put(39, 39);
        pairmap.put(40, 41);
        pairmap.put(60, 62);
        pairmap.put(91, 93);
        pairmap.put(123, 125);
        pairmap.put(65288, 65289);
        pairmap.put(8216, 8217);
        pairmap.put(8220, 8221);
    }
}

