/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ko.KoreanFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class KoreanFilterFactory
extends TokenFilterFactory {
    private static final String BIGRAMMABLE_PARAM = "bigrammable";
    private static final String HAS_ORIGIN_PARAM = "hasOrigin";
    private static final String HAS_COMPOUND_NOUN_PARAM = "hasCNoun";
    private static final String IS_QUERY_MODE_PARAM = "queryMode";
    private static final String EXACT_MATCH_PARAM = "exactMatch";
    private final boolean bigrammable;
    private final boolean hasOrigin;
    private final boolean hasCNoun;
    private final boolean exactMatch;
    private final boolean queryMode;

    public KoreanFilterFactory(Map<String, String> args) {
        super(args);
        this.bigrammable = this.getBoolean(args, BIGRAMMABLE_PARAM, true);
        this.hasOrigin = this.getBoolean(args, HAS_ORIGIN_PARAM, true);
        this.exactMatch = this.getBoolean(args, EXACT_MATCH_PARAM, false);
        this.hasCNoun = this.getBoolean(args, HAS_COMPOUND_NOUN_PARAM, true);
        this.queryMode = this.getBoolean(args, IS_QUERY_MODE_PARAM, true);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public TokenStream create(TokenStream tokenstream) {
        return new KoreanFilter(tokenstream, this.bigrammable, this.hasOrigin, this.exactMatch, this.hasCNoun, this.queryMode);
    }
}

