/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ko.KoreanToken;
import org.apache.lucene.analysis.ko.MorphemeAttribute;
import org.apache.lucene.analysis.ko.morph.AnalysisOutput;
import org.apache.lucene.analysis.ko.morph.CompoundEntry;
import org.apache.lucene.analysis.ko.morph.MorphAnalyzer;
import org.apache.lucene.analysis.ko.morph.MorphException;
import org.apache.lucene.analysis.ko.utils.MorphUtil;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;

public final class KoreanFilter
extends TokenFilter {
    private final LinkedList<KoreanToken> morphQueue = new LinkedList();
    private final MorphAnalyzer morph;
    private AttributeSource.State currentState = null;
    private final boolean bigrammable;
    private final boolean hasOrigin;
    private final boolean originCNoun;
    private final boolean queryMode;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final MorphemeAttribute morphAtt = (MorphemeAttribute)this.addAttribute(MorphemeAttribute.class);
    private static final String KOREAN_TYPE = "korean";

    public KoreanFilter(TokenStream input) {
        this(input, true);
    }

    public KoreanFilter(TokenStream input, boolean bigram) {
        this(input, bigram, false);
    }

    public KoreanFilter(TokenStream input, boolean bigram, boolean has) {
        this(input, bigram, has, false);
    }

    public KoreanFilter(TokenStream input, boolean bigram, boolean has, boolean exactMatch) {
        this(input, bigram, has, exactMatch, true);
    }

    public KoreanFilter(TokenStream input, boolean bigram, boolean has, boolean exactMatch, boolean cnoun) {
        this(input, bigram, has, exactMatch, cnoun, false);
    }

    public KoreanFilter(TokenStream input, boolean bigram, boolean has, boolean exactMatch, boolean cnoun, boolean isQuery) {
        super(input);
        this.bigrammable = bigram;
        this.hasOrigin = has;
        this.originCNoun = cnoun;
        this.morph = new MorphAnalyzer();
        this.morph.setExactCompound(exactMatch);
        this.queryMode = isQuery;
    }

    public boolean incrementToken() throws IOException {
        if (!this.morphQueue.isEmpty()) {
            this.restoreState(this.currentState);
            this.setAttributesFromQueue(false);
            return true;
        }
        while (this.input.incrementToken()) {
            String type = this.typeAtt.type();
            if (KOREAN_TYPE.equals(type)) {
                try {
                    this.analysisKorean(this.termAtt.toString());
                }
                catch (MorphException e) {
                    throw new RuntimeException(e);
                }
            } else {
                return true;
            }
            if (this.morphQueue.isEmpty()) continue;
            this.setAttributesFromQueue(true);
            return true;
        }
        return false;
    }

    private void setAttributesFromQueue(boolean isFirst) {
        KoreanToken iw = this.morphQueue.removeFirst();
        if (isFirst && !this.morphQueue.isEmpty()) {
            this.termAtt.setEmpty();
            this.currentState = this.captureState();
        }
        this.termAtt.setEmpty().append(iw.getTerm());
        this.offsetAtt.setOffset(iw.getOffset(), iw.getOffset() + iw.getLength());
        this.morphAtt.setToken(iw);
        if (!isFirst) {
            this.posIncrAtt.setPositionIncrement(iw.getPosInc());
        }
    }

    private void analysisKorean(String input) throws MorphException {
        List outputs = this.morph.analyze(input = this.trimHangul(input));
        if (outputs.size() == 0) {
            return;
        }
        LinkedHashMap<String, KoreanToken> map = new LinkedHashMap<String, KoreanToken>();
        if (this.hasOrigin) {
            map.put("0:" + input, new KoreanToken(input, this.offsetAtt.startOffset()));
        }
        this.extractKeyword(outputs, this.offsetAtt.startOffset(), map, 0);
        Collection values = map.values();
        for (KoreanToken kt : values) {
            kt.setOutputs(outputs);
        }
        this.morphQueue.addAll(map.values());
    }

    private String trimHangul(String input) {
        int minpos = input.length();
        int i = input.length() - 1;
        while (i >= 0 && !MorphUtil.isHanSyllable((char)input.charAt(i))) {
            minpos = i--;
        }
        if (minpos == input.length()) {
            return input;
        }
        return input.substring(0, minpos);
    }

    private void extractKeyword(List<AnalysisOutput> outputs, int startoffset, Map<String, KoreanToken> map, int position) {
        int maxDecompounds = 0;
        int maxStem = 0;
        for (AnalysisOutput output : outputs) {
            if (this.queryMode && this.hasOrigin && output.getScore() == 30 && output.getCNounList().size() < 2) break;
            if (output.getPos() == 'V' || !this.originCNoun && output.getCNounList().size() > 0) continue;
            int inc = map.size() > 0 ? 0 : 1;
            map.put(position + ":" + output.getStem(), new KoreanToken(output.getStem(), startoffset, inc));
            if (output.getStem().length() > maxStem) {
                maxStem = output.getStem().length();
            }
            if (output.getCNounList().size() > maxDecompounds) {
                maxDecompounds = output.getCNounList().size();
            }
            if (!this.queryMode) continue;
            break;
        }
        if (maxDecompounds > 1) {
            block1: for (int i = 0; i < maxDecompounds; ++i) {
                int cPosition = position += i;
                for (AnalysisOutput output : outputs) {
                    if (output.getPos() == 'V' || output.getCNounList().size() <= i) continue;
                    CompoundEntry cEntry = (CompoundEntry)output.getCNounList().get(i);
                    int cStartoffset = this.getStartOffset(output, i) + startoffset;
                    int inc = i == 0 ? 0 : 1;
                    map.put(cPosition + ":" + cEntry.getWord(), new KoreanToken(cEntry.getWord(), cStartoffset, inc));
                    if (this.bigrammable && !cEntry.isExist()) {
                        cPosition = this.addBiagramToMap(cEntry.getWord(), cStartoffset, map, cPosition);
                    }
                    if (!this.queryMode) continue;
                    continue block1;
                }
            }
        } else {
            for (AnalysisOutput output : outputs) {
                if (output.getPos() == 'V' || !this.bigrammable || output.getScore() >= 70) continue;
                this.addBiagramToMap(output.getStem(), startoffset, map, position);
            }
        }
    }

    private int addBiagramToMap(String input, int startoffset, Map<String, KoreanToken> map, int position) {
        int offset = 0;
        int strlen = input.length();
        if (strlen < 2) {
            return position;
        }
        while (offset < strlen - 1) {
            String text;
            int inc;
            int n = inc = offset == 0 ? 0 : 1;
            if (this.isAlphaNumChar(input.charAt(offset))) {
                text = this.findAlphaNumeric(input.substring(offset));
                map.put(position + ":" + text, new KoreanToken(text, startoffset + offset, inc));
                offset += text.length();
            } else {
                text = input.substring(offset, offset + 2 > strlen ? strlen : offset + 2);
                map.put(position + ":" + text, new KoreanToken(text, startoffset + offset, inc));
                ++offset;
            }
            ++position;
        }
        return position - 1;
    }

    private int getStartOffset(AnalysisOutput output, int index) {
        int sOffset = 0;
        for (int i = 0; i < index; ++i) {
            sOffset += ((CompoundEntry)output.getCNounList().get(i)).getWord().length();
        }
        return sOffset;
    }

    private String findAlphaNumeric(String text) {
        int pos = 0;
        for (int i = 0; i < text.length() && this.isAlphaNumChar(text.charAt(i)); ++i) {
            ++pos;
        }
        if (pos < text.length()) {
            ++pos;
        }
        return text.substring(0, pos);
    }

    private boolean isAlphaNumChar(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 122;
    }

    public void reset() throws IOException {
        super.reset();
        this.morphQueue.clear();
        this.currentState = null;
    }
}

