/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.ko.HanjaMappingFilter;
import org.apache.lucene.analysis.ko.KoreanFilter;
import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.PunctuationDelimitFilter;
import org.apache.lucene.analysis.ko.WordSegmentFilter;
import org.apache.lucene.analysis.standard.ClassicFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;

public class KoreanAnalyzer
extends StopwordAnalyzerBase {
    public static final CharArraySet ENGLISH_STOP_WORDS_SET;
    private boolean bigrammable = false;
    private boolean hasOrigin = false;
    private boolean exactMatch = false;
    private boolean originCNoun = true;
    private boolean queryMode = false;
    private boolean wordSegment = false;

    public KoreanAnalyzer() {
        this(ENGLISH_STOP_WORDS_SET);
    }

    public KoreanAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        KoreanTokenizer src = new KoreanTokenizer();
        Object tok = new LowerCaseFilter((TokenStream)src);
        tok = new ClassicFilter((TokenStream)tok);
        tok = new KoreanFilter((TokenStream)tok, this.bigrammable, this.hasOrigin, this.exactMatch, this.originCNoun, this.queryMode);
        if (this.wordSegment) {
            tok = new WordSegmentFilter((TokenStream)tok, this.hasOrigin);
        }
        tok = new HanjaMappingFilter((TokenStream)tok);
        tok = new PunctuationDelimitFilter((TokenStream)tok);
        tok = new StopFilter((TokenStream)tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(src, (TokenStream)tok){

            protected void setReader(Reader reader) throws IOException {
                super.setReader(reader);
            }
        };
    }

    public void setBigrammable(boolean is) {
        this.bigrammable = is;
    }

    public void setHasOrigin(boolean has) {
        this.hasOrigin = has;
    }

    public void setOriginCNoun(boolean cnoun) {
        this.originCNoun = cnoun;
    }

    public void setExactMatch(boolean exact) {
        this.exactMatch = exact;
    }

    public void setQueryMode(boolean mode) {
        this.queryMode = mode;
    }

    public boolean isWordSegment() {
        return this.wordSegment;
    }

    public void setWordSegment(boolean wordSegment) {
        this.wordSegment = wordSegment;
    }

    static {
        List<String> stopWords = Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with");
        CharArraySet stopSet = new CharArraySet(stopWords, false);
        ENGLISH_STOP_WORDS_SET = CharArraySet.unmodifiableSet((CharArraySet)stopSet);
    }
}

