/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ko.KoreanToken;
import org.apache.lucene.analysis.ko.morph.CompoundEntry;
import org.apache.lucene.analysis.ko.morph.CompoundNounAnalyzer;
import org.apache.lucene.analysis.ko.morph.MorphException;
import org.apache.lucene.analysis.ko.morph.WordEntry;
import org.apache.lucene.analysis.ko.utils.DictionaryUtil;
import org.apache.lucene.analysis.ko.utils.HanjaUtils;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

public final class HanjaMappingFilter
extends TokenFilter {
    private final LinkedList<KoreanToken> outQueue = new LinkedList();
    private AttributeSource.State currentState = null;
    private static int maxCandidateSize = 5;
    private final CompoundNounAnalyzer cnAnalyzer = new CompoundNounAnalyzer();
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);

    protected HanjaMappingFilter(TokenStream input) {
        super(input);
        this.cnAnalyzer.setExactMach(false);
    }

    public boolean incrementToken() throws IOException {
        if (!this.outQueue.isEmpty()) {
            this.restoreState(this.currentState);
            this.setAttributesFromQueue(false);
            return true;
        }
        while (this.input.incrementToken()) {
            if (this.posIncrAtt.getPositionIncrement() == 0 || !this.hasHanja(this.termAtt.toString())) {
                return true;
            }
            int startOffset = this.offsetAtt.startOffset();
            List<StringBuffer> terms = this.splitByHanja(this.termAtt.toString());
            int offset = 0;
            for (StringBuffer sb : terms) {
                if (sb.length() == 0) continue;
                if (this.isHanja(sb.charAt(0))) {
                    try {
                        this.mapHanjaToHangul(sb);
                    }
                    catch (MorphException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.outQueue.add(new KoreanToken(sb.toString(), offset + startOffset, 1));
                }
                offset += sb.length();
            }
            if (this.outQueue.isEmpty()) continue;
            this.setAttributesFromQueue(true);
            return true;
        }
        return false;
    }

    private void setAttributesFromQueue(boolean isFirst) {
        KoreanToken iw = this.outQueue.removeFirst();
        if (isFirst && !this.outQueue.isEmpty()) {
            this.termAtt.setEmpty();
            this.currentState = this.captureState();
        }
        this.termAtt.setEmpty().append(iw.getTerm());
        this.offsetAtt.setOffset(iw.getOffset(), iw.getOffset() + iw.getLength());
        this.posIncrAtt.setPositionIncrement(iw.getPosInc());
    }

    private boolean hasHanja(String term) {
        for (int i = 0; i < term.length(); ++i) {
            if (!this.isHanja(term.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private List<StringBuffer> splitByHanja(String term) {
        ArrayList<StringBuffer> result = new ArrayList<StringBuffer>();
        result.add(new StringBuffer(term));
        return result;
    }

    private void mapHanjaToHangul(StringBuffer term) throws MorphException {
        this.outQueue.add(new KoreanToken(term.toString(), this.offsetAtt.startOffset()));
        if (term.length() < 2) {
            return;
        }
        ArrayList<StringBuffer> candiList = new ArrayList<StringBuffer>();
        candiList.add(new StringBuffer());
        ArrayList<StringBuffer> removeList = new ArrayList<StringBuffer>();
        for (int i = 0; i < term.length(); ++i) {
            char[] chs = HanjaUtils.convertToHangul((char)term.charAt(i));
            if (chs == null) continue;
            int caniSize = candiList.size();
            for (int j = 0; j < caniSize; ++j) {
                String origin = ((StringBuffer)candiList.get(j)).toString();
                for (int k = 0; k < chs.length && k != 4; ++k) {
                    Iterator iter;
                    StringBuffer sb = (StringBuffer)candiList.get(j);
                    if (k > 0) {
                        sb = new StringBuffer(origin);
                    }
                    sb.append(chs[k]);
                    if (k > 0) {
                        candiList.add(sb);
                    }
                    if ((iter = DictionaryUtil.findWithPrefix((String)sb.toString())).hasNext() || removeList.contains(sb)) continue;
                    removeList.add(sb);
                }
            }
            if (candiList.size() <= maxCandidateSize) continue;
            this.removeLast(candiList, removeList, maxCandidateSize);
        }
        if (removeList.size() != candiList.size()) {
            for (StringBuffer rsb : removeList) {
                candiList.remove(rsb);
            }
            removeList.clear();
        }
        int noCandidate = candiList.size();
        int maxDecompounds = 0;
        ArrayList<List<CompoundEntry>> compoundList = new ArrayList<List<CompoundEntry>>();
        for (int i = 0; i < noCandidate; ++i) {
            this.outQueue.add(new KoreanToken(((StringBuffer)candiList.get(i)).toString(), this.offsetAtt.startOffset(), 0));
            List<CompoundEntry> results = this.confirmCNoun(((StringBuffer)candiList.get(i)).toString());
            compoundList.add(results);
            if (maxDecompounds >= results.size()) continue;
            maxDecompounds = results.size();
        }
        if (maxDecompounds > 1) {
            int[] pos = new int[noCandidate];
            int[] offset = new int[noCandidate];
            int[] index = new int[noCandidate];
            int minOffset = term.length();
            for (int i = 0; i < maxDecompounds; ++i) {
                HashMap<String, CompoundEntry> dupcheck = new HashMap<String, CompoundEntry>();
                int min = term.length();
                boolean done = false;
                for (int j = 0; j < noCandidate; ++j) {
                    if (offset[j] > minOffset || ((List)compoundList.get(j)).size() <= index[j]) continue;
                    int posInc = i != 0 && !done ? 1 : 0;
                    CompoundEntry entry = (CompoundEntry)((List)compoundList.get(j)).get(index[j]);
                    int n = j;
                    pos[n] = pos[n] + entry.getWord().length();
                    if (!done && pos[j] <= term.length()) {
                        this.outQueue.add(new KoreanToken(term.substring(offset[j], pos[j]), this.offsetAtt.startOffset() + offset[j], posInc));
                    }
                    if (dupcheck.get(entry.getWord()) == null) {
                        this.outQueue.add(new KoreanToken(entry.getWord(), this.offsetAtt.startOffset() + offset[j], 0));
                        dupcheck.put(entry.getWord(), entry);
                    }
                    offset[j] = pos[j];
                    int n2 = j;
                    index[n2] = index[n2] + 1;
                    if (min > offset[j]) {
                        min = offset[j];
                    }
                    done = true;
                }
                minOffset = min;
            }
        }
    }

    private boolean isHanja(char c) {
        return c >= '\u3400' && c <= '\u4dbf' || c >= '\u4e00' && c <= '\u9fff' || c >= '\uf900' && c <= '\ufaff';
    }

    private List<CompoundEntry> confirmCNoun(String input) throws MorphException {
        WordEntry cnoun = DictionaryUtil.getAllNoun((String)input);
        if (cnoun != null && cnoun.getFeature(0) == '2') {
            return cnoun.getCompounds();
        }
        return this.cnAnalyzer.analyze(input);
    }

    private void removeLast(List<StringBuffer> list, List<StringBuffer> removeCandi, int start) {
        ArrayList<StringBuffer> removed = new ArrayList<StringBuffer>();
        for (int i = start; i < list.size(); ++i) {
            removed.add(list.get(i));
        }
        for (Object e : removed) {
            list.remove(e);
            removeCandi.remove(e);
        }
        removed = null;
    }

    public void reset() throws IOException {
        super.reset();
        this.outQueue.clear();
        this.currentState = null;
    }
}

