/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.vti;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;

public abstract class Restriction
implements Serializable {
    public abstract String toSQL();

    protected String parenthesize(String string) {
        return "( " + string + " )";
    }

    public static class ColumnQualifier
    extends Restriction {
        public static final long serialVersionUID = -8205388794606605844L;
        public static final int ORDER_OP_LESSTHAN = 0;
        public static final int ORDER_OP_EQUALS = 1;
        public static final int ORDER_OP_LESSOREQUALS = 2;
        public static final int ORDER_OP_GREATERTHAN = 3;
        public static final int ORDER_OP_GREATEROREQUALS = 4;
        public static final int ORDER_OP_ISNULL = 5;
        public static final int ORDER_OP_ISNOTNULL = 6;
        public static final int ORDER_OP_NOT_EQUALS = 7;
        private String[] OPERATOR_SYMBOLS = new String[]{"<", "=", "<=", ">", ">=", "IS NULL", "IS NOT NULL", "!="};
        private String _columnName;
        private int _comparisonOperator;
        private Object _constantOperand;

        public ColumnQualifier(String string, int n, Object object) {
            this._columnName = string;
            this._comparisonOperator = n;
            this._constantOperand = object;
        }

        public String getColumnName() {
            return this._columnName;
        }

        public int getComparisonOperator() {
            return this._comparisonOperator;
        }

        public Object getConstantOperand() {
            return this._constantOperand;
        }

        public String toSQL() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(IdUtil.normalToDelimited(this._columnName));
            stringBuffer.append(" " + this.OPERATOR_SYMBOLS[this._comparisonOperator] + " ");
            if (this._constantOperand != null) {
                stringBuffer.append(this.toEscapedString(this._constantOperand));
            }
            return stringBuffer.toString();
        }

        protected String toEscapedString(Object object) {
            if (object instanceof Timestamp) {
                return "TIMESTAMP('" + object.toString() + "')";
            }
            if (object instanceof Date) {
                return "DATE('" + object.toString() + "')";
            }
            if (object instanceof Time) {
                return "TIME('" + object.toString() + "')";
            }
            if (object instanceof String) {
                return "'" + object.toString() + "'";
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return "X'" + StringUtil.toHexString(byArray, 0, byArray.length) + "'";
            }
            return object.toString();
        }
    }

    public static class OR
    extends Restriction {
        public static final long serialVersionUID = -8205388794606605844L;
        private Restriction _leftChild;
        private Restriction _rightChild;

        public OR(Restriction restriction, Restriction restriction2) {
            this._leftChild = restriction;
            this._rightChild = restriction2;
        }

        public Restriction getLeftChild() {
            return this._leftChild;
        }

        public Restriction getRightChild() {
            return this._rightChild;
        }

        public String toSQL() {
            return this.parenthesize(this._leftChild.toSQL()) + " OR " + this.parenthesize(this._rightChild.toSQL());
        }
    }

    public static class AND
    extends Restriction {
        public static final long serialVersionUID = -8205388794606605844L;
        private Restriction _leftChild;
        private Restriction _rightChild;

        public AND(Restriction restriction, Restriction restriction2) {
            this._leftChild = restriction;
            this._rightChild = restriction2;
        }

        public Restriction getLeftChild() {
            return this._leftChild;
        }

        public Restriction getRightChild() {
            return this._rightChild;
        }

        public String toSQL() {
            return this.parenthesize(this._leftChild.toSQL()) + " AND " + this.parenthesize(this._rightChild.toSQL());
        }
    }
}

