/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectReleaseTracker {
    public static Map<Object, String> OBJECTS = new ConcurrentHashMap<Object, String>();

    public static boolean track(Object object) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new ObjectTrackerException().printStackTrace(pw);
        OBJECTS.put(object, sw.toString());
        return true;
    }

    public static boolean release(Object object) {
        OBJECTS.remove(object);
        return true;
    }

    public static String clearObjectTrackerAndCheckEmpty() {
        String error = null;
        Set<Map.Entry<Object, String>> entries = OBJECTS.entrySet();
        boolean empty = entries.isEmpty();
        if (entries.size() > 0) {
            HashSet<String> objects = new HashSet<String>();
            for (Map.Entry<Object, String> entry : entries) {
                objects.add(entry.getKey().getClass().getSimpleName());
            }
            error = "ObjectTracker found " + entries.size() + " object(s) that were not released!!! " + objects;
            System.err.println(error);
            for (Map.Entry<Object, String> entry : entries) {
                System.err.println(entry.getValue());
            }
        }
        OBJECTS.clear();
        return error;
    }

    private static class ObjectTrackerException
    extends RuntimeException {
        private ObjectTrackerException() {
        }
    }
}

