/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop.dedup;

import java.util.Comparator;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;

public final class SolrInputDocumentComparator
implements Comparator<SolrInputDocument> {
    private Comparator child;
    private String fieldName;

    SolrInputDocumentComparator(String fieldName, Comparator child) {
        this.child = child;
        this.fieldName = fieldName;
    }

    @Override
    public int compare(SolrInputDocument doc1, SolrInputDocument doc2) {
        SolrInputField f2;
        SolrInputField f1 = doc1.getField(this.fieldName);
        if (f1 == (f2 = doc2.getField(this.fieldName))) {
            return 0;
        }
        if (f1 == null) {
            return -1;
        }
        if (f2 == null) {
            return 1;
        }
        Object v1 = f1.getFirstValue();
        Object v2 = f2.getFirstValue();
        return this.child.compare(v1, v2);
    }

    public static final class TimeStampComparator
    implements Comparator {
        public int compare(Object v1, Object v2) {
            long t2;
            if (v1 == v2) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            long t1 = this.getLong(v1);
            return t1 < (t2 = this.getLong(v2)) ? -1 : (t1 == t2 ? 0 : 1);
        }

        private long getLong(Object v) {
            if (v instanceof Long) {
                return (Long)v;
            }
            return Long.parseLong(v.toString());
        }
    }
}

