/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.Writable;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.DataInputInputStream;
import org.apache.solr.common.util.FastOutputStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.hadoop.DataOutputOutputStream;
import org.apache.solr.hadoop.UnbufferedDataInputInputStream;

public class SolrInputDocumentWritable
implements Writable {
    private SolrInputDocument sid;

    public SolrInputDocumentWritable() {
    }

    public SolrInputDocumentWritable(SolrInputDocument sid) {
        this.sid = sid;
    }

    public SolrInputDocument getSolrInputDocument() {
        return this.sid;
    }

    public String toString() {
        return this.sid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutput out) throws IOException {
        JavaBinCodec codec = new JavaBinCodec();
        FastOutputStream daos = FastOutputStream.wrap((OutputStream)DataOutputOutputStream.constructOutputStream(out));
        codec.init(daos);
        try {
            codec.writeVal((Object)this.sid);
        }
        finally {
            daos.flushBuffer();
        }
    }

    public void readFields(DataInput in) throws IOException {
        JavaBinCodec codec = new JavaBinCodec();
        UnbufferedDataInputInputStream dis = new UnbufferedDataInputInputStream(in);
        this.sid = (SolrInputDocument)codec.readVal((DataInputInputStream)dis);
    }
}

