/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.SimplePostTool;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCLI {
    public static Logger log = LoggerFactory.getLogger(SolrCLI.class);
    public static final String DEFAULT_SOLR_URL = "http://localhost:8983/solr";
    public static final String ZK_HOST = "localhost:9983";
    public static Option[] cloudOptions;
    public static final String JSON_CONTENT_TYPE = "application/json";
    private static final String DEFAULT_CONFIG_SET = "data_driven_schema_configs";
    private static final long MS_IN_MIN = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_DAY = 86400000L;
    private static final Option[] CREATE_COLLECTION_OPTIONS;

    private static void exit(int exitStatus) {
        block2: {
            try {
                System.exit(exitStatus);
            }
            catch (SecurityException secExc) {
                if (exitStatus == 0) break block2;
                throw new RuntimeException("SolrCLI failed to exit with status " + exitStatus);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String configurerClassName;
        if (args == null || args.length == 0 || args[0] == null || args[0].trim().length() == 0) {
            System.err.println("Invalid command-line args! Must pass the name of a tool to run.\nSupported tools:\n");
            SolrCLI.displayToolOptions(System.err);
            SolrCLI.exit(1);
        }
        if ((configurerClassName = System.getProperty("solr.authentication.httpclient.configurer")) != null) {
            try {
                Class<?> c = Class.forName(configurerClassName);
                HttpClientConfigurer configurer = (HttpClientConfigurer)c.newInstance();
                HttpClientUtil.setConfigurer((HttpClientConfigurer)configurer);
                log.info("Set HttpClientConfigurer from: " + configurerClassName);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error during loading of configurer '" + configurerClassName + "'.", ex);
            }
        }
        String toolType = args[0].trim().toLowerCase(Locale.ROOT);
        Tool tool = SolrCLI.newTool(toolType);
        ArrayList<String> toolArgList = new ArrayList<String>();
        ArrayList<String> dashDList = new ArrayList<String>();
        for (int a = 1; a < args.length; ++a) {
            String arg = args[a];
            if (arg.startsWith("-D")) {
                dashDList.add(arg);
                continue;
            }
            toolArgList.add(arg);
        }
        String[] toolArgs = toolArgList.toArray(new String[0]);
        org.apache.commons.cli.CommandLine cli = SolrCLI.processCommandLineArgs(SolrCLI.joinCommonAndToolOptions(tool.getOptions()), toolArgs);
        List argList = cli.getArgList();
        argList.addAll(dashDList);
        String solrInstallDir = System.getProperty("solr.install.dir");
        if (solrInstallDir != null) {
            SolrCLI.checkSslStoreSysProp(solrInstallDir, "keyStore");
            SolrCLI.checkSslStoreSysProp(solrInstallDir, "trustStore");
        }
        SolrCLI.exit(tool.runTool(cli));
    }

    protected static void checkSslStoreSysProp(String solrInstallDir, String key) {
        String sysProp = "javax.net.ssl." + key;
        String keyStore = System.getProperty(sysProp);
        if (keyStore == null) {
            return;
        }
        File keyStoreFile = new File(keyStore);
        if (keyStoreFile.isFile()) {
            return;
        }
        keyStoreFile = new File(solrInstallDir, "server/" + keyStore);
        if (keyStoreFile.isFile()) {
            System.setProperty(sysProp, keyStoreFile.getAbsolutePath());
        } else {
            System.err.println("WARNING: " + sysProp + " file " + keyStore + " not found! https requests to Solr will likely fail; please update your " + sysProp + " setting to use an absolute path.");
        }
    }

    public static Option[] getCommonToolOptions() {
        return new Option[0];
    }

    private static Tool newTool(String toolType) throws Exception {
        if ("healthcheck".equals(toolType)) {
            return new HealthcheckTool();
        }
        if ("status".equals(toolType)) {
            return new StatusTool();
        }
        if ("api".equals(toolType)) {
            return new ApiTool();
        }
        if ("create_collection".equals(toolType)) {
            return new CreateCollectionTool();
        }
        if ("create_core".equals(toolType)) {
            return new CreateCoreTool();
        }
        if ("create".equals(toolType)) {
            return new CreateTool();
        }
        if ("delete".equals(toolType)) {
            return new DeleteTool();
        }
        if ("config".equals(toolType)) {
            return new ConfigTool();
        }
        if ("run_example".equals(toolType)) {
            return new RunExampleTool();
        }
        for (Class<Tool> next : SolrCLI.findToolClassesInPackage("org.apache.solr.util")) {
            Tool tool = next.newInstance();
            if (!toolType.equals(tool.getName())) continue;
            return tool;
        }
        throw new IllegalArgumentException(toolType + " not supported!");
    }

    private static void displayToolOptions(PrintStream out) throws Exception {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("healthcheck", SolrCLI.getToolOptions(new HealthcheckTool()));
        formatter.printHelp("status", SolrCLI.getToolOptions(new StatusTool()));
        formatter.printHelp("api", SolrCLI.getToolOptions(new ApiTool()));
        formatter.printHelp("create_collection", SolrCLI.getToolOptions(new CreateCollectionTool()));
        formatter.printHelp("create_core", SolrCLI.getToolOptions(new CreateCoreTool()));
        formatter.printHelp("create", SolrCLI.getToolOptions(new CreateTool()));
        formatter.printHelp("delete", SolrCLI.getToolOptions(new DeleteTool()));
        formatter.printHelp("config", SolrCLI.getToolOptions(new ConfigTool()));
        formatter.printHelp("run_example", SolrCLI.getToolOptions(new RunExampleTool()));
        List<Class<Tool>> toolClasses = SolrCLI.findToolClassesInPackage("org.apache.solr.util");
        for (Class<Tool> next : toolClasses) {
            Tool tool = next.newInstance();
            formatter.printHelp(tool.getName(), SolrCLI.getToolOptions(tool));
        }
    }

    private static Options getToolOptions(Tool tool) {
        Options options = new Options();
        options.addOption("help", false, "Print this message");
        options.addOption("verbose", false, "Generate verbose log messages");
        Option[] toolOpts = SolrCLI.joinCommonAndToolOptions(tool.getOptions());
        for (int i = 0; i < toolOpts.length; ++i) {
            options.addOption(toolOpts[i]);
        }
        return options;
    }

    public static Option[] joinCommonAndToolOptions(Option[] toolOpts) {
        return SolrCLI.joinOptions(SolrCLI.getCommonToolOptions(), toolOpts);
    }

    public static Option[] joinOptions(Option[] lhs, Option[] rhs) {
        ArrayList<Option> options = new ArrayList<Option>();
        if (lhs != null && lhs.length > 0) {
            for (Option opt : lhs) {
                options.add(opt);
            }
        }
        if (rhs != null) {
            for (Option opt : rhs) {
                options.add(opt);
            }
        }
        return options.toArray(new Option[0]);
    }

    public static org.apache.commons.cli.CommandLine processCommandLineArgs(Option[] customOptions, String[] args) {
        Options options = new Options();
        options.addOption("help", false, "Print this message");
        options.addOption("verbose", false, "Generate verbose log messages");
        if (customOptions != null) {
            for (int i = 0; i < customOptions.length; ++i) {
                options.addOption(customOptions[i]);
            }
        }
        org.apache.commons.cli.CommandLine cli = null;
        try {
            cli = new GnuParser().parse(options, args);
        }
        catch (ParseException exp) {
            boolean hasHelpArg = false;
            if (args != null && args.length > 0) {
                for (int z = 0; z < args.length; ++z) {
                    if (!"--help".equals(args[z]) && !"-help".equals(args[z])) continue;
                    hasHelpArg = true;
                    break;
                }
            }
            if (!hasHelpArg) {
                System.err.println("Failed to parse command-line arguments due to: " + exp.getMessage());
            }
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(SolrCLI.class.getName(), options);
            SolrCLI.exit(1);
        }
        if (cli.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(SolrCLI.class.getName(), options);
            SolrCLI.exit(0);
        }
        return cli;
    }

    private static List<Class<Tool>> findToolClassesInPackage(String packageName) {
        ArrayList<Class<Tool>> toolClasses = new ArrayList<Class<Tool>>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            TreeSet<String> classes = new TreeSet<String>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                classes.addAll(SolrCLI.findClasses(resource.getFile(), packageName));
            }
            for (String classInPackage : classes) {
                Class<?> theClass = Class.forName(classInPackage);
                if (!Tool.class.isAssignableFrom(theClass)) continue;
                toolClasses.add(theClass);
            }
        }
        catch (Exception e) {
            log.debug("Failed to find Tool impl classes in " + packageName + " due to: " + e);
        }
        return toolClasses;
    }

    private static Set<String> findClasses(String path, String packageName) throws Exception {
        TreeSet<String> classes = new TreeSet<String>();
        if (path.startsWith("file:") && path.contains("!")) {
            ZipEntry entry;
            String[] split = path.split("!");
            URL jar = new URL(split[0]);
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || !(className = entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.')).startsWith(packageName)) continue;
                classes.add(className);
            }
        }
        return classes;
    }

    public static boolean checkCommunicationError(Exception exc) {
        Throwable rootCause = SolrException.getRootCause((Throwable)exc);
        boolean wasCommError = rootCause instanceof ConnectException || rootCause instanceof ConnectTimeoutException || rootCause instanceof NoHttpResponseException || rootCause instanceof SocketException;
        return wasCommError;
    }

    public static CloseableHttpClient getHttpClient() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("maxConnections", 128);
        params.set("maxConnectionsPerHost", 32);
        params.set("followRedirects", false);
        return HttpClientUtil.createClient((SolrParams)params);
    }

    public static void closeHttpClient(CloseableHttpClient httpClient) {
        if (httpClient != null) {
            try {
                HttpClientUtil.close((HttpClient)httpClient);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static NamedList<Object> postJsonToSolr(SolrClient solrClient, String updatePath, String jsonBody) throws Exception {
        ContentStreamBase.StringStream contentStream = new ContentStreamBase.StringStream(jsonBody);
        contentStream.setContentType(JSON_CONTENT_TYPE);
        ContentStreamUpdateRequest req = new ContentStreamUpdateRequest(updatePath);
        req.addContentStream((ContentStream)contentStream);
        return solrClient.request((SolrRequest)req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getJson(String getUrl) throws Exception {
        Map<String, Object> json = null;
        CloseableHttpClient httpClient = SolrCLI.getHttpClient();
        try {
            json = SolrCLI.getJson((HttpClient)httpClient, getUrl, 2, true);
        }
        finally {
            SolrCLI.closeHttpClient(httpClient);
        }
        return json;
    }

    public static Map<String, Object> getJson(HttpClient httpClient, String getUrl, int attempts, boolean isFirstAttempt) throws Exception {
        Map<String, Object> json = null;
        if (attempts >= 1) {
            try {
                json = SolrCLI.getJson(httpClient, getUrl);
            }
            catch (Exception exc) {
                if (--attempts > 0 && SolrCLI.checkCommunicationError(exc)) {
                    if (!isFirstAttempt) {
                        log.warn("Request to " + getUrl + " failed due to: " + exc.getMessage() + ", sleeping for 5 seconds before re-trying the request ...");
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.interrupted();
                    }
                    json = SolrCLI.getJson(httpClient, getUrl, attempts, false);
                }
                throw exc;
            }
        }
        return json;
    }

    public static Map<String, Object> getJson(HttpClient httpClient, String getUrl) throws Exception {
        HttpGet httpGet = new HttpGet(new URIBuilder(getUrl).setParameter("wt", "json").build());
        Map json = (Map)httpClient.execute((HttpUriRequest)httpGet, (ResponseHandler)new SolrResponseHandler());
        Long statusCode = SolrCLI.asLong("/responseHeader/status", json);
        if (statusCode == -1L) {
            throw new SolrServerException("Unable to determine outcome of GET request to: " + getUrl + "! Response: " + json);
        }
        if (statusCode != 0L) {
            String errMsg = SolrCLI.asString("/error/msg", json);
            if (errMsg == null) {
                errMsg = String.valueOf(json);
            }
            throw new SolrServerException(errMsg);
        }
        Object failureObj = json.get("failure");
        if (failureObj != null) {
            Object err;
            if (failureObj instanceof Map && (err = ((Map)failureObj).get("")) != null) {
                throw new SolrServerException(err.toString());
            }
            throw new SolrServerException(failureObj.toString());
        }
        return json;
    }

    public static String asString(String jsonPath, Map<String, Object> json) {
        return SolrCLI.pathAs(String.class, jsonPath, json);
    }

    public static Long asLong(String jsonPath, Map<String, Object> json) {
        return SolrCLI.pathAs(Long.class, jsonPath, json);
    }

    public static List<String> asList(String jsonPath, Map<String, Object> json) {
        return SolrCLI.pathAs(List.class, jsonPath, json);
    }

    public static Map<String, Object> asMap(String jsonPath, Map<String, Object> json) {
        return SolrCLI.pathAs(Map.class, jsonPath, json);
    }

    public static <T> T pathAs(Class<T> clazz, String jsonPath, Map<String, Object> json) {
        Object val = null;
        Object obj = SolrCLI.atPath(jsonPath, json);
        if (obj != null) {
            if (clazz.isAssignableFrom(obj.getClass())) {
                val = obj;
            } else {
                throw new IllegalStateException("Expected a " + clazz.getName() + " at path " + jsonPath + " but found " + obj + " instead! " + json);
            }
        }
        return (T)val;
    }

    public static Object atPath(String jsonPath, Map<String, Object> json) {
        Object child;
        if ("/".equals(jsonPath)) {
            return json;
        }
        if (!jsonPath.startsWith("/")) {
            throw new IllegalArgumentException("Invalid JSON path: " + jsonPath + "! Must start with a /");
        }
        Map parent = json;
        Object result = null;
        String[] path = jsonPath.split("/");
        for (int p = 1; p < path.length && (child = parent.get(path[p])) != null; ++p) {
            if (p == path.length - 1) {
                result = child;
                continue;
            }
            if (!(child instanceof Map)) break;
            parent = (Map)child;
        }
        return result;
    }

    private static final String uptime(long uptimeMs) {
        if (uptimeMs <= 0L) {
            return "?";
        }
        long numDays = uptimeMs >= 86400000L ? (long)Math.floor(uptimeMs / 86400000L) : 0L;
        long rem = uptimeMs - numDays * 86400000L;
        long numHours = rem >= 3600000L ? (long)Math.floor(rem / 3600000L) : 0L;
        long numMinutes = (rem -= numHours * 3600000L) >= 60000L ? (long)Math.floor(rem / 60000L) : 0L;
        long numSeconds = Math.round((rem -= numMinutes * 60000L) / 1000L);
        return String.format(Locale.ROOT, "%d days, %d hours, %d minutes, %d seconds", numDays, numHours, numMinutes, numSeconds);
    }

    public static String resolveSolrUrl(org.apache.commons.cli.CommandLine cli) throws Exception {
        String solrUrl = cli.getOptionValue("solrUrl");
        if (solrUrl == null) {
            String zkHost = cli.getOptionValue("zkHost");
            if (zkHost == null) {
                throw new IllegalStateException("Must provide either the '-solrUrl' or '-zkHost' parameters!");
            }
            try (CloudSolrClient cloudSolrClient = new CloudSolrClient(zkHost);){
                cloudSolrClient.connect();
                Set liveNodes = cloudSolrClient.getZkStateReader().getClusterState().getLiveNodes();
                if (liveNodes.isEmpty()) {
                    throw new IllegalStateException("No live nodes found! Cannot determine 'solrUrl' from ZooKeeper: " + zkHost);
                }
                String firstLiveNode = (String)liveNodes.iterator().next();
                solrUrl = cloudSolrClient.getZkStateReader().getBaseUrlForNodeName(firstLiveNode);
            }
        }
        return solrUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getZkHost(org.apache.commons.cli.CommandLine cli) throws Exception {
        String zkHost = cli.getOptionValue("zkHost");
        if (zkHost != null) {
            return zkHost;
        }
        String solrUrl = cli.getOptionValue("solrUrl");
        if (solrUrl == null) {
            throw new IllegalStateException("Must provide either the -zkHost or -solrUrl parameters to use the create_collection command!");
        }
        if (!solrUrl.endsWith("/")) {
            solrUrl = solrUrl + "/";
        }
        String systemInfoUrl = solrUrl + "admin/info/system";
        CloseableHttpClient httpClient = SolrCLI.getHttpClient();
        try {
            Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2, true);
            StatusTool statusTool = new StatusTool();
            Map<String, Object> status = statusTool.reportStatus(solrUrl, systemInfo, (HttpClient)httpClient);
            Map cloud = (Map)status.get("cloud");
            if (cloud != null) {
                String zookeeper = (String)cloud.get("ZooKeeper");
                if (zookeeper.endsWith("(embedded)")) {
                    zookeeper = zookeeper.substring(0, zookeeper.length() - "(embedded)".length());
                }
                zkHost = zookeeper;
            }
        }
        finally {
            HttpClientUtil.close((HttpClient)httpClient);
        }
        return zkHost;
    }

    public static boolean safeCheckCollectionExists(String url, String collection) {
        boolean exists = false;
        try {
            Map<String, Object> existsCheckResult = SolrCLI.getJson(url);
            List collections = (List)existsCheckResult.get("collections");
            exists = collections != null && collections.contains(collection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    public static boolean safeCheckCoreExists(String coreStatusUrl, String coreName) {
        boolean exists = false;
        try {
            Map<String, Object> existsCheckResult = SolrCLI.getJson(coreStatusUrl);
            Map status = (Map)existsCheckResult.get("status");
            Map coreStatus = (Map)status.get(coreName);
            exists = coreStatus != null && coreStatus.containsKey("name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    static {
        Option[] optionArray = new Option[2];
        OptionBuilder.withArgName((String)"HOST");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Address of the Zookeeper ensemble; defaults to: localhost:9983");
        optionArray[0] = OptionBuilder.create((String)"zkHost");
        OptionBuilder.withArgName((String)"COLLECTION");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Name of collection; no default");
        optionArray[1] = OptionBuilder.create((String)"collection");
        cloudOptions = optionArray;
        Option[] optionArray2 = new Option[9];
        OptionBuilder.withArgName((String)"HOST");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Address of the Zookeeper ensemble; defaults to: localhost:9983");
        optionArray2[0] = OptionBuilder.create((String)"zkHost");
        OptionBuilder.withArgName((String)"HOST");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Base Solr URL, which can be used to determine the zkHost if that's not known");
        optionArray2[1] = OptionBuilder.create((String)"solrUrl");
        OptionBuilder.withArgName((String)"NAME");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Name of collection to create.");
        optionArray2[2] = OptionBuilder.create((String)"name");
        OptionBuilder.withArgName((String)"#");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Number of shards; default is 1");
        optionArray2[3] = OptionBuilder.create((String)"shards");
        OptionBuilder.withArgName((String)"#");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Number of copies of each document across the collection (replicas per shard); default is 1");
        optionArray2[4] = OptionBuilder.create((String)"replicationFactor");
        OptionBuilder.withArgName((String)"#");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Maximum number of shards per Solr node; default is determined based on the number of shards, replication factor, and live nodes.");
        optionArray2[5] = OptionBuilder.create((String)"maxShardsPerNode");
        OptionBuilder.withArgName((String)"NAME");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Configuration directory to copy when creating the new collection; default is data_driven_schema_configs");
        optionArray2[6] = OptionBuilder.create((String)"confdir");
        OptionBuilder.withArgName((String)"NAME");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Configuration name; default is the collection name");
        optionArray2[7] = OptionBuilder.create((String)"confname");
        OptionBuilder.withArgName((String)"DIR");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Path to configsets directory on the local system.");
        optionArray2[8] = OptionBuilder.create((String)"configsetsDir");
        CREATE_COLLECTION_OPTIONS = optionArray2;
    }

    public static class RunExampleTool
    extends ToolBase {
        private static final String PROMPT_FOR_NUMBER = "Please enter %s [%d]: ";
        private static final String PROMPT_FOR_NUMBER_IN_RANGE = "Please enter %s between %d and %d [%d]: ";
        private static final String PROMPT_NUMBER_TOO_SMALL = "%d is too small! Please enter %s between %d and %d [%d]: ";
        private static final String PROMPT_NUMBER_TOO_LARGE = "%d is too large! Please enter %s between %d and %d [%d]: ";
        protected InputStream userInput;
        protected Executor executor;
        protected String script;
        protected File serverDir;
        protected File exampleDir;
        protected String urlScheme;

        public RunExampleTool() {
            this(null, System.in, System.out);
        }

        public RunExampleTool(Executor executor, InputStream userInput, PrintStream stdout) {
            super(stdout);
            this.executor = executor != null ? executor : new DefaultExecutor();
            this.userInput = userInput;
        }

        @Override
        public String getName() {
            return "run_example";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[12];
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Don't prompt for input; accept all defaults when running examples that accept user input");
            optionArray[0] = OptionBuilder.create((String)"noprompt");
            OptionBuilder.withArgName((String)"NAME");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            OptionBuilder.withDescription((String)"Name of the example to launch, one of: cloud, techproducts, dih, schemaless");
            OptionBuilder.withLongOpt((String)"example");
            optionArray[1] = OptionBuilder.create((char)'e');
            OptionBuilder.withArgName((String)"PATH");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Path to the bin/solr script");
            optionArray[2] = OptionBuilder.create((String)"script");
            OptionBuilder.withArgName((String)"DIR");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            OptionBuilder.withDescription((String)"Path to the Solr server directory.");
            OptionBuilder.withLongOpt((String)"serverDir");
            optionArray[3] = OptionBuilder.create((char)'d');
            OptionBuilder.withArgName((String)"DIR");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Path to the Solr example directory; if not provided, ${serverDir}/../example is expected to exist.");
            optionArray[4] = OptionBuilder.create((String)"exampleDir");
            OptionBuilder.withArgName((String)"SCHEME");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Solr URL scheme: http or https, defaults to http if not specified");
            optionArray[5] = OptionBuilder.create((String)"urlScheme");
            OptionBuilder.withArgName((String)"PORT");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Specify the port to start the Solr HTTP listener on; default is 8983");
            OptionBuilder.withLongOpt((String)"port");
            optionArray[6] = OptionBuilder.create((char)'p');
            OptionBuilder.withArgName((String)"HOSTNAME");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Specify the hostname for this Solr instance");
            OptionBuilder.withLongOpt((String)"host");
            optionArray[7] = OptionBuilder.create((char)'h');
            OptionBuilder.withArgName((String)"ZKHOST");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"ZooKeeper connection string; only used when running in SolrCloud mode using -c");
            OptionBuilder.withLongOpt((String)"zkhost");
            optionArray[8] = OptionBuilder.create((char)'z');
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Start Solr in SolrCloud mode; if -z not supplied, an embedded ZooKeeper instance is started on Solr port+1000, such as 9983 if Solr is bound to 8983");
            OptionBuilder.withLongOpt((String)"cloud");
            optionArray[9] = OptionBuilder.create((char)'c');
            OptionBuilder.withArgName((String)"MEM");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Sets the min (-Xms) and max (-Xmx) heap size for the JVM, such as: -m 4g results in: -Xms4g -Xmx4g; by default, this script sets the heap size to 512m");
            OptionBuilder.withLongOpt((String)"memory");
            optionArray[10] = OptionBuilder.create((char)'m');
            OptionBuilder.withArgName((String)"OPTS");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Additional options to be passed to the JVM when starting example Solr server(s)");
            OptionBuilder.withLongOpt((String)"addlopts");
            optionArray[11] = OptionBuilder.create((char)'a');
            return optionArray;
        }

        @Override
        protected void runImpl(org.apache.commons.cli.CommandLine cli) throws Exception {
            String exampleType;
            this.urlScheme = cli.getOptionValue("urlScheme", "http");
            this.serverDir = new File(cli.getOptionValue("serverDir"));
            if (!this.serverDir.isDirectory()) {
                throw new IllegalArgumentException("Value of -serverDir option is invalid! " + this.serverDir.getAbsolutePath() + " is not a directory!");
            }
            this.script = cli.getOptionValue("script");
            if (this.script != null) {
                if (!new File(this.script).isFile()) {
                    throw new IllegalArgumentException("Value of -script option is invalid! " + this.script + " not found");
                }
            } else {
                File scriptFile = new File(this.serverDir.getParentFile(), "bin/solr");
                if (scriptFile.isFile()) {
                    this.script = scriptFile.getAbsolutePath();
                } else {
                    scriptFile = new File(this.serverDir.getParentFile(), "bin/solr.cmd");
                    if (scriptFile.isFile()) {
                        this.script = scriptFile.getAbsolutePath();
                    } else {
                        throw new IllegalArgumentException("Cannot locate the bin/solr script! Please pass -script to this application.");
                    }
                }
            }
            File file = this.exampleDir = cli.hasOption("exampleDir") ? new File(cli.getOptionValue("exampleDir")) : new File(this.serverDir.getParent(), "example");
            if (!this.exampleDir.isDirectory()) {
                throw new IllegalArgumentException("Value of -exampleDir option is invalid! " + this.exampleDir.getAbsolutePath() + " is not a directory!");
            }
            if (this.verbose) {
                this.echo("Running with\nserverDir=" + this.serverDir.getAbsolutePath() + ",\nexampleDir=" + this.exampleDir.getAbsolutePath() + "\nscript=" + this.script);
            }
            if ("cloud".equals(exampleType = cli.getOptionValue("example"))) {
                this.runCloudExample(cli);
            } else if ("dih".equals(exampleType)) {
                this.runDihExample(cli);
            } else if ("techproducts".equals(exampleType) || "schemaless".equals(exampleType)) {
                this.runExample(cli, exampleType);
            } else {
                throw new IllegalArgumentException("Unsupported example " + exampleType + "! Please choose one of: cloud, dih, schemaless, or techproducts");
            }
        }

        protected void runDihExample(org.apache.commons.cli.CommandLine cli) throws Exception {
            File dihSolrHome = new File(this.exampleDir, "example-DIH/solr");
            if (!dihSolrHome.isDirectory() && !(dihSolrHome = new File(this.serverDir.getParentFile(), "example/example-DIH/solr")).isDirectory()) {
                throw new Exception("example/example-DIH/solr directory not found");
            }
            boolean isCloudMode = cli.hasOption('c');
            String zkHost = cli.getOptionValue('z');
            int port = Integer.parseInt(cli.getOptionValue('p', "8983"));
            Map<String, Object> nodeStatus = this.startSolr(dihSolrHome, isCloudMode, cli, port, zkHost, 30);
            String solrUrl = (String)nodeStatus.get("baseUrl");
            this.echo("\nSolr dih example launched successfully. Direct your Web browser to " + solrUrl + " to visit the Solr Admin UI");
        }

        protected void runExample(org.apache.commons.cli.CommandLine cli, String exampleName) throws Exception {
            File exDir = this.setupExampleDir(this.serverDir, this.exampleDir, exampleName);
            String collectionName = "schemaless".equals(exampleName) ? "gettingstarted" : exampleName;
            String configSet = "techproducts".equals(exampleName) ? "sample_techproducts_configs" : SolrCLI.DEFAULT_CONFIG_SET;
            boolean isCloudMode = cli.hasOption('c');
            String zkHost = cli.getOptionValue('z');
            int port = Integer.parseInt(cli.getOptionValue('p', "8983"));
            Map<String, Object> nodeStatus = this.startSolr(new File(exDir, "solr"), isCloudMode, cli, port, zkHost, 30);
            File configsetsDir = new File(this.serverDir, "solr/configsets");
            String solrUrl = (String)nodeStatus.get("baseUrl");
            boolean alreadyExists = false;
            if (nodeStatus.get("cloud") != null) {
                String collectionListUrl = solrUrl + "/admin/collections?action=list";
                if (SolrCLI.safeCheckCollectionExists(collectionListUrl, collectionName)) {
                    alreadyExists = true;
                    this.echo("\nWARNING: Collection '" + collectionName + "' already exists!\nChecked collection existence using Collections API command:\n" + collectionListUrl + "\n");
                }
            } else {
                String coreName = collectionName;
                String coreStatusUrl = solrUrl + "/admin/cores?action=STATUS&core=" + coreName;
                if (SolrCLI.safeCheckCoreExists(coreStatusUrl, coreName)) {
                    alreadyExists = true;
                    this.echo("\nWARNING: Core '" + coreName + "' already exists!\nChecked core existence using Core API command:\n" + coreStatusUrl + "\n");
                }
            }
            if (!alreadyExists) {
                String[] createArgs = new String[]{"-name", collectionName, "-shards", "1", "-replicationFactor", "1", "-confname", collectionName, "-confdir", configSet, "-configsetsDir", configsetsDir.getAbsolutePath(), "-solrUrl", solrUrl};
                CreateTool createTool = new CreateTool(this.stdout);
                int createCode = createTool.runTool(SolrCLI.processCommandLineArgs(SolrCLI.joinCommonAndToolOptions(createTool.getOptions()), createArgs));
                if (createCode != 0) {
                    throw new Exception("Failed to create " + collectionName + " using command: " + Arrays.asList(createArgs));
                }
            }
            if ("techproducts".equals(exampleName)) {
                File readOnlyExampleDir;
                File exampledocsDir = new File(this.exampleDir, "exampledocs");
                if (!exampledocsDir.isDirectory() && (readOnlyExampleDir = new File(this.serverDir.getParentFile(), "example")).isDirectory()) {
                    exampledocsDir = new File(readOnlyExampleDir, "exampledocs");
                }
                if (exampledocsDir.isDirectory()) {
                    String updateUrl = String.format(Locale.ROOT, "%s/%s/update", solrUrl, collectionName);
                    this.echo("Indexing tech product example docs from " + exampledocsDir.getAbsolutePath());
                    String currentPropVal = System.getProperty("url");
                    System.setProperty("url", updateUrl);
                    SimplePostTool.main(new String[]{exampledocsDir.getAbsolutePath() + "/*.xml"});
                    if (currentPropVal != null) {
                        System.setProperty("url", currentPropVal);
                    } else {
                        System.clearProperty("url");
                    }
                } else {
                    this.echo("exampledocs directory not found, skipping indexing step for the techproducts example");
                }
            }
            this.echo("\nSolr " + exampleName + " example launched successfully. Direct your Web browser to " + solrUrl + " to visit the Solr Admin UI");
        }

        protected void runCloudExample(org.apache.commons.cli.CommandLine cli) throws Exception {
            String solrUrl;
            Scanner readInput;
            boolean prompt = !cli.hasOption("noprompt");
            int numNodes = 2;
            int[] cloudPorts = new int[]{8983, 7574, 8984, 7575};
            File cloudDir = new File(this.exampleDir, "cloud");
            if (!cloudDir.isDirectory()) {
                cloudDir.mkdir();
            }
            this.echo("\nWelcome to the SolrCloud example!\n");
            Scanner scanner = readInput = prompt ? new Scanner(this.userInput, StandardCharsets.UTF_8.name()) : null;
            if (prompt) {
                this.echo("This interactive session will help you launch a SolrCloud cluster on your local workstation.");
                numNodes = this.promptForInt(readInput, "To begin, how many Solr nodes would you like to run in your local cluster? (specify 1-4 nodes) [2]: ", "a number", numNodes, 1, 4);
                this.echo("Ok, let's start up " + numNodes + " Solr nodes for your example SolrCloud cluster.");
                for (int n = 0; n < numNodes; ++n) {
                    String promptMsg = String.format(Locale.ROOT, "Please enter the port for node%d [%d]: ", n + 1, cloudPorts[n]);
                    int port = this.promptForPort(readInput, n + 1, promptMsg, cloudPorts[n]);
                    while (!this.isPortAvailable(port)) {
                        port = this.promptForPort(readInput, n + 1, "Oops! Looks like port " + port + " is already being used by another process. Please choose a different port.", cloudPorts[n]);
                    }
                    cloudPorts[n] = port;
                    if (!this.verbose) continue;
                    this.echo("Using port " + port + " for node " + (n + 1));
                }
            } else {
                this.echo("Starting up " + numNodes + " Solr nodes for your example SolrCloud cluster.\n");
            }
            File node1Dir = this.setupExampleDir(this.serverDir, cloudDir, "node1");
            for (int n = 2; n <= numNodes; ++n) {
                File nodeNDir = new File(cloudDir, "node" + n);
                if (!nodeNDir.isDirectory()) {
                    this.echo("Cloning " + node1Dir.getAbsolutePath() + " into\n   " + nodeNDir.getAbsolutePath());
                    FileUtils.copyDirectory((File)node1Dir, (File)nodeNDir);
                    continue;
                }
                this.echo(nodeNDir.getAbsolutePath() + " already exists.");
            }
            String zkHost = cli.getOptionValue('z');
            Map<String, Object> nodeStatus = this.startSolr(new File(node1Dir, "solr"), true, cli, cloudPorts[0], zkHost, 30);
            if (zkHost == null) {
                String zookeeper;
                Map cloudStatus = (Map)nodeStatus.get("cloud");
                if (cloudStatus != null && (zookeeper = (String)cloudStatus.get("ZooKeeper")) != null) {
                    zkHost = zookeeper;
                }
                if (zkHost == null) {
                    throw new Exception("Could not get the ZooKeeper connection string for node1!");
                }
            }
            if (numNodes > 1) {
                for (int n = 1; n < numNodes; ++n) {
                    this.startSolr(new File(cloudDir, "node" + (n + 1) + "/solr"), true, cli, cloudPorts[n], zkHost, 30);
                }
            }
            if ((solrUrl = (String)nodeStatus.get("baseUrl")).endsWith("/")) {
                solrUrl = solrUrl.substring(0, solrUrl.length() - 1);
            }
            this.waitToSeeLiveNodes(10, zkHost, numNodes);
            String collectionName = this.createCloudExampleCollection(numNodes, readInput, prompt, solrUrl);
            this.echo("\nEnabling auto soft-commits with maxTime 3 secs using the Config API");
            this.setCollectionConfigProperty(solrUrl, collectionName, "updateHandler.autoSoftCommit.maxTime", "3000");
            this.echo("\n\nSolrCloud example running, please visit: " + solrUrl + " \n");
        }

        protected void setCollectionConfigProperty(String solrUrl, String collectionName, String propName, String propValue) {
            ConfigTool configTool = new ConfigTool(this.stdout);
            String[] configArgs = new String[]{"-collection", collectionName, "-property", propName, "-value", propValue, "-solrUrl", solrUrl};
            try {
                configTool.runTool(SolrCLI.processCommandLineArgs(SolrCLI.joinCommonAndToolOptions(configTool.getOptions()), configArgs));
            }
            catch (Exception exc) {
                System.err.println("Failed to update '" + propName + "' property due to: " + exc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void waitToSeeLiveNodes(int maxWaitSecs, String zkHost, int numNodes) {
            CloudSolrClient cloudClient = null;
            try {
                cloudClient = new CloudSolrClient(zkHost);
                cloudClient.connect();
                Set liveNodes = cloudClient.getZkStateReader().getClusterState().getLiveNodes();
                int numLiveNodes = liveNodes != null ? liveNodes.size() : 0;
                long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(maxWaitSecs, TimeUnit.SECONDS);
                while (System.nanoTime() < timeout && numLiveNodes < numNodes) {
                    this.echo("\nWaiting up to " + maxWaitSecs + " seconds to see " + (numNodes - numLiveNodes) + " more nodes join the SolrCloud cluster ...");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.interrupted();
                    }
                    liveNodes = cloudClient.getZkStateReader().getClusterState().getLiveNodes();
                    numLiveNodes = liveNodes != null ? liveNodes.size() : 0;
                }
                if (numLiveNodes < numNodes) {
                    this.echo("\nWARNING: Only " + numLiveNodes + " of " + numNodes + " are active in the cluster after " + maxWaitSecs + " seconds! Please check the solr.log for each node to look for errors.\n");
                }
            }
            catch (Exception exc) {
                System.err.println("Failed to see if " + numNodes + " joined the SolrCloud cluster due to: " + exc);
            }
            finally {
                if (cloudClient != null) {
                    try {
                        cloudClient.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }

        protected Map<String, Object> startSolr(File solrHomeDir, boolean cloudMode, org.apache.commons.cli.CommandLine cli, int port, String zkHost, int maxWaitSecs) throws Exception {
            String extraArgs = this.readExtraArgs(cli.getArgs());
            String host = cli.getOptionValue('h');
            String memory = cli.getOptionValue('m');
            String hostArg = host != null && !"localhost".equals(host) ? " -h " + host : "";
            String zkHostArg = zkHost != null ? " -z " + zkHost : "";
            String memArg = memory != null ? " -m " + memory : "";
            String cloudModeArg = cloudMode ? "-cloud " : "";
            String addlOpts = cli.getOptionValue('a');
            String addlOptsArg = addlOpts != null ? " -a \"" + addlOpts + "\"" : "";
            File cwd = new File(System.getProperty("user.dir"));
            File binDir = new File(this.script).getParentFile();
            boolean isWindows = OS.isFamilyDOS() || OS.isFamilyWin9x() || OS.isFamilyWindows();
            String callScript = !isWindows && cwd.equals(binDir.getParentFile()) ? "bin/solr" : this.script;
            String cwdPath = cwd.getAbsolutePath();
            String solrHome = solrHomeDir.getAbsolutePath();
            if (!isWindows && solrHome.startsWith(cwdPath)) {
                solrHome = solrHome.substring(cwdPath.length() + 1);
            }
            String startCmd = String.format(Locale.ROOT, "%s start %s -p %d -s \"%s\" %s %s %s %s %s", callScript, cloudModeArg, port, solrHome, hostArg, zkHostArg, memArg, extraArgs, addlOptsArg);
            startCmd = startCmd.replaceAll("\\s+", " ").trim();
            this.echo("\nStarting up Solr on port " + port + " using command:");
            this.echo(startCmd + "\n");
            String solrUrl = String.format(Locale.ROOT, "%s://%s:%d/solr", this.urlScheme, host != null ? host : "localhost", port);
            Map<String, Object> nodeStatus = this.checkPortConflict(solrUrl, solrHomeDir, port, cli);
            if (nodeStatus != null) {
                return nodeStatus;
            }
            int code = 0;
            if (isWindows) {
                HashMap<String, String> startEnv = new HashMap<String, String>();
                Map procEnv = EnvironmentUtils.getProcEnvironment();
                if (procEnv != null) {
                    for (String envVar : procEnv.keySet()) {
                        String envVarVal = (String)procEnv.get(envVar);
                        if (envVarVal == null || "EXAMPLE".equals(envVar) || envVar.startsWith("SOLR_")) continue;
                        startEnv.put(envVar, envVarVal);
                    }
                }
                this.executor.execute(CommandLine.parse((String)startCmd), startEnv, (ExecuteResultHandler)new DefaultExecuteResultHandler());
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
            } else {
                code = this.executor.execute(CommandLine.parse((String)startCmd));
            }
            if (code != 0) {
                throw new Exception("Failed to start Solr using command: " + startCmd);
            }
            return this.getNodeStatus(solrUrl, maxWaitSecs);
        }

        protected Map<String, Object> checkPortConflict(String solrUrl, File solrHomeDir, int port, org.apache.commons.cli.CommandLine cli) {
            String solr_home;
            if (this.isPortAvailable(port)) {
                return null;
            }
            Map<String, Object> nodeStatus = null;
            try {
                nodeStatus = new StatusTool().getStatus(solrUrl);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (nodeStatus != null && (solr_home = (String)nodeStatus.get("solr_home")) != null) {
                String solrHomePath = solrHomeDir.getAbsolutePath();
                if (!solrHomePath.endsWith("/")) {
                    solrHomePath = solrHomePath + "/";
                }
                if (!solr_home.endsWith("/")) {
                    solr_home = solr_home + "/";
                }
                if (solrHomePath.equals(solr_home)) {
                    CharArr arr = new CharArr();
                    new JSONWriter(arr, 2).write(nodeStatus);
                    this.echo("Solr is already setup and running on port " + port + " with status:\n" + arr.toString());
                    this.echo("\nIf this is not the example node you are trying to start, please choose a different port.");
                    nodeStatus.put("baseUrl", solrUrl);
                    return nodeStatus;
                }
            }
            throw new IllegalStateException("Port " + port + " is already being used by another process.");
        }

        protected String readExtraArgs(String[] extraArgsArr) {
            String extraArgs = "";
            if (extraArgsArr != null && extraArgsArr.length > 0) {
                StringBuilder sb = new StringBuilder();
                int app = 0;
                for (int e = 0; e < extraArgsArr.length; ++e) {
                    String arg = extraArgsArr[e];
                    if ("e".equals(arg) || "example".equals(arg)) {
                        ++e;
                        continue;
                    }
                    if (app > 0) {
                        sb.append(" ");
                    }
                    sb.append(arg);
                    ++app;
                }
                extraArgs = sb.toString().trim();
            }
            return extraArgs;
        }

        protected String createCloudExampleCollection(int numNodes, Scanner readInput, boolean prompt, String solrUrl) throws Exception {
            int numShards = 2;
            int replicationFactor = 2;
            String cloudConfig = SolrCLI.DEFAULT_CONFIG_SET;
            String collectionName = "gettingstarted";
            File configsetsDir = new File(this.serverDir, "solr/configsets");
            String collectionListUrl = solrUrl + "/admin/collections?action=list";
            if (prompt) {
                this.echo("\nNow let's create a new collection for indexing documents in your " + numNodes + "-node cluster.");
                while (SolrCLI.safeCheckCollectionExists(collectionListUrl, collectionName = this.prompt(readInput, "Please provide a name for your new collection: [" + collectionName + "] ", collectionName))) {
                    this.echo("\nCollection '" + collectionName + "' already exists!");
                    int oneOrTwo = this.promptForInt(readInput, "Do you want to re-use the existing collection or create a new one? Enter 1 to reuse, 2 to create new [1]: ", "a 1 or 2", 1, 1, 2);
                    if (oneOrTwo != 1) continue;
                    return collectionName;
                }
                numShards = this.promptForInt(readInput, "How many shards would you like to split " + collectionName + " into? [2]", "a shard count", 2, 1, 4);
                replicationFactor = this.promptForInt(readInput, "How many replicas per shard would you like to create? [2] ", "a replication factor", 2, 1, 4);
                this.echo("Please choose a configuration for the " + collectionName + " collection, available options are:");
                cloudConfig = this.prompt(readInput, "basic_configs, data_driven_schema_configs, or sample_techproducts_configs [" + cloudConfig + "] ", cloudConfig);
                while (!this.isValidConfig(configsetsDir, cloudConfig)) {
                    this.echo(cloudConfig + " is not a valid configuration directory! Please choose a configuration for the " + collectionName + " collection, available options are:");
                    cloudConfig = this.prompt(readInput, "basic_configs, data_driven_schema_configs, or sample_techproducts_configs [" + cloudConfig + "] ", cloudConfig);
                }
            } else if (SolrCLI.safeCheckCollectionExists(collectionListUrl, collectionName)) {
                this.echo("\nCollection '" + collectionName + "' already exists! Skipping collection creation step.");
                return collectionName;
            }
            String[] createArgs = new String[]{"-name", collectionName, "-shards", String.valueOf(numShards), "-replicationFactor", String.valueOf(replicationFactor), "-confname", collectionName, "-confdir", cloudConfig, "-configsetsDir", configsetsDir.getAbsolutePath(), "-solrUrl", solrUrl};
            CreateCollectionTool createCollectionTool = new CreateCollectionTool(this.stdout);
            int createCode = createCollectionTool.runTool(SolrCLI.processCommandLineArgs(SolrCLI.joinCommonAndToolOptions(createCollectionTool.getOptions()), createArgs));
            if (createCode != 0) {
                throw new Exception("Failed to create collection using command: " + Arrays.asList(createArgs));
            }
            return collectionName;
        }

        protected boolean isValidConfig(File configsetsDir, String config) {
            File configDir = new File(configsetsDir, config);
            if (configDir.isDirectory()) {
                return true;
            }
            configDir = new File(config);
            return configDir.isDirectory();
        }

        protected Map<String, Object> getNodeStatus(String solrUrl, int maxWaitSecs) throws Exception {
            String mode;
            StatusTool statusTool = new StatusTool();
            if (this.verbose) {
                this.echo("\nChecking status of Solr at " + solrUrl + " ...");
            }
            URL solrURL = new URL(solrUrl);
            Map<String, Object> nodeStatus = statusTool.waitToSeeSolrUp(solrUrl, maxWaitSecs);
            nodeStatus.put("baseUrl", solrUrl);
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(nodeStatus);
            String string = mode = nodeStatus.get("cloud") != null ? "cloud" : "standalone";
            if (this.verbose) {
                this.echo("\nSolr is running on " + solrURL.getPort() + " in " + mode + " mode with status:\n" + arr.toString());
            }
            return nodeStatus;
        }

        protected File setupExampleDir(File serverDir, File exampleParentDir, String dirName) throws IOException {
            File solrXml = new File(serverDir, "solr/solr.xml");
            if (!solrXml.isFile()) {
                throw new IllegalArgumentException("Value of -serverDir option is invalid! " + solrXml.getAbsolutePath() + " not found!");
            }
            File zooCfg = new File(serverDir, "solr/zoo.cfg");
            if (!zooCfg.isFile()) {
                throw new IllegalArgumentException("Value of -serverDir option is invalid! " + zooCfg.getAbsolutePath() + " not found!");
            }
            File solrHomeDir = new File(exampleParentDir, dirName + "/solr");
            if (!solrHomeDir.isDirectory()) {
                this.echo("Creating Solr home directory " + solrHomeDir);
                solrHomeDir.mkdirs();
            } else {
                this.echo("Solr home directory " + solrHomeDir.getAbsolutePath() + " already exists.");
            }
            this.copyIfNeeded(solrXml, new File(solrHomeDir, "solr.xml"));
            this.copyIfNeeded(zooCfg, new File(solrHomeDir, "zoo.cfg"));
            return solrHomeDir.getParentFile();
        }

        protected void copyIfNeeded(File src, File dest) throws IOException {
            if (!dest.isFile()) {
                FileUtils.copyFile((File)src, (File)dest);
            }
            if (!dest.isFile()) {
                throw new IllegalStateException("Required file " + dest.getAbsolutePath() + " not found!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isPortAvailable(int port) {
            Socket s = null;
            try {
                s = new Socket("localhost", port);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                boolean bl = true;
                return bl;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }

        protected Integer promptForPort(Scanner s, int node, String prompt, Integer defVal) {
            return this.promptForInt(s, prompt, "a port for node " + node, defVal, null, null);
        }

        protected Integer promptForInt(Scanner s, String prompt, String label, Integer defVal, Integer min, Integer max) {
            Integer inputAsInt = null;
            String value = this.prompt(s, prompt, null);
            if (value != null) {
                int attempts = 3;
                while (value != null && --attempts > 0) {
                    try {
                        inputAsInt = new Integer(value);
                        if (min != null && inputAsInt < min) {
                            value = this.prompt(s, String.format(Locale.ROOT, PROMPT_NUMBER_TOO_SMALL, inputAsInt, label, min, max, defVal));
                            inputAsInt = null;
                            continue;
                        }
                        if (max == null || inputAsInt <= max) continue;
                        value = this.prompt(s, String.format(Locale.ROOT, PROMPT_NUMBER_TOO_LARGE, inputAsInt, label, min, max, defVal));
                        inputAsInt = null;
                    }
                    catch (NumberFormatException nfe) {
                        if (this.verbose) {
                            this.echo(value + " is not a number!");
                        }
                        if (min != null && max != null) {
                            value = this.prompt(s, String.format(Locale.ROOT, PROMPT_FOR_NUMBER_IN_RANGE, label, min, max, defVal));
                            continue;
                        }
                        value = this.prompt(s, String.format(Locale.ROOT, PROMPT_FOR_NUMBER, label, defVal));
                    }
                }
                if (attempts == 0 && value != null && inputAsInt == null) {
                    this.echo("Too many failed attempts! Going with default value " + defVal);
                }
            }
            return inputAsInt != null ? inputAsInt : defVal;
        }

        protected String prompt(Scanner s, String prompt) {
            return this.prompt(s, prompt, null);
        }

        protected String prompt(Scanner s, String prompt, String defaultValue) {
            this.echo(prompt);
            String nextInput = s.nextLine();
            if (nextInput != null && (nextInput = nextInput.trim()).isEmpty()) {
                nextInput = null;
            }
            return nextInput != null ? nextInput : defaultValue;
        }
    }

    public static class ConfigTool
    extends ToolBase {
        public ConfigTool() {
            this(System.out);
        }

        public ConfigTool(PrintStream stdout) {
            super(stdout);
        }

        @Override
        public String getName() {
            return "config";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[4];
            OptionBuilder.withArgName((String)"ACTION");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Config API action, one of: set-property, unset-property; default is set-property");
            optionArray[0] = OptionBuilder.create((String)"action");
            OptionBuilder.withArgName((String)"PROP");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            OptionBuilder.withDescription((String)"Name of the Config API property to apply the action to, such as: updateHandler.autoSoftCommit.maxTime");
            optionArray[1] = OptionBuilder.create((String)"property");
            OptionBuilder.withArgName((String)"VALUE");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Set the property to this value; accepts JSON objects and strings");
            optionArray[2] = OptionBuilder.create((String)"value");
            OptionBuilder.withArgName((String)"HOST");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Base Solr URL, which can be used to determine the zkHost if that's not known");
            optionArray[3] = OptionBuilder.create((String)"solrUrl");
            Option[] configOptions = optionArray;
            return SolrCLI.joinOptions(configOptions, cloudOptions);
        }

        @Override
        protected void runImpl(org.apache.commons.cli.CommandLine cli) throws Exception {
            block17: {
                String solrUrl = SolrCLI.resolveSolrUrl(cli);
                String action = cli.getOptionValue("action", "set-property");
                String collection = cli.getOptionValue("collection", "gettingstarted");
                String property = cli.getOptionValue("property");
                String value = cli.getOptionValue("value");
                HashMap<String, Object> jsonObj = new HashMap<String, Object>();
                if (value != null) {
                    HashMap<String, String> setMap = new HashMap<String, String>();
                    setMap.put(property, value);
                    jsonObj.put(action, setMap);
                } else {
                    jsonObj.put(action, property);
                }
                CharArr arr = new CharArr();
                new JSONWriter(arr, 0).write(jsonObj);
                String jsonBody = arr.toString();
                String updatePath = "/" + collection + "/config";
                this.echo("\nPOSTing request to Config API: " + solrUrl + updatePath);
                this.echo(jsonBody);
                try (HttpSolrClient solrClient = new HttpSolrClient(solrUrl);){
                    NamedList<Object> result = SolrCLI.postJsonToSolr((SolrClient)solrClient, updatePath, jsonBody);
                    Integer statusCode = (Integer)((NamedList)result.get("responseHeader")).get("status");
                    if (statusCode == 0) {
                        if (value != null) {
                            this.echo("Successfully " + action + " " + property + " to " + value);
                        } else {
                            this.echo("Successfully " + action + " " + property);
                        }
                        break block17;
                    }
                    throw new Exception("Failed to " + action + " property due to:\n" + result);
                }
            }
        }
    }

    public static class DeleteTool
    extends ToolBase {
        public DeleteTool() {
            this(System.out);
        }

        public DeleteTool(PrintStream stdout) {
            super(stdout);
        }

        @Override
        public String getName() {
            return "delete";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[5];
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Base Solr URL, default is http://localhost:8983/solr");
            optionArray[0] = OptionBuilder.create((String)"solrUrl");
            OptionBuilder.withArgName((String)"NAME");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            OptionBuilder.withDescription((String)"Name of the core / collection to delete.");
            optionArray[1] = OptionBuilder.create((String)"name");
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Flag to indicate if the underlying configuration directory for a collection should also be deleted; default is true");
            optionArray[2] = OptionBuilder.create((String)"deleteConfig");
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Skip safety checks when deleting the configuration directory used by a collection");
            optionArray[3] = OptionBuilder.create((String)"forceDeleteConfig");
            OptionBuilder.withArgName((String)"HOST");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Address of the Zookeeper ensemble; defaults to: localhost:9983");
            optionArray[4] = OptionBuilder.create((String)"zkHost");
            return optionArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runImpl(org.apache.commons.cli.CommandLine cli) throws Exception {
            String solrUrl = cli.getOptionValue("solrUrl", SolrCLI.DEFAULT_SOLR_URL);
            if (!solrUrl.endsWith("/")) {
                solrUrl = solrUrl + "/";
            }
            String systemInfoUrl = solrUrl + "admin/info/system";
            CloseableHttpClient httpClient = SolrCLI.getHttpClient();
            try {
                Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2, true);
                if ("solrcloud".equals(systemInfo.get("mode"))) {
                    this.deleteCollection(cli);
                } else {
                    this.deleteCore(cli, httpClient, solrUrl);
                }
            }
            finally {
                SolrCLI.closeHttpClient(httpClient);
            }
        }

        protected void deleteCollection(org.apache.commons.cli.CommandLine cli) throws Exception {
            String zkHost = SolrCLI.getZkHost(cli);
            try (CloudSolrClient cloudSolrClient = new CloudSolrClient(zkHost);){
                this.echo("Connecting to ZooKeeper at " + zkHost);
                cloudSolrClient.connect();
                this.deleteCollection(cloudSolrClient, cli);
            }
        }

        protected void deleteCollection(CloudSolrClient cloudSolrClient, org.apache.commons.cli.CommandLine cli) throws Exception {
            Set liveNodes = cloudSolrClient.getZkStateReader().getClusterState().getLiveNodes();
            if (liveNodes.isEmpty()) {
                throw new IllegalStateException("No live nodes found! Cannot delete a collection until there is at least 1 live node in the cluster.");
            }
            String firstLiveNode = (String)liveNodes.iterator().next();
            ZkStateReader zkStateReader = cloudSolrClient.getZkStateReader();
            String baseUrl = zkStateReader.getBaseUrlForNodeName(firstLiveNode);
            String collectionName = cli.getOptionValue("name");
            if (!zkStateReader.getClusterState().hasCollection(collectionName)) {
                throw new IllegalArgumentException("Collection " + collectionName + " not found!");
            }
            String configName = zkStateReader.readConfigName(collectionName);
            boolean deleteConfig = "true".equals(cli.getOptionValue("deleteConfig", "true"));
            if (deleteConfig && configName != null) {
                if (cli.hasOption("forceDeleteConfig")) {
                    log.warn("Skipping safety checks, configuration directory " + configName + " will be deleted with impunity.");
                } else {
                    Set collections = zkStateReader.getClusterState().getCollections();
                    if (collections.size() > 50) {
                        log.info("Scanning " + collections.size() + " to ensure no other collections are using config " + configName);
                    }
                    for (String next : collections) {
                        if (collectionName.equals(next) || !configName.equals(zkStateReader.readConfigName(next))) continue;
                        deleteConfig = false;
                        log.warn("Configuration directory " + configName + " is also being used by " + next + "; configuration will not be deleted from ZooKeeper. You can pass the -forceDeleteConfig flag to force delete.");
                        break;
                    }
                }
            }
            String deleteCollectionUrl = String.format(Locale.ROOT, "%s/admin/collections?action=DELETE&name=%s", baseUrl, collectionName);
            this.echo("\nDeleting collection '" + collectionName + "' using command:\n" + deleteCollectionUrl + "\n");
            Map<String, Object> json = null;
            try {
                json = SolrCLI.getJson(deleteCollectionUrl);
            }
            catch (SolrServerException sse) {
                throw new Exception("Failed to delete collection '" + collectionName + "' due to: " + sse.getMessage());
            }
            if (deleteConfig) {
                String configZnode = "/configs/" + configName;
                try {
                    zkStateReader.getZkClient().clean(configZnode);
                }
                catch (Exception exc) {
                    System.err.println("\nWARNING: Failed to delete configuration directory " + configZnode + " in ZooKeeper due to: " + exc.getMessage() + "\nYou'll need to manually delete this znode using the zkcli script.");
                }
            }
            if (json != null) {
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(json);
                this.echo(arr.toString());
                this.echo("\n");
            }
        }

        protected void deleteCore(org.apache.commons.cli.CommandLine cli, CloseableHttpClient httpClient, String solrUrl) throws Exception {
            String coreName = cli.getOptionValue("name");
            String deleteCoreUrl = String.format(Locale.ROOT, "%sadmin/cores?action=UNLOAD&core=%s&deleteIndex=true&deleteDataDir=true&deleteInstanceDir=true", solrUrl, coreName);
            this.echo("\nDeleting core '" + coreName + "' using command:\n" + deleteCoreUrl + "\n");
            Map<String, Object> json = null;
            try {
                json = SolrCLI.getJson(deleteCoreUrl);
            }
            catch (SolrServerException sse) {
                throw new Exception("Failed to delete core '" + coreName + "' due to: " + sse.getMessage());
            }
            if (json != null) {
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(json);
                this.echo(arr.toString());
                this.echo("\n");
            }
        }
    }

    public static class CreateTool
    extends ToolBase {
        public CreateTool() {
            this(System.out);
        }

        public CreateTool(PrintStream stdout) {
            super(stdout);
        }

        @Override
        public String getName() {
            return "create";
        }

        @Override
        public Option[] getOptions() {
            return CREATE_COLLECTION_OPTIONS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runImpl(org.apache.commons.cli.CommandLine cli) throws Exception {
            String solrUrl = cli.getOptionValue("solrUrl", SolrCLI.DEFAULT_SOLR_URL);
            if (!solrUrl.endsWith("/")) {
                solrUrl = solrUrl + "/";
            }
            String systemInfoUrl = solrUrl + "admin/info/system";
            CloseableHttpClient httpClient = SolrCLI.getHttpClient();
            ToolBase tool = null;
            try {
                Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2, true);
                tool = "solrcloud".equals(systemInfo.get("mode")) ? new CreateCollectionTool(this.stdout) : new CreateCoreTool(this.stdout);
                tool.runTool(cli);
            }
            finally {
                SolrCLI.closeHttpClient(httpClient);
            }
        }
    }

    public static class CreateCoreTool
    extends ToolBase {
        public CreateCoreTool() {
            this(System.out);
        }

        public CreateCoreTool(PrintStream stdout) {
            super(stdout);
        }

        @Override
        public String getName() {
            return "create_core";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[4];
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Base Solr URL, default is http://localhost:8983/solr");
            optionArray[0] = OptionBuilder.create((String)"solrUrl");
            OptionBuilder.withArgName((String)"NAME");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            OptionBuilder.withDescription((String)"Name of the core to create.");
            optionArray[1] = OptionBuilder.create((String)"name");
            OptionBuilder.withArgName((String)"CONFIG");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Configuration directory to copy when creating the new core; default is data_driven_schema_configs");
            optionArray[2] = OptionBuilder.create((String)"confdir");
            OptionBuilder.withArgName((String)"DIR");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            OptionBuilder.withDescription((String)"Path to configsets directory on the local system.");
            optionArray[3] = OptionBuilder.create((String)"configsetsDir");
            return optionArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runImpl(org.apache.commons.cli.CommandLine cli) throws Exception {
            File configsetsDir;
            String solrUrl = cli.getOptionValue("solrUrl", SolrCLI.DEFAULT_SOLR_URL);
            if (!solrUrl.endsWith("/")) {
                solrUrl = solrUrl + "/";
            }
            if (!(configsetsDir = new File(cli.getOptionValue("configsetsDir"))).isDirectory()) {
                throw new FileNotFoundException(configsetsDir.getAbsolutePath() + " not found!");
            }
            String configSet = cli.getOptionValue("confdir", SolrCLI.DEFAULT_CONFIG_SET);
            File configSetDir = new File(configsetsDir, configSet);
            if (!configSetDir.isDirectory()) {
                File possibleConfigDir = new File(configSet);
                if (possibleConfigDir.isDirectory()) {
                    configSetDir = possibleConfigDir;
                } else {
                    throw new FileNotFoundException("Specified config directory " + configSet + " not found in " + configsetsDir.getAbsolutePath());
                }
            }
            String coreName = cli.getOptionValue("name");
            String systemInfoUrl = solrUrl + "admin/info/system";
            CloseableHttpClient httpClient = SolrCLI.getHttpClient();
            String solrHome = null;
            try {
                Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2, true);
                if ("solrcloud".equals(systemInfo.get("mode"))) {
                    throw new IllegalStateException("Solr at " + solrUrl + " is running in SolrCloud mode, please use create_collection command instead.");
                }
                solrHome = (String)systemInfo.get("solr_home");
                if (solrHome == null) {
                    solrHome = configsetsDir.getParentFile().getAbsolutePath();
                }
            }
            finally {
                SolrCLI.closeHttpClient(httpClient);
            }
            String coreStatusUrl = solrUrl + "admin/cores?action=STATUS&core=" + coreName;
            if (SolrCLI.safeCheckCoreExists(coreStatusUrl, coreName)) {
                throw new IllegalArgumentException("\nCore '" + coreName + "' already exists!\nChecked core existence using Core API command:\n" + coreStatusUrl);
            }
            File coreInstanceDir = new File(solrHome, coreName);
            File confDir = new File(configSetDir, "conf");
            if (!coreInstanceDir.isDirectory()) {
                coreInstanceDir.mkdirs();
                if (!coreInstanceDir.isDirectory()) {
                    throw new IOException("Failed to create new core instance directory: " + coreInstanceDir.getAbsolutePath());
                }
                if (confDir.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)confDir, (File)coreInstanceDir);
                } else if (new File(configSetDir, "solrconfig.xml").isFile()) {
                    FileUtils.copyDirectory((File)configSetDir, (File)new File(coreInstanceDir, "conf"));
                } else {
                    throw new IllegalArgumentException("\n" + configSetDir.getAbsolutePath() + " doesn't contain a conf subdirectory or solrconfig.xml\n");
                }
                this.echo("\nSetup new core instance directory:\n" + coreInstanceDir.getAbsolutePath());
            }
            String createCoreUrl = String.format(Locale.ROOT, "%sadmin/cores?action=CREATE&name=%s&instanceDir=%s", solrUrl, coreName, coreName);
            this.echo("\nCreating new core '" + coreName + "' using command:\n" + createCoreUrl + "\n");
            Map<String, Object> json = SolrCLI.getJson(createCoreUrl);
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(json);
            this.echo(arr.toString());
            this.echo("\n");
        }
    }

    public static class CreateCollectionTool
    extends ToolBase {
        public CreateCollectionTool() {
            this(System.out);
        }

        public CreateCollectionTool(PrintStream stdout) {
            super(stdout);
        }

        @Override
        public String getName() {
            return "create_collection";
        }

        @Override
        public Option[] getOptions() {
            return CREATE_COLLECTION_OPTIONS;
        }

        @Override
        protected void runImpl(org.apache.commons.cli.CommandLine cli) throws Exception {
            String zkHost = SolrCLI.getZkHost(cli);
            if (zkHost == null) {
                throw new IllegalStateException("Solr at " + cli.getOptionValue("solrUrl") + " is running in standalone server mode, please use the create_core command instead;\n" + "create_collection can only be used when running in SolrCloud mode.\n");
            }
            try (CloudSolrClient cloudSolrClient = new CloudSolrClient(zkHost);){
                this.echo("\nConnecting to ZooKeeper at " + zkHost + " ...");
                cloudSolrClient.connect();
                this.runCloudTool(cloudSolrClient, cli);
            }
        }

        protected void runCloudTool(CloudSolrClient cloudSolrClient, org.apache.commons.cli.CommandLine cli) throws Exception {
            String collectionListUrl;
            Set liveNodes = cloudSolrClient.getZkStateReader().getClusterState().getLiveNodes();
            if (liveNodes.isEmpty()) {
                throw new IllegalStateException("No live nodes found! Cannot create a collection until there is at least 1 live node in the cluster.");
            }
            String baseUrl = cli.getOptionValue("solrUrl");
            if (baseUrl == null) {
                String firstLiveNode = (String)liveNodes.iterator().next();
                baseUrl = cloudSolrClient.getZkStateReader().getBaseUrlForNodeName(firstLiveNode);
            }
            String collectionName = cli.getOptionValue("name");
            int numShards = this.optionAsInt(cli, "shards", 1);
            int replicationFactor = this.optionAsInt(cli, "replicationFactor", 1);
            int maxShardsPerNode = -1;
            if (cli.hasOption("maxShardsPerNode")) {
                maxShardsPerNode = Integer.parseInt(cli.getOptionValue("maxShardsPerNode"));
            } else {
                int numNodes = liveNodes.size();
                maxShardsPerNode = (numShards * replicationFactor + numNodes - 1) / numNodes;
            }
            String confname = cli.getOptionValue("confname", collectionName);
            boolean configExistsInZk = cloudSolrClient.getZkStateReader().getZkClient().exists("/configs/" + confname, true);
            if (!".system".equals(collectionName)) {
                if (configExistsInZk) {
                    this.echo("Re-using existing configuration directory " + confname);
                } else {
                    String configSet = cli.getOptionValue("confdir", SolrCLI.DEFAULT_CONFIG_SET);
                    File configSetDir = null;
                    File possibleConfigDir = new File(configSet);
                    if (possibleConfigDir.isDirectory()) {
                        configSetDir = possibleConfigDir;
                    } else {
                        File configsetsDir = new File(cli.getOptionValue("configsetsDir"));
                        if (!configsetsDir.isDirectory()) {
                            throw new FileNotFoundException(configsetsDir.getAbsolutePath() + " not found!");
                        }
                        configSetDir = new File(configsetsDir, configSet);
                        if (!configSetDir.isDirectory()) {
                            throw new FileNotFoundException("Specified config " + configSet + " not found in " + configsetsDir.getAbsolutePath());
                        }
                    }
                    File confDir = new File(configSetDir, "conf");
                    if (!confDir.isDirectory()) {
                        if (new File(configSetDir, "solrconfig.xml").isFile()) {
                            confDir = configSetDir;
                        } else {
                            throw new IllegalArgumentException("Specified configuration directory " + configSetDir.getAbsolutePath() + " is invalid;\nit should contain either conf sub-directory or solrconfig.xml");
                        }
                    }
                    this.echo("Uploading " + confDir.getAbsolutePath() + " for config " + confname + " to ZooKeeper at " + cloudSolrClient.getZkHost());
                    cloudSolrClient.uploadConfig(confDir.toPath(), confname);
                }
            }
            if (SolrCLI.safeCheckCollectionExists(collectionListUrl = baseUrl + "/admin/collections?action=list", collectionName)) {
                throw new IllegalStateException("\nCollection '" + collectionName + "' already exists!\nChecked collection existence using Collections API command:\n" + collectionListUrl);
            }
            String createCollectionUrl = String.format(Locale.ROOT, "%s/admin/collections?action=CREATE&name=%s&numShards=%d&replicationFactor=%d&maxShardsPerNode=%d&collection.configName=%s", baseUrl, collectionName, numShards, replicationFactor, maxShardsPerNode, confname);
            this.echo("\nCreating new collection '" + collectionName + "' using command:\n" + createCollectionUrl + "\n");
            Map<String, Object> json = null;
            try {
                json = SolrCLI.getJson(createCollectionUrl);
            }
            catch (SolrServerException sse) {
                throw new Exception("Failed to create collection '" + collectionName + "' due to: " + sse.getMessage());
            }
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(json);
            this.echo(arr.toString());
        }

        protected int optionAsInt(org.apache.commons.cli.CommandLine cli, String option, int defaultVal) {
            return Integer.parseInt(cli.getOptionValue(option, String.valueOf(defaultVal)));
        }
    }

    public static class HealthcheckTool
    extends SolrCloudTool {
        public HealthcheckTool() {
            this(System.out);
        }

        public HealthcheckTool(PrintStream stdout) {
            super(stdout);
        }

        @Override
        public String getName() {
            return "healthcheck";
        }

        @Override
        protected void runCloudTool(CloudSolrClient cloudSolrClient, org.apache.commons.cli.CommandLine cli) throws Exception {
            String collection = cli.getOptionValue("collection");
            if (collection == null) {
                throw new IllegalArgumentException("Must provide a collection to run a healthcheck against!");
            }
            log.debug("Running healthcheck for " + collection);
            ZkStateReader zkStateReader = cloudSolrClient.getZkStateReader();
            ClusterState clusterState = zkStateReader.getClusterState();
            Set liveNodes = clusterState.getLiveNodes();
            Collection slices = clusterState.getSlices(collection);
            if (slices == null) {
                throw new IllegalArgumentException("Collection " + collection + " not found!");
            }
            SolrQuery q = new SolrQuery("*:*");
            q.setRows(Integer.valueOf(0));
            QueryResponse qr = cloudSolrClient.query((SolrParams)q);
            String collErr = null;
            long docCount = -1L;
            try {
                docCount = qr.getResults().getNumFound();
            }
            catch (Exception exc) {
                collErr = String.valueOf(exc);
            }
            ArrayList<Map<String, Object>> shardList = new ArrayList<Map<String, Object>>();
            boolean collectionIsHealthy = docCount != -1L;
            for (Slice slice : slices) {
                String shardName = slice.getName();
                String leaderUrl = null;
                try {
                    leaderUrl = zkStateReader.getLeaderUrl(collection, shardName, 1000);
                }
                catch (Exception exc) {
                    log.warn("Failed to get leader for shard " + shardName + " due to: " + exc);
                }
                ArrayList<ReplicaHealth> replicaList = new ArrayList<ReplicaHealth>();
                for (Replica r : slice.getReplicas()) {
                    String uptime = null;
                    String memory = null;
                    String replicaStatus = null;
                    long numDocs = -1L;
                    ZkCoreNodeProps replicaCoreProps = new ZkCoreNodeProps((ZkNodeProps)r);
                    String coreUrl = replicaCoreProps.getCoreUrl();
                    boolean isLeader = coreUrl.equals(leaderUrl);
                    String nodeName = replicaCoreProps.getNodeName();
                    if (nodeName == null || !liveNodes.contains(nodeName)) {
                        replicaStatus = Replica.State.DOWN.toString();
                    } else {
                        q = new SolrQuery("*:*");
                        q.setRows(Integer.valueOf(0));
                        q.set("distrib", new String[]{"false"});
                        try (HttpSolrClient solr = new HttpSolrClient(coreUrl);){
                            String solrUrl = solr.getBaseURL();
                            qr = solr.query((SolrParams)q);
                            numDocs = qr.getResults().getNumFound();
                            int lastSlash = solrUrl.lastIndexOf(47);
                            String systemInfoUrl = solrUrl.substring(0, lastSlash) + "/admin/info/system";
                            Map<String, Object> info = SolrCLI.getJson(solr.getHttpClient(), systemInfoUrl, 2, true);
                            uptime = SolrCLI.uptime(SolrCLI.asLong("/jvm/jmx/upTimeMS", info));
                            String usedMemory = SolrCLI.asString("/jvm/memory/used", info);
                            String totalMemory = SolrCLI.asString("/jvm/memory/total", info);
                            memory = usedMemory + " of " + totalMemory;
                            replicaStatus = replicaCoreProps.getState();
                        }
                        catch (Exception exc) {
                            log.error("ERROR: " + exc + " when trying to reach: " + coreUrl);
                            replicaStatus = SolrCLI.checkCommunicationError(exc) ? Replica.State.DOWN.toString() : "error: " + exc;
                        }
                    }
                    replicaList.add(new ReplicaHealth(shardName, r.getName(), coreUrl, replicaStatus, numDocs, isLeader, uptime, memory));
                }
                ShardHealth shardHealth = new ShardHealth(shardName, replicaList);
                if (ShardState.healthy != shardHealth.getShardState()) {
                    collectionIsHealthy = false;
                }
                shardList.add(shardHealth.asMap());
            }
            LinkedHashMap<String, Object> report = new LinkedHashMap<String, Object>();
            report.put("collection", collection);
            report.put("status", collectionIsHealthy ? "healthy" : "degraded");
            if (collErr != null) {
                report.put("error", collErr);
            }
            report.put("numDocs", docCount);
            report.put("numShards", slices.size());
            report.put("shards", shardList);
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(report);
            this.echo(arr.toString());
        }
    }

    static class ShardHealth {
        String shard;
        List<ReplicaHealth> replicas;

        ShardHealth(String shard, List<ReplicaHealth> replicas) {
            this.shard = shard;
            this.replicas = replicas;
        }

        public ShardState getShardState() {
            boolean healthy = true;
            boolean hasLeader = false;
            boolean atLeastOneActive = false;
            for (ReplicaHealth replicaHealth : this.replicas) {
                if (replicaHealth.isLeader) {
                    hasLeader = true;
                }
                if (!Replica.State.ACTIVE.toString().equals(replicaHealth.status)) {
                    healthy = false;
                    continue;
                }
                atLeastOneActive = true;
            }
            if (!hasLeader) {
                return ShardState.no_leader;
            }
            return healthy ? ShardState.healthy : (atLeastOneActive ? ShardState.degraded : ShardState.down);
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("shard", this.shard);
            map.put("status", this.getShardState().toString());
            ArrayList<Map<String, Object>> replicaList = new ArrayList<Map<String, Object>>();
            for (ReplicaHealth replica : this.replicas) {
                replicaList.add(replica.asMap());
            }
            map.put("replicas", replicaList);
            return map;
        }

        public String toString() {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(this.asMap());
            return arr.toString();
        }
    }

    static enum ShardState {
        healthy,
        degraded,
        down,
        no_leader;

    }

    static class ReplicaHealth
    implements Comparable<ReplicaHealth> {
        String shard;
        String name;
        String url;
        String status;
        long numDocs;
        boolean isLeader;
        String uptime;
        String memory;

        ReplicaHealth(String shard, String name, String url, String status, long numDocs, boolean isLeader, String uptime, String memory) {
            this.shard = shard;
            this.name = name;
            this.url = url;
            this.numDocs = numDocs;
            this.status = status;
            this.isLeader = isLeader;
            this.uptime = uptime;
            this.memory = memory;
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", this.name);
            map.put("url", this.url);
            map.put("numDocs", this.numDocs);
            map.put("status", this.status);
            if (this.uptime != null) {
                map.put("uptime", this.uptime);
            }
            if (this.memory != null) {
                map.put("memory", this.memory);
            }
            if (this.isLeader) {
                map.put("leader", true);
            }
            return map;
        }

        public String toString() {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(this.asMap());
            return arr.toString();
        }

        public int hashCode() {
            return this.shard.hashCode() + (this.isLeader ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ReplicaHealth)) {
                return true;
            }
            ReplicaHealth that = (ReplicaHealth)obj;
            return this.shard.equals(that.shard) && this.isLeader == that.isLeader;
        }

        @Override
        public int compareTo(ReplicaHealth other) {
            int otherShardIndex;
            if (this == other) {
                return 0;
            }
            if (other == null) {
                return 1;
            }
            int myShardIndex = Integer.parseInt(this.shard.substring("shard".length()));
            if (myShardIndex == (otherShardIndex = Integer.parseInt(other.shard.substring("shard".length())))) {
                return this.isLeader ? -1 : 1;
            }
            return myShardIndex - otherShardIndex;
        }
    }

    public static class ApiTool
    extends ToolBase {
        public ApiTool() {
            this(System.out);
        }

        public ApiTool(PrintStream stdout) {
            super(stdout);
        }

        @Override
        public String getName() {
            return "api";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[1];
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Send a GET request to a Solr API endpoint");
            optionArray[0] = OptionBuilder.create((String)"get");
            return optionArray;
        }

        @Override
        protected void runImpl(org.apache.commons.cli.CommandLine cli) throws Exception {
            String getUrl = cli.getOptionValue("get");
            if (getUrl != null) {
                Map<String, Object> json = SolrCLI.getJson(getUrl);
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(json);
                this.echo(arr.toString());
            }
        }
    }

    public static class StatusTool
    extends ToolBase {
        public StatusTool() {
            this(System.out);
        }

        public StatusTool(PrintStream stdout) {
            super(stdout);
        }

        @Override
        public String getName() {
            return "status";
        }

        @Override
        public Option[] getOptions() {
            Option[] optionArray = new Option[2];
            OptionBuilder.withArgName((String)"URL");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Address of the Solr Web application, defaults to: http://localhost:8983/solr");
            optionArray[0] = OptionBuilder.create((String)"solr");
            OptionBuilder.withArgName((String)"SECS");
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"Wait up to the specified number of seconds to see Solr running.");
            optionArray[1] = OptionBuilder.create((String)"maxWaitSecs");
            return optionArray;
        }

        @Override
        protected void runImpl(org.apache.commons.cli.CommandLine cli) throws Exception {
            int maxWaitSecs = Integer.parseInt(cli.getOptionValue("maxWaitSecs", "0"));
            String solrUrl = cli.getOptionValue("solr", SolrCLI.DEFAULT_SOLR_URL);
            if (maxWaitSecs > 0) {
                int solrPort = new URL(solrUrl).getPort();
                this.echo("Waiting up to " + maxWaitSecs + " to see Solr running on port " + solrPort);
                try {
                    this.waitToSeeSolrUp(solrUrl, maxWaitSecs);
                    this.echo("Started Solr server on port " + solrPort + ". Happy searching!");
                }
                catch (TimeoutException timeout) {
                    throw new Exception("Solr at " + solrUrl + " did not come online within " + maxWaitSecs + " seconds!");
                }
            }
            try {
                CharArr arr = new CharArr();
                new JSONWriter(arr, 2).write(this.getStatus(solrUrl));
                this.echo(arr.toString());
            }
            catch (Exception exc) {
                if (SolrCLI.checkCommunicationError(exc)) {
                    System.err.println("Solr at " + solrUrl + " not online.");
                }
                throw new Exception("Failed to get system information from " + solrUrl + " due to: " + exc);
            }
        }

        public Map<String, Object> waitToSeeSolrUp(String solrUrl, int maxWaitSecs) throws Exception {
            long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(maxWaitSecs, TimeUnit.SECONDS);
            while (System.nanoTime() < timeout) {
                try {
                    return this.getStatus(solrUrl);
                }
                catch (Exception exc) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interrupted) {
                        timeout = 0L;
                    }
                }
            }
            throw new TimeoutException("Did not see Solr at " + solrUrl + " come online within " + maxWaitSecs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Object> getStatus(String solrUrl) throws Exception {
            Map<String, Object> status = null;
            if (!solrUrl.endsWith("/")) {
                solrUrl = solrUrl + "/";
            }
            String systemInfoUrl = solrUrl + "admin/info/system";
            CloseableHttpClient httpClient = SolrCLI.getHttpClient();
            try {
                Map<String, Object> systemInfo = SolrCLI.getJson((HttpClient)httpClient, systemInfoUrl, 2, true);
                status = this.reportStatus(solrUrl, systemInfo, (HttpClient)httpClient);
            }
            finally {
                SolrCLI.closeHttpClient(httpClient);
            }
            return status;
        }

        public Map<String, Object> reportStatus(String solrUrl, Map<String, Object> info, HttpClient httpClient) throws Exception {
            LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
            String solrHome = (String)info.get("solr_home");
            status.put("solr_home", solrHome != null ? solrHome : "?");
            status.put("version", SolrCLI.asString("/lucene/solr-impl-version", info));
            status.put("startTime", SolrCLI.asString("/jvm/jmx/startTime", info));
            status.put("uptime", SolrCLI.uptime(SolrCLI.asLong("/jvm/jmx/upTimeMS", info)));
            String usedMemory = SolrCLI.asString("/jvm/memory/used", info);
            String totalMemory = SolrCLI.asString("/jvm/memory/total", info);
            status.put("memory", usedMemory + " of " + totalMemory);
            if ("solrcloud".equals(info.get("mode"))) {
                String zkHost = (String)info.get("zkHost");
                status.put("cloud", this.getCloudStatus(httpClient, solrUrl, zkHost));
            }
            return status;
        }

        protected Map<String, String> getCloudStatus(HttpClient httpClient, String solrUrl, String zkHost) throws Exception {
            LinkedHashMap<String, String> cloudStatus = new LinkedHashMap<String, String>();
            cloudStatus.put("ZooKeeper", zkHost != null ? zkHost : "?");
            String clusterStatusUrl = solrUrl + "admin/collections?action=CLUSTERSTATUS";
            Map<String, Object> json = SolrCLI.getJson(httpClient, clusterStatusUrl, 2, true);
            List<String> liveNodes = SolrCLI.asList("/cluster/live_nodes", json);
            cloudStatus.put("liveNodes", String.valueOf(liveNodes.size()));
            Map<String, Object> collections = SolrCLI.asMap("/cluster/collections", json);
            cloudStatus.put("collections", String.valueOf(collections.size()));
            return cloudStatus;
        }
    }

    private static class SolrResponseHandler
    implements ResponseHandler<Map<String, Object>> {
        private SolrResponseHandler() {
        }

        public Map<String, Object> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String respBody = EntityUtils.toString((HttpEntity)entity);
                Object resp = null;
                try {
                    resp = ObjectBuilder.getVal((JSONParser)new JSONParser(respBody));
                }
                catch (JSONParser.ParseException pe) {
                    throw new ClientProtocolException("Expected JSON response from server but received: " + respBody + "\nTypically, this indicates a problem with the Solr server; check the Solr server logs for more information.");
                }
                if (resp != null && resp instanceof Map) {
                    return (Map)resp;
                }
                throw new ClientProtocolException("Expected JSON object in response but received " + resp);
            }
            StatusLine statusLine = response.getStatusLine();
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
    }

    public static abstract class SolrCloudTool
    extends ToolBase {
        protected SolrCloudTool(PrintStream stdout) {
            super(stdout);
        }

        @Override
        public Option[] getOptions() {
            return cloudOptions;
        }

        @Override
        protected void runImpl(org.apache.commons.cli.CommandLine cli) throws Exception {
            String zkHost = cli.getOptionValue("zkHost", SolrCLI.ZK_HOST);
            log.debug("Connecting to Solr cluster: " + zkHost);
            try (CloudSolrClient cloudSolrClient = new CloudSolrClient(zkHost);){
                String collection = cli.getOptionValue("collection");
                if (collection != null) {
                    cloudSolrClient.setDefaultCollection(collection);
                }
                cloudSolrClient.connect();
                this.runCloudTool(cloudSolrClient, cli);
            }
        }

        protected abstract void runCloudTool(CloudSolrClient var1, org.apache.commons.cli.CommandLine var2) throws Exception;
    }

    public static abstract class ToolBase
    implements Tool {
        protected PrintStream stdout;
        protected boolean verbose = false;

        protected ToolBase() {
            this(System.out);
        }

        protected ToolBase(PrintStream stdout) {
            this.stdout = stdout;
        }

        protected void echo(String msg) {
            this.stdout.println(msg);
        }

        @Override
        public int runTool(org.apache.commons.cli.CommandLine cli) throws Exception {
            this.verbose = cli.hasOption("verbose");
            int toolExitStatus = 0;
            try {
                this.runImpl(cli);
            }
            catch (Exception exc) {
                String excMsg = exc.getMessage();
                if (excMsg != null) {
                    System.err.println("\nERROR: " + excMsg + "\n");
                    toolExitStatus = 1;
                }
                throw exc;
            }
            return toolExitStatus;
        }

        protected abstract void runImpl(org.apache.commons.cli.CommandLine var1) throws Exception;
    }

    public static interface Tool {
        public String getName();

        public Option[] getOptions();

        public int runTool(org.apache.commons.cli.CommandLine var1) throws Exception;
    }
}

