/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.QueryContext;

public class BlockJoin {
    public static DocSet toChildren(DocSet parentInput, BitDocSet parentList, DocSet acceptDocs, QueryContext qcontext) throws IOException {
        FixedBitSet parentBits = parentList.getBits();
        DocSetCollector collector = new DocSetCollector(qcontext.searcher().maxDoc() >> 6, qcontext.searcher().maxDoc());
        DocIterator iter = parentInput.iterator();
        while (iter.hasNext()) {
            int parentDoc = iter.nextDoc();
            if (!parentList.exists(parentDoc) || parentDoc == 0) continue;
            int prevParent = parentBits.prevSetBit(parentDoc - 1);
            for (int childDoc = prevParent + 1; childDoc < parentDoc; ++childDoc) {
                if (acceptDocs != null && !acceptDocs.exists(childDoc)) continue;
                collector.collect(childDoc);
            }
        }
        return collector.getDocSet();
    }

    public static DocSet toParents(DocSet childInput, BitDocSet parentList, QueryContext qcontext) throws IOException {
        FixedBitSet parentBits = parentList.getBits();
        DocSetCollector collector = new DocSetCollector(qcontext.searcher().maxDoc() >> 6, qcontext.searcher().maxDoc());
        DocIterator iter = childInput.iterator();
        int currentParent = -1;
        while (iter.hasNext()) {
            int childDoc = iter.nextDoc();
            if (childDoc <= currentParent || (currentParent = parentBits.nextSetBit(childDoc)) == Integer.MAX_VALUE) continue;
            collector.collect(currentParent);
        }
        return collector.getDocSet();
    }
}

