/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.carrotsearch.hppc.FloatArrayList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIntOpenHashMap;
import com.carrotsearch.hppc.IntLongOpenHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import com.carrotsearch.hppc.cursors.IntLongCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongValues;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.QueryElevationComponent;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.ExtendedQueryBase;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.ScoreFilter;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class CollapsingQParserPlugin
extends QParserPlugin {
    public static final String NAME = "collapse";
    public static final String NULL_COLLAPSE = "collapse";
    public static final String NULL_IGNORE = "ignore";
    public static final String NULL_EXPAND = "expand";
    public static final String HINT_TOP_FC = "top_fc";
    public static final String HINT_MULTI_DOCVALUES = "multi_docvalues";

    @Override
    public void init(NamedList namedList) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
        return new CollapsingQParser(qstr, localParams, params, request);
    }

    private class MinLongComp
    implements LongCompare {
        private MinLongComp() {
        }

        @Override
        public boolean test(long i1, long i2) {
            return i1 < i2;
        }
    }

    private class MaxLongComp
    implements LongCompare {
        private MaxLongComp() {
        }

        @Override
        public boolean test(long i1, long i2) {
            return i1 > i2;
        }
    }

    private class MinFloatComp
    implements FloatCompare {
        private MinFloatComp() {
        }

        @Override
        public boolean test(float i1, float i2) {
            return i1 < i2;
        }
    }

    private class MaxFloatComp
    implements FloatCompare {
        private MaxFloatComp() {
        }

        @Override
        public boolean test(float i1, float i2) {
            return i1 > i2;
        }
    }

    private class MinIntComp
    implements IntCompare {
        private MinIntComp() {
        }

        @Override
        public boolean test(int i1, int i2) {
            return i1 < i2;
        }
    }

    private class MaxIntComp
    implements IntCompare {
        private MaxIntComp() {
        }

        @Override
        public boolean test(int i1, int i2) {
            return i1 > i2;
        }
    }

    private static interface LongCompare {
        public boolean test(long var1, long var3);
    }

    private static interface FloatCompare {
        public boolean test(float var1, float var2);
    }

    private static interface IntCompare {
        public boolean test(int var1, int var2);
    }

    static class MergeBoost {
        private int[] boostDocs;
        private int index = 0;

        public MergeBoost(int[] boostDocs) {
            this.boostDocs = boostDocs;
        }

        public void reset() {
            this.index = 0;
        }

        public boolean boost(int globalDoc) {
            if (this.index == Integer.MIN_VALUE) {
                return false;
            }
            while (true) {
                if (this.index >= this.boostDocs.length) {
                    this.index = Integer.MIN_VALUE;
                    return false;
                }
                int comp = this.boostDocs[this.index];
                if (comp == globalDoc) {
                    ++this.index;
                    return true;
                }
                if (comp >= globalDoc) break;
                ++this.index;
            }
            return false;
        }
    }

    private class IntValueSourceStrategy
    extends IntFieldValueStrategy {
        private FloatCompare comp;
        private float[] testValues;
        private float nullCompVal;
        private ValueSource valueSource;
        private FunctionValues functionValues;
        private Map rcontext;
        private CollapseScore collapseScore;
        private boolean cscore;
        private float score;
        private int index;

        public IntValueSourceStrategy(int maxDoc, String funcStr, int size, String collapseField, int nullValue, int nullPolicy, boolean max, boolean needsScores, IntIntOpenHashMap boostDocs, FunctionQuery funcQuery, IndexSearcher searcher) throws IOException {
            super(maxDoc, size, collapseField, null, nullValue, nullPolicy, max, needsScores, boostDocs);
            this.collapseScore = new CollapseScore();
            this.index = -1;
            this.testValues = new float[size];
            this.docs = new int[size];
            this.valueSource = funcQuery.getValueSource();
            this.rcontext = ValueSource.newContext((IndexSearcher)searcher);
            if (max) {
                this.nullCompVal = -3.4028235E38f;
                this.comp = new MaxFloatComp();
            } else {
                this.nullCompVal = Float.MAX_VALUE;
                this.comp = new MinFloatComp();
            }
            if (funcStr.indexOf("cscore()") != -1) {
                this.cscore = true;
                this.rcontext.put("CSCORE", this.collapseScore);
            }
            if (needsScores) {
                this.scores = new float[size];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.functionValues = this.valueSource.getValues(this.rcontext, context);
        }

        @Override
        public void collapse(int collapseKey, int contextDoc, int globalDoc) throws IOException {
            if (this.boosts && this.mergeBoost.boost(globalDoc)) {
                this.boostDocs.add(globalDoc);
                this.boostKeys.add(collapseKey);
                return;
            }
            if (this.needsScores || this.cscore) {
                this.collapseScore.score = this.score = this.scorer.score();
            }
            float currentVal = this.functionValues.floatVal(contextDoc);
            if (collapseKey != this.nullValue) {
                if (this.cmap.containsKey(collapseKey)) {
                    int pointer = this.cmap.lget();
                    if (this.comp.test(currentVal, this.testValues[pointer])) {
                        this.testValues[pointer] = currentVal;
                        this.docs[pointer] = globalDoc;
                        if (this.needsScores) {
                            this.scores[pointer] = this.score;
                        }
                    }
                } else {
                    ++this.index;
                    this.cmap.put(collapseKey, this.index);
                    if (this.index == this.testValues.length) {
                        this.testValues = ArrayUtil.grow((float[])this.testValues);
                        this.docs = ArrayUtil.grow((int[])this.docs);
                        if (this.needsScores) {
                            this.scores = ArrayUtil.grow((float[])this.scores);
                        }
                    }
                    this.docs[this.index] = globalDoc;
                    this.testValues[this.index] = currentVal;
                    if (this.needsScores) {
                        this.scores[this.index] = this.score;
                    }
                }
            } else if (this.nullPolicy == 1) {
                if (this.comp.test(currentVal, this.nullCompVal)) {
                    this.nullCompVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 2) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private class IntFloatStrategy
    extends IntFieldValueStrategy {
        private NumericDocValues minMaxVals;
        private float[] testValues;
        private FloatCompare comp;
        private float nullCompVal;
        private int index;

        public IntFloatStrategy(int maxDoc, int size, String collapseField, String field, int nullValue, int nullPolicy, boolean max, boolean needsScores, IntIntOpenHashMap boostDocs) throws IOException {
            super(maxDoc, size, collapseField, field, nullValue, nullPolicy, max, needsScores, boostDocs);
            this.index = -1;
            this.testValues = new float[size];
            this.docs = new int[size];
            if (max) {
                this.comp = new MaxFloatComp();
                this.nullCompVal = -3.4028235E38f;
            } else {
                this.comp = new MinFloatComp();
                this.nullCompVal = Float.MAX_VALUE;
            }
            if (needsScores) {
                this.scores = new float[size];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.minMaxVals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void collapse(int collapseKey, int contextDoc, int globalDoc) throws IOException {
            if (this.boosts && this.mergeBoost.boost(globalDoc)) {
                this.boostDocs.add(globalDoc);
                this.boostKeys.add(collapseKey);
                return;
            }
            int minMaxVal = (int)this.minMaxVals.get(contextDoc);
            float currentVal = Float.intBitsToFloat(minMaxVal);
            if (collapseKey != this.nullValue) {
                if (this.cmap.containsKey(collapseKey)) {
                    int pointer = this.cmap.lget();
                    if (this.comp.test(currentVal, this.testValues[pointer])) {
                        this.testValues[pointer] = currentVal;
                        this.docs[pointer] = globalDoc;
                        if (this.needsScores) {
                            this.scores[pointer] = this.scorer.score();
                        }
                    }
                } else {
                    ++this.index;
                    this.cmap.put(collapseKey, this.index);
                    if (this.index == this.testValues.length) {
                        this.testValues = ArrayUtil.grow((float[])this.testValues);
                        this.docs = ArrayUtil.grow((int[])this.docs);
                        if (this.needsScores) {
                            this.scores = ArrayUtil.grow((float[])this.scores);
                        }
                    }
                    this.testValues[this.index] = currentVal;
                    this.docs[this.index] = globalDoc;
                    if (this.needsScores) {
                        this.scores[this.index] = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 1) {
                if (this.comp.test(currentVal, this.nullCompVal)) {
                    this.nullCompVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 2) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private class IntIntStrategy
    extends IntFieldValueStrategy {
        private NumericDocValues minMaxVals;
        private int[] testValues;
        private IntCompare comp;
        private int nullCompVal;
        private int index;

        public IntIntStrategy(int maxDoc, int size, String collapseField, String field, int nullValue, int nullPolicy, boolean max, boolean needsScores, IntIntOpenHashMap boostDocs) throws IOException {
            super(maxDoc, size, collapseField, field, nullValue, nullPolicy, max, needsScores, boostDocs);
            this.index = -1;
            this.testValues = new int[size];
            this.docs = new int[size];
            if (max) {
                this.comp = new MaxIntComp();
                this.nullCompVal = Integer.MIN_VALUE;
            } else {
                this.comp = new MinIntComp();
                this.nullCompVal = Integer.MAX_VALUE;
            }
            if (needsScores) {
                this.scores = new float[size];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.minMaxVals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void collapse(int collapseKey, int contextDoc, int globalDoc) throws IOException {
            if (this.boosts && this.mergeBoost.boost(globalDoc)) {
                this.boostDocs.add(globalDoc);
                this.boostKeys.add(collapseKey);
                return;
            }
            int currentVal = (int)this.minMaxVals.get(contextDoc);
            if (collapseKey != this.nullValue) {
                if (this.cmap.containsKey(collapseKey)) {
                    int pointer = this.cmap.lget();
                    if (this.comp.test(currentVal, this.testValues[pointer])) {
                        this.testValues[pointer] = currentVal;
                        this.docs[pointer] = globalDoc;
                        if (this.needsScores) {
                            this.scores[pointer] = this.scorer.score();
                        }
                    }
                } else {
                    ++this.index;
                    this.cmap.put(collapseKey, this.index);
                    if (this.index == this.testValues.length) {
                        this.testValues = ArrayUtil.grow((int[])this.testValues);
                        this.docs = ArrayUtil.grow((int[])this.docs);
                        if (this.needsScores) {
                            this.scores = ArrayUtil.grow((float[])this.scores);
                        }
                    }
                    this.testValues[this.index] = currentVal;
                    this.docs[this.index] = globalDoc;
                    if (this.needsScores) {
                        this.scores[this.index] = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 1) {
                if (this.comp.test(currentVal, this.nullCompVal)) {
                    this.nullCompVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 2) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private abstract class IntFieldValueStrategy {
        protected int nullPolicy;
        protected IntIntOpenHashMap cmap;
        protected Scorer scorer;
        protected FloatArrayList nullScores;
        protected float nullScore;
        protected float[] scores;
        protected FixedBitSet collapsedSet;
        protected int nullDoc = -1;
        protected boolean needsScores;
        protected boolean max;
        protected String field;
        protected String collapseField;
        protected int[] docs;
        protected int nullValue;
        protected IntArrayList boostDocs;
        protected IntArrayList boostKeys;
        protected boolean boosts;
        protected MergeBoost mergeBoost;

        public abstract void collapse(int var1, int var2, int var3) throws IOException;

        public abstract void setNextReader(LeafReaderContext var1) throws IOException;

        public IntFieldValueStrategy(int maxDoc, int size, String collapseField, String field, int nullValue, int nullPolicy, boolean max, boolean needsScores, IntIntOpenHashMap boostDocsMap) {
            this.field = field;
            this.collapseField = collapseField;
            this.nullValue = nullValue;
            this.nullPolicy = nullPolicy;
            this.max = max;
            this.needsScores = needsScores;
            this.collapsedSet = new FixedBitSet(maxDoc);
            this.cmap = new IntIntOpenHashMap(size);
            if (boostDocsMap != null) {
                this.boosts = true;
                this.boostDocs = new IntArrayList();
                this.boostKeys = new IntArrayList();
                int[] bd = new int[boostDocsMap.size()];
                Iterator it = boostDocsMap.iterator();
                int index = -1;
                while (it.hasNext()) {
                    IntIntCursor cursor = (IntIntCursor)it.next();
                    bd[++index] = cursor.key;
                }
                Arrays.sort(bd);
                this.mergeBoost = new MergeBoost(bd);
            }
        }

        public FixedBitSet getCollapsedSet() {
            if (this.nullDoc > -1) {
                this.collapsedSet.set(this.nullDoc);
            }
            if (this.boostKeys != null) {
                int s = this.boostKeys.size();
                for (int i = 0; i < s; ++i) {
                    int key = this.boostKeys.get(i);
                    if (key != this.nullValue) {
                        this.cmap.remove(key);
                    }
                    this.collapsedSet.set(this.boostDocs.get(i));
                }
                this.mergeBoost.reset();
            }
            for (IntIntCursor cursor : this.cmap) {
                int pointer = cursor.value;
                this.collapsedSet.set(this.docs[pointer]);
            }
            return this.collapsedSet;
        }

        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        public FloatArrayList getNullScores() {
            return this.nullScores;
        }

        public IntIntOpenHashMap getCollapseMap() {
            return this.cmap;
        }

        public float getNullScore() {
            return this.nullScore;
        }

        public float[] getScores() {
            return this.scores;
        }

        public int[] getDocs() {
            return this.docs;
        }

        public MergeBoost getMergeBoost() {
            return this.mergeBoost;
        }
    }

    private class OrdValueSourceStrategy
    extends OrdFieldValueStrategy {
        private FloatCompare comp;
        private float nullVal;
        private ValueSource valueSource;
        private FunctionValues functionValues;
        private float[] ordVals;
        private Map rcontext;
        private CollapseScore collapseScore;
        private float score;
        private boolean cscore;

        public OrdValueSourceStrategy(int maxDoc, String funcStr, int nullPolicy, int[] ords, boolean max, boolean needsScores, IntIntOpenHashMap boostDocs, FunctionQuery funcQuery, IndexSearcher searcher, SortedDocValues values) throws IOException {
            super(maxDoc, null, nullPolicy, max, needsScores, boostDocs, values);
            this.collapseScore = new CollapseScore();
            this.valueSource = funcQuery.getValueSource();
            this.rcontext = ValueSource.newContext((IndexSearcher)searcher);
            this.ords = ords;
            this.ordVals = new float[ords.length];
            Arrays.fill(ords, -1);
            if (max) {
                this.comp = new MaxFloatComp();
                Arrays.fill(this.ordVals, -3.4028235E38f);
            } else {
                this.nullVal = Float.MAX_VALUE;
                this.comp = new MinFloatComp();
                Arrays.fill(this.ordVals, Float.MAX_VALUE);
            }
            if (funcStr.indexOf("cscore()") != -1) {
                this.cscore = true;
                this.rcontext.put("CSCORE", this.collapseScore);
            }
            if (this.needsScores) {
                this.scores = new float[ords.length];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.functionValues = this.valueSource.getValues(this.rcontext, context);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            if (this.boosted && this.mergeBoost.boost(globalDoc)) {
                this.boostOrds.add(ord);
                this.boostDocs.add(globalDoc);
            }
            if (this.needsScores || this.cscore) {
                this.collapseScore.score = this.score = this.scorer.score();
            }
            float currentVal = this.functionValues.floatVal(contextDoc);
            if (ord > -1) {
                if (this.comp.test(currentVal, this.ordVals[ord])) {
                    this.ords[ord] = globalDoc;
                    this.ordVals[ord] = currentVal;
                    if (this.needsScores) {
                        this.scores[ord] = this.score;
                    }
                }
            } else if (this.nullPolicy == 1) {
                if (this.comp.test(currentVal, this.nullVal)) {
                    this.nullVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.score;
                    }
                }
            } else if (this.nullPolicy == 2) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.score);
                }
            }
        }
    }

    private class OrdLongStrategy
    extends OrdFieldValueStrategy {
        private NumericDocValues minMaxVals;
        private LongCompare comp;
        private long nullVal;
        private long[] ordVals;

        public OrdLongStrategy(int maxDoc, String field, int nullPolicy, int[] ords, boolean max, boolean needsScores, IntIntOpenHashMap boostDocs, SortedDocValues values) throws IOException {
            super(maxDoc, field, nullPolicy, max, needsScores, boostDocs, values);
            this.ords = ords;
            this.ordVals = new long[ords.length];
            Arrays.fill(ords, -1);
            if (max) {
                this.comp = new MaxLongComp();
                Arrays.fill(this.ordVals, Long.MIN_VALUE);
            } else {
                this.nullVal = Long.MAX_VALUE;
                this.comp = new MinLongComp();
                Arrays.fill(this.ordVals, Long.MAX_VALUE);
            }
            if (needsScores) {
                this.scores = new float[ords.length];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.minMaxVals = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            if (this.boosted && this.mergeBoost.boost(globalDoc)) {
                this.boostOrds.add(ord);
                this.boostDocs.add(globalDoc);
                return;
            }
            long currentVal = this.minMaxVals.get(contextDoc);
            if (ord > -1) {
                if (this.comp.test(currentVal, this.ordVals[ord])) {
                    this.ords[ord] = globalDoc;
                    this.ordVals[ord] = currentVal;
                    if (this.needsScores) {
                        this.scores[ord] = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 1) {
                if (this.comp.test(currentVal, this.nullVal)) {
                    this.nullVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 2) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private class OrdFloatStrategy
    extends OrdFieldValueStrategy {
        private NumericDocValues minMaxValues;
        private FloatCompare comp;
        private float nullVal;
        private float[] ordVals;

        public OrdFloatStrategy(int maxDoc, String field, int nullPolicy, int[] ords, boolean max, boolean needsScores, IntIntOpenHashMap boostDocs, SortedDocValues values) throws IOException {
            super(maxDoc, field, nullPolicy, max, needsScores, boostDocs, values);
            this.ords = ords;
            this.ordVals = new float[ords.length];
            Arrays.fill(ords, -1);
            if (max) {
                this.comp = new MaxFloatComp();
                Arrays.fill(this.ordVals, -3.4028235E38f);
                this.nullVal = -3.4028235E38f;
            } else {
                this.comp = new MinFloatComp();
                Arrays.fill(this.ordVals, Float.MAX_VALUE);
                this.nullVal = Float.MAX_VALUE;
            }
            if (needsScores) {
                this.scores = new float[ords.length];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.minMaxValues = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            if (this.boosted && this.mergeBoost.boost(globalDoc)) {
                this.boostDocs.add(globalDoc);
                this.boostOrds.add(ord);
                return;
            }
            int currentMinMax = (int)this.minMaxValues.get(contextDoc);
            float currentVal = Float.intBitsToFloat(currentMinMax);
            if (ord > -1) {
                if (this.comp.test(currentVal, this.ordVals[ord])) {
                    this.ords[ord] = globalDoc;
                    this.ordVals[ord] = currentVal;
                    if (this.needsScores) {
                        this.scores[ord] = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 1) {
                if (this.comp.test(currentVal, this.nullVal)) {
                    this.nullVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 2) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private class OrdIntStrategy
    extends OrdFieldValueStrategy {
        private NumericDocValues minMaxValues;
        private IntCompare comp;
        private int nullVal;
        private int[] ordVals;

        public OrdIntStrategy(int maxDoc, String field, int nullPolicy, int[] ords, boolean max, boolean needsScores, IntIntOpenHashMap boostDocs, SortedDocValues values) throws IOException {
            super(maxDoc, field, nullPolicy, max, needsScores, boostDocs, values);
            this.ords = ords;
            this.ordVals = new int[ords.length];
            Arrays.fill(ords, -1);
            if (max) {
                this.comp = new MaxIntComp();
                Arrays.fill(this.ordVals, Integer.MIN_VALUE);
            } else {
                this.comp = new MinIntComp();
                Arrays.fill(this.ordVals, Integer.MAX_VALUE);
                this.nullVal = Integer.MAX_VALUE;
            }
            if (needsScores) {
                this.scores = new float[ords.length];
                if (nullPolicy == 2) {
                    this.nullScores = new FloatArrayList();
                }
            }
        }

        @Override
        public void setNextReader(LeafReaderContext context) throws IOException {
            this.minMaxValues = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void collapse(int ord, int contextDoc, int globalDoc) throws IOException {
            if (this.boosted && this.mergeBoost.boost(globalDoc)) {
                this.boostDocs.add(globalDoc);
                this.boostOrds.add(ord);
                return;
            }
            int currentVal = (int)this.minMaxValues.get(contextDoc);
            if (ord > -1) {
                if (this.comp.test(currentVal, this.ordVals[ord])) {
                    this.ords[ord] = globalDoc;
                    this.ordVals[ord] = currentVal;
                    if (this.needsScores) {
                        this.scores[ord] = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 1) {
                if (this.comp.test(currentVal, this.nullVal)) {
                    this.nullVal = currentVal;
                    this.nullDoc = globalDoc;
                    if (this.needsScores) {
                        this.nullScore = this.scorer.score();
                    }
                }
            } else if (this.nullPolicy == 2) {
                this.collapsedSet.set(globalDoc);
                if (this.needsScores) {
                    this.nullScores.add(this.scorer.score());
                }
            }
        }
    }

    private abstract class OrdFieldValueStrategy {
        protected int nullPolicy;
        protected int[] ords;
        protected Scorer scorer;
        protected FloatArrayList nullScores;
        protected float nullScore;
        protected float[] scores;
        protected FixedBitSet collapsedSet;
        protected int nullDoc = -1;
        protected boolean needsScores;
        protected boolean max;
        protected String field;
        protected boolean boosts;
        protected IntArrayList boostOrds;
        protected IntArrayList boostDocs;
        protected MergeBoost mergeBoost;
        protected boolean boosted;

        public abstract void collapse(int var1, int var2, int var3) throws IOException;

        public abstract void setNextReader(LeafReaderContext var1) throws IOException;

        public OrdFieldValueStrategy(int maxDoc, String field, int nullPolicy, boolean max, boolean needsScores, IntIntOpenHashMap boostDocsMap, SortedDocValues values) {
            this.field = field;
            this.nullPolicy = nullPolicy;
            this.max = max;
            this.needsScores = needsScores;
            this.collapsedSet = new FixedBitSet(maxDoc);
            if (boostDocsMap != null) {
                this.boosts = true;
                this.boostOrds = new IntArrayList();
                this.boostDocs = new IntArrayList();
                int[] bd = new int[boostDocsMap.size()];
                Iterator it = boostDocsMap.iterator();
                int index = -1;
                while (it.hasNext()) {
                    IntIntCursor cursor = (IntIntCursor)it.next();
                    bd[++index] = cursor.key;
                }
                Arrays.sort(bd);
                this.mergeBoost = new MergeBoost(bd);
                this.boosted = true;
            }
        }

        public MergeBoost getMergeBoost() {
            return this.mergeBoost;
        }

        public FixedBitSet getCollapsedSet() {
            if (this.nullDoc > -1) {
                this.collapsedSet.set(this.nullDoc);
            }
            if (this.boostOrds != null) {
                int s = this.boostOrds.size();
                for (int i = 0; i < s; ++i) {
                    int ord = this.boostOrds.get(i);
                    if (ord > -1) {
                        this.ords[ord] = -1;
                    }
                    this.collapsedSet.set(this.boostDocs.get(i));
                }
                this.mergeBoost.reset();
            }
            for (int i = 0; i < this.ords.length; ++i) {
                int doc = this.ords[i];
                if (doc <= -1) continue;
                this.collapsedSet.set(doc);
            }
            return this.collapsedSet;
        }

        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        public FloatArrayList getNullScores() {
            return this.nullScores;
        }

        public float getNullScore() {
            return this.nullScore;
        }

        public float[] getScores() {
            return this.scores;
        }
    }

    public static final class CollapseScore {
        public float score;
    }

    private class CollectorFactory {
        private CollectorFactory() {
        }

        public DelegatingCollector getCollector(String collapseField, String min, String max, int nullPolicy, String hint, boolean needsScores, int size, IntIntOpenHashMap boostDocs, SolrIndexSearcher searcher) throws IOException {
            FunctionQParser functionQParser;
            ModifiableSolrParams params;
            SolrQueryRequestBase request;
            SortedDocValues docValues = null;
            FunctionQuery funcQuery = null;
            FieldType collapseFieldType = searcher.getSchema().getField(collapseField).getType();
            String defaultValue = searcher.getSchema().getField(collapseField).getDefaultValue();
            if (collapseFieldType instanceof StrField) {
                if (CollapsingQParserPlugin.HINT_TOP_FC.equals(hint)) {
                    HashMap<String, UninvertingReader.Type> mapping = new HashMap<String, UninvertingReader.Type>();
                    mapping.put(collapseField, UninvertingReader.Type.SORTED);
                    UninvertingReader uninvertingReader = new UninvertingReader((LeafReader)new ReaderWrapper(searcher.getLeafReader(), collapseField), mapping);
                    docValues = uninvertingReader.getSortedDocValues(collapseField);
                } else {
                    docValues = DocValues.getSorted((LeafReader)searcher.getLeafReader(), (String)collapseField);
                }
            } else if (CollapsingQParserPlugin.HINT_TOP_FC.equals(hint)) {
                throw new IOException("top_fc hint is only supported when collapsing on String Fields");
            }
            FieldType minMaxFieldType = null;
            if (max != null) {
                if (max.indexOf("(") == -1) {
                    minMaxFieldType = searcher.getSchema().getField(max).getType();
                } else {
                    request = null;
                    try {
                        params = new ModifiableSolrParams();
                        request = new LocalSolrQueryRequest(searcher.getCore(), (SolrParams)params);
                        functionQParser = new FunctionQParser(max, null, null, request);
                        funcQuery = (FunctionQuery)functionQParser.parse();
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    finally {
                        request.close();
                    }
                }
            }
            if (min != null) {
                if (min.indexOf("(") == -1) {
                    minMaxFieldType = searcher.getSchema().getField(min).getType();
                } else {
                    request = null;
                    try {
                        params = new ModifiableSolrParams();
                        request = new LocalSolrQueryRequest(searcher.getCore(), (SolrParams)params);
                        functionQParser = new FunctionQParser(min, null, null, request);
                        funcQuery = (FunctionQuery)functionQParser.parse();
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    finally {
                        request.close();
                    }
                }
            }
            int maxDoc = searcher.maxDoc();
            int leafCount = searcher.getTopReaderContext().leaves().size();
            if (min != null || max != null) {
                if (collapseFieldType instanceof StrField) {
                    return new OrdFieldValueCollector(maxDoc, leafCount, docValues, nullPolicy, max != null ? max : min, max != null, needsScores, minMaxFieldType, boostDocs, funcQuery, searcher);
                }
                if (collapseFieldType instanceof TrieIntField || collapseFieldType instanceof TrieFloatField) {
                    int nullValue = 0;
                    if (collapseFieldType instanceof TrieFloatField) {
                        nullValue = defaultValue != null ? Float.floatToIntBits(Float.parseFloat(defaultValue)) : Float.floatToIntBits(0.0f);
                    } else if (defaultValue != null) {
                        nullValue = Integer.parseInt(defaultValue);
                    }
                    return new IntFieldValueCollector(maxDoc, size, leafCount, nullValue, nullPolicy, collapseField, max != null ? max : min, max != null, needsScores, minMaxFieldType, boostDocs, funcQuery, searcher);
                }
                throw new IOException("64 bit numeric collapse fields are not supported");
            }
            if (collapseFieldType instanceof StrField) {
                return new OrdScoreCollector(maxDoc, leafCount, docValues, nullPolicy, boostDocs);
            }
            if (collapseFieldType instanceof TrieIntField || collapseFieldType instanceof TrieFloatField) {
                int nullValue = 0;
                if (collapseFieldType instanceof TrieFloatField) {
                    nullValue = defaultValue != null ? Float.floatToIntBits(Float.parseFloat(defaultValue)) : Float.floatToIntBits(0.0f);
                } else if (defaultValue != null) {
                    nullValue = Integer.parseInt(defaultValue);
                }
                return new IntScoreCollector(maxDoc, leafCount, nullValue, nullPolicy, size, collapseField, boostDocs);
            }
            throw new IOException("64 bit numeric collapse fields are not supported");
        }
    }

    private class IntFieldValueCollector
    extends DelegatingCollector {
        private LeafReaderContext[] contexts;
        private NumericDocValues collapseValues;
        private int maxDoc;
        private int nullValue;
        private int nullPolicy;
        private IntFieldValueStrategy collapseStrategy;
        private boolean needsScores;
        private String collapseField;

        public IntFieldValueCollector(int maxDoc, int size, int segments, int nullValue, int nullPolicy, String collapseField, String field, boolean max, boolean needsScores, FieldType fieldType, IntIntOpenHashMap boostDocsMap, FunctionQuery funcQuery, IndexSearcher searcher) throws IOException {
            this.maxDoc = maxDoc;
            this.contexts = new LeafReaderContext[segments];
            this.collapseField = collapseField;
            this.nullValue = nullValue;
            this.nullPolicy = nullPolicy;
            this.needsScores = needsScores;
            if (funcQuery != null) {
                this.collapseStrategy = new IntValueSourceStrategy(maxDoc, field, size, collapseField, nullValue, nullPolicy, max, this.needsScores, boostDocsMap, funcQuery, searcher);
            } else if (fieldType instanceof TrieIntField) {
                this.collapseStrategy = new IntIntStrategy(maxDoc, size, collapseField, field, nullValue, nullPolicy, max, this.needsScores, boostDocsMap);
            } else if (fieldType instanceof TrieFloatField) {
                this.collapseStrategy = new IntFloatStrategy(maxDoc, size, collapseField, field, nullValue, nullPolicy, max, this.needsScores, boostDocsMap);
            } else {
                throw new IOException("min/max must be TrieInt or TrieFloat when collapsing on numeric fields .");
            }
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.collapseStrategy.setScorer(scorer);
        }

        @Override
        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.contexts[context.ord] = context;
            this.docBase = context.docBase;
            this.collapseStrategy.setNextReader(context);
            this.collapseValues = context.reader().getNumericDocValues(this.collapseField);
        }

        @Override
        public void collect(int contextDoc) throws IOException {
            int globalDoc = contextDoc + this.docBase;
            int collapseKey = (int)this.collapseValues.get(contextDoc);
            this.collapseStrategy.collapse(collapseKey, contextDoc, globalDoc);
        }

        @Override
        public void finish() throws IOException {
            if (this.contexts.length == 0) {
                return;
            }
            int currentContext = 0;
            int currentDocBase = 0;
            this.collapseValues = this.contexts[currentContext].reader().getNumericDocValues(this.collapseField);
            int nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
            this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
            DummyScorer dummy = new DummyScorer();
            this.leafDelegate.setScorer((Scorer)dummy);
            BitSetIterator it = new BitSetIterator((BitSet)this.collapseStrategy.getCollapsedSet(), 0L);
            int globalDoc = -1;
            int nullScoreIndex = 0;
            IntIntOpenHashMap cmap = this.collapseStrategy.getCollapseMap();
            int[] docs = this.collapseStrategy.getDocs();
            float[] scores = this.collapseStrategy.getScores();
            FloatArrayList nullScores = this.collapseStrategy.getNullScores();
            MergeBoost mergeBoost = this.collapseStrategy.getMergeBoost();
            float nullScore = this.collapseStrategy.getNullScore();
            while ((globalDoc = it.nextDoc()) != Integer.MAX_VALUE) {
                while (globalDoc >= nextDocBase) {
                    currentDocBase = this.contexts[++currentContext].docBase;
                    nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
                    this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
                    this.leafDelegate.setScorer((Scorer)dummy);
                    this.collapseValues = this.contexts[currentContext].reader().getNumericDocValues(this.collapseField);
                }
                int contextDoc = globalDoc - currentDocBase;
                if (this.needsScores) {
                    int collapseValue = (int)this.collapseValues.get(contextDoc);
                    if (collapseValue != this.nullValue) {
                        int pointer = cmap.get(collapseValue);
                        dummy.score = scores[pointer];
                    } else if (mergeBoost != null && mergeBoost.boost(globalDoc)) {
                        dummy.score = 0.0f;
                    } else if (this.nullPolicy == 1) {
                        dummy.score = nullScore;
                    } else if (this.nullPolicy == 2) {
                        dummy.score = nullScores.get(nullScoreIndex++);
                    }
                }
                dummy.docId = contextDoc;
                this.leafDelegate.collect(contextDoc);
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private class OrdFieldValueCollector
    extends DelegatingCollector {
        private LeafReaderContext[] contexts;
        private SortedDocValues collapseValues;
        protected MultiDocValues.OrdinalMap ordinalMap;
        protected SortedDocValues segmentValues;
        protected LongValues segmentOrdinalMap;
        protected MultiDocValues.MultiSortedDocValues multiSortedDocValues;
        private int maxDoc;
        private int nullPolicy;
        private OrdFieldValueStrategy collapseStrategy;
        private boolean needsScores;

        public OrdFieldValueCollector(int maxDoc, int segments, SortedDocValues collapseValues, int nullPolicy, String field, boolean max, boolean needsScores, FieldType fieldType, IntIntOpenHashMap boostDocs, FunctionQuery funcQuery, IndexSearcher searcher) throws IOException {
            this.maxDoc = maxDoc;
            this.contexts = new LeafReaderContext[segments];
            this.collapseValues = collapseValues;
            if (collapseValues instanceof MultiDocValues.MultiSortedDocValues) {
                this.multiSortedDocValues = (MultiDocValues.MultiSortedDocValues)collapseValues;
                this.ordinalMap = this.multiSortedDocValues.mapping;
            }
            int valueCount = collapseValues.getValueCount();
            this.nullPolicy = nullPolicy;
            this.needsScores = needsScores;
            if (funcQuery != null) {
                this.collapseStrategy = new OrdValueSourceStrategy(maxDoc, field, nullPolicy, new int[valueCount], max, this.needsScores, boostDocs, funcQuery, searcher, collapseValues);
            } else if (fieldType instanceof TrieIntField) {
                this.collapseStrategy = new OrdIntStrategy(maxDoc, field, nullPolicy, new int[valueCount], max, this.needsScores, boostDocs, collapseValues);
            } else if (fieldType instanceof TrieFloatField) {
                this.collapseStrategy = new OrdFloatStrategy(maxDoc, field, nullPolicy, new int[valueCount], max, this.needsScores, boostDocs, collapseValues);
            } else if (fieldType instanceof TrieLongField) {
                this.collapseStrategy = new OrdLongStrategy(maxDoc, field, nullPolicy, new int[valueCount], max, this.needsScores, boostDocs, collapseValues);
            } else {
                throw new IOException("min/max must be either TrieInt, TrieLong, TrieFloat.");
            }
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        @Override
        public void setScorer(Scorer scorer) {
            this.collapseStrategy.setScorer(scorer);
        }

        @Override
        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.contexts[context.ord] = context;
            this.docBase = context.docBase;
            this.collapseStrategy.setNextReader(context);
            if (this.ordinalMap != null) {
                this.segmentValues = this.multiSortedDocValues.values[context.ord];
                this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(context.ord);
            } else {
                this.segmentValues = this.collapseValues;
            }
        }

        @Override
        public void collect(int contextDoc) throws IOException {
            int globalDoc = contextDoc + this.docBase;
            int ord = -1;
            if (this.ordinalMap != null) {
                ord = this.segmentValues.getOrd(contextDoc);
                if (ord > -1) {
                    ord = (int)this.segmentOrdinalMap.get(ord);
                }
            } else {
                ord = this.segmentValues.getOrd(globalDoc);
            }
            this.collapseStrategy.collapse(ord, contextDoc, globalDoc);
        }

        @Override
        public void finish() throws IOException {
            if (this.contexts.length == 0) {
                return;
            }
            int currentContext = 0;
            int currentDocBase = 0;
            if (this.ordinalMap != null) {
                this.segmentValues = this.multiSortedDocValues.values[currentContext];
                this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(currentContext);
            } else {
                this.segmentValues = this.collapseValues;
            }
            int nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
            this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
            DummyScorer dummy = new DummyScorer();
            this.leafDelegate.setScorer((Scorer)dummy);
            BitSetIterator it = new BitSetIterator((BitSet)this.collapseStrategy.getCollapsedSet(), 0L);
            int globalDoc = -1;
            int nullScoreIndex = 0;
            float[] scores = this.collapseStrategy.getScores();
            FloatArrayList nullScores = this.collapseStrategy.getNullScores();
            float nullScore = this.collapseStrategy.getNullScore();
            MergeBoost mergeBoost = this.collapseStrategy.getMergeBoost();
            while ((globalDoc = it.nextDoc()) != Integer.MAX_VALUE) {
                while (globalDoc >= nextDocBase) {
                    currentDocBase = this.contexts[++currentContext].docBase;
                    nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
                    this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
                    this.leafDelegate.setScorer((Scorer)dummy);
                    if (this.ordinalMap == null) continue;
                    this.segmentValues = this.multiSortedDocValues.values[currentContext];
                    this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(currentContext);
                }
                int contextDoc = globalDoc - currentDocBase;
                if (this.needsScores) {
                    int ord = -1;
                    if (this.ordinalMap != null) {
                        ord = this.segmentValues.getOrd(contextDoc);
                        if (ord > -1) {
                            ord = (int)this.segmentOrdinalMap.get(ord);
                        }
                    } else {
                        ord = this.segmentValues.getOrd(globalDoc);
                    }
                    if (ord > -1) {
                        dummy.score = scores[ord];
                    } else if (mergeBoost != null && mergeBoost.boost(globalDoc)) {
                        dummy.score = 0.0f;
                    } else if (this.nullPolicy == 1) {
                        dummy.score = nullScore;
                    } else if (this.nullPolicy == 2) {
                        dummy.score = nullScores.get(nullScoreIndex++);
                    }
                }
                dummy.docId = contextDoc;
                this.leafDelegate.collect(contextDoc);
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private class IntScoreCollector
    extends DelegatingCollector {
        private LeafReaderContext[] contexts;
        private FixedBitSet collapsedSet;
        private NumericDocValues collapseValues;
        private IntLongOpenHashMap cmap;
        private int maxDoc;
        private int nullPolicy;
        private float nullScore = -3.4028235E38f;
        private int nullDoc;
        private FloatArrayList nullScores;
        private IntArrayList boostKeys;
        private IntArrayList boostDocs;
        private MergeBoost mergeBoost;
        private boolean boosts;
        private String field;
        private int nullValue;

        public IntScoreCollector(int maxDoc, int segments, int nullValue, int nullPolicy, int size, String field, IntIntOpenHashMap boostDocsMap) {
            this.maxDoc = maxDoc;
            this.contexts = new LeafReaderContext[segments];
            this.collapsedSet = new FixedBitSet(maxDoc);
            this.nullValue = nullValue;
            this.nullPolicy = nullPolicy;
            if (nullPolicy == 2) {
                this.nullScores = new FloatArrayList();
            }
            this.cmap = new IntLongOpenHashMap(size);
            this.field = field;
            if (boostDocsMap != null) {
                this.boosts = true;
                this.boostDocs = new IntArrayList();
                this.boostKeys = new IntArrayList();
                int[] bd = new int[boostDocsMap.size()];
                Iterator it = boostDocsMap.iterator();
                int index = -1;
                while (it.hasNext()) {
                    IntIntCursor cursor = (IntIntCursor)it.next();
                    bd[++index] = cursor.key;
                }
                Arrays.sort(bd);
                this.mergeBoost = new MergeBoost(bd);
                this.boosts = true;
            }
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.contexts[context.ord] = context;
            this.docBase = context.docBase;
            this.collapseValues = DocValues.getNumeric((LeafReader)context.reader(), (String)this.field);
        }

        @Override
        public void collect(int contextDoc) throws IOException {
            int collapseValue = (int)this.collapseValues.get(contextDoc);
            int globalDoc = this.docBase + contextDoc;
            if (this.boosts && this.mergeBoost.boost(globalDoc)) {
                this.boostDocs.add(globalDoc);
                this.boostKeys.add(collapseValue);
                return;
            }
            if (collapseValue != this.nullValue) {
                float score = this.scorer.score();
                if (this.cmap.containsKey(collapseValue)) {
                    long scoreDoc = this.cmap.lget();
                    int testScore = (int)(scoreDoc >> 32);
                    int currentScore = Float.floatToRawIntBits(score);
                    if (currentScore > testScore) {
                        this.cmap.lset(((long)currentScore << 32) + (long)globalDoc);
                    }
                } else {
                    long scoreDoc = ((long)Float.floatToRawIntBits(score) << 32) + (long)globalDoc;
                    this.cmap.put(collapseValue, scoreDoc);
                }
            } else if (this.nullPolicy == 1) {
                float score = this.scorer.score();
                if (score > this.nullScore) {
                    this.nullScore = score;
                    this.nullDoc = globalDoc;
                }
            } else if (this.nullPolicy == 2) {
                this.collapsedSet.set(globalDoc);
                this.nullScores.add(this.scorer.score());
            }
        }

        @Override
        public void finish() throws IOException {
            if (this.contexts.length == 0) {
                return;
            }
            if (this.nullScore > -1.0f) {
                this.collapsedSet.set(this.nullDoc);
            }
            if (this.boostKeys != null) {
                int s = this.boostKeys.size();
                for (int i = 0; i < s; ++i) {
                    int key = this.boostKeys.get(i);
                    if (key != this.nullValue) {
                        this.cmap.remove(key);
                    }
                    this.collapsedSet.set(this.boostDocs.get(i));
                }
            }
            for (IntLongCursor cursor : this.cmap) {
                int doc = (int)cursor.value;
                this.collapsedSet.set(doc);
            }
            int currentContext = 0;
            int currentDocBase = 0;
            this.collapseValues = this.contexts[currentContext].reader().getNumericDocValues(this.field);
            int nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
            this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
            DummyScorer dummy = new DummyScorer();
            this.leafDelegate.setScorer((Scorer)dummy);
            BitSetIterator it = new BitSetIterator((BitSet)this.collapsedSet, 0L);
            int globalDoc = -1;
            int nullScoreIndex = 0;
            while ((globalDoc = it.nextDoc()) != Integer.MAX_VALUE) {
                while (globalDoc >= nextDocBase) {
                    currentDocBase = this.contexts[++currentContext].docBase;
                    nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
                    this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
                    this.leafDelegate.setScorer((Scorer)dummy);
                    this.collapseValues = this.contexts[currentContext].reader().getNumericDocValues(this.field);
                }
                int contextDoc = globalDoc - currentDocBase;
                int collapseValue = (int)this.collapseValues.get(contextDoc);
                if (collapseValue != this.nullValue) {
                    long scoreDoc = this.cmap.get(collapseValue);
                    dummy.score = Float.intBitsToFloat((int)(scoreDoc >> 32));
                } else if (!this.boosts || !this.mergeBoost.boost(globalDoc)) {
                    if (this.nullPolicy == 1) {
                        dummy.score = this.nullScore;
                    } else if (this.nullPolicy == 2) {
                        dummy.score = this.nullScores.get(nullScoreIndex++);
                    }
                }
                dummy.docId = contextDoc;
                this.leafDelegate.collect(contextDoc);
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private class OrdScoreCollector
    extends DelegatingCollector {
        private LeafReaderContext[] contexts;
        private FixedBitSet collapsedSet;
        private SortedDocValues collapseValues;
        private MultiDocValues.OrdinalMap ordinalMap;
        private SortedDocValues segmentValues;
        private LongValues segmentOrdinalMap;
        private MultiDocValues.MultiSortedDocValues multiSortedDocValues;
        private int[] ords;
        private float[] scores;
        private int maxDoc;
        private int nullPolicy;
        private float nullScore = -3.4028235E38f;
        private int nullDoc;
        private FloatArrayList nullScores;
        private IntArrayList boostOrds;
        private IntArrayList boostDocs;
        private MergeBoost mergeBoost;
        private boolean boosts;

        public OrdScoreCollector(int maxDoc, int segments, SortedDocValues collapseValues, int nullPolicy, IntIntOpenHashMap boostDocsMap) {
            this.maxDoc = maxDoc;
            this.contexts = new LeafReaderContext[segments];
            this.collapsedSet = new FixedBitSet(maxDoc);
            this.collapseValues = collapseValues;
            int valueCount = collapseValues.getValueCount();
            if (collapseValues instanceof MultiDocValues.MultiSortedDocValues) {
                this.multiSortedDocValues = (MultiDocValues.MultiSortedDocValues)collapseValues;
                this.ordinalMap = this.multiSortedDocValues.mapping;
            }
            this.ords = new int[valueCount];
            Arrays.fill(this.ords, -1);
            this.scores = new float[valueCount];
            Arrays.fill(this.scores, -3.4028235E38f);
            this.nullPolicy = nullPolicy;
            if (nullPolicy == 2) {
                this.nullScores = new FloatArrayList();
            }
            if (boostDocsMap != null) {
                this.boosts = true;
                this.boostOrds = new IntArrayList();
                this.boostDocs = new IntArrayList();
                int[] bd = new int[boostDocsMap.size()];
                Iterator it = boostDocsMap.iterator();
                int index = -1;
                while (it.hasNext()) {
                    IntIntCursor cursor = (IntIntCursor)it.next();
                    bd[++index] = cursor.key;
                }
                Arrays.sort(bd);
                this.mergeBoost = new MergeBoost(bd);
            }
        }

        @Override
        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.contexts[context.ord] = context;
            this.docBase = context.docBase;
            if (this.ordinalMap != null) {
                this.segmentValues = this.multiSortedDocValues.values[context.ord];
                this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(context.ord);
            } else {
                this.segmentValues = this.collapseValues;
            }
        }

        @Override
        public void collect(int contextDoc) throws IOException {
            int globalDoc = contextDoc + this.docBase;
            int ord = -1;
            if (this.ordinalMap != null) {
                ord = this.segmentValues.getOrd(contextDoc);
                if (ord > -1) {
                    ord = (int)this.segmentOrdinalMap.get(ord);
                }
            } else {
                ord = this.segmentValues.getOrd(globalDoc);
            }
            if (this.boosts && this.mergeBoost.boost(globalDoc)) {
                this.boostDocs.add(globalDoc);
                this.boostOrds.add(ord);
                return;
            }
            if (ord > -1) {
                float score = this.scorer.score();
                if (score > this.scores[ord]) {
                    this.ords[ord] = globalDoc;
                    this.scores[ord] = score;
                }
            } else if (this.nullPolicy == 1) {
                float score = this.scorer.score();
                if (score > this.nullScore) {
                    this.nullScore = score;
                    this.nullDoc = globalDoc;
                }
            } else if (this.nullPolicy == 2) {
                this.collapsedSet.set(globalDoc);
                this.nullScores.add(this.scorer.score());
            }
        }

        @Override
        public void finish() throws IOException {
            if (this.contexts.length == 0) {
                return;
            }
            if (this.nullScore > 0.0f) {
                this.collapsedSet.set(this.nullDoc);
            }
            if (this.boostOrds != null) {
                int s = this.boostOrds.size();
                for (int i = 0; i < s; ++i) {
                    int ord = this.boostOrds.get(i);
                    if (ord > -1) {
                        this.ords[ord] = -1;
                    }
                    this.collapsedSet.set(this.boostDocs.get(i));
                }
                this.mergeBoost.reset();
            }
            for (int i = 0; i < this.ords.length; ++i) {
                int doc = this.ords[i];
                if (doc <= -1) continue;
                this.collapsedSet.set(doc);
            }
            int currentContext = 0;
            int currentDocBase = 0;
            if (this.ordinalMap != null) {
                this.segmentValues = this.multiSortedDocValues.values[currentContext];
                this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(currentContext);
            } else {
                this.segmentValues = this.collapseValues;
            }
            int nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
            this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
            DummyScorer dummy = new DummyScorer();
            this.leafDelegate.setScorer((Scorer)dummy);
            BitSetIterator it = new BitSetIterator((BitSet)this.collapsedSet, 0L);
            int docId = -1;
            int index = -1;
            while ((docId = it.nextDoc()) != Integer.MAX_VALUE) {
                while (docId >= nextDocBase) {
                    currentDocBase = this.contexts[++currentContext].docBase;
                    nextDocBase = currentContext + 1 < this.contexts.length ? this.contexts[currentContext + 1].docBase : this.maxDoc;
                    this.leafDelegate = this.delegate.getLeafCollector(this.contexts[currentContext]);
                    this.leafDelegate.setScorer((Scorer)dummy);
                    if (this.ordinalMap == null) continue;
                    this.segmentValues = this.multiSortedDocValues.values[currentContext];
                    this.segmentOrdinalMap = this.ordinalMap.getGlobalOrds(currentContext);
                }
                int contextDoc = docId - currentDocBase;
                int ord = -1;
                if (this.ordinalMap != null) {
                    ord = this.segmentValues.getOrd(contextDoc);
                    if (ord > -1) {
                        ord = (int)this.segmentOrdinalMap.get(ord);
                    }
                } else {
                    ord = this.segmentValues.getOrd(docId);
                }
                if (ord > -1) {
                    dummy.score = this.scores[ord];
                } else if (!this.boosts || !this.mergeBoost.boost(docId)) {
                    if (this.nullPolicy == 1) {
                        dummy.score = this.nullScore;
                    } else if (this.nullPolicy == 2) {
                        dummy.score = this.nullScores.get(++index);
                    }
                }
                dummy.docId = contextDoc;
                this.leafDelegate.collect(contextDoc);
            }
            if (this.delegate instanceof DelegatingCollector) {
                ((DelegatingCollector)this.delegate).finish();
            }
        }
    }

    private class DummyScorer
    extends Scorer {
        public float score;
        public int docId;

        public DummyScorer() {
            super(null);
        }

        public float score() {
            return this.score;
        }

        public int freq() {
            return 0;
        }

        public int advance(int i) {
            return -1;
        }

        public int nextDoc() {
            return 0;
        }

        public int docID() {
            return this.docId;
        }

        public long cost() {
            return 0L;
        }
    }

    private class ReaderWrapper
    extends FilterLeafReader {
        private String field;

        public ReaderWrapper(LeafReader leafReader, String field) {
            super(leafReader);
            this.field = field;
        }

        public SortedDocValues getSortedDocValues(String field) {
            return null;
        }

        public Object getCoreCacheKey() {
            return this.in.getCoreCacheKey();
        }

        public FieldInfos getFieldInfos() {
            Iterator it = this.in.getFieldInfos().iterator();
            ArrayList<FieldInfo> newInfos = new ArrayList<FieldInfo>();
            while (it.hasNext()) {
                FieldInfo fieldInfo = (FieldInfo)it.next();
                if (fieldInfo.name.equals(this.field)) {
                    FieldInfo f = new FieldInfo(fieldInfo.name, fieldInfo.number, fieldInfo.hasVectors(), fieldInfo.hasNorms(), fieldInfo.hasPayloads(), fieldInfo.getIndexOptions(), DocValuesType.NONE, fieldInfo.getDocValuesGen(), fieldInfo.attributes());
                    newInfos.add(f);
                    continue;
                }
                newInfos.add(fieldInfo);
            }
            FieldInfos infos = new FieldInfos(newInfos.toArray(new FieldInfo[newInfos.size()]));
            return infos;
        }
    }

    public class CollapsingPostFilter
    extends ExtendedQueryBase
    implements PostFilter,
    ScoreFilter {
        private String collapseField;
        private String max;
        private String min;
        public String hint;
        private boolean needsScores = true;
        private int nullPolicy;
        private Map<BytesRef, Integer> boosted;
        public static final int NULL_POLICY_IGNORE = 0;
        public static final int NULL_POLICY_COLLAPSE = 1;
        public static final int NULL_POLICY_EXPAND = 2;
        private int size;

        public String getField() {
            return this.collapseField;
        }

        @Override
        public void setCache(boolean cache) {
        }

        @Override
        public void setCacheSep(boolean cacheSep) {
        }

        @Override
        public boolean getCacheSep() {
            return false;
        }

        @Override
        public boolean getCache() {
            return false;
        }

        public int hashCode() {
            int hashCode = this.collapseField.hashCode();
            hashCode = this.max != null ? hashCode + this.max.hashCode() : hashCode;
            hashCode = this.min != null ? hashCode + this.min.hashCode() : hashCode;
            hashCode += this.nullPolicy;
            return hashCode *= (1 + Float.floatToIntBits(this.getBoost())) * 31;
        }

        public boolean equals(Object o) {
            if (o instanceof CollapsingPostFilter) {
                CollapsingPostFilter c = (CollapsingPostFilter)o;
                if (this.collapseField.equals(c.collapseField) && (this.max == null && c.max == null || this.max != null && c.max != null && this.max.equals(c.max)) && (this.min == null && c.min == null || this.min != null && c.min != null && this.min.equals(c.min)) && this.nullPolicy == c.nullPolicy && this.getBoost() == c.getBoost()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int getCost() {
            return Math.max(super.getCost(), 100);
        }

        @Override
        public String toString(String s) {
            return s;
        }

        public CollapsingPostFilter(SolrParams localParams, SolrParams params, SolrQueryRequest request) throws IOException {
            String nPolicy;
            this.collapseField = localParams.get("field");
            if (this.collapseField == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required 'field' param is missing.");
            }
            this.max = localParams.get("max");
            this.min = localParams.get("min");
            this.hint = localParams.get("hint");
            this.size = localParams.getInt("size", 100000);
            if (this.min != null || this.max != null) {
                this.needsScores = this.needsScores(params);
            }
            if ((nPolicy = localParams.get("nullPolicy", CollapsingQParserPlugin.NULL_IGNORE)).equals(CollapsingQParserPlugin.NULL_IGNORE)) {
                this.nullPolicy = 0;
            } else if (nPolicy.equals("collapse")) {
                this.nullPolicy = 1;
            } else if (nPolicy.equals(CollapsingQParserPlugin.NULL_EXPAND)) {
                this.nullPolicy = 2;
            } else {
                throw new IOException("Invalid nullPolicy:" + nPolicy);
            }
        }

        private IntIntOpenHashMap getBoostDocs(SolrIndexSearcher indexSearcher, Map<BytesRef, Integer> boosted, Map context) throws IOException {
            IntIntOpenHashMap boostDocs = QueryElevationComponent.getBoostDocs(indexSearcher, boosted, context);
            return boostDocs;
        }

        @Override
        public DelegatingCollector getFilterCollector(IndexSearcher indexSearcher) {
            try {
                SolrIndexSearcher searcher = (SolrIndexSearcher)indexSearcher;
                CollectorFactory collectorFactory = new CollectorFactory();
                IntIntOpenHashMap boostDocsMap = null;
                Map<Object, Object> context = null;
                SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
                if (info != null) {
                    context = info.getReq().getContext();
                }
                if (this.boosted == null && context != null) {
                    this.boosted = (Map)context.get("BOOSTED_PRIORITY");
                }
                boostDocsMap = this.getBoostDocs(searcher, this.boosted, context);
                return collectorFactory.getCollector(this.collapseField, this.min, this.max, this.nullPolicy, this.hint, this.needsScores, this.size, boostDocsMap, searcher);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean needsScores(SolrParams params) {
            String sortSpec = params.get("sort");
            if (sortSpec != null && sortSpec.length() != 0) {
                String[] sorts;
                for (String s : sorts = sortSpec.split(",")) {
                    String[] parts = s.split(" ");
                    if (!parts[0].equals("score")) continue;
                    return true;
                }
            } else {
                return true;
            }
            String fl = params.get("fl");
            if (fl != null) {
                String[] fls;
                for (String f : fls = fl.split(",")) {
                    if (!f.trim().equals("score")) continue;
                    return true;
                }
            }
            return this.boosted != null;
        }
    }

    private class CollapsingQParser
    extends QParser {
        public CollapsingQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest request) {
            super(qstr, localParams, params, request);
        }

        @Override
        public Query parse() throws SyntaxError {
            try {
                return new CollapsingPostFilter(this.localParams, this.params, this.req);
            }
            catch (Exception e) {
                throw new SyntaxError(e.getMessage(), e);
            }
        }
    }
}

