/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.SolrConfigHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.ConfigEditablePlugin;
import org.apache.solr.util.CommandOperation;
import org.apache.zookeeper.KeeperException;

public class SecurityConfHandler
extends RequestHandlerBase {
    private CoreContainer cores;

    public SecurityConfHandler(CoreContainer coreContainer) {
        this.cores = coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrConfigHandler.setWt(req, "json");
        String httpMethod = (String)req.getContext().get("httpMethod");
        String path = (String)req.getContext().get("path");
        String key = path.substring(path.lastIndexOf(47) + 1);
        if ("GET".equals(httpMethod)) {
            this.getConf(rsp, key);
        } else if ("POST".equals(httpMethod)) {
            Object plugin = this.getPlugin(key);
            this.doEdit(req, rsp, path, key, plugin);
        }
    }

    private void doEdit(SolrQueryRequest req, SolrQueryResponse rsp, String path, String key, Object plugin) throws IOException {
        ZkStateReader.ConfigData data;
        ConfigEditablePlugin configEditablePlugin = null;
        if (plugin == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No " + key + " plugin configured");
        }
        if (!(plugin instanceof ConfigEditablePlugin)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, key + " plugin is not editable");
        }
        configEditablePlugin = (ConfigEditablePlugin)plugin;
        if (req.getContentStreams() == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No contentStream");
        }
        List<CommandOperation> ops = CommandOperation.readCommands(req.getContentStreams(), rsp);
        if (ops == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No commands");
        }
        do {
            data = this.getSecurityProps(true);
            Map latestConf = (Map)data.data.get(key);
            if (latestConf == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No configuration present for " + key);
            }
            List<CommandOperation> commandsCopy = CommandOperation.clone(ops);
            Map<String, Object> out = configEditablePlugin.edit(Utils.getDeepCopy((Map)latestConf, (int)4), commandsCopy);
            if (out == null) {
                List<Map> errs = CommandOperation.captureErrors(commandsCopy);
                if (!errs.isEmpty()) {
                    rsp.add("errorMessages", errs);
                    return;
                }
                return;
            }
            if (!Objects.equals(latestConf.get("class"), out.get("class"))) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class cannot be modified");
            }
            Map<String, Object> meta = SecurityConfHandler.getMapValue(out, "");
            meta.put("v", data.version + 1);
            data.data.put(key, out);
        } while (!this.persistConf("/security.json", Utils.toJSON((Object)data.data), data.version));
    }

    Object getPlugin(String key) {
        Closeable plugin = null;
        if ("authentication".equals(key)) {
            plugin = this.cores.getAuthenticationPlugin();
        }
        if ("authorization".equals(key)) {
            plugin = this.cores.getAuthorizationPlugin();
        }
        return plugin;
    }

    ZkStateReader.ConfigData getSecurityProps(boolean getFresh) {
        return this.cores.getZkController().getZkStateReader().getSecurityProps(getFresh);
    }

    boolean persistConf(String path, byte[] buf, int version) {
        try {
            this.cores.getZkController().getZkClient().setData(path, buf, version, true);
            return true;
        }
        catch (KeeperException.BadVersionException bdve) {
            return false;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, " Unable to persist conf", (Throwable)e);
        }
    }

    private void getConf(SolrQueryResponse rsp, String key) {
        Object o;
        ZkStateReader.ConfigData map = this.cores.getZkController().getZkStateReader().getSecurityProps(false);
        Object v0 = o = map == null ? null : map.data.get(key);
        if (o == null) {
            rsp.add("errorMessages", Collections.singletonList("No " + key + " configured"));
        } else {
            rsp.add(key + ".enabled", this.getPlugin(key) != null);
            rsp.add(key, o);
        }
    }

    public static Map<String, Object> getMapValue(Map<String, Object> lookupMap, String key) {
        LinkedHashMap m = (LinkedHashMap)lookupMap.get(key);
        if (m == null) {
            m = new LinkedHashMap();
            lookupMap.put(key, m);
        }
        return m;
    }

    public static List getListValue(Map<String, Object> lookupMap, String key) {
        ArrayList l = (ArrayList)lookupMap.get(key);
        if (l == null) {
            l = new ArrayList();
            lookupMap.put(key, l);
        }
        return l;
    }

    @Override
    public String getDescription() {
        return "Edit or read security configuration";
    }
}

