/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.Config;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.logging.LogWatcherConfig;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SolrXmlConfig {
    public static final String SOLR_XML_FILE = "solr.xml";
    private static final Logger log = LoggerFactory.getLogger(SolrXmlConfig.class);

    public static NodeConfig fromConfig(Config config) {
        UpdateShardHandlerConfig updateConfig;
        NamedList<Object> entries;
        String nodeName;
        SolrXmlConfig.checkForIllegalConfig(config);
        config.substituteProperties();
        CloudConfig cloudConfig = null;
        UpdateShardHandlerConfig deprecatedUpdateConfig = null;
        if (config.getNodeList("solr/solrcloud", false).getLength() > 0) {
            NamedList<Object> cloudSection = SolrXmlConfig.readNodeListAsNamedList(config, "solr/solrcloud/*[@name]", "<solrcloud>");
            deprecatedUpdateConfig = SolrXmlConfig.loadUpdateConfig(cloudSection, false);
            cloudConfig = SolrXmlConfig.fillSolrCloudSection(cloudSection);
        }
        if (Strings.isNullOrEmpty((String)(nodeName = (String)(entries = SolrXmlConfig.readNodeListAsNamedList(config, "solr/*[@name]", "<solr>")).remove("nodeName"))) && cloudConfig != null) {
            nodeName = cloudConfig.getHost();
        }
        if (deprecatedUpdateConfig == null) {
            updateConfig = SolrXmlConfig.loadUpdateConfig(SolrXmlConfig.readNodeListAsNamedList(config, "solr/updateshardhandler/*[@name]", "<updateshardhandler>"), true);
        } else {
            updateConfig = SolrXmlConfig.loadUpdateConfig(SolrXmlConfig.readNodeListAsNamedList(config, "solr/updateshardhandler/*[@name]", "<updateshardhandler>"), false);
            if (updateConfig != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "UpdateShardHandler configuration defined twice in solr.xml");
            }
            updateConfig = deprecatedUpdateConfig;
        }
        NodeConfig.NodeConfigBuilder configBuilder = new NodeConfig.NodeConfigBuilder(nodeName, config.getResourceLoader());
        configBuilder.setUpdateShardHandlerConfig(updateConfig);
        configBuilder.setShardHandlerFactoryConfig(SolrXmlConfig.getShardHandlerFactoryPluginInfo(config));
        configBuilder.setLogWatcherConfig(SolrXmlConfig.loadLogWatcherConfig(config, "solr/logging/*[@name]", "solr/logging/watcher/*[@name]"));
        configBuilder.setSolrProperties(SolrXmlConfig.loadProperties(config));
        if (cloudConfig != null) {
            configBuilder.setCloudConfig(cloudConfig);
        }
        return SolrXmlConfig.fillSolrSection(configBuilder, entries);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NodeConfig fromFile(SolrResourceLoader loader, File configFile) {
        log.info("Loading container configuration from {}", (Object)configFile.getAbsolutePath());
        if (!configFile.exists()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "solr.xml does not exist in " + configFile.getAbsolutePath() + " cannot start Solr");
        }
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            NodeConfig nodeConfig = SolrXmlConfig.fromInputStream(loader, inputStream);
            return nodeConfig;
        }
        catch (SolrException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load SOLR configuration", (Throwable)exc);
        }
    }

    public static NodeConfig fromString(SolrResourceLoader loader, String xml) {
        return SolrXmlConfig.fromInputStream(loader, new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NodeConfig fromInputStream(SolrResourceLoader loader, InputStream is) {
        try {
            byte[] buf = IOUtils.toByteArray((InputStream)is);
            try (ByteArrayInputStream dup = new ByteArrayInputStream(buf);){
                Config config = new Config(loader, null, new InputSource(dup), null, false);
                NodeConfig nodeConfig = SolrXmlConfig.fromConfig(config);
                return nodeConfig;
            }
        }
        catch (SolrException exc) {
            throw exc;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public static NodeConfig fromSolrHome(SolrResourceLoader loader, String solrHome) {
        return SolrXmlConfig.fromFile(loader, new File(solrHome, SOLR_XML_FILE));
    }

    public static NodeConfig fromSolrHome(Path solrHome) {
        SolrResourceLoader loader = new SolrResourceLoader(solrHome.toString());
        return SolrXmlConfig.fromSolrHome(loader, solrHome.toString());
    }

    private static void checkForIllegalConfig(Config config) {
        SolrXmlConfig.failIfFound(config, "solr/@coreLoadThreads");
        SolrXmlConfig.failIfFound(config, "solr/@persistent");
        SolrXmlConfig.failIfFound(config, "solr/@sharedLib");
        SolrXmlConfig.failIfFound(config, "solr/@zkHost");
        SolrXmlConfig.failIfFound(config, "solr/cores");
        SolrXmlConfig.assertSingleInstance("solrcloud", config);
        SolrXmlConfig.assertSingleInstance("logging", config);
        SolrXmlConfig.assertSingleInstance("logging/watcher", config);
    }

    private static void assertSingleInstance(String section, Config config) {
        if (config.getNodeList("/solr/" + section, false).getLength() > 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple instances of " + section + " section found in solr.xml");
        }
    }

    private static void failIfFound(Config config, String xPath) {
        if (config.getVal(xPath, false) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Should not have found " + xPath + "\n. Please upgrade your solr.xml: https://cwiki.apache.org/confluence/display/solr/Format+of+solr.xml");
        }
    }

    private static Properties loadProperties(Config config) {
        try {
            Node node = ((NodeList)config.evaluate("solr", XPathConstants.NODESET)).item(0);
            XPath xpath = config.getXPath();
            NodeList props = (NodeList)xpath.evaluate("property", node, XPathConstants.NODESET);
            Properties properties = new Properties();
            for (int i = 0; i < props.getLength(); ++i) {
                Node prop = props.item(i);
                properties.setProperty(DOMUtil.getAttr(prop, "name"), PropertiesUtil.substituteProperty(DOMUtil.getAttr(prop, "value"), null));
            }
            return properties;
        }
        catch (XPathExpressionException e) {
            log.warn("Error parsing solr.xml: " + e.getMessage());
            return null;
        }
    }

    private static NamedList<Object> readNodeListAsNamedList(Config config, String path, String section) {
        NodeList nodes = config.getNodeList(path, false);
        if (nodes == null) {
            return null;
        }
        return SolrXmlConfig.checkForDuplicates(section, DOMUtil.nodesToNamedList(nodes));
    }

    private static NamedList<Object> checkForDuplicates(String section, NamedList<Object> nl) {
        HashSet keys = new HashSet();
        for (Map.Entry entry : nl) {
            if (keys.add(entry.getKey())) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, section + " section of solr.xml contains duplicated '" + (String)entry.getKey() + "'");
        }
        return nl;
    }

    private static int parseInt(String field, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing '" + field + "', value '" + value + "' cannot be parsed as int");
        }
    }

    private static NodeConfig fillSolrSection(NodeConfig.NodeConfigBuilder builder, NamedList<Object> nl) {
        block24: for (Map.Entry entry : nl) {
            String name = (String)entry.getKey();
            if (entry.getValue() == null) continue;
            String value = entry.getValue().toString();
            switch (name) {
                case "adminHandler": {
                    builder.setCoreAdminHandlerClass(value);
                    continue block24;
                }
                case "collectionsHandler": {
                    builder.setCollectionsAdminHandlerClass(value);
                    continue block24;
                }
                case "infoHandler": {
                    builder.setInfoHandlerClass(value);
                    continue block24;
                }
                case "coreRootDirectory": {
                    builder.setCoreRootDirectory(value);
                    continue block24;
                }
                case "managementPath": {
                    builder.setManagementPath(value);
                    continue block24;
                }
                case "sharedLib": {
                    builder.setSharedLibDirectory(value);
                    continue block24;
                }
                case "configSetBaseDir": {
                    builder.setConfigSetBaseDirectory(value);
                    continue block24;
                }
                case "shareSchema": {
                    builder.setUseSchemaCache(Boolean.parseBoolean(value));
                    continue block24;
                }
                case "coreLoadThreads": {
                    builder.setCoreLoadThreads(SolrXmlConfig.parseInt(name, value));
                    continue block24;
                }
                case "transientCacheSize": {
                    builder.setTransientCacheSize(SolrXmlConfig.parseInt(name, value));
                    continue block24;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown configuration value in solr.xml: " + name);
        }
        return builder.build();
    }

    private static UpdateShardHandlerConfig loadUpdateConfig(NamedList<Object> nl, boolean alwaysDefine) {
        Object dct;
        Object dst;
        Object mucph;
        if (nl == null && !alwaysDefine) {
            return null;
        }
        if (nl == null) {
            return UpdateShardHandlerConfig.DEFAULT;
        }
        boolean defined = false;
        int maxUpdateConnections = 10000;
        int maxUpdateConnectionsPerHost = 100;
        int distributedSocketTimeout = 600000;
        int distributedConnectionTimeout = 60000;
        Object muc = nl.remove("maxUpdateConnections");
        if (muc != null) {
            maxUpdateConnections = SolrXmlConfig.parseInt("maxUpdateConnections", muc.toString());
            defined = true;
        }
        if ((mucph = nl.remove("maxUpdateConnectionsPerHost")) != null) {
            maxUpdateConnectionsPerHost = SolrXmlConfig.parseInt("maxUpdateConnectionsPerHost", mucph.toString());
            defined = true;
        }
        if ((dst = nl.remove("distribUpdateSoTimeout")) != null) {
            distributedSocketTimeout = SolrXmlConfig.parseInt("distribUpdateSoTimeout", dst.toString());
            defined = true;
        }
        if ((dct = nl.remove("distribUpdateConnTimeout")) != null) {
            distributedConnectionTimeout = SolrXmlConfig.parseInt("distribUpdateConnTimeout", dct.toString());
            defined = true;
        }
        if (!defined && !alwaysDefine) {
            return null;
        }
        return new UpdateShardHandlerConfig(maxUpdateConnections, maxUpdateConnectionsPerHost, distributedSocketTimeout, distributedConnectionTimeout);
    }

    private static String removeValue(NamedList<Object> nl, String key) {
        Object value = nl.remove(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private static String required(String section, String key, String value) {
        if (value != null) {
            return value;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, section + " section missing required entry '" + key + "'");
    }

    private static CloudConfig fillSolrCloudSection(NamedList<Object> nl) {
        String hostName = SolrXmlConfig.required("solrcloud", "host", SolrXmlConfig.removeValue(nl, "host"));
        int hostPort = SolrXmlConfig.parseInt("hostPort", SolrXmlConfig.required("solrcloud", "hostPort", SolrXmlConfig.removeValue(nl, "hostPort")));
        String hostContext = SolrXmlConfig.required("solrcloud", "hostContext", SolrXmlConfig.removeValue(nl, "hostContext"));
        CloudConfig.CloudConfigBuilder builder = new CloudConfig.CloudConfigBuilder(hostName, hostPort, hostContext);
        block25: for (Map.Entry entry : nl) {
            String name = (String)entry.getKey();
            if (entry.getValue() == null) continue;
            String value = entry.getValue().toString();
            switch (name) {
                case "leaderVoteWait": {
                    builder.setLeaderVoteWait(SolrXmlConfig.parseInt(name, value));
                    continue block25;
                }
                case "leaderConflictResolveWait": {
                    builder.setLeaderConflictResolveWait(SolrXmlConfig.parseInt(name, value));
                    continue block25;
                }
                case "zkClientTimeout": {
                    builder.setZkClientTimeout(SolrXmlConfig.parseInt(name, value));
                    continue block25;
                }
                case "autoReplicaFailoverBadNodeExpiration": {
                    builder.setAutoReplicaFailoverBadNodeExpiration(SolrXmlConfig.parseInt(name, value));
                    continue block25;
                }
                case "autoReplicaFailoverWaitAfterExpiration": {
                    builder.setAutoReplicaFailoverWaitAfterExpiration(SolrXmlConfig.parseInt(name, value));
                    continue block25;
                }
                case "autoReplicaFailoverWorkLoopDelay": {
                    builder.setAutoReplicaFailoverWorkLoopDelay(SolrXmlConfig.parseInt(name, value));
                    continue block25;
                }
                case "zkHost": {
                    builder.setZkHost(value);
                    continue block25;
                }
                case "genericCoreNodeNames": {
                    builder.setUseGenericCoreNames(Boolean.parseBoolean(value));
                    continue block25;
                }
                case "zkACLProvider": {
                    builder.setZkACLProviderClass(value);
                    continue block25;
                }
                case "zkCredientialsProvider": 
                case "zkCredentialsProvider": {
                    builder.setZkCredentialsProviderClass(value);
                    continue block25;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown configuration parameter in <solrcloud> section of solr.xml: " + name);
        }
        return builder.build();
    }

    private static LogWatcherConfig loadLogWatcherConfig(Config config, String loggingPath, String watcherPath) {
        String value;
        String name;
        String loggingClass = null;
        boolean enabled = true;
        int watcherQueueSize = 50;
        String watcherThreshold = null;
        block16: for (Map.Entry entry : SolrXmlConfig.readNodeListAsNamedList(config, loggingPath, "<logging>")) {
            name = (String)entry.getKey();
            value = entry.getValue().toString();
            switch (name) {
                case "class": {
                    loggingClass = value;
                    continue block16;
                }
                case "enabled": {
                    enabled = Boolean.parseBoolean(value);
                    continue block16;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown value in logwatcher config: " + name);
        }
        block17: for (Map.Entry entry : SolrXmlConfig.readNodeListAsNamedList(config, watcherPath, "<watcher>")) {
            name = (String)entry.getKey();
            value = entry.getValue().toString();
            switch (name) {
                case "size": {
                    watcherQueueSize = SolrXmlConfig.parseInt(name, value);
                    continue block17;
                }
                case "threshold": {
                    watcherThreshold = value;
                    continue block17;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown value in logwatcher config: " + name);
        }
        return new LogWatcherConfig(enabled, loggingClass, watcherThreshold, watcherQueueSize);
    }

    private static PluginInfo getShardHandlerFactoryPluginInfo(Config config) {
        Node node = config.getNode("solr/shardHandlerFactory", false);
        return node == null ? null : new PluginInfo(node, "shardHandlerFactory", false, true);
    }
}

