/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.solr.cloud.CloudConfigSetService;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetProperties;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigSetService {
    protected final SolrResourceLoader parentLoader;

    public static ConfigSetService createConfigSetService(NodeConfig nodeConfig, SolrResourceLoader loader, ZkController zkController) {
        if (zkController != null) {
            return new CloudConfigSetService(loader, zkController);
        }
        if (nodeConfig.hasSchemaCache()) {
            return new SchemaCaching(loader, nodeConfig.getConfigSetBaseDirectory());
        }
        return new Default(loader, nodeConfig.getConfigSetBaseDirectory());
    }

    public ConfigSetService(SolrResourceLoader loader) {
        this.parentLoader = loader;
    }

    public final ConfigSet getConfig(CoreDescriptor dcore) {
        SolrResourceLoader coreLoader = this.createCoreResourceLoader(dcore);
        try {
            SolrConfig solrConfig = this.createSolrConfig(dcore, coreLoader);
            IndexSchema schema = this.createIndexSchema(dcore, solrConfig);
            NamedList properties = this.createConfigSetProperties(dcore, coreLoader);
            return new ConfigSet(this.configName(dcore), solrConfig, schema, properties);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load conf for core " + dcore.getName() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected SolrConfig createSolrConfig(CoreDescriptor cd, SolrResourceLoader loader) {
        return SolrConfig.readFromResourceLoader(loader, cd.getConfigName());
    }

    protected IndexSchema createIndexSchema(CoreDescriptor cd, SolrConfig solrConfig) {
        return IndexSchemaFactory.buildIndexSchema(cd.getSchemaName(), solrConfig);
    }

    protected NamedList createConfigSetProperties(CoreDescriptor cd, SolrResourceLoader loader) {
        return ConfigSetProperties.readFromResourceLoader(loader, cd.getConfigSetPropertiesName());
    }

    protected abstract SolrResourceLoader createCoreResourceLoader(CoreDescriptor var1);

    public abstract String configName(CoreDescriptor var1);

    public static class SchemaCaching
    extends Default {
        private static final Logger logger = LoggerFactory.getLogger(SchemaCaching.class);
        private final Cache<String, IndexSchema> schemaCache = CacheBuilder.newBuilder().build();
        public static final DateTimeFormatter cacheKeyFormatter = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");

        public SchemaCaching(SolrResourceLoader loader, String configSetBase) {
            super(loader, configSetBase);
        }

        public static String cacheName(File schemaFile) {
            return String.format(Locale.ROOT, "%s:%s", schemaFile.getAbsolutePath(), cacheKeyFormatter.print(schemaFile.lastModified()));
        }

        @Override
        public IndexSchema createIndexSchema(final CoreDescriptor cd, final SolrConfig solrConfig) {
            String resourceNameToBeUsed = IndexSchemaFactory.getResourceNameToBeUsed(cd.getSchemaName(), solrConfig);
            File schemaFile = new File(resourceNameToBeUsed);
            if (!schemaFile.isAbsolute()) {
                schemaFile = new File(solrConfig.getResourceLoader().getConfigDir(), schemaFile.getPath());
            }
            if (schemaFile.exists()) {
                try {
                    return (IndexSchema)this.schemaCache.get((Object)SchemaCaching.cacheName(schemaFile), (Callable)new Callable<IndexSchema>(){

                        @Override
                        public IndexSchema call() throws Exception {
                            logger.info("Creating new index schema for core {}", (Object)cd.getName());
                            return IndexSchemaFactory.buildIndexSchema(cd.getSchemaName(), solrConfig);
                        }
                    });
                }
                catch (ExecutionException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating index schema for core " + cd.getName(), (Throwable)e);
                }
            }
            return IndexSchemaFactory.buildIndexSchema(cd.getSchemaName(), solrConfig);
        }
    }

    public static class Default
    extends ConfigSetService {
        private final File configSetBase;

        public Default(SolrResourceLoader loader, String configSetBase) {
            super(loader);
            this.configSetBase = this.resolveBaseDirectory(loader, configSetBase);
        }

        private File resolveBaseDirectory(SolrResourceLoader loader, String configSetBase) {
            File csBase = new File(configSetBase);
            if (!csBase.isAbsolute()) {
                csBase = new File(loader.getInstanceDir(), configSetBase);
            }
            return csBase;
        }

        File getConfigSetBase() {
            return this.configSetBase;
        }

        @Override
        public SolrResourceLoader createCoreResourceLoader(CoreDescriptor cd) {
            String instanceDir = this.locateInstanceDir(cd);
            return new SolrResourceLoader(instanceDir, this.parentLoader.getClassLoader(), cd.getSubstitutableProperties());
        }

        @Override
        public String configName(CoreDescriptor cd) {
            return (cd.getConfigSet() == null ? "instancedir " : "configset ") + this.locateInstanceDir(cd);
        }

        protected String locateInstanceDir(CoreDescriptor cd) {
            String configSet = cd.getConfigSet();
            if (configSet == null) {
                return cd.getInstanceDir();
            }
            File configSetDirectory = new File(this.configSetBase, configSet);
            if (!configSetDirectory.exists() || !configSetDirectory.isDirectory()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load configuration from directory " + configSetDirectory.getAbsolutePath());
            }
            return configSetDirectory.getAbsolutePath();
        }
    }
}

