/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.RetryUtil;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShardLeaderElectionContextBase
extends ElectionContext {
    private static Logger log = LoggerFactory.getLogger(ShardLeaderElectionContextBase.class);
    protected final SolrZkClient zkClient;
    protected String shardId;
    protected String collection;
    protected LeaderElector leaderElector;

    public ShardLeaderElectionContextBase(LeaderElector leaderElector, String shardId, String collection, String coreNodeName, ZkNodeProps props, ZkStateReader zkStateReader) {
        super(coreNodeName, "/collections/" + collection + "/leader_elect/" + shardId, ZkStateReader.getShardLeadersPath((String)collection, (String)shardId), props, zkStateReader.getZkClient());
        this.leaderElector = leaderElector;
        this.zkClient = zkStateReader.getZkClient();
        this.shardId = shardId;
        this.collection = collection;
        try {
            new ZkCmdExecutor(zkStateReader.getZkClient().getZkClientTimeout()).ensureExists("/collections/" + collection, this.zkClient);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    void runLeaderProcess(boolean weAreReplacement, int pauseBeforeStartMs) throws KeeperException, InterruptedException, IOException {
        try {
            RetryUtil.retryOnThrowable(KeeperException.NodeExistsException.class, (long)15000L, (long)1000L, (RetryUtil.RetryCmd)new RetryUtil.RetryCmd(){

                public void execute() throws Throwable {
                    ShardLeaderElectionContextBase.this.zkClient.makePath(ShardLeaderElectionContextBase.this.leaderPath, Utils.toJSON((Object)ShardLeaderElectionContextBase.this.leaderProps), CreateMode.EPHEMERAL, true);
                }
            });
        }
        catch (Throwable t) {
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not register as the leader because creating the ephemeral registration node in ZooKeeper failed", t);
        }
        assert (this.shardId != null);
        ZkNodeProps m = ZkNodeProps.fromKeyVals((Object[])new Object[]{"operation", OverseerAction.LEADER.toLower(), "shard", this.shardId, "collection", this.collection, "base_url", this.leaderProps.getProperties().get("base_url"), "core", this.leaderProps.getProperties().get("core"), "state", Replica.State.ACTIVE.toString()});
        Overseer.getInQueue(this.zkClient).offer(Utils.toJSON((Object)m));
    }
}

