/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util.valuesource;

import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.analytics.util.valuesource.SingleDoubleFunction;

public class NegateDoubleFunction
extends SingleDoubleFunction {
    public static final String NAME = "neg";

    public NegateDoubleFunction(ValueSource source) {
        super(source);
    }

    @Override
    protected String name() {
        return NAME;
    }

    @Override
    public String description() {
        return this.name() + "(" + this.source.description() + ")";
    }

    @Override
    protected double func(int doc, FunctionValues vals) {
        return vals.doubleVal(doc) * -1.0;
    }

    @Override
    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NegateDoubleFunction other = (NegateDoubleFunction)((Object)o);
        return this.source.equals((Object)other.source);
    }
}

