/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util.valuesource;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.solr.util.DateFormatUtil;

public class FilterFieldSource
extends ValueSource {
    public static final String NAME = "filter";
    public final Object missValue;
    protected final ValueSource source;

    public FilterFieldSource(ValueSource source, Object missValue) {
        this.source = source;
        this.missValue = missValue;
    }

    protected String name() {
        return NAME;
    }

    public String description() {
        if (this.missValue.getClass().equals(Date.class)) {
            return this.name() + "(" + this.source.description() + "," + DateFormatUtil.formatExternal((Date)((Date)this.missValue)) + ")";
        }
        return this.name() + "(" + this.source.description() + "," + this.missValue.toString() + ")";
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues vals = this.source.getValues(context, readerContext);
        return new FunctionValues(){

            public byte byteVal(int doc) {
                return vals.byteVal(doc);
            }

            public short shortVal(int doc) {
                return vals.shortVal(doc);
            }

            public float floatVal(int doc) {
                return vals.floatVal(doc);
            }

            public int intVal(int doc) {
                return vals.intVal(doc);
            }

            public long longVal(int doc) {
                return vals.longVal(doc);
            }

            public double doubleVal(int doc) {
                return vals.doubleVal(doc);
            }

            public String strVal(int doc) {
                return vals.strVal(doc);
            }

            public Object objectVal(int doc) {
                return this.exists(doc) ? vals.objectVal(doc) : null;
            }

            public boolean exists(int doc) {
                Object other = vals.objectVal(doc);
                return other != null && !FilterFieldSource.this.missValue.equals(other);
            }

            public String toString(int doc) {
                return "filter(" + vals.toString(doc) + ')';
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final FunctionValues.ValueFiller delegateFiller;
                    private final MutableValue mval;
                    {
                        this.delegateFiller = vals.getValueFiller();
                        this.mval = this.delegateFiller.getValue();
                    }

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) {
                        this.delegateFiller.fillValue(doc);
                        this.mval.exists = this.exists(doc);
                    }
                };
            }
        };
    }

    public ValueSource getRootSource() {
        if (this.source instanceof FilterFieldSource) {
            return ((FilterFieldSource)this.source).getRootSource();
        }
        return this.source;
    }

    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FilterFieldSource other = (FilterFieldSource)((Object)o);
        return this.source.equals((Object)other.source) && this.missValue.equals(other.missValue);
    }

    public int hashCode() {
        return this.source.hashCode() + this.name().hashCode();
    }
}

