/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.statistics;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.analytics.statistics.AbstractDelegatingStatsCollector;
import org.apache.solr.analytics.statistics.StatsCollector;
import org.apache.solr.analytics.util.MedianCalculator;

public class MedianStatsCollector
extends AbstractDelegatingStatsCollector {
    private final List<Double> values = new ArrayList<Double>();
    protected double median;

    public MedianStatsCollector(StatsCollector delegate) {
        super(delegate);
    }

    public Double getMedian() {
        return new Double(MedianCalculator.getMedian(this.values));
    }

    @Override
    public Comparable getStat(String stat) {
        if (stat.equals("median")) {
            return new Double(this.median);
        }
        return this.delegate.getStat(stat);
    }

    @Override
    public void compute() {
        this.delegate.compute();
        this.median = this.getMedian();
    }

    @Override
    public void collect(int doc) {
        super.collect(doc);
        if (this.value.exists) {
            this.values.add(this.function.doubleVal(doc));
        }
    }
}

