/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.request;

import java.util.Arrays;
import java.util.EnumSet;
import org.apache.solr.analytics.request.AbstractFieldFacetRequest;
import org.apache.solr.analytics.util.AnalyticsParams;
import org.apache.solr.common.params.FacetParams;
import org.apache.solr.schema.SchemaField;

public class RangeFacetRequest
extends AbstractFieldFacetRequest {
    protected String start;
    protected String end;
    protected String[] gaps;
    protected boolean hardEnd = false;
    protected EnumSet<FacetParams.FacetRangeInclude> include;
    protected boolean includeCalled = false;
    protected EnumSet<FacetParams.FacetRangeOther> others;
    protected boolean othersCalled = false;

    public RangeFacetRequest(SchemaField field) {
        super(field);
        this.include = EnumSet.of(AnalyticsParams.DEFAULT_INCLUDE);
        this.others = EnumSet.of(AnalyticsParams.DEFAULT_OTHER);
    }

    public RangeFacetRequest(SchemaField field, String start, String end, String[] gaps) {
        super(field);
        this.start = start;
        this.end = end;
        this.gaps = gaps;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public EnumSet<FacetParams.FacetRangeInclude> getInclude() {
        return this.include;
    }

    public void setInclude(EnumSet<FacetParams.FacetRangeInclude> include) {
        this.includeCalled = true;
        this.include = include;
    }

    public void addInclude(FacetParams.FacetRangeInclude include) {
        if (this.includeCalled) {
            this.include.add(include);
        } else {
            this.includeCalled = true;
            this.include = EnumSet.of(include);
        }
    }

    public String[] getGaps() {
        return this.gaps;
    }

    public void setGaps(String[] gaps) {
        this.gaps = gaps;
    }

    public boolean isHardEnd() {
        return this.hardEnd;
    }

    public void setHardEnd(boolean hardEnd) {
        this.hardEnd = hardEnd;
    }

    public EnumSet<FacetParams.FacetRangeOther> getOthers() {
        return this.others;
    }

    public void setOthers(EnumSet<FacetParams.FacetRangeOther> others) {
        this.othersCalled = true;
        this.others = others;
    }

    public void addOther(FacetParams.FacetRangeOther other) {
        if (this.othersCalled) {
            this.others.add(other);
        } else {
            this.othersCalled = true;
            this.others = EnumSet.of(other);
        }
    }

    public String toString() {
        return "<RangeFacetRequest field=" + this.field.getName() + " start=" + this.start + ", end=" + this.end + ", gap=" + Arrays.toString(this.gaps) + ", hardEnd=" + this.hardEnd + ", include=" + this.include + ", others=" + this.others + ">";
    }
}

