/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.expression;

import java.text.ParseException;
import java.util.ArrayList;
import org.apache.solr.analytics.expression.AbsoluteValueExpression;
import org.apache.solr.analytics.expression.AddExpression;
import org.apache.solr.analytics.expression.BaseExpression;
import org.apache.solr.analytics.expression.ConcatenateExpression;
import org.apache.solr.analytics.expression.ConstantDateExpression;
import org.apache.solr.analytics.expression.ConstantNumberExpression;
import org.apache.solr.analytics.expression.ConstantStringExpression;
import org.apache.solr.analytics.expression.DateMathExpression;
import org.apache.solr.analytics.expression.DivideExpression;
import org.apache.solr.analytics.expression.Expression;
import org.apache.solr.analytics.expression.LogExpression;
import org.apache.solr.analytics.expression.MultiplyExpression;
import org.apache.solr.analytics.expression.NegateExpression;
import org.apache.solr.analytics.expression.PowerExpression;
import org.apache.solr.analytics.expression.ReverseExpression;
import org.apache.solr.analytics.statistics.StatsCollector;
import org.apache.solr.analytics.util.AnalyticsParams;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.DateFormatUtil;

public class ExpressionFactory {
    public static Expression create(String expression, StatsCollector[] statsCollectors) {
        String operands;
        int paren = expression.indexOf(40);
        if (paren <= 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The expression [" + expression + "] has no arguments and is not supported.");
        }
        String topOperation = expression.substring(0, paren).trim();
        try {
            operands = expression.substring(paren + 1, expression.lastIndexOf(41)).trim();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing closing parenthesis in [" + expression + "]", (Throwable)e);
        }
        if (AnalyticsParams.ALL_STAT_SET.contains(topOperation)) {
            if (topOperation.equals("percentile")) {
                operands = expression.substring(expression.indexOf(44) + 1, expression.lastIndexOf(41)).trim();
                topOperation = topOperation + "_" + expression.substring(expression.indexOf(40) + 1, expression.indexOf(44)).trim();
            }
            StatsCollector collector = null;
            for (StatsCollector c : statsCollectors) {
                if (!c.valueSourceString().equals(operands)) continue;
                collector = c;
                break;
            }
            if (collector == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ValueSource [" + operands + "] in Expression [" + expression + "] not found.");
            }
            return new BaseExpression(collector, topOperation);
        }
        if (topOperation.equals("const_num")) {
            try {
                return new ConstantNumberExpression(Double.parseDouble(operands));
            }
            catch (NumberFormatException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The constant " + operands + " cannot be converted into a number.", (Throwable)e);
            }
        }
        if (topOperation.equals("const_date")) {
            try {
                return new ConstantDateExpression(DateFormatUtil.parseDate((String)operands));
            }
            catch (ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The constant " + operands + " cannot be converted into a date.", (Throwable)e);
            }
        }
        if (topOperation.equals("const_str")) {
            operands = expression.substring(paren + 1, expression.lastIndexOf(41));
            return new ConstantStringExpression(operands);
        }
        String[] arguments = ExpressionFactory.getArguments(operands);
        Expression[] expArgs = new Expression[arguments.length];
        for (int count = 0; count < arguments.length; ++count) {
            expArgs[count] = ExpressionFactory.create(arguments[count], statsCollectors);
        }
        if (expArgs.length == 1) {
            if (topOperation.equals("neg")) {
                return new NegateExpression(expArgs[0]);
            }
            if (topOperation.equals("abs")) {
                return new AbsoluteValueExpression(expArgs[0]);
            }
            if (topOperation.equals("rev")) {
                return new ReverseExpression(expArgs[0]);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, topOperation + " does not have the correct number of arguments.");
        }
        if (topOperation.equals("add")) {
            return new AddExpression(expArgs);
        }
        if (topOperation.equals("mult")) {
            return new MultiplyExpression(expArgs);
        }
        if (topOperation.equals("date_math")) {
            return new DateMathExpression(expArgs);
        }
        if (topOperation.equals("concat")) {
            return new ConcatenateExpression(expArgs);
        }
        if (expArgs.length == 2 && (topOperation.equals("div") || topOperation.equals("pow") || topOperation.equals("log"))) {
            if (topOperation.equals("div")) {
                return new DivideExpression(expArgs[0], expArgs[1]);
            }
            if (topOperation.equals("pow")) {
                return new PowerExpression(expArgs[0], expArgs[1]);
            }
            if (topOperation.equals("log")) {
                return new LogExpression(expArgs[0], expArgs[1]);
            }
            return null;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, topOperation + " does not have the correct number of arguments or is unsupported.");
    }

    public static String[] getArguments(String expression) {
        String[] strings = new String[1];
        int stack = 0;
        int start = 0;
        ArrayList<String> arguments = new ArrayList<String>();
        char[] chars = expression.toCharArray();
        for (int count = 0; count < expression.length(); ++count) {
            char c = chars[count];
            if (c == ',' && stack == 0) {
                arguments.add(expression.substring(start, count).replace("\\(", "(").replace("\\)", ")").replace("\\,", ",").trim());
                start = count + 1;
                continue;
            }
            if (c == '(') {
                ++stack;
                continue;
            }
            if (c == ')') {
                --stack;
                continue;
            }
            if (c != '\\') continue;
        }
        if (stack == 0) {
            arguments.add(expression.substring(start).trim());
        }
        return arguments.toArray(strings);
    }
}

