/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.avro;

import com.typesafe.config.Config;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.avro.FastGenericDatumReader;
import org.kitesdk.morphline.avro.ReadAvroContainerBuilder;

public final class ReadAvroBuilder
implements CommandBuilder {
    public static final String AVRO_MEMORY_MIME_TYPE = "avro/java+memory";

    public Collection<String> getNames() {
        return Collections.singletonList("readAvro");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadAvro(this, config, parent, child, context);
    }

    static final class ReadAvro
    extends ReadAvroContainerBuilder.ReadAvroContainer {
        private final Schema writerSchema;
        private final boolean isJson;
        private BinaryDecoder binaryDecoder = null;
        private JsonDecoder jsonDecoder = null;

        public ReadAvro(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            String schemaString = this.getConfigs().getString(config, "writerSchemaString", null);
            if (schemaString != null) {
                this.writerSchema = new Schema.Parser().parse(schemaString);
            } else {
                String schemaFile = this.getConfigs().getString(config, "writerSchemaFile", null);
                if (schemaFile != null) {
                    try {
                        this.writerSchema = new Schema.Parser().parse(new File(schemaFile));
                    }
                    catch (IOException e) {
                        throw new MorphlineCompilationException("Cannot parse external Avro writer schema file: " + schemaFile, config, (Throwable)e);
                    }
                } else {
                    this.writerSchema = null;
                }
            }
            this.isJson = this.getConfigs().getBoolean(config, "isJson", false);
            this.validateArguments();
        }

        protected void validateArguments() {
            super.validateArguments();
            if (this.writerSchema == null) {
                throw new MorphlineCompilationException("You must specify an external Avro writer schema because this is required to read containerless Avro", this.getConfig());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean doProcess(Record inputRecord, InputStream in) throws IOException {
            Record template = inputRecord.copy();
            ReadAvro.removeAttachments((Record)template);
            template.put("_attachment_mimetype", (Object)ReadAvroBuilder.AVRO_MEMORY_MIME_TYPE);
            Decoder decoder = this.prepare(in);
            try {
                while (true) {
                    GenericContainer datum;
                    if (!this.extract(datum = (GenericContainer)this.datumReader.read(null, decoder), template)) {
                        boolean bl = false;
                        return bl;
                    }
                    continue;
                    break;
                }
            }
            catch (EOFException eOFException) {
                return true;
            }
            finally {
                in.close();
            }
        }

        private Decoder prepare(InputStream in) throws IOException {
            BinaryDecoder decoder;
            if (this.isJson) {
                if (this.jsonDecoder == null) {
                    this.jsonDecoder = DecoderFactory.get().jsonDecoder(this.writerSchema, in);
                } else {
                    this.jsonDecoder.configure(in);
                }
                decoder = this.jsonDecoder;
            } else {
                decoder = this.binaryDecoder = DecoderFactory.get().binaryDecoder(in, this.binaryDecoder);
            }
            if (this.datumReader == null) {
                Schema readSchema = this.readerSchema != null ? this.readerSchema : this.writerSchema;
                this.datumReader = new FastGenericDatumReader(this.writerSchema, readSchema);
                this.datumReader.setResolver(this.createResolver(this.writerSchema, readSchema));
            }
            return decoder;
        }
    }
}

