/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.helper;

import java.io.PrintWriter;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.argparse4j.helper.TextWidthCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextHelper {
    public static final String LINESEP = System.getProperty("line.separator");

    private TextHelper() {
    }

    public static <T> String concat(T[] a, int offset, String sep, String start, String end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        if (a.length - offset > 0) {
            sb.append(a[offset]);
            int len = a.length;
            for (int i = offset + 1; i < len; ++i) {
                sb.append(sep).append(a[i]);
            }
        }
        sb.append(end);
        return sb.toString();
    }

    public static <T> String concat(T[] a, int offset, String sep) {
        return TextHelper.concat(a, offset, sep, "", "");
    }

    public static <T> String concat(Collection<T> a, int offset, String sep, String start, String end) {
        StringBuilder sb = new StringBuilder();
        sb.append(start);
        Iterator<T> it = a.iterator();
        while (offset > 0 && it.hasNext()) {
            --offset;
            it.next();
        }
        if (offset == 0 && it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(sep).append(it.next());
            }
        }
        sb.append(end);
        return sb.toString();
    }

    public static <T> String concat(Collection<T> a, int offset, String sep) {
        return TextHelper.concat(a, offset, sep, "", "");
    }

    public static String wrap(TextWidthCounter textWidthCounter, String s, int width, int initialOffset, String initialIndent, String subsequentIndent) {
        BreakIterator iter = BreakIterator.getLineInstance();
        iter.setText(s);
        StringBuilder res = new StringBuilder(initialIndent);
        StringBuilder sb = new StringBuilder();
        int currentWidth = initialOffset + initialIndent.length();
        int start = iter.first();
        int end = iter.next();
        while (end != -1) {
            String sub = s.substring(start, end);
            int subwidth = textWidthCounter.width(sub);
            if ((currentWidth += subwidth) > width) {
                res.append((CharSequence)TextHelper.adjustSpace(sb, width, currentWidth - subwidth)).append(LINESEP).append(subsequentIndent);
                sb.delete(0, sb.length());
                currentWidth = subsequentIndent.length() + subwidth;
            }
            sb.append(sub);
            if (sub.endsWith(LINESEP) || sub.endsWith("\n")) {
                res.append((CharSequence)sb).append(subsequentIndent);
                sb.delete(0, sb.length());
                currentWidth = subsequentIndent.length();
            }
            start = end;
            end = iter.next();
        }
        res.append((CharSequence)sb);
        return res.toString();
    }

    public static StringBuilder adjustSpace(StringBuilder sb, int width, int curwidth) {
        int i;
        int len;
        int origLen = len = sb.length();
        for (i = 0; i < len && sb.charAt(i) == ' '; ++i) {
        }
        sb.delete(0, i);
        len = sb.length();
        for (i = len - 1; i >= 0 && sb.charAt(i) == ' '; --i) {
        }
        sb.delete(i + 1, len);
        len = sb.length();
        curwidth -= origLen - len;
        int numWsBlock = 0;
        boolean cont = false;
        for (i = 0; i < len; ++i) {
            if (sb.charAt(i) == ' ') {
                if (cont) continue;
                cont = true;
                ++numWsBlock;
                continue;
            }
            cont = false;
        }
        if (numWsBlock == 0) {
            return sb;
        }
        int needWs = width - curwidth;
        int eachWs = needWs / numWsBlock;
        int rem = needWs % numWsBlock;
        int remStart = (numWsBlock - rem + 1) / 2;
        int remEnd = remStart + rem;
        cont = false;
        int b = 0;
        for (i = 0; i < len; ++i) {
            if (sb.charAt(i) == ' ') {
                if (cont) continue;
                cont = true;
                int add = eachWs + (remStart <= b && b < remEnd ? 1 : 0);
                for (int j = 0; j < add; ++j) {
                    sb.insert(i, ' ');
                }
                len = sb.length();
                ++b;
                continue;
            }
            cont = false;
        }
        return sb;
    }

    public static void printHelp(PrintWriter writer, String title, String help, TextWidthCounter textWidthCounter, int width) {
        int INDENT_WIDTH = 25;
        writer.print("  ");
        writer.print(title);
        if (!help.isEmpty()) {
            int titleWidth = textWidthCounter.width(title);
            int indentWidth = INDENT_WIDTH;
            if (titleWidth <= 21) {
                indentWidth -= titleWidth + 2;
            } else {
                writer.println();
            }
            for (int i = 0; i < indentWidth; ++i) {
                writer.print(" ");
            }
            writer.println(TextHelper.wrap(textWidthCounter, help, width, INDENT_WIDTH, "", "                         "));
        } else {
            writer.println();
        }
    }

    public static String nonNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static List<String> findPrefix(Collection<String> src, String prefix) {
        ArrayList<String> res = new ArrayList<String>();
        for (String s : src) {
            if (!s.startsWith(prefix)) continue;
            res.add(s);
        }
        return res;
    }
}

