/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class AtomizingIterator
implements SequenceIterator {
    private SequenceIterator base;
    private AtomicSequence currentValue = null;
    private int currentValuePosition = 1;
    private int currentValueSize = 1;

    public AtomizingIterator(SequenceIterator base) {
        this.base = base;
    }

    public AtomicValue next() throws XPathException {
        block6: {
            Item nextSource;
            while (true) {
                if (this.currentValue != null) {
                    if (this.currentValuePosition < this.currentValueSize) {
                        return this.currentValue.itemAt(this.currentValuePosition++);
                    }
                    this.currentValue = null;
                }
                if ((nextSource = this.base.next()) == null) break block6;
                if (!(nextSource instanceof NodeInfo)) break;
                AtomicSequence v = ((NodeInfo)nextSource).atomize();
                if (v instanceof AtomicValue) {
                    return (AtomicValue)v;
                }
                this.currentValue = v;
                this.currentValuePosition = 0;
                this.currentValueSize = this.currentValue.getLength();
            }
            if (nextSource instanceof AtomicValue) {
                return (AtomicValue)nextSource;
            }
            if (nextSource instanceof ObjectValue) {
                return StringValue.makeStringValue(nextSource.getStringValue());
            }
            throw new XPathException("The typed value of a function item is not defined", "FOTY0013");
        }
        this.currentValue = null;
        return null;
    }

    public void close() {
        this.base.close();
    }

    public SequenceIterator getAnother() throws XPathException {
        return new AtomizingIterator(this.base.getAnother());
    }

    public int getProperties() {
        return 0;
    }
}

