/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class StylesheetFunctionLibrary
implements FunctionLibrary {
    private StylesheetPackage stylesheetPackage;
    private boolean overrideExtensionFunction;

    public StylesheetFunctionLibrary(StylesheetPackage sheet, boolean overrideExtensionFunction) {
        this.stylesheetPackage = sheet;
        this.overrideExtensionFunction = overrideExtensionFunction;
    }

    public boolean isOverrideExtensionFunction() {
        return this.overrideExtensionFunction;
    }

    public Expression bind(SymbolicName functionName, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        UserFunction fn = this.stylesheetPackage.getFunction(functionName);
        if (fn == null) {
            return null;
        }
        UserFunctionCall fc = new UserFunctionCall();
        fc.setFunctionName(functionName.getComponentName());
        fc.setArguments(staticArgs);
        fc.setContainer(container);
        return fc;
    }

    public boolean isAvailable(SymbolicName functionName) {
        return this.stylesheetPackage.getFunction(functionName) != null;
    }

    public FunctionLibrary copy() {
        return this;
    }
}

