/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.pattern.PatternParser;
import net.sf.saxon.sxpath.SimpleContainer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.PrependIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DecimalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pattern
implements PatternFinder,
Container {
    private double priority = 0.5;
    private String originalText;
    private PackageData packageData;
    private String systemId;
    private int lineNumber;

    public static Pattern make(String pattern, StaticContext env, PackageData packageData) throws XPathException {
        DecimalValue languageLevel = DecimalValue.TWO;
        if (packageData.isAllowXPath30() && env.getXPathLanguageLevel().equals(DecimalValue.THREE)) {
            languageLevel = DecimalValue.THREE;
        }
        PatternParser parser = (PatternParser)((Object)env.getConfiguration().newExpressionParser("PATTERN", false, languageLevel));
        ((XPathParser)((Object)parser)).setLanguage(1, env.getXPathLanguageLevel());
        SimpleContainer container = new SimpleContainer(packageData);
        container.setLocation(env.getSystemId(), env.getLineNumber());
        ((XPathParser)((Object)parser)).setDefaultContainer(container);
        Pattern pat = parser.parsePattern(pattern, env);
        pat.packageData = packageData;
        pat.setSystemId(env.getSystemId());
        pat.setLineNumber(env.getLineNumber());
        pat.setOriginalText(pattern);
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        pat = pat.simplify(visitor);
        return pat;
    }

    @Override
    public Configuration getConfiguration() {
        return this.packageData.getConfiguration();
    }

    @Override
    public PackageData getPackageData() {
        return this.packageData;
    }

    public void setPackageData(PackageData packageData) {
        this.packageData = packageData;
    }

    protected static void replaceCurrent(Expression exp, LocalBinding binding) {
        for (Operand o : exp.operands()) {
            Expression child = o.getExpression();
            if (child instanceof Current) {
                LocalVariableReference ref = new LocalVariableReference(binding);
                exp.replaceOperand(child, ref);
                continue;
            }
            Pattern.replaceCurrent(child, binding);
        }
    }

    public void bindCurrent(LocalBinding binding) {
    }

    public LocationProvider getLocationProvider() {
        return this.packageData.getLocationMap();
    }

    @Override
    public int getContainerGranularity() {
        return 1;
    }

    public void setOriginalText(String text) {
        this.originalText = text;
    }

    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Pattern analyze(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        return this;
    }

    public int getDependencies() {
        return 0;
    }

    public Iterator<Expression> iterateSubExpressions() {
        List list = Collections.emptyList();
        return list.iterator();
    }

    public int allocateSlots(SlotManager slotManager, int nextFree) {
        return nextFree;
    }

    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public boolean isMotionless(boolean allowExtensions) {
        return true;
    }

    public abstract boolean matches(Item var1, XPathContext var2) throws XPathException;

    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        return this.matches(node, context);
    }

    @Override
    public SequenceIterator selectNodes(DocumentInfo doc, final XPathContext context) throws XPathException {
        int kind = this.getNodeKind();
        switch (kind) {
            case 9: {
                if (this.matches(doc, context)) {
                    return SingletonIterator.makeIterator(doc);
                }
                return EmptyIterator.getInstance();
            }
            case 2: {
                AxisIterator allElements = doc.iterateAxis((byte)4, NodeKindTest.ELEMENT);
                MappingFunction<NodeInfo, NodeInfo> atts = new MappingFunction<NodeInfo, NodeInfo>(){

                    @Override
                    public SequenceIterator map(NodeInfo item) {
                        return item.iterateAxis((byte)2);
                    }
                };
                MappingIterator<NodeInfo, NodeInfo> allAttributes = new MappingIterator<NodeInfo, NodeInfo>(allElements, atts);
                ItemMappingFunction<NodeInfo, NodeInfo> test = new ItemMappingFunction<NodeInfo, NodeInfo>(){

                    @Override
                    public NodeInfo mapItem(NodeInfo item) throws XPathException {
                        if (Pattern.this.matches(item, context)) {
                            return item;
                        }
                        return null;
                    }
                };
                return new ItemMappingIterator<NodeInfo, NodeInfo>(allAttributes, test);
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                AxisIterator allChildren = doc.iterateAxis((byte)4, NodeKindTest.makeNodeKindTest(kind));
                ItemMappingFunction test = new ItemMappingFunction(){

                    public Item mapItem(Item item) throws XPathException {
                        if (Pattern.this.matches(item, context)) {
                            return item;
                        }
                        return null;
                    }
                };
                return new ItemMappingIterator(allChildren, test);
            }
            case 0: {
                AxisIterator allChildren = doc.iterateAxis((byte)4);
                MappingFunction<NodeInfo, NodeInfo> attsOrSelf = new MappingFunction<NodeInfo, NodeInfo>(){

                    @Override
                    public SequenceIterator map(NodeInfo item) {
                        return new PrependIterator(item, item.iterateAxis((byte)2));
                    }
                };
                MappingIterator<NodeInfo, NodeInfo> attributesOrSelf = new MappingIterator<NodeInfo, NodeInfo>(allChildren, attsOrSelf);
                ItemMappingFunction test = new ItemMappingFunction(){

                    public Item mapItem(Item item) throws XPathException {
                        if (Pattern.this.matches(item, context)) {
                            return item;
                        }
                        return null;
                    }
                };
                return new ItemMappingIterator(attributesOrSelf, test);
            }
            case 13: {
                throw new UnsupportedOperationException("Patterns can't match namespace nodes");
            }
        }
        throw new UnsupportedOperationException("Unknown node kind");
    }

    public int getNodeKind() {
        return 0;
    }

    public int getNodeKindMask() {
        return 9102;
    }

    public int getFingerprint() {
        return -1;
    }

    public abstract ItemType getItemType();

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public double getDefaultPriority() {
        return this.priority;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    public String toString() {
        if (this.originalText != null) {
            return this.originalText;
        }
        return "pattern matching " + this.getItemType().toString();
    }

    @Override
    public int getHostLanguage() {
        return 50;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        throw new IllegalArgumentException("Invalid replacement");
    }

    public Pattern convertToTypedPattern(String val) throws XPathException {
        return null;
    }
}

