/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class PowFn
extends ExtensionFunctionDefinition {
    public static String NAMESPACE = "http://www.w3.org/2005/xpath-functions/math";
    private static StructuredQName POW = new StructuredQName("math", NAMESPACE, "pow");

    public StructuredQName getFunctionQName() {
        return POW;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public boolean trustResultType() {
        return true;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_DOUBLE, SequenceType.SINGLE_DOUBLE};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.OPTIONAL_DOUBLE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            @Override
            public ZeroOrOne<DoubleValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
                DoubleValue result;
                DoubleValue x = (DoubleValue)arguments[0].head();
                if (x == null) {
                    result = null;
                } else {
                    double dx = x.getDoubleValue();
                    if (dx == 1.0) {
                        result = x;
                    } else {
                        NumericValue y = (NumericValue)arguments[1].head();
                        assert (y != null);
                        double dy = y.getDoubleValue();
                        result = dx == -1.0 && Double.isInfinite(dy) ? new DoubleValue(1.0) : new DoubleValue(Math.pow(dx, dy));
                    }
                }
                return new ZeroOrOne<Object>(result);
            }
        };
    }
}

