/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.SequenceType;

public class Atan2Fn
extends ExtensionFunctionDefinition {
    public static String NAMESPACE = "http://www.w3.org/2005/xpath-functions/math";
    private static StructuredQName ATAN2 = new StructuredQName("math", NAMESPACE, "atan2");

    public StructuredQName getFunctionQName() {
        return ATAN2;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public boolean trustResultType() {
        return true;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_DOUBLE, SequenceType.SINGLE_DOUBLE};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_DOUBLE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public DoubleValue call(XPathContext context, Sequence[] arguments) throws XPathException {
                DoubleValue y = (DoubleValue)arguments[0].head();
                assert (y != null);
                DoubleValue x = (DoubleValue)arguments[1].head();
                assert (x != null);
                double result = Math.atan2(y.getDoubleValue(), x.getDoubleValue());
                return new DoubleValue(result);
            }
        };
    }
}

