/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.ByteCharProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractByteCharMap
extends AbstractSet {
    public boolean containsKey(final byte key) {
        return !this.forEachKey(new ByteProcedure(){

            public boolean apply(byte iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final char value) {
        return !this.forEachPair(new ByteCharProcedure(){

            public boolean apply(byte iterKey, char iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractByteCharMap copy() {
        return (AbstractByteCharMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractByteCharMap)) {
            return false;
        }
        final AbstractByteCharMap other = (AbstractByteCharMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ByteCharProcedure(){

            public boolean apply(byte key, char value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ByteCharProcedure(){

            public boolean apply(byte key, char value) {
                return AbstractByteCharMap.this.containsKey(key) && AbstractByteCharMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(ByteProcedure var1);

    public boolean forEachPair(final ByteCharProcedure procedure) {
        return this.forEachKey(new ByteProcedure(){

            public boolean apply(byte key) {
                return procedure.apply(key, AbstractByteCharMap.this.get(key));
            }
        });
    }

    public abstract char get(byte var1);

    public ByteArrayList keys() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new ByteProcedure(){

            public boolean apply(byte key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(ByteArrayList keyList) {
        this.pairsSortedByValue(keyList, new CharArrayList(this.size()));
    }

    public void pairsMatching(final ByteCharProcedure condition, final ByteArrayList keyList, final CharArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ByteCharProcedure(){

            public boolean apply(byte key, char value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(ByteArrayList keyList, CharArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(ByteArrayList keyList, CharArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final byte[] k = keyList.elements();
        final char[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                char t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                byte t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(byte var1, char var2);

    public abstract boolean removeKey(byte var1);

    public String toString() {
        ByteArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            byte key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ByteArrayList theKeys = new ByteArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            byte key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public CharArrayList values() {
        CharArrayList list = new CharArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final CharArrayList list) {
        list.clear();
        this.forEachKey(new ByteProcedure(){

            public boolean apply(byte key) {
                list.add(AbstractByteCharMap.this.get(key));
                return true;
            }
        });
    }

    public char adjustOrPutValue(byte key, char newValue, char incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (char)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

