/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Private
public class FsPermissionExtension
extends FsPermission {
    private static final short ACL_BIT = 4096;
    private static final short ENCRYPTED_BIT = 8192;
    private final boolean aclBit;
    private final boolean encryptedBit;

    public FsPermissionExtension(FsPermission perm, boolean hasAcl, boolean isEncrypted) {
        super(perm.toShort());
        this.aclBit = hasAcl;
        this.encryptedBit = isEncrypted;
    }

    public FsPermissionExtension(short perm) {
        super(perm);
        this.aclBit = (perm & 0x1000) != 0;
        this.encryptedBit = (perm & 0x2000) != 0;
    }

    public short toExtendedShort() {
        return (short)(this.toShort() | (this.aclBit ? 4096 : 0) | (this.encryptedBit ? 8192 : 0));
    }

    public boolean getAclBit() {
        return this.aclBit;
    }

    public boolean getEncryptedBit() {
        return this.encryptedBit;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

