/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.MS949CharToByteConverter;
import java.sql.SQLException;

public class MS949Encoder
implements CharsetEncoder {
    private MS949CharToByteConverter conv = new MS949CharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    @Override
    public int charsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return this.conv.convCharArr(cArray, n, n + n2, byArray, n3, n3 + n4);
    }

    @Override
    public int charsToFixedBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5 = n3;
        for (int i = n; i < n + n2; ++i) {
            if (cArray[i] < '\u0080') {
                byArray[n5++] = 0;
                byArray[n5++] = (byte)cArray[i];
                continue;
            }
            int n6 = this.conv.convCharArr(cArray, i, i + 1, byArray, n5, n5 + this.maxBytesPerChar);
            if (n6 == 0) {
                byArray[n5] = 0;
                byArray[n5 + 1] = 0;
            } else if (n6 == 1) {
                byArray[n5 + 1] = byArray[n5];
                byArray[n5] = 0;
            }
            n5 += this.maxBytesPerChar;
        }
        return n5 - n3;
    }

    @Override
    public int getEndingBytePos(byte[] byArray, int n) {
        if (this.isEndingByte(byArray, n)) {
            return n;
        }
        return n + 1;
    }

    @Override
    public int getLeadingBytePos(byte[] byArray, int n) {
        if (this.isLeadingByte(byArray, n)) {
            return n;
        }
        return n - 1;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    @Override
    public boolean isEndingByte(byte[] byArray, int n) {
        if (byArray[n] >= 0) {
            return true;
        }
        return !this.isLeadingByte(byArray, n);
    }

    @Override
    public boolean isLeadingByte(byte[] byArray, int n) {
        int n2;
        for (n2 = n; n2 >= 0 && byArray[n2] < 0; --n2) {
        }
        return n2 == n || (n - n2) % 2 == 1;
    }

    @Override
    public byte[] stringToBytes(String string) throws SQLException {
        byte[] byArray = new byte[string.length() * this.getMaxBytesPerChar()];
        int n = this.conv.convString(string, 0, string.length(), byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    @Override
    public int stringToBytes(byte[] byArray, int n, String string) throws SQLException {
        return this.conv.convString(string, 0, string.length(), byArray, n, byArray.length);
    }
}

