/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbStreamDataReader {
    private StreamBuffer buf;
    private int curReadOffset;
    private DataTypeConverter typeConverter = null;

    public TbStreamDataReader(StreamBuffer streamBuffer, DataTypeConverter dataTypeConverter) {
        this.typeConverter = dataTypeConverter;
        this.initialize(streamBuffer);
    }

    public int getBufferedDataSize() {
        if (this.buf != null) {
            return this.buf.getCurDataSize();
        }
        return 0;
    }

    public int getCurOffset() {
        return this.curReadOffset;
    }

    public void initialize(StreamBuffer streamBuffer) {
        this.buf = streamBuffer;
        this.curReadOffset = 0;
    }

    private void isBufferAvailable(int n) throws SQLException {
        if (this.buf == null || this.buf.getCurDataSize() <= 0 || this.buf.getCurDataSize() <= this.curReadOffset || this.buf.getCurDataSize() < this.curReadOffset + n) {
            throw TbError.newSQLException(-590730);
        }
    }

    public void moveReadOffset(int n) {
        this.curReadOffset += n;
    }

    public void readBytes(byte[] byArray, int n, int n2) throws SQLException {
        this.isBufferAvailable(n2);
        System.arraycopy(this.buf.getRawBytes(), this.curReadOffset, byArray, n, n2);
        this.moveReadOffset(n2);
    }

    public String readDBDecodedString(int n) throws SQLException {
        this.isBufferAvailable(n);
        String string = null;
        if (n > 0) {
            string = this.typeConverter.getDBDecodedString(this.buf.getRawBytes(), this.curReadOffset, n);
            this.moveReadOffset(n);
        }
        return string;
    }

    public String readDBDecodedPadString(int n) throws SQLException {
        this.isBufferAvailable(n);
        String string = null;
        if (n > 0) {
            string = this.typeConverter.getDBDecodedString(this.buf.getRawBytes(), this.curReadOffset, n);
            this.moveReadOffset(n);
        }
        this.skipPadding(TbCommon.getPadLength(n));
        return string;
    }

    public int readInt32() throws SQLException {
        this.isBufferAvailable(4);
        int n = TbCommon.bytes2Int(this.buf.getRawBytes(), this.curReadOffset, 4);
        this.moveReadOffset(4);
        return n;
    }

    public void readPadBytes(byte[] byArray, int n, int n2) throws SQLException {
        this.readBytes(byArray, n, n2);
        this.skipPadding(TbCommon.getPadLength(n2));
    }

    public byte[] readRpcolData() throws SQLException {
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        this.readBytes(byArray, 0, 1);
        if (byArray[0] <= -6) {
            byte by = byArray[0];
            byArray2 = new byte[by + 1];
            byArray2[0] = byArray[0];
            this.readBytes(byArray2, 1, by);
        } else if (byArray[0] == -2) {
            byte[] byArray3 = new byte[2];
            this.readBytes(byArray3, 0, 2);
            int n = 0xFF & byArray3[0] << 8;
            byArray2 = new byte[(n &= 0xFF & byArray3[1]) + 3];
            byArray2[0] = byArray[0];
            byArray2[1] = byArray3[0];
            byArray2[2] = byArray3[1];
            this.readBytes(byArray2, 3, n);
        } else {
            throw TbError.newSQLException(-90405);
        }
        return byArray2;
    }

    public void reset() {
        this.buf = null;
        this.typeConverter = null;
    }

    private void skipPadding(int n) throws SQLException {
        this.isBufferAvailable(n);
        this.moveReadOffset(n);
    }
}

