/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.UdtAttrMeta;
import com.tmax.tibero.jdbc.data.UdtInfo;
import com.tmax.tibero.jdbc.data.UdtMeta;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbDatabaseMetaQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TbArrayDescriptor
extends TbTypeDescriptor {
    public static final String _DESC_OID_PREFIX = "/O";
    public static final String _DESC_TOBJ_ID_PREFIX = "/T";
    public static final String _DESC_VERSION_NO_PREFIX = "/V";
    private TbConnection conn;
    private int elementType;
    private String elementTypeName;
    private int elementsLimit;

    protected TbArrayDescriptor(String string, Connection connection) throws SQLException {
        this.init(29, null, string.toUpperCase());
        this.conn = (TbConnection)connection;
    }

    protected TbArrayDescriptor(int n, String string, String string2, int n2, String string3, int n3, TbConnection tbConnection) throws SQLException {
        this.init(n, string, string2);
        this.elementType = n2;
        this.elementTypeName = string3;
        this.elementsLimit = n3;
        this.conn = tbConnection;
    }

    public static TbArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + string + "]");
        }
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + connection + "]");
        }
        TbConnection tbConnection = (TbConnection)connection;
        if (!tbConnection.getExtFeatureInfo().supports(2)) {
            throw TbError.newSQLException(-90203);
        }
        String string2 = string.toUpperCase();
        Object object = tbConnection.getDescriptor(string2);
        if (object instanceof TbArrayDescriptor) {
            return (TbArrayDescriptor)object;
        }
        if (object != null) {
            throw TbError.newSQLException(-90666);
        }
        String[] stringArray = TbTypeDescriptor.splitSQLTypeName(string2);
        if (stringArray.length != 2) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + string + "]");
        }
        return TbArrayDescriptor.lookupUdtMeta(stringArray[0], stringArray[1], tbConnection);
    }

    public static TbArrayDescriptor createDescriptor(int n, String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "OID[" + string + "]");
        }
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + connection + "]");
        }
        TbConnection tbConnection = (TbConnection)connection;
        Object object = tbConnection.getDescriptor(_DESC_OID_PREFIX + string);
        if (object instanceof TbArrayDescriptor) {
            return (TbArrayDescriptor)object;
        }
        if (object != null) {
            throw TbError.newSQLException(-90666);
        }
        return TbArrayDescriptor.lookupUdtMeta(string, tbConnection);
    }

    public static TbArrayDescriptor createDescriptor(int n, String string, int n2, int n3, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "OID[" + string + "]");
        }
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + connection + "]");
        }
        TbConnection tbConnection = (TbConnection)connection;
        Object object = tbConnection.getDescriptor(_DESC_OID_PREFIX + string + _DESC_TOBJ_ID_PREFIX + n2 + _DESC_VERSION_NO_PREFIX + n3);
        if (object instanceof TbArrayDescriptor) {
            return (TbArrayDescriptor)object;
        }
        if (object != null) {
            throw TbError.newSQLException(-90666);
        }
        return TbArrayDescriptor.lookupUdtMeta(string, tbConnection);
    }

    public int getBaseType() throws SQLException {
        return DataType.getSqlType(this.elementType);
    }

    public int getElementType() {
        return this.elementType;
    }

    public String getElementTypeName() {
        return this.elementTypeName;
    }

    public int getElementsLimit() {
        return this.elementsLimit;
    }

    public static TbArrayDescriptor lookupUdtMeta(String string, String string2, TbConnection tbConnection) throws SQLException {
        if ("SYS.UDT_META_T".equalsIgnoreCase(string + "." + string2)) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            throw TbError.newSQLException(-90608, "typeName[" + string2 + "]");
        }
        PreparedStatement preparedStatement = tbConnection.prepareStatement(TbDatabaseMetaQuery.QUERY_UDTMETA__BY_TYPENAME);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        return TbArrayDescriptor.lookupUdtMetaInternal((TbResultSetBase)resultSet, tbConnection);
    }

    public static TbArrayDescriptor lookupUdtMeta(String string, TbConnection tbConnection) throws SQLException {
        if ("00000000000000000000000000000009".equalsIgnoreCase(string)) {
            return null;
        }
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "OID(hex)[" + string + "]");
        }
        PreparedStatement preparedStatement = tbConnection.prepareStatement(TbDatabaseMetaQuery.QUERY_UDTMETA__BY_OID);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        return TbArrayDescriptor.lookupUdtMetaInternal((TbResultSetBase)resultSet, tbConnection);
    }

    private static TbArrayDescriptor lookupUdtMetaInternal(TbResultSetBase tbResultSetBase, TbConnection tbConnection) throws SQLException {
        if (!tbResultSetBase.next()) {
            throw TbError.newSQLException(-90665);
        }
        try {
            Object object = tbResultSetBase.getObject(1, TbTypeDescriptor.getUdtMeta2ClsMap());
            if (!(object instanceof UdtMeta)) {
                throw TbError.newSQLException(-90664);
            }
            UdtMeta udtMeta = (UdtMeta)object;
            UdtInfo udtInfo = udtMeta.getUdtId();
            int n = udtInfo.getVersionNo();
            int n2 = udtInfo.getTobjID();
            Object[] objectArray = (Object[])udtMeta.getAttrMetaArr().getArray();
            UdtAttrMeta udtAttrMeta = (UdtAttrMeta)objectArray[0];
            String string = udtInfo.getSchemaName() + "." + udtInfo.getUdtName();
            String string2 = udtAttrMeta.getOid();
            TbArrayDescriptor tbArrayDescriptor = new TbArrayDescriptor(udtInfo.getTypeNo(), udtInfo.getOid(), string, udtAttrMeta.getTypeNo(), string2, udtMeta.getElemOrAttrCnt(), tbConnection);
            tbArrayDescriptor.setVersionNo(n);
            tbArrayDescriptor.setTobjID(n2);
            tbConnection.putDescriptor(string, tbArrayDescriptor);
            tbConnection.putDescriptor(_DESC_OID_PREFIX + udtInfo.getOid(), tbArrayDescriptor);
            return tbArrayDescriptor;
        }
        catch (SQLException sQLException) {
            int n = sQLException.getErrorCode();
            if (n <= -90400 && n > -90500 || n == -90664) {
                throw sQLException;
            }
            throw TbError.newSQLException(-90664, sQLException);
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90664, exception);
        }
    }
}

