/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.pivot;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.data.TbNumber;
import com.tmax.tibero.jdbc.util.TbCommon;
import com.tmax.tibero.pivot.TbPivotMeta;
import com.tmax.tibero.pivot.TbPivotValHdrItem;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class TbPivotValReader {
    Blob blobData;
    byte[] byteData;
    int itemCnt;
    int offsetIdx;
    Vector hdr;
    HashMap newIdxMap;

    private byte[] getNextRpcolData() throws Exception {
        byte[] data;
        int dataLenLen;
        int length;
        int firstLenByte;
        if (this.offsetIdx >= this.itemCnt) {
            throw new Exception("offset index out of bound (itemCnt: " + this.itemCnt + ", offsetIdx: " + this.offsetIdx);
        }
        int offset = ((TbPivotValHdrItem)this.hdr.elementAt(this.offsetIdx)).getOffset();
        if (this.byteData != null) {
            firstLenByte = 0xFF & this.byteData[offset];
        } else {
            byte[] buf = this.blobData.getBytes(offset + 1, 1);
            firstLenByte = 0xFF & buf[0];
        }
        if (0 <= firstLenByte && firstLenByte <= 250) {
            length = firstLenByte;
            dataLenLen = 1;
        } else if (firstLenByte == 254) {
            int thirdLenByte;
            int secondLenByte;
            if (this.byteData != null) {
                secondLenByte = 0xFF & this.byteData[offset + 1];
                thirdLenByte = 0xFF & this.byteData[offset + 2];
            } else {
                byte[] buf = this.blobData.getBytes(offset + 2, 2);
                secondLenByte = 0xFF & buf[0];
                thirdLenByte = 0xFF & buf[1];
            }
            length = 0xFF & secondLenByte << 8;
            length &= 0xFF & thirdLenByte;
            dataLenLen = 3;
        } else {
            throw new Exception("invalid rpcol first length byte: " + firstLenByte);
        }
        if (length == 0) {
            ++this.offsetIdx;
            return null;
        }
        if (length < 0) {
            throw new Exception("invalid rpcol length: " + length);
        }
        if (this.byteData != null) {
            data = new byte[length];
            for (int i = 0; i < length; ++i) {
                data[i] = this.byteData[offset + dataLenLen + i];
            }
        } else {
            data = this.blobData.getBytes(offset + dataLenLen + 1, length);
        }
        ++this.offsetIdx;
        return data;
    }

    private byte[] getNextRpcolForNumber() throws Exception {
        byte[] data = this.getNextRpcolData();
        if (data == null) {
            return null;
        }
        if (data.length > 250) {
            throw new Exception("invalid rpcol length for number: " + data.length);
        }
        byte[] newData = new byte[data.length + 1];
        newData[0] = (byte)data.length;
        for (int i = 0; i < data.length; ++i) {
            newData[i + 1] = data[i];
        }
        return newData;
    }

    private int getNextIntForHdr(InputStream in) throws Exception {
        int retval = 0;
        int shift = 24;
        for (int i = 0; i < 4; ++i) {
            int readByte = in.read();
            retval += readByte << shift;
            shift -= 8;
        }
        return retval;
    }

    private int getNextIntFrom4ByteArr(int byteArrPos) {
        int retval = 0;
        int i = 0;
        int shift = 24;
        while (i < 4) {
            int b = 0xFF & this.byteData[byteArrPos + i];
            retval += b << shift;
            ++i;
            shift -= 8;
        }
        return retval;
    }

    private int getNextIntFrom2ByteArr(int byteArrPos) {
        int retval = ((0xFF & this.byteData[byteArrPos]) << 8) + (0xFF & this.byteData[byteArrPos + 1]);
        return retval;
    }

    private int getNewIdx(int oldIdx) {
        return (Integer)this.newIdxMap.get(new Integer(oldIdx));
    }

    public TbPivotValReader(Blob data, int colIdx, TbPivotMeta pvm) throws Exception {
        this.blobData = data;
        this.offsetIdx = 0;
        this.byteData = ((TbBlob)data).getLobData();
        this.hdr = new Vector();
        this.newIdxMap = pvm.getNewIdxMap(colIdx);
        if (this.byteData == null) {
            InputStream in = data.getBinaryStream();
            this.itemCnt = this.getNextIntForHdr(in);
            for (int i = 0; i < this.itemCnt; ++i) {
                int nameIdx = this.getNewIdx(this.getNextIntForHdr(in));
                int offset = this.getNextIntForHdr(in);
                this.hdr.add(new TbPivotValHdrItem(nameIdx, offset));
            }
            in.close();
        } else {
            int pos = 0;
            this.itemCnt = this.getNextIntFrom4ByteArr(pos);
            pos += 4;
            for (int i = 0; i < this.itemCnt; ++i) {
                int nameIdx = this.getNewIdx(this.getNextIntFrom4ByteArr(pos));
                int offset = this.getNextIntFrom2ByteArr(pos + 4);
                this.hdr.add(new TbPivotValHdrItem(nameIdx, offset));
                pos += 6;
            }
        }
        Collections.sort(this.hdr);
    }

    public int getColNameIdx(int i) throws Exception {
        return ((TbPivotValHdrItem)this.hdr.elementAt(i)).getNameIdx();
    }

    public int getCnt() {
        return this.itemCnt;
    }

    public Long getNextLong() throws Exception {
        byte[] data = this.getNextRpcolForNumber();
        if (data == null) {
            return null;
        }
        return new Long(TbNumber.toLong(data, 0, data.length));
    }

    public Integer getNextInt() throws Exception {
        byte[] data = this.getNextRpcolForNumber();
        if (data == null) {
            return null;
        }
        return new Integer(TbNumber.toInteger(data, 0, data.length));
    }

    public Double getNextDouble() throws Exception {
        byte[] data = this.getNextRpcolForNumber();
        if (data == null) {
            return null;
        }
        return new Double(TbNumber.toDouble(data, 0, data.length));
    }

    public BigDecimal getNextBigDecimal() throws Exception {
        byte[] data = this.getNextRpcolForNumber();
        if (data == null) {
            return null;
        }
        return TbNumber.toBigDecimal(data, 0, data.length);
    }

    public String getNextString() throws Exception {
        byte[] data = this.getNextRpcolData();
        if (data == null) {
            return null;
        }
        return new String(data);
    }

    public Date getNextDate() throws Exception {
        byte[] data = this.getNextRpcolData();
        if (data == null) {
            return null;
        }
        if (data.length != 8) {
            throw new Exception("invalid rpcol length for date: " + data.length);
        }
        int db_century = 0xFF & data[0];
        int db_year = 0xFF & data[1];
        int db_month = 0xFF & data[2];
        int day = 0xFF & data[3];
        int hour = 0xFF & data[4];
        int minute = 0xFF & data[5];
        int second = 0xFF & data[6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hour, minute, second);
        return new Date(cal.getTime().getTime());
    }

    public Timestamp getNextTimestamp() throws Exception {
        byte[] data = this.getNextRpcolData();
        if (data == null) {
            return null;
        }
        if (data.length != 12) {
            throw new Exception("invalid rpcol length for timestamp: " + data.length);
        }
        int db_century = 0xFF & data[0];
        int db_year = 0xFF & data[1];
        int db_month = 0xFF & data[2];
        int day = 0xFF & data[3];
        int hour = 0xFF & data[4];
        int minute = 0xFF & data[5];
        int second = 0xFF & data[6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        int nanoSec = TbCommon.bytes2Int(data, 8, 4);
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hour, minute, second);
        Timestamp timestamp = new Timestamp(cal.getTime().getTime());
        timestamp.setNanos(nanoSec);
        return timestamp;
    }

    public Time getNextTime() throws Exception {
        byte[] data = this.getNextRpcolData();
        if (data == null) {
            return null;
        }
        if (data.length != 8) {
            throw new Exception("invalid rpcol length for time: " + data.length);
        }
        int hour = 0xFF & data[0];
        int minute = 0xFF & data[1];
        int second = 0xFF & data[2];
        int nanoSec = TbCommon.bytes2Int(data, 4, 4);
        Calendar cal = Calendar.getInstance();
        cal.set(10, hour);
        cal.set(12, minute);
        cal.set(13, second);
        Timestamp timestamp = new Timestamp(cal.getTime().getTime());
        timestamp.setNanos(nanoSec);
        return new Time(timestamp.getTime());
    }
}

