/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

public class TbSQLTypeScanner {
    private static final char NULL = '\u0000';
    private static final int STATE_START = 0;
    private static final int STATE_1 = 1;
    private static final int STATE_2 = 2;
    private static final int STATE_3 = 3;
    private static final int STATE_4 = 4;
    private static final int STATE_5 = 5;
    private static final int STATE_6 = 6;
    private static final int STATE_DONE = 10;
    public static final int STMT_UNKNOWN = 0;
    public static final int STMT_QUERY = 16;
    public static final int STMT_DML = 32;
    public static final int STMT_DML_DELETE = 33;
    public static final int STMT_DML_UPDATE = 34;
    public static final int STMT_DML_INSERT = 36;
    public static final int STMT_DML_MERGE = 40;
    public static final int STMT_PSM = 64;
    public static final int STMT_PSM_BEGIN = 65;
    public static final int STMT_PSM_CALL = 66;
    public static final int STMT_PSM_DECLARE = 68;
    public static final int STMT_DDL = 128;
    public static final int STMT_DDL_JAVA_SRC = 136;
    private int state;
    private int index;
    private int textLen;
    private String text;

    public int getCurrentIndex() {
        return this.index;
    }

    private char getNextChar() {
        if (this.index < this.textLen) {
            return this.text.charAt(this.index++);
        }
        return '\u0000';
    }

    public synchronized int getSQLType(String sql) {
        this.index = 0;
        this.textLen = sql.length();
        this.text = sql;
        String token = this.getToken();
        if (token.equals("(")) {
            token = this.getToken();
        }
        if (token.equals("SELECT") || token.equals("WITH")) {
            return 16;
        }
        if (token.equals("DELETE")) {
            return 33;
        }
        if (token.equals("INSERT")) {
            return 36;
        }
        if (token.equals("UPDATE")) {
            return 34;
        }
        if (token.equals("MERGE")) {
            return 40;
        }
        if (token.equals("BEGIN")) {
            return 65;
        }
        if (token.equals("DECLARE")) {
            return 68;
        }
        if (token.equals("CALL")) {
            return 66;
        }
        String[] ddlJavaSrcTkns = new String[]{"CREATE", "OR", "REPLACE", "AND", "RESOLVE", "JAVA", "SOURCE"};
        if (token.equals(ddlJavaSrcTkns[0])) {
            int nextStartIdx = 1;
            int matchFlag = 1;
            while (matchFlag > 0) {
                int i;
                String next = this.getToken();
                for (i = nextStartIdx; i < ddlJavaSrcTkns.length; ++i) {
                    if (!ddlJavaSrcTkns[i].equals(next)) continue;
                    nextStartIdx = i + 1;
                    matchFlag |= 1 << i;
                    break;
                }
                if ((matchFlag & 1) > 0 && (matchFlag & 0x20) > 0 && (matchFlag & 0x40) > 0) {
                    return 136;
                }
                if (i != ddlJavaSrcTkns.length) continue;
                matchFlag = 0;
            }
            return 128;
        }
        String[] bracedCallTkns = new String[]{"{", "?", "=", "CALL"};
        if (token.startsWith(bracedCallTkns[0])) {
            int nextStartIdx = 1;
            int matchFlag = 1;
            String next = token;
            int prevItmLen = bracedCallTkns[0].length();
            while (matchFlag > 0) {
                int i;
                next = next.length() == prevItmLen ? this.getToken() : next.substring(prevItmLen);
                for (i = nextStartIdx; i < bracedCallTkns.length; ++i) {
                    if (next.startsWith(bracedCallTkns[i])) {
                        nextStartIdx = i + 1;
                        prevItmLen = bracedCallTkns[i].length();
                        matchFlag |= 1 << i;
                        break;
                    }
                    if (i != 1 || next.length() <= 1 || next.charAt(0) != ':') continue;
                    nextStartIdx = i + 1;
                    int eqIdx = next.indexOf(61);
                    prevItmLen = eqIdx > 0 ? eqIdx : next.length();
                    matchFlag |= 1 << i;
                    break;
                }
                if ((matchFlag & 1) > 0 && (matchFlag & 8) > 0) {
                    return 66;
                }
                if (i != bracedCallTkns.length) continue;
                matchFlag = 0;
            }
        }
        return 0;
    }

    private String getToken() {
        this.state = 0;
        StringBuffer token = new StringBuffer(32);
        while (this.state != 10) {
            char chr = this.getNextChar();
            boolean save = true;
            block0 : switch (this.state) {
                case 0: {
                    switch (chr) {
                        case '/': {
                            this.state = 1;
                            break block0;
                        }
                        case '-': {
                            this.state = 4;
                            break block0;
                        }
                        case '\'': {
                            this.state = 6;
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            if (token.length() > 0) {
                                this.state = 10;
                                save = false;
                                this.ungetNextChar();
                                break block0;
                            }
                            this.state = 10;
                            save = true;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (token.length() > 0) {
                                this.state = 10;
                            }
                            save = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (chr) {
                        case '*': {
                            this.state = 2;
                            save = false;
                            token.delete(token.length() - 1, token.length());
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            this.state = 10;
                            save = false;
                            this.ungetNextChar();
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    switch (chr) {
                        case '*': {
                            this.state = 3;
                            save = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    save = false;
                    break;
                }
                case 3: {
                    switch (chr) {
                        case '*': {
                            save = false;
                            break block0;
                        }
                        case '/': {
                            this.state = 0;
                            save = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    this.state = 2;
                    save = false;
                    break;
                }
                case 4: {
                    switch (chr) {
                        case '-': {
                            this.state = 5;
                            save = false;
                            token.delete(token.length() - 1, token.length());
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            this.state = 10;
                            save = false;
                            this.ungetNextChar();
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    switch (chr) {
                        case '\n': 
                        case '\r': {
                            this.state = 0;
                            this.ungetNextChar();
                            save = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                    save = false;
                    break;
                }
                case 6: {
                    switch (chr) {
                        case '\'': {
                            this.state = 0;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            save = false;
                            break block0;
                        }
                    }
                }
            }
            if (!save) continue;
            token.append(chr);
        }
        return token.substring(0, token.length()).toUpperCase();
    }

    private void ungetNextChar() {
        --this.index;
    }

    public static boolean isDMLStmt(int type) {
        return (type & 0x20) > 0;
    }

    public static boolean isPSMStmt(int type) {
        return (type & 0x40) > 0;
    }

    public static boolean isQueryStmt(int type) {
        return (type & 0x10) > 0;
    }

    public static boolean isDDLStmt(int type) {
        return (type & 0x80) > 0;
    }
}

