/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

import com.tmax.tibero.jdbc.data.BigLiteral;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;

public class TbSQLParser {
    private String originalSql;
    private int length;
    private StringBuffer parsedSql;
    private StringBuffer token;
    private char chr;
    private int index;
    private int openParenCnt;
    private boolean isString;
    private static final byte[] IDEOGRAPHIC_SPACE = new byte[]{-29, -128, -128};

    private void appendFunctionName(String newName) throws SQLException {
        this.parsedSql.append(newName);
        this.skipWhitespace();
        this.processSQL();
    }

    private void appendFunctionPrefix(String newPrefix) throws SQLException {
        this.skipWhitespace();
        if (this.index < this.length && (this.chr = this.originalSql.charAt(this.index)) == '(') {
            ++this.index;
        } else {
            String errorDescription = new String(this.index + ": '(' is expected");
            throw TbError.newSQLException(-90632, errorDescription);
        }
        this.parsedSql.append(newPrefix);
        this.skipWhitespace();
        this.processSQL();
    }

    private void checkCurrentChar(char dueChar) throws SQLException {
        this.chr = this.originalSql.charAt(this.index - 1);
        if (this.chr != dueChar) {
            String errorDescription = new String(this.index + ": '" + dueChar + "' is expected");
            throw TbError.newSQLException(-90632, errorDescription);
        }
    }

    public static String getBigLiteral(String sql, int maxByteCount, ArrayList<BigLiteral> literal) {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        int paramIndex = 0;
        char[] sqlChars = new char[sql.length() + 1];
        sql.getChars(0, sql.length(), sqlChars, 0);
        while (true) {
            if (sqlChars[index] == '-' && sqlChars[index + 1] == '-') {
                sb.append(sqlChars[index++]);
                sb.append(sqlChars[index++]);
                while (sqlChars[index] != '\n') {
                    if (sqlChars[index] == '\u0000') {
                        return sb.toString();
                    }
                    sb.append(sqlChars[index++]);
                }
                sb.append(sqlChars[index++]);
                continue;
            }
            if (sqlChars[index] == '\"') {
                sb.append(sqlChars[index++]);
                while (sqlChars[index] != '\"') {
                    if (sqlChars[index] == '\u0000') {
                        return sb.toString();
                    }
                    sb.append(sqlChars[index++]);
                }
                sb.append(sqlChars[index++]);
                continue;
            }
            if (sqlChars[index] == '\'') {
                int beginIndex = ++index;
                StringBuffer temp = new StringBuffer();
                while (sqlChars[index] != '\'') {
                    if (sqlChars[index] == '\u0000') {
                        sb.append('\'');
                        sb.append(temp);
                        return sb.toString();
                    }
                    temp.append(sqlChars[index++]);
                }
                if (index - beginIndex > 65535 / maxByteCount) {
                    BigLiteral bl = new BigLiteral(paramIndex++, sql.substring(beginIndex, index));
                    literal.add(bl);
                    sb.append('?');
                } else {
                    sb.append('\'');
                    sb.append(temp);
                    sb.append('\'');
                }
                ++index;
                continue;
            }
            if (sqlChars[index] == '/' && sqlChars[index + 1] == '*') {
                sb.append(sqlChars[index++]);
                sb.append(sqlChars[index++]);
                while (sqlChars[index] != '*' || sqlChars[index + 1] != '/') {
                    if (sqlChars[index] == '\u0000') {
                        return sb.toString();
                    }
                    sb.append(sqlChars[index++]);
                }
                sb.append(sqlChars[index++]);
                sb.append(sqlChars[index++]);
                continue;
            }
            if (sqlChars[index] == '\u0000') {
                return sb.toString();
            }
            if (sqlChars[index] == '?' || sqlChars[index] == ':' && sqlChars[index + 1] != '=') {
                sb.append(sqlChars[index++]);
                ++paramIndex;
                continue;
            }
            sb.append(sqlChars[index++]);
        }
    }

    public static int getParamCount(String sql, int sqlType) {
        if (TbSQLTypeScanner.isDDLStmt(sqlType)) {
            return 0;
        }
        int index = 0;
        int paramCount = 0;
        boolean isIntoStarted = false;
        char[] sqlChars = new char[sql.length() + 1];
        sql.getChars(0, sql.length(), sqlChars, 0);
        while (true) {
            if (sqlChars[index] == '-' && sqlChars[index + 1] == '-') {
                index += 2;
                while (sqlChars[index] != '\n') {
                    if (sqlChars[index] == '\u0000') {
                        return paramCount;
                    }
                    ++index;
                }
                ++index;
                continue;
            }
            if (sqlChars[index] == '\"') {
                ++index;
                while (sqlChars[index] != '\"') {
                    if (sqlChars[index] == '\u0000') {
                        return paramCount;
                    }
                    ++index;
                }
                ++index;
                continue;
            }
            if (sqlChars[index] == '\'') {
                ++index;
                while (sqlChars[index] != '\'') {
                    if (sqlChars[index] == '\u0000') {
                        return paramCount;
                    }
                    ++index;
                }
                ++index;
                continue;
            }
            if (sqlChars[index] == '/' && sqlChars[index + 1] == '*') {
                index += 2;
                while (sqlChars[index] != '*' || sqlChars[index + 1] != '/') {
                    if (sqlChars[index] == '\u0000') {
                        return paramCount;
                    }
                    ++index;
                }
                index += 2;
                continue;
            }
            if (!TbSQLTypeScanner.isPSMStmt(sqlType) && sql.regionMatches(true, index, "returning", 0, 9) && index > 1 && index + 9 < sqlChars.length && Character.isWhitespace(sqlChars[index - 1]) && Character.isWhitespace(sqlChars[index + 9]) || isIntoStarted) {
                int returningEnd = index;
                if (!isIntoStarted) {
                    returningEnd = index += 9;
                }
                while (sqlChars[index] != ';') {
                    if (sqlChars[index] == '\u0000') {
                        return paramCount;
                    }
                    if (!isIntoStarted && sql.regionMatches(true, index, "into", 0, 3)) {
                        isIntoStarted = true;
                        index = returningEnd;
                        break;
                    }
                    ++index;
                }
                ++index;
                if (!isIntoStarted) continue;
            }
            if (sqlChars[index] == '\u0000') {
                return paramCount;
            }
            if (sqlChars[index] == '?' || sqlChars[index] == ':' && sqlChars[index + 1] != '=') {
                ++paramCount;
            }
            ++index;
        }
    }

    public static String[] getParamNames(String sql) {
        int chrIndex = 0;
        char[] sqlChars = new char[sql.length() + 1];
        ArrayList<String> paramNames = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sql.getChars(0, sql.length(), sqlChars, 0);
        block0: while (true) {
            if (sqlChars[chrIndex] == '-' && sqlChars[chrIndex + 1] == '-') {
                chrIndex += 2;
                while (sqlChars[chrIndex] != '\n') {
                    if (sqlChars[chrIndex] == '\u0000') {
                        return paramNames.toArray(new String[0]);
                    }
                    ++chrIndex;
                }
                ++chrIndex;
                continue;
            }
            if (sqlChars[chrIndex] == '\"') {
                ++chrIndex;
                while (sqlChars[chrIndex] != '\"') {
                    if (sqlChars[chrIndex] == '\u0000') {
                        return paramNames.toArray(new String[0]);
                    }
                    ++chrIndex;
                }
                ++chrIndex;
                continue;
            }
            if (sqlChars[chrIndex] == '\'') {
                ++chrIndex;
                while (sqlChars[chrIndex] != '\'') {
                    if (sqlChars[chrIndex] == '\u0000') {
                        return paramNames.toArray(new String[0]);
                    }
                    ++chrIndex;
                }
                ++chrIndex;
                continue;
            }
            if (sqlChars[chrIndex] == '/' && sqlChars[chrIndex + 1] == '*') {
                chrIndex += 2;
                while (sqlChars[chrIndex] != '*' || sqlChars[chrIndex + 1] != '/') {
                    if (sqlChars[chrIndex] == '\u0000') {
                        return paramNames.toArray(new String[0]);
                    }
                    ++chrIndex;
                }
                chrIndex += 2;
                continue;
            }
            if (sqlChars[chrIndex] == '\u0000') {
                return paramNames.toArray(new String[0]);
            }
            if (sqlChars[chrIndex] == '?') {
                paramNames.add("?");
            } else if (sqlChars[chrIndex] == ':' && sqlChars[chrIndex + 1] != '=') {
                ++chrIndex;
                sb.delete(0, sb.length());
                while (true) {
                    if (sqlChars[chrIndex] == '\u0000') {
                        return paramNames.toArray(new String[0]);
                    }
                    if (!Character.isLetterOrDigit(sqlChars[chrIndex]) && sqlChars[chrIndex] != '_') {
                        if (sb.length() <= 0) continue block0;
                        paramNames.add(sb.toString());
                        continue block0;
                    }
                    sb.append(sqlChars[chrIndex]);
                    ++chrIndex;
                }
            }
            ++chrIndex;
        }
    }

    public static String getRowIdAddedRefetchSql(String originalSql, int cnt) throws SQLException {
        if (originalSql == null) {
            throw TbError.newSQLException(-90608, "null");
        }
        if (cnt <= 0) {
            return originalSql;
        }
        StringBuffer retSql = new StringBuffer();
        retSql.append("select * from (").append(originalSql).append(") ");
        if (cnt > 0) {
            retSql.append(" WHERE _ROWID_CHAR0_ = ? ");
        }
        for (int i = 1; i < cnt; ++i) {
            retSql.append(" OR _ROWID_CHAR0_ = ? ");
        }
        return retSql.toString();
    }

    private void init() {
        this.index = 0;
        this.openParenCnt = 0;
        this.isString = false;
    }

    private void makeToken() {
        while (this.index < this.length && (Character.isJavaIdentifierPart(this.chr = this.originalSql.charAt(this.index)) || this.chr == '?')) {
            this.token.append(this.chr);
            ++this.index;
        }
    }

    public String parse(String sql) throws SQLException {
        this.init();
        this.parsedSql = new StringBuffer(sql.length());
        this.token = new StringBuffer(32);
        this.originalSql = sql;
        this.length = this.originalSql.length();
        this.processSQL();
        return this.parsedSql.substring(0, this.parsedSql.length());
    }

    private void processCall() throws SQLException {
        this.parsedSql.append("CALL");
        this.processSQL();
    }

    private void processDate() throws SQLException {
        this.parsedSql.append("TO_DATE (");
        this.skipWhitespace();
        this.processSQL();
        this.parsedSql.append(", 'YYYY-MM-DD')");
    }

    private void processEscape() throws SQLException {
        this.parsedSql.append("ESCAPE ");
        this.skipWhitespace();
        this.processSQL();
    }

    private void processFunction() throws SQLException {
        this.parsedSql.append("?");
        this.processSQL();
    }

    private void processOuterJoin() throws SQLException {
        this.parsedSql.append(" ( ");
        this.skipWhitespace();
        this.processSQL();
        this.parsedSql.append(" ) ");
    }

    private void processScalarFunction() throws SQLException {
        this.token.delete(0, this.token.length());
        this.skipWhitespace();
        this.makeToken();
        String functionName = this.token.substring(0, this.token.length()).toUpperCase().intern();
        if ("ABS".equalsIgnoreCase(functionName) || "ACOS".equalsIgnoreCase(functionName) || "ASIN".equalsIgnoreCase(functionName) || "ATAN".equalsIgnoreCase(functionName) || "ATAN2".equalsIgnoreCase(functionName) || "COS".equalsIgnoreCase(functionName) || "EXP".equalsIgnoreCase(functionName) || "FLOOR".equalsIgnoreCase(functionName) || "MOD".equalsIgnoreCase(functionName) || "POWER".equalsIgnoreCase(functionName) || "ROUND".equalsIgnoreCase(functionName) || "SIGN".equalsIgnoreCase(functionName) || "SIN".equalsIgnoreCase(functionName) || "SQRT".equalsIgnoreCase(functionName) || "TAN".equalsIgnoreCase(functionName) || "ASCII".equalsIgnoreCase(functionName) || "CHAR_LENGTH".equalsIgnoreCase(functionName) || "CHARACTER_LENGTH".equalsIgnoreCase(functionName) || "CONCAT".equalsIgnoreCase(functionName) || "LENGTH".equalsIgnoreCase(functionName) || "LTRIM".equalsIgnoreCase(functionName) || "REPLACE".equalsIgnoreCase(functionName) || "RTRIM".equalsIgnoreCase(functionName) || "EXTRACT".equalsIgnoreCase(functionName)) {
            this.appendFunctionName(functionName);
        } else if ("CEILING".equalsIgnoreCase(functionName)) {
            this.appendFunctionName("CEIL");
        } else if ("LOG".equalsIgnoreCase(functionName)) {
            this.appendFunctionName("LN");
        } else if ("LOG10".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("LOG ( 10, ");
        } else if ("PI".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
        } else if ("TRUNCATE".equalsIgnoreCase(functionName)) {
            this.appendFunctionName("TRUNC");
        } else if ("CHAR".equalsIgnoreCase(functionName)) {
            this.appendFunctionName("CHR");
        } else if ("INSERT".equalsIgnoreCase(functionName)) {
            int numOfArgs;
            ArrayList<StringBuffer> args = this.processArguments();
            int n = numOfArgs = args == null ? 0 : args.size();
            if (numOfArgs != 4) {
                String err = new String("The number of arguments is wrong. expected=4, actual=" + numOfArgs);
                throw TbError.newSQLException(-90632, err);
            }
            this.parsedSql.append("SUBSTR(").append(args.get(0)).append(", 1, (").append(args.get(1)).append(")-1) || ").append(args.get(3)).append(" || SUBSTR(").append(args.get(0)).append(", (").append(args.get(1)).append(")+(").append(args.get(2)).append("))");
            this.processSQL();
        } else if ("LCASE".equalsIgnoreCase(functionName)) {
            this.appendFunctionName("LOWER");
        } else if ("LEFT".equalsIgnoreCase(functionName)) {
            int numOfArgs;
            ArrayList<StringBuffer> args = this.processArguments();
            int n = numOfArgs = args == null ? 0 : args.size();
            if (numOfArgs != 2) {
                String err = new String("The number of arguments is wrong. expected=2, actual=" + numOfArgs);
                throw TbError.newSQLException(-90632, err);
            }
            this.parsedSql.append("SUBSTR(").append(args.get(0)).append(", 1,").append(args.get(1)).append(')');
            this.processSQL();
        } else if ("LOCATE".equalsIgnoreCase(functionName)) {
            int numOfArgs;
            ArrayList<StringBuffer> args = this.processArguments();
            int n = numOfArgs = args == null ? 0 : args.size();
            if (numOfArgs != 2) {
                String err = new String("The number of arguments is wrong. expected=2, actual=" + numOfArgs);
                throw TbError.newSQLException(-90632, err);
            }
            this.parsedSql.append("INSTR(").append(args.get(1)).append(", ").append(args.get(0)).append(')');
            this.processSQL();
        } else if ("REPEAT".equalsIgnoreCase(functionName)) {
            int numOfArgs;
            ArrayList<StringBuffer> args = this.processArguments();
            int n = numOfArgs = args == null ? 0 : args.size();
            if (numOfArgs != 2) {
                String err = new String("The number of arguments is wrong. expected=2, actual=" + numOfArgs);
                throw TbError.newSQLException(-90632, err);
            }
            this.parsedSql.append("RPAD(").append(args.get(0)).append(", ").append(args.get(1)).append(" * LENGTH(").append(args.get(0)).append("), ").append(args.get(0)).append(')');
            this.processSQL();
        } else if ("RIGHT".equalsIgnoreCase(functionName)) {
            int numOfArgs;
            ArrayList<StringBuffer> args = this.processArguments();
            int n = numOfArgs = args == null ? 0 : args.size();
            if (numOfArgs != 2) {
                String err = new String("The number of arguments is wrong. expected=2, actual=" + numOfArgs);
                throw TbError.newSQLException(-90632, err);
            }
            this.parsedSql.append("SUBSTR(").append(args.get(0)).append(", - ").append(args.get(1)).append(')');
            this.processSQL();
        } else if ("SPACE".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("LPAD(' ', ");
        } else if ("SUBSTRING".equalsIgnoreCase(functionName)) {
            this.appendFunctionName("SUBSTR");
        } else if ("UCASE".equalsIgnoreCase(functionName)) {
            this.appendFunctionName("UPPER");
        } else if ("CURDATE".equalsIgnoreCase(functionName) || "CURRENT_DATE".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("(CURRENT_DATE");
        } else if ("CURRENT_TIME".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("(CURRENT_TIME");
        } else if ("CURTIME".equalsIgnoreCase(functionName) || "CURRENT_TIMESTAMP".equalsIgnoreCase(functionName) || "NOW".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if ("DAYOFMONTH".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("EXTRACT ( DAY FROM ");
        } else if ("HOUR".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("EXTRACT ( HOUR FROM ");
        } else if ("MINUTE".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("EXTRACT ( MINUTE FROM ");
        } else if ("MONTH".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("EXTRACT ( MONTH FROM ");
        } else if ("SECOND".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("EXTRACT ( SECOND FROM ");
        } else if ("YEAR".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("EXTRACT ( YEAR FROM ");
        } else if ("DATABASE".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("USERENV('DB_NAME'");
        } else if ("IFNULL".equalsIgnoreCase(functionName)) {
            this.appendFunctionName("NVL");
        } else if ("USER".equalsIgnoreCase(functionName)) {
            this.appendFunctionPrefix("(USER");
        } else if ("CONVERT".equalsIgnoreCase(functionName)) {
            int numOfArgs;
            ArrayList<StringBuffer> args = this.processArguments();
            int n = numOfArgs = args == null ? 0 : args.size();
            if (numOfArgs != 2) {
                String err = new String("The number of arguments is wrong. expected=2, actual=" + numOfArgs);
                throw TbError.newSQLException(-90632, err);
            }
            String argType = args.get(1).toString().trim();
            String fconvName = null;
            if ("SQL_VARCHAR".equalsIgnoreCase(argType) || "SQL_CHAR".equalsIgnoreCase(argType)) {
                fconvName = "TO_CHAR";
            } else if ("SQL_INTEGER".equalsIgnoreCase(argType) || "SQL_NUMERIC".equalsIgnoreCase(argType) || "SQL_DECIMAL".equalsIgnoreCase(argType)) {
                fconvName = "TO_NUMBER";
            } else if ("SQL_DATE".equalsIgnoreCase(argType)) {
                fconvName = "TO_DATE";
            } else if ("SQL_TIME".equalsIgnoreCase(argType)) {
                fconvName = "TO_TIME";
            } else if ("SQL_TIMESTAMP".equalsIgnoreCase(argType)) {
                fconvName = "TO_TIMESTAMP";
            } else {
                String errorDescription = new String("NOT implemented option: \"" + argType + "\"");
                throw TbError.newSQLException(-90632, errorDescription);
            }
            this.parsedSql.append(fconvName).append('(').append(args.get(0)).append(')');
            this.processSQL();
        } else {
            String errorDescription = new String("unsuppoted SQL92 Token: \"" + functionName + "\"");
            throw TbError.newSQLException(-90632, errorDescription);
        }
    }

    private void processSQL() throws SQLException {
        block7: while (this.index < this.length) {
            this.chr = this.originalSql.charAt(this.index++);
            char nextChr = '\u0000';
            if (this.isString) {
                this.parsedSql.append(this.chr);
                if (this.chr != '\'') continue;
                this.isString = false;
                continue;
            }
            switch (this.chr) {
                case '\'': {
                    this.parsedSql.append(this.chr);
                    this.isString = true;
                    continue block7;
                }
                case '{': {
                    ++this.openParenCnt;
                    this.token.delete(0, this.token.length());
                    this.skipWhitespace();
                    this.makeToken();
                    this.processToken();
                    this.checkCurrentChar('}');
                    continue block7;
                }
                case '}': {
                    --this.openParenCnt;
                    if (this.openParenCnt < 0) {
                        String errorDescription = new String(this.index + ": Unnecessary '" + this.chr + "' exists");
                        throw TbError.newSQLException(-90632, errorDescription);
                    }
                    return;
                }
                case '/': {
                    if (this.index < this.length && (nextChr = this.originalSql.charAt(this.index)) == '*') {
                        this.parsedSql.append(this.chr).append(nextChr);
                        ++this.index;
                        while (this.index < this.length && ((this.chr = this.originalSql.charAt(this.index)) != '*' || (nextChr = this.originalSql.charAt(this.index + 1)) != '/')) {
                            this.parsedSql.append(this.chr);
                            ++this.index;
                        }
                        this.chr = this.originalSql.charAt(this.index++);
                        this.parsedSql.append(this.chr);
                        this.chr = this.originalSql.charAt(this.index++);
                        this.parsedSql.append(this.chr);
                        continue block7;
                    }
                    this.parsedSql.append(this.chr);
                    continue block7;
                }
                case '-': {
                    if (this.index < this.length && (nextChr = this.originalSql.charAt(this.index)) == '-') {
                        this.parsedSql.append(this.chr).append(nextChr);
                        ++this.index;
                        while (this.index < this.length && (this.chr = this.originalSql.charAt(this.index)) != '\n') {
                            this.parsedSql.append(this.chr);
                            ++this.index;
                        }
                        this.parsedSql.append(this.chr);
                        ++this.index;
                        continue block7;
                    }
                    this.parsedSql.append(this.chr);
                    continue block7;
                }
            }
            this.parsedSql.append(this.chr);
        }
    }

    private ArrayList<StringBuffer> processArguments() throws SQLException {
        this.skipWhitespace();
        if (this.index < this.length && (this.chr = this.originalSql.charAt(this.index)) == '(') {
            ++this.index;
        } else {
            String errorDescription = new String(this.index + ": '(' is expected");
            throw TbError.newSQLException(-90632, errorDescription);
        }
        ArrayList<StringBuffer> ret = new ArrayList<StringBuffer>();
        StringBuffer orgBuf = this.parsedSql;
        this.parsedSql = new StringBuffer();
        int argParenCnt = 0;
        block9: while (this.index < this.length) {
            char chr = this.originalSql.charAt(this.index++);
            if (this.isString) {
                this.parsedSql.append(chr);
                if (chr != '\'') continue;
                this.isString = false;
                continue;
            }
            switch (chr) {
                case '\'': {
                    this.parsedSql.append(chr);
                    this.isString = true;
                    continue block9;
                }
                case '{': {
                    ++this.openParenCnt;
                    this.token.delete(0, this.token.length());
                    this.skipWhitespace();
                    this.makeToken();
                    this.processToken();
                    this.checkCurrentChar('}');
                    continue block9;
                }
                case ',': {
                    if (argParenCnt != 0) {
                        this.parsedSql.append(chr);
                        continue block9;
                    }
                    ret.add(this.parsedSql);
                    this.parsedSql = new StringBuffer();
                    continue block9;
                }
                case '(': {
                    ++argParenCnt;
                    this.skipWhitespace();
                    this.makeToken();
                    this.processToken();
                    this.checkCurrentChar(')');
                    continue block9;
                }
                case ')': {
                    if (argParenCnt == 0) {
                        ret.add(this.parsedSql);
                        break block9;
                    }
                    if (argParenCnt <= 0) continue block9;
                    --argParenCnt;
                    continue block9;
                }
                case '/': {
                    char nextChr;
                    if (this.index < this.length && (nextChr = this.originalSql.charAt(this.index)) == '*') {
                        this.parsedSql.append(chr).append(nextChr);
                        ++this.index;
                        while (this.index < this.length && ((chr = this.originalSql.charAt(this.index)) != '*' || (nextChr = this.originalSql.charAt(this.index + 1)) != '/')) {
                            this.parsedSql.append(chr);
                            ++this.index;
                        }
                        chr = this.originalSql.charAt(this.index++);
                        this.parsedSql.append(chr);
                        chr = this.originalSql.charAt(this.index++);
                        this.parsedSql.append(chr);
                        continue block9;
                    }
                    this.parsedSql.append(chr);
                    continue block9;
                }
                case '-': {
                    char nextChr;
                    if (this.index < this.length && (nextChr = this.originalSql.charAt(this.index)) == '-') {
                        this.parsedSql.append(chr).append(nextChr);
                        ++this.index;
                        while (this.index < this.length && (chr = this.originalSql.charAt(this.index)) != '\n') {
                            this.parsedSql.append(chr);
                            ++this.index;
                        }
                        this.parsedSql.append(chr);
                        ++this.index;
                        continue block9;
                    }
                    this.parsedSql.append(chr);
                    continue block9;
                }
                default: {
                    this.parsedSql.append(chr);
                    continue block9;
                }
            }
        }
        this.parsedSql = orgBuf;
        return ret;
    }

    private void processTime() throws SQLException {
        this.parsedSql.append("TO_DATE (");
        this.skipWhitespace();
        this.processSQL();
        this.parsedSql.append(", 'HH24:MI:SS')");
    }

    private void processTimestamp() throws SQLException {
        this.parsedSql.append("TO_TIMESTAMP (");
        this.skipWhitespace();
        this.processSQL();
        this.parsedSql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
    }

    private void processToken() throws SQLException {
        String curToken = this.token.substring(0, this.token.length());
        if (curToken.equalsIgnoreCase("?")) {
            this.processFunction();
        } else if (curToken.equalsIgnoreCase("CALL")) {
            this.processCall();
        } else if (curToken.equalsIgnoreCase("TS")) {
            this.processTimestamp();
        } else if (curToken.equalsIgnoreCase("T")) {
            this.processTime();
        } else if (curToken.equalsIgnoreCase("D")) {
            this.processDate();
        } else if (curToken.equalsIgnoreCase("ESCAPE")) {
            this.processEscape();
        } else if (curToken.equalsIgnoreCase("FN")) {
            this.processScalarFunction();
        } else if (curToken.equalsIgnoreCase("OJ")) {
            this.processOuterJoin();
        } else {
            String errorDescription = new String(this.index + ": \"" + this.token + "\" token is not supported");
            throw TbError.newSQLException(-90632, errorDescription);
        }
    }

    public static String replace(String sql) {
        int index = 0;
        char[] sqlChars = new char[sql.length() + 1];
        StringBuffer returnedSql = new StringBuffer(sql.length());
        sql.getChars(0, sql.length(), sqlChars, 0);
        while (true) {
            if (sqlChars[index] == '-' && sqlChars[index + 1] == '-') {
                returnedSql.append(sqlChars[index]);
                returnedSql.append(sqlChars[index + 1]);
                index += 2;
                while (sqlChars[index] != '\n') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                ++index;
                continue;
            }
            if (sqlChars[index] == '\"') {
                returnedSql.append(sqlChars[index]);
                ++index;
                while (sqlChars[index] != '\"') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                ++index;
                continue;
            }
            if (sqlChars[index] == '\'') {
                returnedSql.append(sqlChars[index]);
                ++index;
                while (sqlChars[index] != '\'') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                ++index;
                continue;
            }
            if (sqlChars[index] == '/' && sqlChars[index + 1] == '*') {
                returnedSql.append(sqlChars[index]);
                returnedSql.append(sqlChars[index + 1]);
                index += 2;
                while (sqlChars[index] != '*' || sqlChars[index + 1] != '/') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                returnedSql.append(sqlChars[index + 1]);
                index += 2;
                continue;
            }
            if (sqlChars[index] == '\u0000') {
                return returnedSql.toString();
            }
            if (sqlChars[index] == '?' && Character.isDigit(sqlChars[index + 1])) {
                int beginIndex = index;
                index += 2;
                while (Character.isDigit(sqlChars[index])) {
                    ++index;
                }
                if (Character.isLetter(sqlChars[index])) {
                    returnedSql.append(sql.substring(beginIndex, index));
                    continue;
                }
                returnedSql.append(":");
                returnedSql.append(sql.substring(beginIndex + 1, index));
                continue;
            }
            returnedSql.append(sqlChars[index]);
            ++index;
        }
    }

    public static String replaceIDEOGraphicSpace(String sql) {
        char ideoGraphicSpaceCh;
        try {
            ideoGraphicSpaceCh = new String(IDEOGRAPHIC_SPACE, "utf8").charAt(0);
        }
        catch (UnsupportedEncodingException e) {
            return sql;
        }
        if (sql == null || sql.indexOf(ideoGraphicSpaceCh) < 0) {
            return sql;
        }
        int index = 0;
        char[] sqlChars = new char[sql.length() + 1];
        StringBuffer returnedSql = new StringBuffer(sql.length());
        sql.getChars(0, sql.length(), sqlChars, 0);
        while (true) {
            if (sqlChars[index] == '-' && sqlChars[index + 1] == '-') {
                returnedSql.append(sqlChars[index]);
                returnedSql.append(sqlChars[index + 1]);
                index += 2;
                while (sqlChars[index] != '\n') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                ++index;
                continue;
            }
            if (sqlChars[index] == '\"') {
                returnedSql.append(sqlChars[index]);
                ++index;
                while (sqlChars[index] != '\"') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                ++index;
                continue;
            }
            if (sqlChars[index] == '\'') {
                returnedSql.append(sqlChars[index]);
                ++index;
                while (sqlChars[index] != '\'') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                ++index;
                continue;
            }
            if (sqlChars[index] == '/' && sqlChars[index + 1] == '*') {
                returnedSql.append(sqlChars[index]);
                returnedSql.append(sqlChars[index + 1]);
                index += 2;
                while (sqlChars[index] != '*' || sqlChars[index + 1] != '/') {
                    if (sqlChars[index] == '\u0000') {
                        return returnedSql.toString();
                    }
                    returnedSql.append(sqlChars[index]);
                    ++index;
                }
                returnedSql.append(sqlChars[index]);
                returnedSql.append(sqlChars[index + 1]);
                index += 2;
                continue;
            }
            if (sqlChars[index] == '\u0000') {
                return returnedSql.toString();
            }
            if (sqlChars[index] == ideoGraphicSpaceCh) {
                returnedSql.append(" ");
                ++index;
                continue;
            }
            returnedSql.append(sqlChars[index]);
            ++index;
        }
    }

    private void skipWhitespace() {
        while (this.index < this.length) {
            this.chr = this.originalSql.charAt(this.index);
            if (this.chr != ' ' && this.chr != '\t' && this.chr != '\r' && this.chr != '\n') break;
            this.parsedSql.append(this.chr);
            ++this.index;
        }
    }
}

