/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.util.TbDTFormat;
import com.tmax.tibero.jdbc.util.TbDTFormatElement;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;

public class TbDTFormatter {
    private TbDTFormatter() {
    }

    public static String format(TbDTFormat fmt, TbDate value) {
        if (value == null) {
            return null;
        }
        if (fmt == null || fmt.getElements() == null) {
            return value.toString();
        }
        return TbDTFormatter.formatInternal(fmt, value.getYear(), value.getMonth(), value.getDayOfMonth(), value.getHourOfDay(), value.getMinutes(), value.getSeconds(), 0);
    }

    public static String format(TbDTFormat fmt, TbTimestamp value) {
        if (value == null) {
            return null;
        }
        if (fmt == null || fmt.getElements() == null) {
            return value.toString();
        }
        return TbDTFormatter.formatInternal(fmt, value.getYear(), value.getMonth(), value.getDayOfMonth(), value.getHourOfDay(), value.getMinutes(), value.getSeconds(), value.getNanos());
    }

    public static String format(TbDTFormat fmt, Date value) {
        if (value == null) {
            return null;
        }
        if (fmt == null || fmt.getElements() == null) {
            return value.toString();
        }
        return null;
    }

    public static String format(TbDTFormat fmt, Timestamp value) {
        if (value == null) {
            return null;
        }
        if (fmt == null || fmt.getElements() == null) {
            return value.toString();
        }
        return null;
    }

    private static String formatInternal(TbDTFormat fmt, int year, int month, int dayOfMonth, int hourOfDay, int minute, int second, int nanos) {
        Iterator<TbDTFormatElement> iter = fmt.getElements().iterator();
        StringBuilder sb = new StringBuilder(fmt.getElements().size() * 3);
        boolean pad = !fmt.getTrimEnabled();
        Calendar cal = null;
        Locale localeForDisplay = Locale.getDefault();
        if (fmt.hasField(0) || fmt.hasField(7) || fmt.isFieldWithAdditionalOption(4) || fmt.isFieldWithAdditionalOption(6)) {
            cal = Calendar.getInstance(new Locale("GMT+0"));
            cal.clear();
            cal.set(year, month - 1, dayOfMonth, hourOfDay, minute, second);
            cal.getTime();
        }
        block24: while (iter.hasNext()) {
            TbDTFormatElement element = iter.next();
            switch (element.getType()) {
                case 24: {
                    sb.append(cal.getDisplayName(0, 2, localeForDisplay));
                    continue block24;
                }
                case 25: {
                    int cen = Math.abs(year) / 100;
                    if (cen % 100 > 0) {
                        ++cen;
                    }
                    sb.append(cen);
                    continue block24;
                }
                case 46: {
                    int scen = Math.abs(year) / 100;
                    if (scen % 100 > 0) {
                        scen = scen > 0 ? ++scen : --scen;
                    }
                    sb.append(scen);
                    continue block24;
                }
                case 42: 
                case 55: 
                case 56: 
                case 57: {
                    TbDTFormatter.appendNumber(sb, year, element.getEtcValue(), pad, false);
                    continue block24;
                }
                case 47: 
                case 48: {
                    TbDTFormatter.appendNumber(sb, year, 4, pad, true);
                    continue block24;
                }
                case 41: {
                    sb.append((month + 2) / 3);
                    continue block24;
                }
                case 38: 
                case 39: {
                    TbDTFormatter.appendNumber(sb, month, 2, pad, false);
                    continue block24;
                }
                case 40: {
                    sb.append(cal.getDisplayName(2, 2, localeForDisplay));
                    continue block24;
                }
                case 37: {
                    sb.append(cal.getDisplayName(2, 1, localeForDisplay));
                    continue block24;
                }
                case 26: {
                    TbDTFormatter.appendNumber(sb, dayOfMonth, 2, pad, false);
                    continue block24;
                }
                case 27: {
                    sb.append(cal.get(6));
                    continue block24;
                }
                case 29: {
                    sb.append(cal.get(7));
                    continue block24;
                }
                case 30: {
                    sb.append(cal.getDisplayName(7, 2, localeForDisplay));
                    continue block24;
                }
                case 28: {
                    sb.append(cal.getDisplayName(2, 1, localeForDisplay));
                    continue block24;
                }
                case 23: {
                    sb.append(cal.getDisplayName(9, 2, localeForDisplay));
                    continue block24;
                }
                case 34: {
                    TbDTFormatter.appendNumber(sb, hourOfDay > 12 ? hourOfDay - 12 : hourOfDay, 2, pad, false);
                    continue block24;
                }
                case 35: {
                    TbDTFormatter.appendNumber(sb, hourOfDay, 2, pad, false);
                    continue block24;
                }
                case 36: {
                    TbDTFormatter.appendNumber(sb, minute, 2, pad, false);
                    continue block24;
                }
                case 45: {
                    TbDTFormatter.appendNumber(sb, second, 2, pad, false);
                    continue block24;
                }
                case 44: {
                    TbDTFormatter.appendNumber(sb, hourOfDay * 3600 + minute * 60 + second, 5, pad, false);
                    continue block24;
                }
                case 33: {
                    TbDTFormatter.appendNumber(sb, nanos, 9, true, false);
                    int precision = element.getEtcValue();
                    if (precision == 0) {
                        precision = 9;
                    }
                    sb.setLength(sb.length() - (9 - precision));
                    continue block24;
                }
                case 43: {
                    sb.append(new DecimalFormatSymbols(localeForDisplay).getDecimalSeparator());
                    continue block24;
                }
            }
            sb.append(element.getText());
        }
        return sb.toString();
    }

    private static void appendNumber(StringBuilder sb, int value, int width, boolean pad, boolean signed) {
        if (value < 0 && signed) {
            sb.append(value);
        } else {
            String tmp = Integer.toString(Math.abs(value));
            int valLen = tmp.length();
            char[] zerochs = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
            if (width > valLen) {
                sb.insert(sb.length(), zerochs, 0, width - valLen);
            }
            if (width < valLen) {
                sb.append(tmp.substring(valLen - width));
            } else {
                sb.append(tmp);
            }
        }
    }
}

