/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.err.TbError;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Vector;

public class TbRow
implements Serializable {
    private static final long serialVersionUID = -8999757353034075305L;
    protected Object[] originalCols;
    protected Object[] currentCols;
    protected boolean[] isColumnChanged;
    private boolean[] isNull;
    protected boolean deleted = false;
    protected boolean updated = false;
    protected boolean inserted = false;
    protected int columnCount;
    private int insertedColumnCnt;

    public TbRow(int colCount) {
        this.columnCount = colCount;
        this.originalCols = new Object[colCount];
        this.currentCols = new Object[colCount];
        this.isColumnChanged = new boolean[colCount];
        this.isNull = new boolean[colCount];
    }

    public TbRow(int columnCount, boolean flag) {
        this(columnCount);
        this.inserted = flag;
        this.insertedColumnCnt = 0;
    }

    public TbRow(int columnCount, Object[] cols) {
        this(columnCount);
        System.arraycopy(cols, 0, this.originalCols, 0, columnCount);
    }

    public void cancelDeleted() {
        this.deleted = false;
    }

    public void cancelInserted() {
        this.inserted = false;
    }

    public void cancelUpdated() {
        this.insertedColumnCnt = 0;
        for (int k = 0; k < this.columnCount; ++k) {
            this.isColumnChanged[k] = false;
        }
        this.currentCols = null;
        this.currentCols = new Object[this.columnCount];
    }

    public void commitChangedColumns() {
        for (int k = 0; k < this.columnCount; ++k) {
            if (!this.isColumnChanged[k]) continue;
            this.originalCols[k] = this.currentCols[k];
            this.currentCols[k] = null;
            this.isColumnChanged[k] = false;
        }
        this.updated = false;
    }

    public TbRow createCopy() throws SQLException {
        TbRow row = new TbRow(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            row.originalCols[i] = this.getCopy(this.originalCols[i]);
            row.currentCols[i] = this.getCopy(this.currentCols[i]);
        }
        System.arraycopy(this.isColumnChanged, 0, row.isColumnChanged, 0, this.columnCount);
        row.insertedColumnCnt = this.insertedColumnCnt;
        row.deleted = this.deleted;
        row.inserted = this.inserted;
        row.updated = this.updated;
        return row;
    }

    public Object getChangedColumn(int columnIndex) {
        return this.currentCols[columnIndex - 1];
    }

    public Object getColumn(int columnIndex) {
        return this.originalCols[columnIndex - 1];
    }

    public Object getCopy(Object obj) throws SQLException {
        if (obj == null) {
            return null;
        }
        try {
            if (obj instanceof String) {
                return new String((String)obj);
            }
            if (obj instanceof Number) {
                return new BigDecimal(((Number)obj).toString());
            }
            if (obj instanceof Date) {
                return new Date(((Date)obj).getTime());
            }
            if (obj instanceof Timestamp) {
                return new Timestamp(((Timestamp)obj).getTime());
            }
            if (obj instanceof InputStream) {
                return new DataInputStream((InputStream)obj);
            }
            if (obj instanceof OutputStream) {
                return new DataOutputStream((OutputStream)obj);
            }
            throw TbError.newSQLException(-90842, obj.toString());
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90830, e.getMessage());
        }
    }

    public Object[] getOriginalRow() {
        return this.originalCols;
    }

    public void insertRow() {
        this.isColumnChanged = null;
        this.isColumnChanged = new boolean[this.columnCount];
        System.arraycopy(this.currentCols, 0, this.originalCols, 0, this.columnCount);
        this.currentCols = null;
        this.currentCols = new Object[this.columnCount];
    }

    public boolean isColumnChanged(int columnIndex) {
        return this.isColumnChanged[columnIndex - 1];
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    boolean isNull(int columnIndex) throws SQLException {
        return this.isNull[columnIndex - 1];
    }

    public boolean isPopulationCompleted() {
        if (!this.inserted) {
            return false;
        }
        return this.insertedColumnCnt == this.columnCount;
    }

    public boolean isUpdated() {
        if (this.inserted || this.deleted) {
            return false;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (!this.isColumnChanged[i]) continue;
            return true;
        }
        return false;
    }

    public void markDeleted(boolean flag) {
        this.deleted = flag;
    }

    public void markInserted(boolean flag) {
        this.inserted = flag;
    }

    void markNull(int columnIndex, boolean flag) throws SQLException {
        this.isNull[columnIndex - 1] = flag;
    }

    public void markUpdated(boolean flag) {
        this.updated = flag;
        if (!flag) {
            this.cancelUpdated();
        }
    }

    public void reset() {
        this.originalCols = null;
        this.currentCols = null;
        this.isColumnChanged = null;
        this.deleted = false;
        this.updated = false;
        this.inserted = false;
        this.columnCount = 0;
    }

    public void setColumn(int columnIndex, Object obj) {
        if (this.inserted) {
            ++this.insertedColumnCnt;
        }
        this.originalCols[columnIndex - 1] = obj;
    }

    public Collection<Object> toCollection() {
        Vector<Object> cols = new Vector<Object>(this.columnCount);
        for (int i = 1; i <= this.columnCount; ++i) {
            cols.add(this.isColumnChanged(i) ? this.getChangedColumn(i) : this.getColumn(i));
        }
        return cols;
    }

    public void updateObject(int columnIndex, Object obj) {
        if (this.inserted) {
            ++this.insertedColumnCnt;
        }
        this.isColumnChanged[columnIndex - 1] = true;
        this.currentCols[columnIndex - 1] = obj;
    }
}

