/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbRowSet;
import com.tmax.tibero.jdbc.rowset.TbRowSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.RowSetWarning;

public class TbJdbcRowSet
extends TbRowSet
implements JdbcRowSet {
    private Connection conn;
    private PreparedStatement pstmt;
    private ResultSet rs;
    private static boolean isInitializedDriver;

    public TbJdbcRowSet() {
        this(null);
    }

    public TbJdbcRowSet(Connection conn) {
        Debug.logMethod("TbJdbcRowSet", new Object[]{this});
        this.conn = conn;
        isInitializedDriver = false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.absolute", new Object[]{this, Integer.toString(row)});
        boolean flag = this.rs.absolute(row);
        if (flag) {
            this.notifyCursorMoved();
        }
        return flag;
    }

    @Override
    public void afterLast() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.afterLast", new Object[]{this});
        if (!this.isAfterLast()) {
            this.rs.afterLast();
            this.notifyCursorMoved();
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.beforeFirst", new Object[]{this});
        if (!this.isBeforeFirst()) {
            this.rs.beforeFirst();
            this.notifyCursorMoved();
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.cancelRowUpdates", new Object[]{this});
        this.rs.cancelRowUpdates();
        this.notifyRowChanged();
    }

    @Override
    public void clearParameters() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.clearParameters", new Object[]{this});
        this.pstmt.clearParameters();
    }

    @Override
    public void close() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.close", new Object[]{this});
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.pstmt != null) {
            this.pstmt.close();
        }
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.commit();
            this.conn.close();
        }
        this.notifyRowSetChanged();
        this.isClosed = true;
    }

    @Override
    public void commit() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.commit", new Object[]{this});
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.commit();
    }

    @Override
    public void deleteRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.deleteRow", new Object[]{this});
        this.rs.deleteRow();
        this.notifyRowChanged();
    }

    @Override
    public void execute() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.execute", new Object[]{this});
        this.conn = this.getConnection(this);
        try {
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.conn.setTypeMap(this.getTypeMap());
        if (this.pstmt == null) {
            this.pstmt = this.conn.prepareStatement(this.getCommand(), this.getType(), this.getConcurrency());
        }
        this.pstmt.setFetchSize(this.getFetchSize());
        this.pstmt.setFetchDirection(this.getFetchDirection());
        this.pstmt.setMaxFieldSize(this.getMaxFieldSize());
        this.pstmt.setMaxRows(this.getMaxRows());
        this.pstmt.setQueryTimeout(this.getQueryTimeout());
        this.pstmt.setEscapeProcessing(this.getEscapeProcessing());
        this.setParams(this.getParams(), this.pstmt);
        this.rs = this.pstmt.executeQuery();
        this.notifyRowSetChanged();
    }

    private void setParams(Object[] params, PreparedStatement pstmt) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof Object[])) {
                pstmt.setObject(i + 1, params[i]);
                continue;
            }
            Object[] paramObj = (Object[])params[i];
            if (paramObj.length == 2) {
                this.setParams2Arg(i, paramObj, pstmt);
                continue;
            }
            if (paramObj.length != 3) continue;
            this.setParams3Arg(i, paramObj, pstmt);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParams2Arg(int i, Object[] paramObj, PreparedStatement pstmt) throws SQLException {
        if (paramObj[0] == null) {
            pstmt.setNull(i + 1, (Integer)paramObj[1]);
            return;
        } else if (paramObj[0] instanceof RowId) {
            pstmt.setRowId(i + 1, (RowId)paramObj[0]);
            return;
        } else if (paramObj[0] instanceof NClob) {
            pstmt.setNClob(i + 1, (NClob)paramObj[0]);
            return;
        } else if (paramObj[0] instanceof Date) {
            if (!(paramObj[1] instanceof Calendar)) throw TbError.newSQLException(-90846, paramObj[1].toString());
            pstmt.setDate(i + 1, (Date)paramObj[0], (Calendar)paramObj[1]);
            return;
        } else if (paramObj[0] instanceof Time) {
            if (!(paramObj[1] instanceof Calendar)) throw TbError.newSQLException(-90846, paramObj[1].toString());
            pstmt.setTime(i + 1, (Time)paramObj[0], (Calendar)paramObj[1]);
            return;
        } else if (paramObj[0] instanceof Timestamp) {
            if (!(paramObj[1] instanceof Calendar)) throw TbError.newSQLException(-90846, paramObj[1].toString());
            pstmt.setTimestamp(i + 1, (Timestamp)paramObj[0], (Calendar)paramObj[1]);
            return;
        } else if (paramObj[0] instanceof Reader) {
            pstmt.setCharacterStream(i + 1, (Reader)paramObj[0], (Integer)paramObj[1]);
            return;
        } else {
            if (!(paramObj[1] instanceof Integer)) return;
            if ((Integer)paramObj[1] == 0) {
                pstmt.setNString(i + 1, (String)paramObj[0]);
                return;
            } else {
                pstmt.setObject(i + 1, paramObj[0], (Integer)paramObj[1]);
            }
        }
    }

    private void setParams3Arg(int i, Object[] paramObj, PreparedStatement pstmt) throws SQLException {
        block23: {
            block25: {
                block24: {
                    block22: {
                        if (paramObj[0] != null) break block22;
                        pstmt.setNull(i + 1, (Integer)paramObj[1], (String)paramObj[2]);
                        break block23;
                    }
                    if (!(paramObj[0] instanceof Reader)) break block24;
                    switch ((Integer)paramObj[2]) {
                        case 6: {
                            if (paramObj[1] instanceof Integer) {
                                pstmt.setClob(i + 1, (Reader)paramObj[0], ((Integer)paramObj[1]).intValue());
                            } else {
                                pstmt.setClob(i + 1, (Reader)paramObj[0], (Long)paramObj[1]);
                            }
                            break block23;
                        }
                        case 3: {
                            if (paramObj[1] instanceof Integer) {
                                pstmt.setCharacterStream(i + 1, (Reader)paramObj[0], (Integer)paramObj[1]);
                            } else {
                                pstmt.setCharacterStream(i + 1, (Reader)paramObj[0], (Long)paramObj[1]);
                            }
                            break block23;
                        }
                        case 4: {
                            if (paramObj[1] instanceof Integer) {
                                pstmt.setNCharacterStream(i + 1, (Reader)paramObj[0], ((Integer)paramObj[1]).intValue());
                            } else {
                                pstmt.setNCharacterStream(i + 1, (Reader)paramObj[0], (Long)paramObj[1]);
                            }
                            break block23;
                        }
                        default: {
                            throw TbError.newSQLException(-90846, ((Integer)paramObj[2]).toString());
                        }
                    }
                }
                if (!(paramObj[0] instanceof InputStream)) break block25;
                switch ((Integer)paramObj[2]) {
                    case 2: {
                        if (paramObj[1] instanceof Integer) {
                            pstmt.setBinaryStream(i + 1, (InputStream)paramObj[0], (Integer)paramObj[1]);
                        } else {
                            pstmt.setBinaryStream(i + 1, (InputStream)paramObj[0], (Long)paramObj[1]);
                        }
                        break block23;
                    }
                    case 1: {
                        pstmt.setAsciiStream(i + 1, (InputStream)paramObj[0], (Integer)paramObj[1]);
                        break block23;
                    }
                    case 5: {
                        if (paramObj[1] instanceof Integer) {
                            pstmt.setBlob(i + 1, (InputStream)paramObj[0], ((Integer)paramObj[1]).intValue());
                        } else {
                            pstmt.setBlob(i + 1, (InputStream)paramObj[0], (Long)paramObj[1]);
                        }
                        break block23;
                    }
                    default: {
                        throw TbError.newSQLException(-90846, ((Integer)paramObj[2]).toString());
                    }
                }
            }
            if (paramObj[1] instanceof Integer && paramObj[2] instanceof Integer) {
                pstmt.setObject(i + 1, paramObj[0], (Integer)paramObj[1], (int)((Integer)paramObj[2]));
            } else {
                throw TbError.newSQLException(-90846, paramObj[0].toString());
            }
        }
    }

    @Override
    public int findColumn(String label) throws SQLException {
        return this.rs.findColumn(label);
    }

    @Override
    public boolean first() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.first", new Object[]{this});
        boolean flag = this.rs.first();
        if (flag) {
            this.notifyCursorMoved();
        }
        return flag;
    }

    @Override
    public Array getArray(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getArray", new Object[]{this, Integer.toString(i)});
        return this.rs.getArray(i);
    }

    @Override
    public Array getArray(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getArray", new Object[]{this, label});
        return this.rs.getArray(label);
    }

    @Override
    public InputStream getAsciiStream(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getAsciiStream", new Object[]{this, Integer.toString(i)});
        return this.rs.getAsciiStream(i);
    }

    @Override
    public InputStream getAsciiStream(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getAsciiStream", new Object[]{this, label});
        return this.rs.getAsciiStream(label);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getAutoCommit", new Object[]{this});
        if (this.conn != null) {
            return this.conn.getAutoCommit();
        }
        throw TbError.newSQLException(-90827);
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBigDecimal", new Object[]{this, Integer.toString(i)});
        return this.rs.getBigDecimal(i);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBigDecimal", new Object[]{this, Integer.toString(i), Integer.toString(scale)});
        return this.rs.getBigDecimal(i, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBigDecimal", new Object[]{this, label});
        return this.rs.getBigDecimal(label);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String label, int scale) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBigDecimal", new Object[]{this, label});
        return this.rs.getBigDecimal(label, scale);
    }

    @Override
    public InputStream getBinaryStream(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBinaryStream", new Object[]{this, Integer.toString(i)});
        return this.rs.getBinaryStream(i);
    }

    @Override
    public InputStream getBinaryStream(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBinaryStream", new Object[]{this, label});
        return this.rs.getBinaryStream(label);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBlob", new Object[]{this, Integer.toString(i)});
        return this.rs.getBlob(i);
    }

    @Override
    public Blob getBlob(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBlob", new Object[]{this, label});
        return this.rs.getBlob(label);
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBoolean", new Object[]{this, Integer.toString(i)});
        return this.rs.getBoolean(i);
    }

    @Override
    public boolean getBoolean(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBoolean", new Object[]{this, label});
        return this.rs.getBoolean(label);
    }

    @Override
    public byte getByte(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getByte", new Object[]{this, Integer.toString(i)});
        return this.rs.getByte(i);
    }

    @Override
    public byte getByte(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getByte", new Object[]{this, label});
        return this.rs.getByte(label);
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBytes", new Object[]{this, Integer.toString(i)});
        return this.rs.getBytes(i);
    }

    @Override
    public byte[] getBytes(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getBytes", new Object[]{this, label});
        return this.rs.getBytes(label);
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getCharacterStream", new Object[]{this, Integer.toString(i)});
        return this.rs.getCharacterStream(i);
    }

    @Override
    public Reader getCharacterStream(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getCharacterStream", new Object[]{this, label});
        return this.rs.getCharacterStream(label);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getClob", new Object[]{this, Integer.toString(i)});
        return this.rs.getClob(i);
    }

    @Override
    public Clob getClob(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getClob", new Object[]{this, label});
        return this.rs.getClob(label);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return super.getConcurrency();
    }

    private Connection getConnection(RowSet rowset) throws SQLException {
        String url = rowset.getUrl();
        String user = rowset.getUsername();
        String pwd = rowset.getPassword();
        String dataSourceName = rowset.getDataSourceName();
        if (this.conn != null && !this.conn.isClosed()) {
            return this.conn;
        }
        if (dataSourceName != null && !dataSourceName.equals("")) {
            try {
                InitialContext initialcontext = new InitialContext();
                DataSource datasource = (DataSource)initialcontext.lookup(dataSourceName);
                if (user == null || pwd == null) {
                    return datasource.getConnection();
                }
                return datasource.getConnection(user, pwd);
            }
            catch (NamingException e) {
                throw TbError.newSQLException(-90828);
            }
        }
        if (url != null && !url.equals("")) {
            if (!isInitializedDriver) {
                DriverManager.registerDriver(new TbDriver());
                isInitializedDriver = true;
            }
            if (user.equals("") || pwd.equals("")) {
                throw TbError.newSQLException(-90854);
            }
            return DriverManager.getConnection(url, user, pwd);
        }
        throw TbError.newSQLException(-90852);
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    @Override
    public Date getDate(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDate", new Object[]{this, Integer.toString(i)});
        return this.rs.getDate(i);
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDate", new Object[]{this, Integer.toString(i), cal});
        return this.rs.getDate(i, cal);
    }

    @Override
    public Date getDate(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDate", new Object[]{this, label});
        return this.rs.getDate(label);
    }

    @Override
    public Date getDate(String label, Calendar cal) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDate", new Object[]{this, label, cal});
        return this.rs.getDate(label, cal);
    }

    @Override
    public double getDouble(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDouble", new Object[]{this, Integer.toString(i)});
        return this.rs.getDouble(i);
    }

    @Override
    public double getDouble(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getDouble", new Object[]{this, label});
        return this.rs.getDouble(label);
    }

    @Override
    public float getFloat(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getFloat", new Object[]{this, Integer.toString(i)});
        return this.rs.getFloat(i);
    }

    @Override
    public float getFloat(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getFloat", new Object[]{this, label});
        return this.rs.getFloat(label);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.rs.getHoldability();
    }

    @Override
    public int getInt(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getInt", new Object[]{this, Integer.toString(i)});
        return this.rs.getInt(i);
    }

    @Override
    public int getInt(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getInt", new Object[]{this, label});
        return this.rs.getInt(label);
    }

    @Override
    public long getLong(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getLong", new Object[]{this, Integer.toString(i)});
        return this.rs.getLong(i);
    }

    @Override
    public long getLong(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getLong", new Object[]{this, label});
        return this.rs.getLong(label);
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        return super.getMatchColumnIndexes();
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        return super.getMatchColumnNames();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new TbRowSetMetaData(this.rs.getMetaData());
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getNCharacterStream", new Object[]{this, Integer.toString(i)});
        return this.rs.getNCharacterStream(i);
    }

    @Override
    public Reader getNCharacterStream(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getNCharacterStream", new Object[]{this, label});
        return this.rs.getNCharacterStream(label);
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getNClob", new Object[]{this, Integer.toString(i)});
        return this.rs.getNClob(i);
    }

    @Override
    public NClob getNClob(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getNClob", new Object[]{this, label});
        return this.rs.getNClob(label);
    }

    @Override
    public String getNString(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getNString", new Object[]{this, Integer.toString(i)});
        return this.rs.getNString(i);
    }

    @Override
    public String getNString(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getNString", new Object[]{this, label});
        return this.rs.getNString(label);
    }

    @Override
    public Object getObject(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getObject", new Object[]{this, Integer.toString(i)});
        return this.rs.getObject(i);
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getObject", new Object[]{this, Integer.toString(i), map});
        return this.rs.getObject(i, map);
    }

    @Override
    public Object getObject(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getObject", new Object[]{this, label});
        return this.rs.getObject(label);
    }

    @Override
    public Object getObject(String label, Map<String, Class<?>> map) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getObject", new Object[]{this, label});
        return this.rs.getObject(label, map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getRef", new Object[]{this, Integer.toString(i)});
        return this.rs.getRef(i);
    }

    @Override
    public Ref getRef(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getRef", new Object[]{this, label});
        return this.rs.getRef(label);
    }

    @Override
    public int getRow() throws SQLException {
        return this.rs.getRow();
    }

    @Override
    public RowId getRowId(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getRowId", new Object[]{this, Integer.toString(i)});
        return this.rs.getRowId(i);
    }

    @Override
    public RowId getRowId(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getRowId", new Object[]{this, label});
        return this.rs.getRowId(label);
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    @Override
    public short getShort(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getShort", new Object[]{this, Integer.toString(i)});
        return this.rs.getShort(i);
    }

    @Override
    public short getShort(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getShort", new Object[]{this, label});
        return this.rs.getShort(label);
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getSQLXML", new Object[]{this, Integer.toString(i)});
        return this.rs.getSQLXML(i);
    }

    @Override
    public SQLXML getSQLXML(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getSQLXML", new Object[]{this, label});
        return this.rs.getSQLXML(label);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.rs.getStatement();
    }

    @Override
    public String getString(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getString", new Object[]{this, Integer.toString(i)});
        return this.rs.getString(i);
    }

    @Override
    public String getString(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getString", new Object[]{this, label});
        return this.rs.getString(label);
    }

    @Override
    public Time getTime(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTime", new Object[]{this, Integer.toString(i)});
        return this.rs.getTime(i);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTime", new Object[]{this, Integer.toString(i), cal});
        return this.rs.getTime(i, cal);
    }

    @Override
    public Time getTime(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTime", new Object[]{this, label});
        return this.rs.getTime(label);
    }

    @Override
    public Time getTime(String label, Calendar cal) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTime", new Object[]{this, label, cal});
        return this.rs.getTime(label, cal);
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTimestamp", new Object[]{this, Integer.toString(i)});
        return this.rs.getTimestamp(i);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTimestamp", new Object[]{this, Integer.toString(i), cal});
        return this.rs.getTimestamp(i, cal);
    }

    @Override
    public Timestamp getTimestamp(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTimestamp", new Object[]{this, label});
        return this.rs.getTimestamp(label);
    }

    @Override
    public Timestamp getTimestamp(String label, Calendar cal) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getTimestamp", new Object[]{this, label, cal});
        return this.rs.getTimestamp(label, cal);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getUnicodeStream", new Object[]{this, Integer.toString(i)});
        return this.rs.getUnicodeStream(i);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getUnicodeStream", new Object[]{this, label});
        return this.rs.getUnicodeStream(label);
    }

    @Override
    public URL getURL(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getURL", new Object[]{this, Integer.toString(i)});
        return this.rs.getURL(i);
    }

    @Override
    public URL getURL(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.getURL", new Object[]{this, label});
        return this.rs.getURL(label);
    }

    @Override
    public void insertRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.insertRow", new Object[]{this});
        this.rs.insertRow();
        this.notifyRowChanged();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return super.isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.isWrapperFor", new Object[]{iface});
        return iface.isInstance(this);
    }

    @Override
    public boolean last() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.last", new Object[]{this});
        boolean flag = this.rs.last();
        if (flag) {
            this.notifyCursorMoved();
        }
        return flag;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.moveToCurrentRow", new Object[]{this});
        this.rs.moveToCurrentRow();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.moveToInsertRow", new Object[]{this});
        this.rs.moveToInsertRow();
    }

    @Override
    public boolean next() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.next", new Object[]{this});
        boolean flag = this.rs.next();
        if (flag) {
            this.notifyCursorMoved();
        }
        return flag;
    }

    @Override
    public boolean previous() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.previous", new Object[]{this});
        boolean flag = this.rs.previous();
        if (flag) {
            this.notifyCursorMoved();
        }
        return flag;
    }

    @Override
    public void refreshRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.refreshRow", new Object[]{this});
        this.rs.refreshRow();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.relative", new Object[]{this, Integer.toString(rows)});
        boolean flag = this.rs.relative(rows);
        if (flag) {
            this.notifyCursorMoved();
        }
        return flag;
    }

    @Override
    public void rollback() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.rollback", new Object[]{this});
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.rollback", new Object[]{this, savepoint});
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.rollback(savepoint);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.rs.rowDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.rs.rowInserted();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.rs.rowUpdated();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.setAutoCommit", new Object[]{this, new Boolean(autoCommit)});
        if (this.conn == null) {
            throw TbError.newSQLException(-90827);
        }
        this.conn.setAutoCommit(autoCommit);
    }

    @Override
    public void setMatchColumn(int columnIdx) throws SQLException {
        super.setMatchColumn(columnIdx);
    }

    @Override
    public void setMatchColumn(int[] columnIdxes) throws SQLException {
        super.setMatchColumn(columnIdxes);
    }

    @Override
    public void setMatchColumn(String columnName) throws SQLException {
        super.setMatchColumn(columnName);
    }

    @Override
    public void setMatchColumn(String[] columnNames) throws SQLException {
        super.setMatchColumn(columnNames);
    }

    @Override
    public void setShowDeleted(boolean flag) throws SQLException {
        if (flag) {
            throw TbError.newSQLException(-90856);
        }
        super.setShowDeleted(flag);
    }

    @Override
    public void unsetMatchColumn(int columnIdx) throws SQLException {
        super.unsetMatchColumn(columnIdx);
    }

    @Override
    public void unsetMatchColumn(int[] columnIdxes) throws SQLException {
        super.unsetMatchColumn(columnIdxes);
    }

    @Override
    public void unsetMatchColumn(String columnName) throws SQLException {
        super.unsetMatchColumn(columnName);
    }

    @Override
    public void unsetMatchColumn(String[] columnNames) throws SQLException {
        super.unsetMatchColumn(columnNames);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.unwrap", new Object[]{iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }

    @Override
    public void updateArray(int i, Array x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateArray", new Object[]{this, Integer.toString(i), x});
        this.rs.updateArray(i, x);
    }

    @Override
    public void updateArray(String label, Array x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateArray", new Object[]{this, label, x});
        this.rs.updateArray(label, x);
    }

    @Override
    public void updateAsciiStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateAsciiStream", new Object[]{this, Integer.toString(i), x});
        this.rs.updateAsciiStream(i, x);
    }

    @Override
    public void updateAsciiStream(int i, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateAsciiStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        this.rs.updateAsciiStream(i, x, len);
    }

    @Override
    public void updateAsciiStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateAsciiStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.rs.updateAsciiStream(i, x, len);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateAsciiStream", new Object[]{this, label, x});
        this.rs.updateAsciiStream(label, x);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateAsciiStream", new Object[]{this, label, x, Integer.toString(len)});
        this.rs.updateAsciiStream(label, x, len);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateAsciiStream", new Object[]{this, label, x, Long.toString(len)});
        this.rs.updateAsciiStream(label, x, len);
    }

    @Override
    public void updateBigDecimal(int i, BigDecimal x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBigDecimal", new Object[]{this, Integer.toString(i), x});
        this.rs.updateBigDecimal(i, x);
    }

    @Override
    public void updateBigDecimal(String label, BigDecimal x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBigDecimal", new Object[]{this, label, x});
        this.rs.updateBigDecimal(label, x);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBinaryStream", new Object[]{this, Integer.toString(i), x});
        this.rs.updateBinaryStream(i, x);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBinaryStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        this.rs.updateBinaryStream(i, x, len);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBinaryStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.rs.updateBinaryStream(i, x, len);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBinaryStream", new Object[]{this, label, x});
        this.rs.updateBinaryStream(label, x);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBinaryStream", new Object[]{this, label, x, Integer.toString(len)});
        this.rs.updateBinaryStream(label, x, len);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBinaryStream", new Object[]{this, label, x, Long.toString(len)});
        this.rs.updateBinaryStream(label, x, len);
    }

    @Override
    public void updateBlob(int i, Blob x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBlob", new Object[]{this, Integer.toString(i), x});
        this.rs.updateBlob(i, x);
    }

    @Override
    public void updateBlob(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBlob", new Object[]{this, Integer.toString(i), x});
        this.rs.updateBlob(i, x);
    }

    @Override
    public void updateBlob(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBlob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.rs.updateBlob(i, x, len);
    }

    @Override
    public void updateBlob(String label, Blob x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBlob", new Object[]{this, label, x});
        this.rs.updateBlob(label, x);
    }

    @Override
    public void updateBlob(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBlob", new Object[]{this, label, x});
        this.rs.updateBlob(label, x);
    }

    @Override
    public void updateBlob(String label, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBlob", new Object[]{this, label, x, Long.toString(len)});
        this.rs.updateBlob(label, x, len);
    }

    @Override
    public void updateBoolean(int i, boolean x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBoolean", new Object[]{this, Integer.toString(i), new Boolean(x)});
        this.rs.updateBoolean(i, x);
    }

    @Override
    public void updateBoolean(String label, boolean x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBoolean", new Object[]{this, label, new Boolean(x)});
        this.rs.updateBoolean(label, x);
    }

    @Override
    public void updateByte(int i, byte x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateByte", new Object[]{this, Integer.toString(i), Byte.toString(x)});
        this.rs.updateByte(i, x);
    }

    @Override
    public void updateByte(String label, byte x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateByte", new Object[]{this, label, Byte.toString(x)});
        this.rs.updateByte(label, x);
    }

    @Override
    public void updateBytes(int i, byte[] x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBytes", new Object[]{this, Integer.toString(i), x});
        this.rs.updateBytes(i, x);
    }

    @Override
    public void updateBytes(String label, byte[] x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateBytes", new Object[]{this, label, x});
        this.rs.updateBytes(label, x);
    }

    @Override
    public void updateCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateCharacterStream", new Object[]{this, Integer.toString(i), x});
        this.rs.updateCharacterStream(i, x);
    }

    @Override
    public void updateCharacterStream(int i, Reader x, int len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateCharacterStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        this.rs.updateCharacterStream(i, x, len);
    }

    @Override
    public void updateCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.rs.updateCharacterStream(i, x, len);
    }

    @Override
    public void updateCharacterStream(String label, Reader x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateCharacterStream", new Object[]{this, label, x});
        this.rs.updateCharacterStream(label, x);
    }

    @Override
    public void updateCharacterStream(String label, Reader x, int len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateCharacterStream", new Object[]{this, label, x, Integer.toString(len)});
        this.rs.updateCharacterStream(label, x, len);
    }

    @Override
    public void updateCharacterStream(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateCharacterStream", new Object[]{this, label, x, Long.toString(len)});
        this.rs.updateCharacterStream(label, x, len);
    }

    @Override
    public void updateClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateClob", new Object[]{this, Integer.toString(i), x});
        this.rs.updateClob(i, x);
    }

    @Override
    public void updateClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateClob", new Object[]{this, Integer.toString(i), x});
        this.rs.updateClob(i, x);
    }

    @Override
    public void updateClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateClob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.rs.updateClob(i, x, len);
    }

    @Override
    public void updateClob(String label, Clob x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateClob", new Object[]{this, label, x});
        this.rs.updateClob(label, x);
    }

    @Override
    public void updateClob(String label, Reader x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateClob", new Object[]{this, label, x});
        this.rs.updateClob(label, x);
    }

    @Override
    public void updateClob(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateClob", new Object[]{this, label, x, Long.toString(len)});
        this.rs.updateClob(label, x, len);
    }

    @Override
    public void updateDate(int i, Date x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateDate", new Object[]{this, Integer.toString(i), x});
        this.rs.updateDate(i, x);
    }

    @Override
    public void updateDate(String label, Date x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateDate", new Object[]{this, label, x});
        this.rs.updateDate(label, x);
    }

    @Override
    public void updateDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateDouble", new Object[]{this, Integer.toString(i), Double.toString(x)});
        this.rs.updateDouble(i, x);
    }

    @Override
    public void updateDouble(String label, double x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateDouble", new Object[]{this, label, Double.toString(x)});
        this.rs.updateDouble(label, x);
    }

    @Override
    public void updateFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateFloat", new Object[]{this, Integer.toString(i), Float.toString(x)});
        this.rs.updateFloat(i, x);
    }

    @Override
    public void updateFloat(String label, float x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateFloat", new Object[]{this, label, Float.toString(x)});
        this.rs.updateFloat(label, x);
    }

    @Override
    public void updateInt(int i, int x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateInt", new Object[]{this, Integer.toString(i), Integer.toString(x)});
        this.rs.updateInt(i, x);
    }

    @Override
    public void updateInt(String label, int x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateInt", new Object[]{this, label, Integer.toString(x)});
        this.rs.updateInt(label, x);
    }

    @Override
    public void updateLong(int i, long x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateLong", new Object[]{this, Integer.toString(i), Long.toString(x)});
        this.rs.updateLong(i, x);
    }

    @Override
    public void updateLong(String label, long x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateLong", new Object[]{this, label, Long.toString(x)});
        this.rs.updateLong(label, x);
    }

    @Override
    public void updateNCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNCharacterStream", new Object[]{this, Integer.toString(i), x});
        this.rs.updateNCharacterStream(i, x);
    }

    @Override
    public void updateNCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.rs.updateNCharacterStream(i, x, len);
    }

    @Override
    public void updateNCharacterStream(String label, Reader x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNCharacterStream", new Object[]{this, label, x});
        this.rs.updateNCharacterStream(label, x);
    }

    @Override
    public void updateNCharacterStream(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNCharacterStream", new Object[]{this, label, x, Long.toString(len)});
        this.rs.updateNCharacterStream(label, x, len);
    }

    @Override
    public void updateNClob(int i, NClob x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNClob", new Object[]{this, Integer.toString(i), x});
        this.rs.updateNClob(i, x);
    }

    @Override
    public void updateNClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNClob", new Object[]{this, Integer.toString(i), x});
        this.rs.updateNClob(i, x);
    }

    @Override
    public void updateNClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNClob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.rs.updateNClob(i, x, len);
    }

    @Override
    public void updateNClob(String label, NClob x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNClob", new Object[]{this, label, x});
        this.rs.updateNClob(label, x);
    }

    @Override
    public void updateNClob(String label, Reader x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNClob", new Object[]{this, label, x});
        this.rs.updateNClob(label, x);
    }

    @Override
    public void updateNClob(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNClob", new Object[]{this, label, x, Long.toString(len)});
        this.rs.updateNClob(label, x, len);
    }

    @Override
    public void updateNString(int i, String x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNString", new Object[]{this, Integer.toString(i), x});
        this.rs.updateNString(i, x);
    }

    @Override
    public void updateNString(String label, String x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNString", new Object[]{this, label, x});
        this.rs.updateNString(label, x);
    }

    @Override
    public void updateNull(int i) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNull", new Object[]{this, Integer.toString(i)});
        this.rs.updateNull(i);
    }

    @Override
    public void updateNull(String label) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateNString", new Object[]{this, label});
        this.rs.updateNull(label);
    }

    @Override
    public void updateObject(int i, Object x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateObject", new Object[]{this, Integer.toString(i), x});
        this.rs.updateObject(i, x);
    }

    @Override
    public void updateObject(int i, Object x, int scale) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateObject", new Object[]{this, Integer.toString(i), x, Integer.toString(scale)});
        this.rs.updateObject(i, x, scale);
    }

    @Override
    public void updateObject(String label, Object x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateObject", new Object[]{this, label, x});
        this.rs.updateObject(label, x);
    }

    @Override
    public void updateObject(String label, Object x, int scale) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateObject", new Object[]{this, label, x, Integer.toString(scale)});
        this.rs.updateObject(label, x, scale);
    }

    @Override
    public void updateRef(int i, Ref x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateRef", new Object[]{this, Integer.toString(i), x});
        this.rs.updateRef(i, x);
    }

    @Override
    public void updateRef(String label, Ref x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateRef", new Object[]{this, label, x});
        this.rs.updateRef(label, x);
    }

    @Override
    public void updateRow() throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateRow", new Object[]{this});
        this.rs.updateRow();
    }

    @Override
    public void updateRowId(int i, RowId x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateRowId", new Object[]{this, Integer.toString(i), x});
        this.rs.updateRowId(i, x);
    }

    @Override
    public void updateRowId(String label, RowId x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateRowId", new Object[]{this, label, x});
        this.rs.updateRowId(label, x);
    }

    @Override
    public void updateShort(int i, short x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateShort", new Object[]{this, Integer.toString(i), Short.toString(x)});
        this.rs.updateShort(i, x);
    }

    @Override
    public void updateShort(String label, short x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateShort", new Object[]{this, label, Short.toString(x)});
        this.rs.updateShort(label, x);
    }

    @Override
    public void updateSQLXML(int i, SQLXML x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateSQLXML", new Object[]{this, Integer.toString(i), x});
        this.rs.updateSQLXML(i, x);
    }

    @Override
    public void updateSQLXML(String label, SQLXML x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateSQLXML", new Object[]{this, label, x});
        this.rs.updateSQLXML(label, x);
    }

    @Override
    public void updateString(int i, String x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateString", new Object[]{this, Integer.toString(i), x});
        this.rs.updateString(i, x);
    }

    @Override
    public void updateString(String label, String x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateString", new Object[]{this, label, x});
        this.rs.updateString(label, x);
    }

    @Override
    public void updateTime(int i, Time x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateTime", new Object[]{this, Integer.toString(i), x});
        this.rs.updateTime(i, x);
    }

    @Override
    public void updateTime(String label, Time x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateTime", new Object[]{this, label, x});
        this.rs.updateTime(label, x);
    }

    @Override
    public void updateTimestamp(int i, Timestamp x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateTimestamp", new Object[]{this, Integer.toString(i), x});
        this.rs.updateTimestamp(i, x);
    }

    @Override
    public void updateTimestamp(String label, Timestamp x) throws SQLException {
        Debug.logMethod("TbJdbcRowSet.updateTimestamp", new Object[]{this, label, x});
        this.rs.updateTimestamp(label, x);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.rs.wasNull();
    }
}

