/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSet;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSetReader;
import com.tmax.tibero.jdbc.rowset.TbRow;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;

public class TbCachedRowSetWriter
implements RowSetWriter,
Serializable {
    private static final long serialVersionUID = -4465449178814496564L;
    private StringBuffer updateClause = new StringBuffer("");
    private StringBuffer deleteClause = new StringBuffer("");
    private StringBuffer insertClause = new StringBuffer("");
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection conn;
    private int columnCount;

    private boolean deleteRow(RowSet rowset, TbRow row) throws SQLException {
        this.deleteStmt.clearParameters();
        for (int i = 1; i <= this.columnCount; ++i) {
            if (row.isNull(i)) {
                return this.deleteRowWithNull(rowset, row);
            }
            Object obj = row.getColumn(i);
            if (obj == null) {
                this.deleteStmt.setNull(i, this.rsmd.getColumnType(i));
                continue;
            }
            this.deleteStmt.setObject(i, obj);
        }
        return this.deleteStmt.executeUpdate() == 1;
    }

    private boolean deleteRowWithNull(RowSet rowset, TbRow row) throws SQLException {
        boolean flag;
        StringBuffer sb = new StringBuffer("DELETE FROM " + this.getTableName(rowset) + " WHERE ");
        for (int i = 1; i <= this.columnCount; ++i) {
            if (i != 1) {
                sb.append(" AND ");
            }
            if (row.isNull(i)) {
                sb.append(this.rsmd.getColumnName(i) + " IS NULL ");
                continue;
            }
            sb.append(this.rsmd.getColumnName(i) + " = :" + i);
        }
        Statement pstmt = null;
        try {
            pstmt = this.conn.prepareStatement(sb.substring(0, sb.length()));
            int k = 1;
            for (int j = 1; j <= this.columnCount; ++j) {
                if (row.isNull(j)) continue;
                pstmt.setObject(k++, row.getColumn(j));
            }
            boolean bl = flag = pstmt.executeUpdate() == 1;
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            if (pstmt != null) {
                pstmt.close();
            }
            throw e;
        }
        return flag;
    }

    private String getTableName(RowSet rowset) throws SQLException {
        String s1 = rowset.getCommand().toUpperCase();
        int i = s1.indexOf(" FROM ");
        if (i == -1) {
            throw TbError.newSQLException(-90821);
        }
        String s2 = s1.substring(i + 6).trim();
        StringTokenizer st = new StringTokenizer(s2);
        if (st.hasMoreTokens()) {
            s2 = st.nextToken();
        }
        return s2;
    }

    private void initSQLStatement(RowSet rowset) throws SQLException {
        this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName(rowset) + "(");
        this.updateClause = new StringBuffer("UPDATE " + this.getTableName(rowset) + " SET ");
        this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName(rowset) + " WHERE ");
        this.rsmd = rowset.getMetaData();
        this.columnCount = this.rsmd.getColumnCount();
        for (int i = 0; i < this.columnCount; ++i) {
            if (i != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(this.rsmd.getColumnName(i + 1));
            if (i != 0) {
                this.updateClause.append(", ");
            }
            this.updateClause.append(this.rsmd.getColumnName(i + 1) + " = :" + i);
            if (i != 0) {
                this.deleteClause.append(" AND ");
            }
            this.deleteClause.append(this.rsmd.getColumnName(i + 1) + " = :" + i);
        }
        this.insertClause.append(") VALUES (");
        this.updateClause.append(" WHERE ");
        for (int j = 0; j < this.columnCount; ++j) {
            if (j != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(":" + j);
            if (j != 0) {
                this.updateClause.append(" AND ");
            }
            this.updateClause.append(this.rsmd.getColumnName(j + 1) + " = :" + j);
        }
        this.insertClause.append(")");
        this.insertStmt = this.conn.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
        this.updateStmt = this.conn.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
        this.deleteStmt = this.conn.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
    }

    private boolean insertRow(TbRow row) throws SQLException {
        this.insertStmt.clearParameters();
        for (int i = 1; i <= this.columnCount; ++i) {
            Object obj = null;
            Object object = obj = row.isColumnChanged(i) ? row.getChangedColumn(i) : row.getColumn(i);
            if (obj == null) {
                this.insertStmt.setNull(i, this.rsmd.getColumnType(i));
                continue;
            }
            this.insertStmt.setObject(i, obj);
        }
        return this.insertStmt.executeUpdate() == 1;
    }

    private boolean updateRow(RowSet rowset, TbRow row) throws SQLException {
        this.updateStmt.clearParameters();
        for (int i = 1; i <= this.columnCount; ++i) {
            Object obj = null;
            Object object = obj = row.isColumnChanged(i) ? row.getChangedColumn(i) : row.getColumn(i);
            if (obj == null) {
                this.updateStmt.setNull(i, this.rsmd.getColumnType(i));
                continue;
            }
            this.updateStmt.setObject(i, obj);
        }
        for (int j = 1; j <= this.columnCount; ++j) {
            if (row.isNull(j)) {
                return this.updateRowWithNull(rowset, row);
            }
            this.updateStmt.setObject(j + this.columnCount, row.getColumn(j));
        }
        return this.updateStmt.executeUpdate() == 1;
    }

    private boolean updateRowWithNull(RowSet rowset, TbRow row) throws SQLException {
        boolean flag1;
        StringBuffer sb = new StringBuffer("UPDATE " + this.getTableName(rowset) + " SET ");
        for (int i = 1; i <= this.columnCount; ++i) {
            if (i != 1) {
                sb.append(", ");
            }
            sb.append(this.rsmd.getColumnName(i) + " = :" + i);
        }
        sb.append(" WHERE ");
        for (int j = 1; j <= this.columnCount; ++j) {
            if (j != 1) {
                sb.append(" AND ");
            }
            if (row.isNull(j)) {
                sb.append(this.rsmd.getColumnName(j) + " IS NULL ");
                continue;
            }
            sb.append(this.rsmd.getColumnName(j) + " = :" + j);
        }
        Statement pstmt = null;
        try {
            pstmt = this.conn.prepareStatement(sb.substring(0, sb.length()));
            for (int k = 1; k <= this.columnCount; ++k) {
                Object obj = null;
                Object object = obj = row.isColumnChanged(k) ? row.getChangedColumn(k) : row.getColumn(k);
                if (obj == null) {
                    pstmt.setNull(k, this.rsmd.getColumnType(k));
                    continue;
                }
                pstmt.setObject(k, obj);
            }
            int i1 = 1;
            for (int l = 1; l <= this.columnCount; ++l) {
                if (row.isNull(l)) continue;
                pstmt.setObject(i1 + this.columnCount, row.getColumn(l));
                ++i1;
            }
            boolean bl = flag1 = pstmt.executeUpdate() == 1;
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            if (pstmt != null) {
                pstmt.close();
            }
            throw e;
        }
        return flag1;
    }

    @Override
    public synchronized boolean writeData(RowSetInternal rsi) throws SQLException {
        TbCachedRowSet rowset = (TbCachedRowSet)rsi;
        this.conn = ((TbCachedRowSetReader)rowset.getReader()).getConnection(rsi);
        if (this.conn.getAutoCommit()) {
            this.conn.setAutoCommit(false);
        }
        this.conn.setTransactionIsolation(rowset.getTransactionIsolation());
        this.initSQLStatement(rowset);
        if (this.columnCount < 1) {
            this.conn.close();
            return true;
        }
        boolean flag = rowset.getShowDeleted();
        rowset.setShowDeleted(true);
        rowset.beforeFirst();
        boolean flag1 = true;
        boolean flag2 = true;
        boolean flag3 = true;
        while (rowset.next()) {
            TbRow row;
            if (rowset.rowInserted()) {
                if (rowset.rowDeleted()) continue;
                row = rowset.getCurrentRow();
                flag2 = this.insertRow(row) || flag2;
                continue;
            }
            if (rowset.rowUpdated()) {
                row = rowset.getCurrentRow();
                flag1 = this.updateRow(rowset, row) || flag1;
                continue;
            }
            if (!rowset.rowDeleted()) continue;
            row = rowset.getCurrentRow();
            flag3 = this.deleteRow(rowset, row) || flag3;
        }
        if (flag1 && flag2 && flag3) {
            this.conn.commit();
            rowset.setOriginal();
        } else {
            this.conn.rollback();
        }
        this.insertStmt.close();
        this.updateStmt.close();
        this.deleteStmt.close();
        if (!rowset.isConnectionOpened()) {
            this.conn.close();
        }
        rowset.setShowDeleted(flag);
        return true;
    }
}

