/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSetReader;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSetWriter;
import com.tmax.tibero.jdbc.rowset.TbRow;
import com.tmax.tibero.jdbc.rowset.TbRowSet;
import com.tmax.tibero.jdbc.rowset.TbRowSetMetaData;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;

public class TbCachedRowSet
extends TbRowSet
implements RowSetInternal,
Serializable,
CachedRowSet {
    private static final long serialVersionUID = -3966681529200633668L;
    private Connection conn;
    private ResultSet rs;
    private boolean isConnectionOpened;
    private RowSetMetaData rowsetMetaData;
    private Vector<TbRow> rows;
    protected int currentRowIndex;
    private int columnCount;
    protected int rowCount;
    private RowSetReader reader;
    private RowSetWriter writer;
    private String[] columnNames;
    private boolean isOnUpdate;
    private int updateRowIndex;
    private boolean isOnInsert;
    private int insertRowIndex;
    private TbRow temporaryRow;
    private int pageSize;
    private int currentPageIndex;
    private boolean prevColumnWasNull;
    private boolean isInitializedDriver;
    private boolean isPopulateCompleted;
    private int[] keyColumns;
    private String tableName;
    private RowSetWarning rowsetWarnings;
    private SyncProvider syncProvider;
    private static final String DEFAULT_SYNC_PROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";

    public TbCachedRowSet() throws SQLException {
        Debug.logMethod("TbCachedRowSet", new Object[]{this});
        this.currentRowIndex = -1;
        this.columnCount = 0;
        this.rowCount = 0;
        this.prevColumnWasNull = false;
        this.isConnectionOpened = false;
        this.isOnInsert = false;
        this.isOnUpdate = false;
        this.currentRowIndex = 0;
        this.pageSize = 0;
        this.currentPageIndex = 0;
        this.prevColumnWasNull = false;
        this.isInitializedDriver = false;
        this.isPopulateCompleted = false;
        this.rows = new Vector();
        try {
            this.syncProvider = SyncFactory.getInstance(DEFAULT_SYNC_PROVIDER);
        }
        catch (SyncFactoryException e) {
            throw TbError.newSQLException(-90820, e.getMessage());
        }
        this.setReader(new TbCachedRowSetReader());
        this.setWriter(new TbCachedRowSetWriter());
    }

    @Override
    public boolean absolute(int rowIndex) throws SQLException {
        Debug.logMethod("TbCachedRowSet.absolute", new Object[]{this, Integer.toString(rowIndex)});
        if (this.rowsetType == 1003) {
            throw TbError.newSQLException(-590758);
        }
        if (rowIndex == 0 || Math.abs(rowIndex) > this.rowCount) {
            return false;
        }
        this.currentRowIndex = rowIndex >= 0 ? rowIndex : this.rowCount + rowIndex + 1;
        this.notifyCursorMoved();
        return true;
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        Debug.logMethod("TbCachedRowSet.acceptChanges", new Object[]{this});
        try {
            this.getWriter().writeData(this);
        }
        catch (SQLException e) {
            throw new SyncProviderException(e.getMessage());
        }
    }

    @Override
    public void acceptChanges(Connection conn) throws SyncProviderException {
        Debug.logMethod("TbCachedRowSet.acceptChanges", new Object[]{this, conn});
        this.conn = conn;
        this.isConnectionOpened = true;
        this.acceptChanges();
    }

    @Override
    public void afterLast() throws SQLException {
        Debug.logMethod("TbCachedRowSet.afterLast", new Object[]{this});
        this.currentRowIndex = this.rowCount + 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        Debug.logMethod("TbCachedRowSet.beforeFirst", new Object[]{this});
        this.currentRowIndex = 0;
    }

    public void cancelRowDelete() throws SQLException {
        Debug.logMethod("TbCachedRowSet.cancelRowDeleted", new Object[]{this});
        if (!this.getCurrentRow().isDeleted()) {
            throw TbError.newSQLException(-90858);
        }
        this.getCurrentRow().markDeleted(false);
        this.notifyRowChanged();
    }

    public void cancelRowInsert() throws SQLException {
        Debug.logMethod("TbCachedRowSet.cancelRowInsert", new Object[]{this});
        if (this.getCurrentRow().isInserted()) {
            this.rows.remove(--this.currentRowIndex);
            --this.rowCount;
        } else {
            throw TbError.newSQLException(-90862);
        }
        this.notifyRowChanged();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        Debug.logMethod("TbCachedRowSet.cancelRowUpdates", new Object[]{this});
        if (!this.getCurrentRow().isUpdated()) {
            throw TbError.newSQLException(-90863);
        }
        this.isOnUpdate = false;
        this.getCurrentRow().markUpdated(false);
        this.notifyRowChanged();
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (this.readOnly) {
            throw TbError.newSQLException(-90825);
        }
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(columnIndex));
        }
    }

    @Override
    public void close() throws SQLException {
        Debug.logMethod("TbCachedRowSet.close", new Object[]{this});
        this.release();
        this.isClosed = true;
    }

    @Override
    public boolean columnUpdated(int i) throws SQLException {
        if (this.isOnInsert) {
            throw TbError.newSQLException(-90851);
        }
        return this.getCurrentRow().isColumnChanged(i);
    }

    @Override
    public boolean columnUpdated(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.columnUpdated", new Object[]{this, label});
        return this.columnUpdated(this.findColumn(label));
    }

    @Override
    public void commit() throws SQLException {
        Debug.logMethod("TbCachedRowSet.commit", new Object[]{this});
        this.getConnection().commit();
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        Debug.logMethod("TbCachedRowSet.createCopy", new Object[]{this});
        TbCachedRowSet rowset = (TbCachedRowSet)this.createShared();
        int i = this.rows.size();
        rowset.rows = new Vector(i);
        for (int j = 0; j < i; ++j) {
            rowset.rows.add(this.rows.elementAt(j).createCopy());
        }
        return rowset;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        Debug.logMethod("TbCachedRowSet.createCopyNoConstraints", new Object[]{this});
        TbCachedRowSet rowset = (TbCachedRowSet)this.createCopy();
        rowset.initialize();
        rowset.listeners = new Vector();
        try {
            rowset.unsetMatchColumn(rowset.getMatchColumnIndexes());
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            rowset.unsetMatchColumn(rowset.getMatchColumnNames());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rowset;
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        Debug.logMethod("TbCachedRowSet.createCopySchema", new Object[]{this});
        TbCachedRowSet rowset = (TbCachedRowSet)this.createCopy();
        rowset.rows = null;
        rowset.rowCount = 0;
        rowset.currentPageIndex = 0;
        return rowset;
    }

    @Override
    public RowSet createShared() throws SQLException {
        Debug.logMethod("TbCachedRowSet.createShared", new Object[]{this});
        TbCachedRowSet rowset = new TbCachedRowSet();
        rowset.rows = this.rows;
        rowset.setDataSourceName(this.getDataSourceName());
        rowset.setUsername(this.getUsername());
        rowset.setPassword(this.getPassword());
        rowset.setUrl(this.getUrl());
        rowset.setTypeMap((Map)this.getTypeMap());
        rowset.setMaxFieldSize(this.getMaxFieldSize());
        rowset.setMaxRows(this.getMaxRows());
        rowset.setQueryTimeout(this.getQueryTimeout());
        rowset.setFetchSize(this.getFetchSize());
        rowset.setEscapeProcessing(this.getEscapeProcessing());
        rowset.setConcurrency(this.getConcurrency());
        rowset.setReadOnly(this.readOnly);
        rowset.rowsetType = this.getType();
        rowset.setFetchDirection(this.getFetchDirection());
        rowset.setCommand(this.getCommand());
        rowset.setTransactionIsolation(this.getTransactionIsolation());
        rowset.currentRowIndex = this.currentRowIndex;
        rowset.columnCount = this.columnCount;
        rowset.rowCount = this.rowCount;
        rowset.showDeleted = this.showDeleted;
        rowset.syncProvider = this.syncProvider;
        rowset.currentPageIndex = this.currentPageIndex;
        rowset.pageSize = this.pageSize;
        rowset.tableName = this.tableName != null ? new String(this.tableName) : null;
        rowset.keyColumns = this.keyColumns != null ? (int[])this.keyColumns.clone() : null;
        int i = this.listeners.size();
        for (int j = 0; j < i; ++j) {
            rowset.listeners.add(this.listeners.elementAt(j));
        }
        rowset.rowsetMetaData = new TbRowSetMetaData(this.rowsetMetaData);
        i = this.params.size();
        for (int k = 0; k < i; ++k) {
            rowset.params.add(this.params.elementAt(k));
        }
        rowset.columnNames = new String[this.columnNames.length];
        System.arraycopy(this.columnNames, 0, rowset.columnNames, 0, this.columnNames.length);
        return rowset;
    }

    @Override
    public void deleteRow() throws SQLException {
        Debug.logMethod("TbCachedRowSet.deleteRow", new Object[]{this});
        this.getCurrentRow().markDeleted(true);
        this.notifyRowChanged();
    }

    @Override
    public synchronized void execute() throws SQLException {
        Debug.logMethod("TbCachedRowSet.execute", new Object[]{this});
        this.isConnectionOpened = false;
        this.reader.readData(this);
    }

    @Override
    public synchronized void execute(Connection conn) throws SQLException {
        Debug.logMethod("TbCachedRowSet.execute", new Object[]{this, conn});
        this.conn = conn;
        this.execute();
    }

    @Override
    public int findColumn(String colName) throws SQLException {
        int i = 0;
        colName = colName.toUpperCase();
        for (i = 0; i < this.columnCount && !this.columnNames[i].equals(colName); ++i) {
        }
        if (i == this.columnCount) {
            throw TbError.newSQLException(-90835, colName);
        }
        return i + 1;
    }

    @Override
    public boolean first() throws SQLException {
        Debug.logMethod("TbCachedRowSet.first", new Object[]{this});
        return this.absolute(1);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getArray", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Array) {
            return (Array)obj;
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public Array getArray(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getArray", new Object[]{this, label});
        return this.getArray(this.findColumn(label));
    }

    @Override
    public InputStream getAsciiStream(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getAsciiStream", new Object[]{this, Integer.toString(i)});
        InputStream x = this.getStream(i);
        return x != null ? x : null;
    }

    @Override
    public InputStream getAsciiStream(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getAsciiStream", new Object[]{this, label});
        return this.getAsciiStream(this.findColumn(label));
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getBigDecimal", new Object[]{this, Integer.toString(i)});
        Number obj = this.getNumeric(i);
        if (obj == null || obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Number) {
            return new BigDecimal(obj.doubleValue());
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        return this.getBigDecimal(i);
    }

    @Override
    public BigDecimal getBigDecimal(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getBigDecimal", new Object[]{this, label});
        return this.getBigDecimal(this.findColumn(label));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String label, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(label));
    }

    @Override
    public InputStream getBinaryStream(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getBinaryStream", new Object[]{this, Integer.toString(i)});
        InputStream x = this.getStream(i);
        return x != null ? x : null;
    }

    @Override
    public InputStream getBinaryStream(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getBinaryStream", new Object[]{this, label});
        return this.getBinaryStream(this.findColumn(label));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getBlob", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof TbBlob) {
            return (Blob)obj;
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public Blob getBlob(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getBlob", new Object[]{this, label});
        return this.getBlob(this.findColumn(label));
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getBoolean", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue() != 0.0;
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public boolean getBoolean(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getBoolean", new Object[]{this, label});
        return this.getBoolean(this.findColumn(label));
    }

    @Override
    public byte getByte(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getByte", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes()[0];
        }
        if (obj instanceof TbBlob) {
            TbBlob blob = (TbBlob)obj;
            return blob.getBytes(0L, 1)[0];
        }
        if (obj instanceof TbClobBase) {
            TbClobBase clob = (TbClobBase)obj;
            return clob.getSubString(0L, 1).getBytes()[0];
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public byte getByte(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getByte", new Object[]{this, label});
        return this.getByte(this.findColumn(label));
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getBytes", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes();
        }
        if (obj instanceof Number) {
            return ((Number)obj).toString().getBytes();
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).toString().getBytes();
        }
        if (obj instanceof TbBlob) {
            TbBlob blob = (TbBlob)obj;
            return blob.getBytes(0L, (int)blob.length());
        }
        if (obj instanceof TbClobBase) {
            TbClobBase clob = (TbClobBase)obj;
            return clob.getSubString(0L, (int)clob.length()).getBytes();
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public byte[] getBytes(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getBytes", new Object[]{this, label});
        return this.getBytes(this.findColumn(label));
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getCharacterStream", new Object[]{this, Integer.toString(i)});
        return this.getCharacterStreamInternal(i);
    }

    @Override
    public Reader getCharacterStream(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getCharacterStream", new Object[]{this, label});
        return this.getCharacterStreamInternal(this.findColumn(label));
    }

    private Reader getCharacterStreamInternal(int i) throws SQLException {
        InputStream is = this.getAsciiStream(i);
        if (is == null) {
            return null;
        }
        try {
            StringBuffer sb = new StringBuffer();
            int j = 0;
            while ((j = is.read()) != -1) {
                sb.append((char)j);
            }
            char[] ac = new char[sb.length()];
            sb.getChars(0, sb.length(), ac, 0);
            return new CharArrayReader(ac);
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90829, e.getMessage());
        }
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getClob", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof TbClobBase) {
            return (Clob)obj;
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public Clob getClob(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getClob", new Object[]{this, label});
        return this.getClob(this.findColumn(label));
    }

    @Override
    public Connection getConnection() throws SQLException {
        Debug.logMethod("TbCachedRowSet.getConnection", new Object[]{this});
        if (this.conn == null || this.conn.isClosed()) {
            String user = this.getUsername();
            String pwd = this.getPassword();
            String url = this.getUrl();
            String dataSourceName = this.getDataSourceName();
            if (dataSourceName != null && !dataSourceName.equals("")) {
                try {
                    InitialContext ic = null;
                    try {
                        Properties properties = System.getProperties();
                        ic = new InitialContext(properties);
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                    if (ic == null) {
                        ic = new InitialContext();
                    }
                    DataSource ds = (DataSource)ic.lookup(dataSourceName);
                    if (this.username == null || pwd == null) {
                        this.conn = ds.getConnection();
                    }
                    this.conn = ds.getConnection(this.username, pwd);
                }
                catch (NamingException e) {
                    throw TbError.newSQLException(-90828, e.getMessage());
                }
            } else if (url != null && !url.equals("")) {
                if (!this.isInitializedDriver) {
                    DriverManager.registerDriver(new TbDriver());
                    this.isInitializedDriver = true;
                }
                if (user.equals("") || pwd.equals("")) {
                    throw TbError.newSQLException(-90854, "(" + user + "," + pwd + ")");
                }
                this.conn = DriverManager.getConnection(url, user, pwd);
            } else {
                throw TbError.newSQLException(-90852);
            }
        }
        return this.conn;
    }

    protected TbRow getCurrentRow() throws SQLException {
        if (this.currentRowIndex < 1 || this.currentRowIndex > this.rowCount) {
            throw TbError.newSQLException(-90847, "(" + this.currentRowIndex + "," + this.rowCount + ")");
        }
        return this.rows.elementAt(this.currentRowIndex - 1);
    }

    @Override
    public String getCursorName() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Date getDate(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getDate", new Object[]{this, Integer.toString(i)});
        return this.getDateInternal(i, null);
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getDate", new Object[]{this, Integer.toString(i), cal});
        return this.getDateInternal(i, cal);
    }

    @Override
    public Date getDate(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getDate", new Object[]{this, label});
        return this.getDateInternal(this.findColumn(label), null);
    }

    @Override
    public Date getDate(String label, Calendar cal) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getDate", new Object[]{this, label, cal});
        return this.getDateInternal(this.findColumn(label), cal);
    }

    private Date getDateInternal(int i, Calendar cal) throws SQLException {
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return new Date(((Time)obj).getTime());
        }
        if (obj instanceof Date) {
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            cal.setTime((Date)obj);
            return new Date(cal.getTime().getTime());
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public double getDouble(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getDouble", new Object[]{this, Integer.toString(i)});
        Number number = this.getNumeric(i);
        return number != null ? number.doubleValue() : 0.0;
    }

    @Override
    public double getDouble(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getDouble", new Object[]{this, label});
        return this.getDouble(this.findColumn(label));
    }

    @Override
    public float getFloat(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getFloat", new Object[]{this, Integer.toString(i)});
        Number number = this.getNumeric(i);
        return number != null ? number.floatValue() : 0.0f;
    }

    @Override
    public float getFloat(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getFloat", new Object[]{this, label});
        return this.getFloat(this.findColumn(label));
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getInt(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getInt", new Object[]{this, Integer.toString(i)});
        Number number = this.getNumeric(i);
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int getInt(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getInt", new Object[]{this, label});
        return this.getInt(this.findColumn(label));
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return this.keyColumns;
    }

    @Override
    public long getLong(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getLong", new Object[]{this, Integer.toString(i)});
        Number number = this.getNumeric(i);
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long getLong(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getLong", new Object[]{this, label});
        return this.getLong(this.findColumn(label));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowsetMetaData;
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getNCharacterStream", new Object[]{this, Integer.toString(i)});
        return this.getCharacterStreamInternal(i);
    }

    @Override
    public Reader getNCharacterStream(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getNCharacterStream", new Object[]{this, label});
        return this.getCharacterStreamInternal(this.findColumn(label));
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getNClob", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof TbNClob) {
            return (NClob)obj;
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public NClob getNClob(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getNClob", new Object[]{this, label});
        return this.getNClob(this.findColumn(label));
    }

    @Override
    public String getNString(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getNString", new Object[]{this, Integer.toString(i)});
        return this.getStringInternal(i);
    }

    @Override
    public String getNString(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getNString", new Object[]{this, label});
        return this.getStringInternal(this.findColumn(label));
    }

    private synchronized Number getNumeric(int i) throws SQLException {
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof BigDecimal || obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof Boolean) {
            return new Integer((Boolean)obj != false ? 1 : 0);
        }
        if (!(obj instanceof String)) {
            throw TbError.newSQLException(-90836, obj.toString());
        }
        try {
            return new BigDecimal((String)obj);
        }
        catch (NumberFormatException e) {
            throw TbError.newSQLException(-90829, ((String)obj).toString());
        }
    }

    @Override
    public Object getObject(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getObject", new Object[]{this, Integer.toString(i)});
        Object obj = null;
        obj = !this.isUpdated(i) ? this.getCurrentRow().getColumn(i) : this.getCurrentRow().getChangedColumn(i);
        this.prevColumnWasNull = obj == null;
        return obj;
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(i);
    }

    @Override
    public Object getObject(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getObject", new Object[]{this, label});
        return this.getObject(this.findColumn(label));
    }

    @Override
    public Object getObject(String label, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(label), map);
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        Debug.logMethod("TbCachedRowSet.getOriginal", new Object[]{this});
        TbCachedRowSet rowset = new TbCachedRowSet();
        rowset.rowsetMetaData = this.rowsetMetaData;
        rowset.columnCount = this.columnCount;
        rowset.rowCount = this.rowCount;
        rowset.currentRowIndex = 0;
        rowset.setType(1004);
        rowset.setConcurrency(1008);
        rowset.setReader(null);
        rowset.setWriter(null);
        TbRow row = null;
        Iterator<TbRow> itr = this.rows.iterator();
        while (itr.hasNext()) {
            row = new TbRow(this.columnCount, itr.next().getOriginalRow());
            rowset.rows.add(row);
        }
        return rowset;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        Debug.logMethod("TbCachedRowSet.getOriginalRow", new Object[]{this});
        TbCachedRowSet rowset = new TbCachedRowSet();
        rowset.rowsetMetaData = this.rowsetMetaData;
        rowset.columnCount = this.columnCount;
        rowset.rowCount = 1;
        rowset.currentRowIndex = 0;
        rowset.setReader(null);
        rowset.setWriter(null);
        TbRow row = new TbRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
        rowset.rows.add(row);
        return rowset;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public RowSetReader getReader() throws SQLException {
        return this.reader;
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getRef", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Ref) {
            return (Ref)obj;
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public Ref getRef(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getRef", new Object[]{this, label});
        return this.getRef(this.findColumn(label));
    }

    @Override
    public int getRow() throws SQLException {
        Debug.logMethod("TbCachedRowSet.getRow", new Object[]{this});
        if (this.currentRowIndex > this.rowCount) {
            return this.rowCount;
        }
        return this.currentRowIndex;
    }

    @Override
    public RowId getRowId(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getRowId", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof RowId) {
            return (RowId)obj;
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public RowId getRowId(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getRowId", new Object[]{this, label});
        return this.getRowId(this.findColumn(label));
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return this.rowsetWarnings;
    }

    @Override
    public short getShort(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getShort", new Object[]{this, Integer.toString(i)});
        Number number = this.getNumeric(i);
        return number != null ? number.shortValue() : (short)0;
    }

    @Override
    public short getShort(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getShort", new Object[]{this, label});
        return this.getShort(this.findColumn(label));
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getSQLXML", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof SQLXML) {
            return (SQLXML)obj;
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public SQLXML getSQLXML(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getSQLXML", new Object[]{this, label});
        return this.getSQLXML(this.findColumn(label));
    }

    @Override
    public Statement getStatement() throws SQLException {
        Debug.logMethod("TbCachedRowSet.getStatement", new Object[]{this});
        if (this.rs == null) {
            throw TbError.newSQLException(-90859);
        }
        return this.rs.getStatement();
    }

    private synchronized InputStream getStream(int i) throws SQLException {
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof String) {
            return new ByteArrayInputStream(((String)obj).getBytes());
        }
        if (obj instanceof byte[]) {
            return new ByteArrayInputStream((byte[])obj);
        }
        if (obj instanceof TbClobBase) {
            return ((TbClobBase)obj).getAsciiStream();
        }
        if (obj instanceof TbBlob) {
            return ((TbBlob)obj).getBinaryStream();
        }
        if (!(obj instanceof Reader)) {
            try {
                int j = 0;
                BufferedReader br = new BufferedReader((Reader)obj);
                PipedInputStream pis = new PipedInputStream();
                PipedOutputStream pos = new PipedOutputStream(pis);
                while ((j = br.read()) != -1) {
                    pos.write(j);
                }
                pos.close();
                return pis;
            }
            catch (IOException e) {
                throw TbError.newSQLException(-90829, e.getMessage());
            }
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public String getString(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getString", new Object[]{this, Integer.toString(i)});
        return this.getStringInternal(i);
    }

    @Override
    public String getString(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getString", new Object[]{this, label});
        return this.getStringInternal(this.findColumn(label));
    }

    private String getStringInternal(int i) throws SQLException {
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Number || obj instanceof BigDecimal) {
            return obj.toString();
        }
        if (obj instanceof Date) {
            return ((Date)obj).toString();
        }
        if (obj instanceof Timestamp) {
            return ((Date)obj).toString();
        }
        if (obj instanceof byte[]) {
            return new String((byte[])obj);
        }
        if (obj instanceof TbClobBase) {
            TbClobBase clob = (TbClobBase)obj;
            return clob.getSubString(0L, (int)clob.length());
        }
        if (obj instanceof TbBlob) {
            TbBlob blob = (TbBlob)obj;
            return new String(blob.getBytes(0L, (int)blob.length()));
        }
        if (obj instanceof URL) {
            return ((URL)obj).toString();
        }
        if (!(obj instanceof Reader)) {
            throw TbError.newSQLException(-90836, obj.toString());
        }
        try {
            Reader reader1 = (Reader)obj;
            char[] ac = new char[1024];
            int j = 0;
            StringBuffer sb = new StringBuffer(1024);
            while ((j = reader1.read(ac)) > 0) {
                sb.append(ac, 0, j);
            }
            return sb.substring(0, sb.length());
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90829, e.getMessage());
        }
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return this.syncProvider;
    }

    @Override
    public String getTableName() throws SQLException {
        return this.tableName;
    }

    @Override
    public Time getTime(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getTime", new Object[]{this, Integer.toString(i)});
        return this.getTimeInternal(i, null);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getTime", new Object[]{this, Integer.toString(i), cal});
        return this.getTimeInternal(i, cal);
    }

    @Override
    public Time getTime(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getTime", new Object[]{this, label});
        return this.getTimeInternal(this.findColumn(label), null);
    }

    @Override
    public Time getTime(String label, Calendar cal) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getTime", new Object[]{this, label, cal});
        return this.getTimeInternal(this.findColumn(label), cal);
    }

    private Time getTimeInternal(int i, Calendar cal) throws SQLException {
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Time) {
            return (Time)obj;
        }
        if (obj instanceof java.util.Date) {
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            cal.setTime((Date)obj);
            return new Time(cal.getTime().getTime());
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getTimestamp", new Object[]{this, Integer.toString(i)});
        return this.getTimestampInternal(i, null);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getTimestamp", new Object[]{this, Integer.toString(i), cal});
        return this.getTimestampInternal(i, cal);
    }

    @Override
    public Timestamp getTimestamp(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getTimestamp", new Object[]{this, label});
        return this.getTimestampInternal(this.findColumn(label), null);
    }

    @Override
    public Timestamp getTimestamp(String label, Calendar cal) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getTimestamp", new Object[]{this, label, cal});
        return this.getTimestampInternal(this.findColumn(label), cal);
    }

    private Timestamp getTimestampInternal(int i, Calendar cal) throws SQLException {
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof Date) {
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            cal.setTime((Date)obj);
            return new Timestamp(((java.util.Date)obj).getTime());
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getUnicodeStream", new Object[]{this, Integer.toString(i)});
        throw TbError.newSQLException(-90201);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getUnicodeStream", new Object[]{this, label});
        return this.getUnicodeStream(this.findColumn(label));
    }

    @Override
    public URL getURL(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getURL", new Object[]{this, Integer.toString(i)});
        Object obj = this.getObject(i);
        if (obj == null) {
            return null;
        }
        if (obj instanceof URL) {
            return (URL)obj;
        }
        throw TbError.newSQLException(-90836, obj.toString());
    }

    @Override
    public URL getURL(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.getURL", new Object[]{this, label});
        return this.getURL(this.findColumn(label));
    }

    public RowSetWriter getWriter() throws SQLException {
        return this.writer;
    }

    @Override
    public void insertRow() throws SQLException {
        Debug.logMethod("TbCachedRowSet.insertRow", new Object[]{this});
        if (!this.isOnInsert) {
            throw TbError.newSQLException(-90822);
        }
        if (!this.temporaryRow.isPopulationCompleted()) {
            throw TbError.newSQLException(-90865);
        }
        this.temporaryRow.insertRow();
        this.rows.insertElementAt(this.temporaryRow, this.insertRowIndex - 1);
        this.isOnInsert = false;
        ++this.rowCount;
        this.notifyRowChanged();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        Debug.logMethod("TbCachedRowSet.isAfterLast", new Object[]{this});
        return this.rowCount > 0 && this.currentRowIndex == this.rowCount + 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        Debug.logMethod("TbCachedRowSet.isBeforeFirst", new Object[]{this});
        return this.rowCount > 0 && this.currentRowIndex == 0;
    }

    boolean isConnectionOpened() {
        return this.isConnectionOpened;
    }

    @Override
    public boolean isFirst() throws SQLException {
        Debug.logMethod("TbCachedRowSet.isFirst", new Object[]{this});
        return this.currentRowIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        Debug.logMethod("TbCachedRowSet.isLast", new Object[]{this});
        return this.currentRowIndex == this.rowCount;
    }

    private final boolean isUpdated(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(columnIndex));
        }
        return this.getCurrentRow().isColumnChanged(columnIndex);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbCachedRowSet.isWrapperFor", new Object[]{iface});
        return iface.isInstance(this);
    }

    @Override
    public boolean last() throws SQLException {
        Debug.logMethod("TbCachedRowSet.last", new Object[]{this});
        return this.absolute(-1);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        Debug.logMethod("TbCachedRowSet.moveToCurrentRow", new Object[]{this});
        this.isOnInsert = false;
        this.isOnUpdate = false;
        this.absolute(this.currentRowIndex);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        Debug.logMethod("TbCachedRowSet.moveToInsertRow", new Object[]{this});
        this.temporaryRow = new TbRow(this.columnCount, true);
        this.isOnInsert = true;
        this.insertRowIndex = this.isAfterLast() ? this.currentRowIndex : this.currentRowIndex + 1;
    }

    @Override
    public boolean next() throws SQLException {
        Debug.logMethod("TbCachedRowSet.next", new Object[]{this});
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.currentRowIndex + 1 <= this.rowCount) {
                ++this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.currentRowIndex - 1 > 0) {
                --this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = 0;
            return false;
        }
        return false;
    }

    @Override
    public boolean nextPage() throws SQLException {
        Debug.logMethod("TbCachedRowSet.nextPage", new Object[]{this});
        if (this.fetchDirection == 1001 && this.rs != null && this.rs.getType() == 1003) {
            throw TbError.newSQLException(-90850);
        }
        if (this.rows.size() == 0 && !this.isPopulateCompleted) {
            throw TbError.newSQLException(-90853);
        }
        this.populate(this.rs);
        ++this.currentPageIndex;
        return !this.isPopulateCompleted;
    }

    @Override
    protected synchronized void notifyCursorMoved() {
        Debug.logMethod("TbCachedRowSet.notifyCursorMoved", new Object[]{this});
        if (this.isOnInsert) {
            this.isOnInsert = false;
            this.temporaryRow.markUpdated(false);
            this.warnings.setNextWarning(new SQLWarning("Insertion is canceled because of the cursor"));
        } else if (this.isOnUpdate) {
            try {
                this.isOnUpdate = false;
                int i = this.currentRowIndex;
                this.currentRowIndex = this.updateRowIndex;
                this.getCurrentRow().markUpdated(false);
                this.currentRowIndex = i;
                this.warnings.setNextWarning(new SQLWarning("All Updates are canceled because of the cursor"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.notifyCursorMoved();
    }

    @Override
    public void populate(ResultSet rs) throws SQLException {
        Debug.logMethod("TbCachedRowSet.populate", new Object[]{this, rs});
        if (this.rows == null) {
            this.rows = new Vector(100, 10);
        }
        this.rowsetMetaData = new TbRowSetMetaData(rs.getMetaData());
        this.columnCount = this.rowsetMetaData.getColumnCount();
        this.columnNames = new String[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.columnNames[i] = this.rowsetMetaData.getColumnName(i + 1);
        }
        boolean flag = this.fetchDirection == 1000 || this.fetchDirection == 1002;
        this.rowCount = 0;
        int i = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
        if (rs.getType() != 1003 && this.rows.size() == 0 && !flag) {
            rs.afterLast();
        }
        while (this.rowCount < i && (flag ? rs.next() : rs.previous())) {
            TbRow row = new TbRow(this.columnCount);
            for (int j = 1; j <= this.columnCount; ++j) {
                row.setColumn(j, rs.getObject(j));
                row.markNull(j, rs.wasNull());
            }
            if (flag) {
                this.rows.add(row);
            } else {
                this.rows.add(1, row);
            }
            ++this.rowCount;
        }
        if (flag && rs.isAfterLast() || !flag && rs.isBeforeFirst()) {
            this.isPopulateCompleted = true;
        }
        this.conn = null;
        this.notifyRowSetChanged();
    }

    @Override
    public void populate(ResultSet rs, int rowIndex) throws SQLException {
        Debug.logMethod("TbCachedRowSet.populate", new Object[]{this, rs, Integer.toString(rowIndex)});
        if (rowIndex < 0) {
            throw TbError.newSQLException(-90847, Integer.toString(rowIndex));
        }
        if (rs == null) {
            throw TbError.newSQLException(-90823);
        }
        if (rs.getType() == 1003) {
            int k = 0;
            for (k = 0; rs.next() && k < rowIndex; ++k) {
            }
            if (k < rowIndex) {
                throw TbError.newSQLException(-90868);
            }
        } else {
            rs.absolute(rowIndex);
        }
        this.populate(rs);
    }

    @Override
    public boolean previous() throws SQLException {
        Debug.logMethod("TbCachedRowSet.previous", new Object[]{this});
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.currentRowIndex + 1 <= this.rowCount) {
                ++this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.currentRowIndex - 1 > 0) {
                --this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = 0;
            return false;
        }
        return false;
    }

    @Override
    public boolean previousPage() throws SQLException {
        Debug.logMethod("TbCachedRowSet.previousPage", new Object[]{this});
        if (this.rs != null && this.rs.getType() == 1003) {
            throw TbError.newSQLException(-90850);
        }
        if (this.rows.size() == 0 && !this.isPopulateCompleted) {
            throw TbError.newSQLException(-90853);
        }
        if (this.fetchDirection == 1001) {
            this.rs.relative(this.pageSize * 2);
        } else {
            this.rs.relative(-2 * this.pageSize);
        }
        this.populate(this.rs);
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
        }
        return this.currentPageIndex != 0;
    }

    @Override
    public void refreshRow() throws SQLException {
        Debug.logMethod("TbCachedRowSet.refreshRow", new Object[]{this});
        TbRow row = this.getCurrentRow();
        if (row.isUpdated()) {
            row.cancelUpdated();
        }
    }

    @Override
    public boolean relative(int offset) throws SQLException {
        Debug.logMethod("TbCachedRowSet.relative", new Object[]{this, Integer.toString(offset)});
        return this.absolute(this.currentRowIndex + offset);
    }

    @Override
    public void release() throws SQLException {
        Debug.logMethod("TbCachedRowSet.release", new Object[]{this});
        this.rows = null;
        this.rows = new Vector();
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
        }
        this.rowCount = 0;
        this.currentRowIndex = 0;
        this.notifyRowSetChanged();
    }

    @Override
    public void restoreOriginal() throws SQLException {
        Debug.logMethod("TbCachedRowSet.restoreOriginal", new Object[]{this});
        boolean flag = false;
        for (int i = 0; i < this.rowCount; ++i) {
            TbRow row = this.rows.elementAt(i);
            if (row.isInserted()) {
                this.rows.remove(i);
                --this.rowCount;
                --i;
                flag = true;
                continue;
            }
            if (row.isUpdated()) {
                row.markUpdated(false);
                flag = true;
                continue;
            }
            if (!row.isDeleted()) continue;
            row.markDeleted(false);
            flag = true;
        }
        if (!flag) {
            throw TbError.newSQLException(-90857);
        }
        this.notifyRowSetChanged();
        this.currentRowIndex = 0;
    }

    @Override
    public void rollback() throws SQLException {
        Debug.logMethod("TbCachedRowSet.rollback", new Object[]{this});
        this.getConnection().rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Debug.logMethod("TbCachedRowSet.rollback", new Object[]{this, savepoint});
        Connection conn = this.getConnection();
        boolean flag = conn.getAutoCommit();
        conn.setAutoCommit(false);
        try {
            conn.rollback(savepoint);
            conn.setAutoCommit(flag);
        }
        catch (SQLException e) {
            conn.setAutoCommit(flag);
            throw e;
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isInserted();
    }

    @Override
    public void rowSetPopulated(RowSetEvent event, int numRows) throws SQLException {
        Debug.logMethod("TbCachedRowSet.rowSetPopulated", new Object[]{this, event, Integer.toString(numRows)});
        if (numRows < 0 || numRows < this.getFetchSize()) {
            throw TbError.newSQLException(-90848, Integer.toString(numRows));
        }
        if (this.size() % numRows == 0) {
            this.rowsetEvent = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isUpdated();
    }

    protected void setConnection(Connection conn) throws SQLException {
        this.conn = conn;
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        Debug.logMethod("TbCachedRowSet.setFetchDirection", new Object[]{this, Integer.toString(fetchDirection)});
        if (this.rowsetType == 1005) {
            throw TbError.newSQLException(-590759);
        }
        switch (fetchDirection) {
            case 1000: 
            case 1002: {
                this.currentRowIndex = 0;
                break;
            }
            case 1001: {
                if (this.rowsetType == 1003) {
                    throw TbError.newSQLException(-590760);
                }
                this.currentRowIndex = this.rowCount + 1;
                break;
            }
            default: {
                throw TbError.newSQLException(-90838, Integer.toString(fetchDirection));
            }
        }
        super.setFetchDirection(fetchDirection);
    }

    @Override
    public void setKeyColumns(int[] keys) throws SQLException {
        Debug.logMethod("TbCachedRowSet.setKeyColumns", new Object[]{this, keys});
        int i = 0;
        if (this.rowsetMetaData != null) {
            i = this.rowsetMetaData.getColumnCount();
            if (keys == null || keys.length > i) {
                throw TbError.newSQLException(-90839);
            }
        }
        int j = keys.length;
        this.keyColumns = new int[j];
        for (int k = 0; k < j; ++k) {
            if (keys[k] <= 0 || keys[k] > i) {
                throw TbError.newSQLException(-90834, Integer.toString(keys[k]));
            }
            this.keyColumns[k] = keys[k];
        }
    }

    @Override
    public void setMetaData(RowSetMetaData rowsetMetaData) throws SQLException {
        Debug.logMethod("TbCachedRowSet.setMetaData", new Object[]{this, rowsetMetaData});
        this.rowsetMetaData = rowsetMetaData;
        if (rowsetMetaData != null) {
            this.columnCount = rowsetMetaData.getColumnCount();
        }
    }

    public void setOriginal() throws SQLException {
        Debug.logMethod("TbCachedRowSet.setOriginal", new Object[]{this});
        int i = 1;
        do {
            boolean flag;
            if (flag = this.setOriginalInternal(i)) continue;
            ++i;
        } while (i <= this.rowCount);
        this.notifyRowSetChanged();
        this.currentRowIndex = 0;
    }

    private boolean setOriginalInternal(int rowIndex) throws SQLException {
        if (rowIndex < 1 || rowIndex > this.rowCount) {
            throw TbError.newSQLException(-90837);
        }
        boolean flag = false;
        TbRow row = this.rows.elementAt(rowIndex - 1);
        if (row.isDeleted()) {
            this.rows.remove(rowIndex - 1);
            --this.rowCount;
            flag = true;
        } else {
            if (row.isInserted()) {
                row.markInserted(false);
            }
            if (row.isUpdated()) {
                row.commitChangedColumns();
            }
        }
        return flag;
    }

    @Override
    public void setOriginalRow() throws SQLException {
        Debug.logMethod("TbCachedRowSet.setOriginalRow", new Object[]{this});
        if (this.isOnInsert) {
            throw TbError.newSQLException(-90851);
        }
        this.setOriginalInternal(this.currentRowIndex);
    }

    @Override
    public void setPageSize(int size) throws SQLException {
        Debug.logMethod("TbCachedRowSet.setPageSize", new Object[]{this, Integer.toString(size)});
        if (size < 0 || this.maxRows > 0 && size > this.maxRows) {
            throw TbError.newSQLException(-90843, Integer.toString(size));
        }
        this.pageSize = size;
    }

    public void setReader(RowSetReader reader) throws SQLException {
        Debug.logMethod("TbCachedRowSet.setReader", new Object[]{this, reader});
        this.reader = reader;
    }

    @Override
    public void setSyncProvider(String provider) throws SQLException {
        Debug.logMethod("TbCachedRowSet.setSyncProvider", new Object[]{this, provider});
        this.syncProvider = SyncFactory.getInstance(provider);
        this.reader = this.syncProvider.getRowSetReader();
        this.writer = this.syncProvider.getRowSetWriter();
    }

    @Override
    public void setTableName(String tabName) throws SQLException {
        Debug.logMethod("TbCachedRowSet.setTableName", new Object[]{this, tabName});
        this.tableName = tabName;
    }

    public void setWriter(RowSetWriter writer) throws SQLException {
        Debug.logMethod("TbCachedRowSet.setWriter", new Object[]{this, writer});
        this.writer = writer;
    }

    @Override
    public int size() {
        return this.rowCount;
    }

    public Collection<Collection<Object>> toCollection() throws SQLException {
        Debug.logMethod("TbCachedRowSet.toCollection", new Object[]{this});
        Map<Integer, Collection<Object>> map = Collections.synchronizedMap(new TreeMap());
        try {
            for (int i = 0; i < this.rowCount; ++i) {
                map.put(new Integer(i), this.rows.elementAt(i).toCollection());
            }
        }
        catch (Exception e) {
            map = null;
            throw TbError.newSQLException(-90831);
        }
        return map.values();
    }

    public Collection<Object> toCollection(int columnIndex) throws SQLException {
        Debug.logMethod("TbCachedRowSet.toCollection", new Object[]{this, Integer.toString(columnIndex)});
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(columnIndex));
        }
        Vector<Object> columnRows = new Vector<Object>(this.rowCount);
        for (int i = 0; i < this.rowCount; ++i) {
            TbRow row = this.rows.elementAt(i);
            Object obj = row.isColumnChanged(i) ? row.getChangedColumn(i) : row.getColumn(i);
            columnRows.add(obj);
        }
        return columnRows;
    }

    public Collection<Object> toCollection(String columnName) throws SQLException {
        Debug.logMethod("TbCachedRowSet.toCollection", new Object[]{this, columnName});
        return this.toCollection(this.findColumn(columnName));
    }

    @Override
    public void undoDelete() throws SQLException {
        this.cancelRowDelete();
    }

    @Override
    public void undoInsert() throws SQLException {
        this.cancelRowInsert();
    }

    @Override
    public void undoUpdate() throws SQLException {
        this.cancelRowUpdates();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbCachedRowSet.unwrap", new Object[]{iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }

    @Override
    public void updateArray(int i, Array x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateArray", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateArray(String label, Array x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateArray", new Object[]{this, label, x});
        this.updateArray(this.findColumn(label), x);
    }

    @Override
    public void updateAsciiStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateAsciiStream", new Object[]{this, Integer.toString(i), x});
        this.updateAsciiStream(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void updateAsciiStream(int i, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateAsciiStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        try {
            InputStreamReader reader = new InputStreamReader(x);
            char[] ac = new char[len];
            int k = 0;
            while ((k += reader.read(ac, k, len - k)) < len) {
            }
            this.updateObject(i, (Object)new CharArrayReader(ac));
            ac = null;
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90829, e.getMessage());
        }
    }

    @Override
    public void updateAsciiStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateAsciiStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.updateAsciiStream(i, x, (int)len);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateAsciiStream", new Object[]{this, label, x});
        this.updateAsciiStream(this.findColumn(label), x);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateAsciiStream", new Object[]{this, label, x});
        this.updateAsciiStream(this.findColumn(label), x, length);
    }

    @Override
    public void updateAsciiStream(String label, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateAsciiStream", new Object[]{this, label, x, Long.toString(len)});
        this.updateAsciiStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateBigDecimal(int i, BigDecimal x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBigDecimal", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateBigDecimal(String label, BigDecimal x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBigDecimal", new Object[]{this, label, x});
        this.updateBigDecimal(this.findColumn(label), x);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBinaryStream", new Object[]{this, Integer.toString(i), x});
        this.updateBinaryStream(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void updateBinaryStream(int i, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBinaryStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        try {
            byte[] abyte0 = new byte[len];
            int k = 0;
            while ((k += x.read(abyte0, k, len - k)) < len) {
            }
            this.updateObject(i, (Object)new ByteArrayInputStream(abyte0));
            abyte0 = null;
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90829, e.getMessage());
        }
    }

    @Override
    public void updateBinaryStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBinaryStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.updateBinaryStream(i, x, (int)len);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBinaryStream", new Object[]{this, label, x});
        this.updateBinaryStream(this.findColumn(label), x);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBinaryStream", new Object[]{this, label, x, Integer.toString(len)});
        this.updateBinaryStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateBinaryStream(String label, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBinaryStream", new Object[]{this, label, x, Long.toString(len)});
        this.updateBinaryStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateBlob(int i, Blob x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBlob", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateBlob(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBlob", new Object[]{this, Integer.toString(i), x});
        this.updateBinaryStream(i, x);
    }

    @Override
    public void updateBlob(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBlob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.updateBinaryStream(i, x, len);
    }

    @Override
    public void updateBlob(String label, Blob x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBlob", new Object[]{this, label, x});
        this.updateBlob(this.findColumn(label), x);
    }

    @Override
    public void updateBlob(String label, InputStream x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBlob", new Object[]{this, label, x});
        this.updateBinaryStream(this.findColumn(label), x);
    }

    @Override
    public void updateBlob(String label, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBlob", new Object[]{this, label, Long.toString(len)});
        this.updateBinaryStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateBoolean(int i, boolean x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBoolean", new Object[]{this, Integer.toString(i), new Boolean(x)});
        this.updateObject(i, (Object)new Boolean(x));
    }

    @Override
    public void updateBoolean(String label, boolean x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBoolean", new Object[]{this, label, new Boolean(x)});
        this.updateBoolean(this.findColumn(label), x);
    }

    @Override
    public void updateByte(int i, byte x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateByte", new Object[]{this, Integer.toString(i), Byte.toString(x)});
        this.updateObject(i, (Object)new Byte(x));
    }

    @Override
    public void updateByte(String label, byte x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateByte", new Object[]{this, label, Byte.toString(x)});
        this.updateByte(this.findColumn(label), x);
    }

    @Override
    public void updateBytes(int i, byte[] x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBytes", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateBytes(String label, byte[] x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateBytes", new Object[]{this, label, x});
        this.updateBytes(this.findColumn(label), x);
    }

    @Override
    public void updateCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateCharacterStream", new Object[]{this, Integer.toString(i), x});
        this.updateCharacterStream(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void updateCharacterStream(int i, Reader x, int len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateCharacterStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        try {
            char[] ac = new char[len];
            int k = 0;
            while ((k += x.read(ac, k, len - k)) < len) {
            }
            this.updateObject(i, (Object)new CharArrayReader(ac));
            ac = null;
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90829, e.getMessage());
        }
    }

    @Override
    public void updateCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.updateCharacterStream(i, x, (int)len);
    }

    @Override
    public void updateCharacterStream(String label, Reader x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateCharacterStream", new Object[]{this, label, x});
        this.updateCharacterStream(this.findColumn(label), x);
    }

    @Override
    public void updateCharacterStream(String label, Reader x, int len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateCharacterStream", new Object[]{this, label, x, Integer.toString(len)});
        this.updateCharacterStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateCharacterStream(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateCharacterStream", new Object[]{this, label, x, Long.toString(len)});
        this.updateCharacterStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateClob", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateClob", new Object[]{this, Integer.toString(i), x});
        this.updateCharacterStream(i, x);
    }

    @Override
    public void updateClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateClob", new Object[]{this, Integer.toString(i), x});
        this.updateCharacterStream(i, x, len);
    }

    @Override
    public void updateClob(String label, Clob x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateClob", new Object[]{this, label, x});
        this.updateClob(this.findColumn(label), x);
    }

    @Override
    public void updateClob(String label, Reader x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateClob", new Object[]{this, label, x});
        this.updateCharacterStream(this.findColumn(label), x);
    }

    @Override
    public void updateClob(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateClob", new Object[]{this, label, x, Long.toString(len)});
        this.updateCharacterStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateDate(int i, Date x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateDate", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateDate(String label, Date x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateDate", new Object[]{this, label, x});
        this.updateDate(this.findColumn(label), x);
    }

    @Override
    public void updateDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateDouble", new Object[]{this, Integer.toString(i), Double.toString(x)});
        this.updateObject(i, (Object)new Double(x));
    }

    @Override
    public void updateDouble(String label, double x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateDouble", new Object[]{this, label, Double.toString(x)});
        this.updateDouble(this.findColumn(label), x);
    }

    @Override
    public void updateFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateFloat", new Object[]{this, Integer.toString(i), Float.toString(x)});
        this.updateObject(i, (Object)new Float(x));
    }

    @Override
    public void updateFloat(String label, float x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateFloat", new Object[]{this, label, Float.toString(x)});
        this.updateFloat(this.findColumn(label), x);
    }

    @Override
    public void updateInt(int i, int x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateInt", new Object[]{this, Integer.toString(i), Integer.toString(x)});
        this.updateObject(i, (Object)new Integer(x));
    }

    @Override
    public void updateInt(String label, int x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateInt", new Object[]{this, label, Integer.toString(x)});
        this.updateInt(this.findColumn(label), x);
    }

    @Override
    public void updateLong(int i, long x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateLong", new Object[]{this, Integer.toString(i), Long.toString(x)});
        this.updateObject(i, (Object)new Long(x));
    }

    @Override
    public void updateLong(String label, long x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateLong", new Object[]{this, label, Long.toString(x)});
        this.updateLong(this.findColumn(label), x);
    }

    @Override
    public void updateNCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNCharacterStream", new Object[]{this, Integer.toString(i), x});
        this.updateCharacterStream(i, x);
    }

    @Override
    public void updateNCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.updateCharacterStream(i, x, len);
    }

    @Override
    public void updateNCharacterStream(String label, Reader x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNCharacterStream", new Object[]{this, label, x});
        this.updateCharacterStream(this.findColumn(label), x);
    }

    @Override
    public void updateNCharacterStream(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNCharacterStream", new Object[]{this, label, x, Long.toString(len)});
        this.updateCharacterStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateNClob(int i, NClob x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNClob", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateNClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNClob", new Object[]{this, Integer.toString(i), x});
        this.updateCharacterStream(i, x);
    }

    @Override
    public void updateNClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNClob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        this.updateCharacterStream(i, x, len);
    }

    @Override
    public void updateNClob(String label, NClob x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNClob", new Object[]{this, label, x});
        this.updateNClob(this.findColumn(label), x);
    }

    @Override
    public void updateNClob(String label, Reader x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNClob", new Object[]{this, label, x});
        this.updateCharacterStream(this.findColumn(label), x);
    }

    @Override
    public void updateNClob(String label, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNClob", new Object[]{this, label, x, Long.toString(len)});
        this.updateCharacterStream(this.findColumn(label), x, len);
    }

    @Override
    public void updateNString(int i, String x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNString", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateNString(String label, String x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNString", new Object[]{this, label, x});
        this.updateNString(this.findColumn(label), x);
    }

    @Override
    public void updateNull(int i) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNull", new Object[]{this, Integer.toString(i)});
        this.updateObject(i, null);
    }

    @Override
    public void updateNull(String label) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateNull", new Object[]{this, label});
        this.updateNull(this.findColumn(label));
    }

    @Override
    public void updateObject(int i, Object x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateObject", new Object[]{this, Integer.toString(i), x});
        this.checkColumnIndex(i);
        if (this.isOnInsert) {
            this.temporaryRow.updateObject(i, x);
        } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
            this.isOnUpdate = true;
            this.updateRowIndex = this.currentRowIndex;
            this.getCurrentRow().updateObject(i, x);
        } else {
            throw TbError.newSQLException(-90855);
        }
    }

    @Override
    public void updateObject(int i, Object x, int scale) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateObject", new Object[]{this, Integer.toString(i), x, Integer.toString(scale)});
        if (!(x instanceof Number)) {
            throw TbError.newSQLException(-90836, x.toString());
        }
        this.updateObject(i, (Object)new BigDecimal(new BigInteger(((Number)x).toString()), scale));
    }

    @Override
    public void updateObject(String label, Object x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateObject", new Object[]{this, label, x});
        this.updateObject(this.findColumn(label), x);
    }

    @Override
    public void updateObject(String label, Object x, int scale) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateObject", new Object[]{this, label, x, Integer.toString(scale)});
        this.updateObject(this.findColumn(label), x, scale);
    }

    @Override
    public void updateRef(int i, Ref x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateRef", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateRef(String label, Ref x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateRef", new Object[]{this, label, x});
        this.updateRef(this.findColumn(label), x);
    }

    @Override
    public void updateRow() throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateRow", new Object[]{this});
        if (!this.isOnUpdate) {
            throw TbError.newSQLException(-90824);
        }
        this.isOnUpdate = false;
        this.getCurrentRow().markUpdated(true);
        this.notifyRowChanged();
    }

    @Override
    public void updateRowId(int i, RowId x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateRowId", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateRowId(String label, RowId x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateRowId", new Object[]{this, label, x});
        this.updateRowId(this.findColumn(label), x);
    }

    @Override
    public void updateShort(int i, short x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateShort", new Object[]{this, Integer.toString(i), Short.toString(x)});
        this.updateObject(i, (Object)new Short(x));
    }

    @Override
    public void updateShort(String label, short x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateShort", new Object[]{this, label, Short.toString(x)});
        this.updateShort(this.findColumn(label), x);
    }

    @Override
    public void updateSQLXML(int i, SQLXML x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateSQLXML", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateSQLXML(String label, SQLXML x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateSQLXML", new Object[]{this, label, x});
        this.updateSQLXML(this.findColumn(label), x);
    }

    @Override
    public void updateString(int i, String x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateString", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateString(String label, String x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateString", new Object[]{this, label, x});
        this.updateString(this.findColumn(label), x);
    }

    @Override
    public void updateTime(int i, Time x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateTime", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateTime(String label, Time x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateTime", new Object[]{this, label, x});
        this.updateTime(this.findColumn(label), x);
    }

    @Override
    public void updateTimestamp(int i, Timestamp x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateTimestamp", new Object[]{this, Integer.toString(i), x});
        this.updateObject(i, (Object)x);
    }

    @Override
    public void updateTimestamp(String label, Timestamp x) throws SQLException {
        Debug.logMethod("TbCachedRowSet.updateTimestamp", new Object[]{this, label, x});
        this.updateTimestamp(this.findColumn(label), x);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.prevColumnWasNull;
    }
}

