/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.msg.common;

import com.tmax.tibero.jdbc.comm.TbStreamDataReader;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import java.sql.SQLException;

public abstract class TbMsgError
extends TbMsg {
    public boolean haveError = true;
    private SQLException prevException;
    private SQLException rootException;

    protected void readErrorStackInfo(TbStreamDataReader reader) throws SQLException {
        int errorStackLen = reader.readInt32();
        if (errorStackLen == 0) {
            this.haveError = false;
            reader.moveReadOffset(4);
            return;
        }
        reader.moveReadOffset(4);
        reader.moveReadOffset(4);
        int errCnt = reader.readInt32();
        if (errCnt <= 0) {
            this.haveError = false;
            return;
        }
        reader.moveReadOffset(4);
        for (int i = 0; i < errCnt; ++i) {
            String desc;
            int nullCh;
            reader.moveReadOffset(8);
            reader.moveReadOffset(4);
            int errCode = reader.readInt32();
            reader.moveReadOffset(4);
            reader.moveReadOffset(4);
            reader.moveReadOffset(1);
            String sqlState = reader.readDBDecodedString(6).trim();
            if (null != sqlState && (nullCh = sqlState.indexOf(0)) > 0) {
                sqlState = sqlState.substring(0, nullCh);
            }
            if (null != (desc = reader.readDBDecodedString(712).trim()) && (nullCh = desc.indexOf(0)) > 0) {
                desc = desc.substring(0, nullCh);
            }
            reader.moveReadOffset(1);
            reader.moveReadOffset(4);
            int dmlLine = reader.readInt32();
            int dmlCol = reader.readInt32();
            reader.moveReadOffset(4);
            reader.moveReadOffset(12);
            reader.moveReadOffset(80);
            reader.moveReadOffset(4);
            reader.moveReadOffset(80);
            SQLException exception = TbError.newSQLException(desc, sqlState, errCode);
            if (this.prevException == null) {
                this.rootException = exception;
            } else {
                this.prevException.setNextException(exception);
            }
            this.prevException = exception;
        }
    }

    public SQLException getException(int code) {
        if (!this.haveError) {
            return TbError.newSQLException(code);
        }
        return this.rootException;
    }

    public void changeRootException(SQLException ex) {
        ex.setNextException(this.rootException.getNextException());
        this.rootException = ex;
    }
}

