/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import com.tmax.tibero.jdbc.ext.TbPooledConnection;
import com.tmax.tibero.jdbc.ext.TbXAException;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TbXAConnection
extends TbPooledConnection
implements XAConnection,
XAResource {
    private boolean autoCommit = false;

    public TbXAConnection(TbConnection conn) throws SQLException {
        super(conn);
        this.getPhysicalConnection().setAutoCommit(true);
        Debug.logMethod("TbXAConnection", new Object[]{this});
    }

    @Override
    public void commit(Xid xid, boolean bool) throws XAException {
        Debug.logMethod("TbXAConnection.commit", new Object[]{this, xid, new Boolean(bool)});
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        this.getPhysicalConnection().getTbXAComm().xaCommit(xid, bool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flag) throws XAException {
        Debug.logMethod("TbXAConnection.end", new Object[]{this, xid, Integer.toString(flag)});
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        try {
            this.getPhysicalConnection().setTxnMode(0);
            this.getPhysicalConnection().getTbXAComm().xaEnd(xid, flag);
        }
        finally {
            try {
                this.restoreAutoCommit();
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        Debug.logMethod("TbXAConnection.forget", new Object[]{this, xid});
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
    }

    @Override
    protected TbLogicalConnection getNewLogicalConnection() throws SQLException {
        return new TbLogicalConnection(this, this.getPhysicalConnection(), true);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    @Override
    public XAResource getXAResource() {
        return this;
    }

    @Override
    public boolean isSameRM(XAResource source) throws XAException {
        Debug.logMethod("TbXAConnection.isSameRM", new Object[]{source});
        if (!(source instanceof TbXAConnection)) {
            return false;
        }
        TbConnection conn = ((TbXAConnection)source).getPhysicalConnection();
        if (conn == null || conn.info == null) {
            return false;
        }
        TbConnection myConn = this.getPhysicalConnection();
        String myUrl = myConn.info.getURL();
        return conn.equals(myConn) || conn.info.getURL().equals(myUrl);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        Debug.logMethod("TbXAConnection.prepare", new Object[]{this, xid});
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        return this.getPhysicalConnection().getTbXAComm().xaPrepare(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        Debug.logMethod("TbXAConnection.recover", new Object[]{Integer.toString(flag)});
        if ((flag & 0x1800000) != flag) {
            throw new TbXAException(-5, "Invalid flag: " + flag);
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        return this.getPhysicalConnection().getTbXAComm().xaRecover(flag);
    }

    public final void restoreAutoCommit() throws SQLException {
        this.getPhysicalConnection().setAutoCommit(this.autoCommit);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        Debug.logMethod("TbXAConnection.rollback", new Object[]{this, xid});
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        this.getPhysicalConnection().getTbXAComm().xaRollback(xid);
    }

    private final void saveAutoCommit() throws SQLException {
        this.autoCommit = this.getPhysicalConnection().getAutoCommit();
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int flag) throws XAException {
        Debug.logMethod("TbXAConnection.start", new Object[]{this, xid, Integer.toString(flag)});
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        try {
            this.saveAutoCommit();
            this.getPhysicalConnection().setAutoCommit(false);
        }
        catch (SQLException se) {
            throw new TbXAException(se.getMessage());
        }
        try {
            this.getPhysicalConnection().getTbXAComm().xaStart(xid, flag);
            this.getPhysicalConnection().setTxnMode(2);
        }
        catch (XAException xe) {
            try {
                this.restoreAutoCommit();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw xe;
        }
        catch (Exception e) {
            try {
                this.restoreAutoCommit();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw new TbXAException(e.getMessage());
        }
    }
}

